/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.jet.engine;

import java.io.InputStream;
import java.util.Map;
import org.eclipse.egf.common.constant.EGFCommonConstants;
import org.eclipse.egf.pattern.engine.PatternHelper;
import org.eclipse.emf.codegen.jet.JETCompiler;
import org.eclipse.emf.codegen.jet.JETCoreElement;
import org.eclipse.emf.codegen.jet.JETException;
import org.eclipse.emf.codegen.jet.JETMark;
import org.eclipse.emf.codegen.jet.JETParser;
import org.eclipse.emf.codegen.jet.JETScriptletGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtendedJetCompiler
extends JETCompiler {
    private static final String EGF_PATTERN_CALL = "egf:patternCall";
    private static final String EGF_PATTERN_INJECTED_CALL = "egf:patternInjectedCall";
    private static final String N = EGFCommonConstants.LINE_SEPARATOR;

    public ExtendedJetCompiler(String templateURI, InputStream inputStream, String encoding) throws JETException {
        super(templateURI, inputStream, encoding);
    }

    public void handleDirective(String directive, JETMark start, JETMark stop, Map<String, String> attributes) throws JETException {
        if (EGF_PATTERN_CALL.equals(directive)) {
            String patternId = attributes.get("patternId");
            String args = attributes.get("args");
            StringBuffer buffer = new StringBuffer();
            buffer.append("final Map<String, Object> parameters = new HashMap<String, Object>();");
            buffer.append(N);
            String[] stringArray = args.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String arg = stringArray[n2];
                int indexOf = arg.indexOf(":");
                buffer.append("parameters.put(\"");
                buffer.append(arg.substring(indexOf + 1));
                buffer.append("\", ");
                buffer.append(arg.substring(0, indexOf));
                buffer.append(");");
                buffer.append(N);
                ++n2;
            }
            buffer.append("CallHelper.executeWithParameterInjection(\"" + patternId + "\", new ExecutionContext((InternalPatternContext) ctx), parameters);");
            buffer.append(N);
            this.generators.add(new JETScriptletGenerator(buffer.toString().toCharArray()));
        } else if (EGF_PATTERN_INJECTED_CALL.equals(directive)) {
            String patternId = attributes.get("patternId");
            String toInject = attributes.get("toInject");
            String id = PatternHelper.generateID();
            StringBuffer buffer = new StringBuffer();
            buffer.append("ExecutionContext ctx_");
            buffer.append(id);
            buffer.append(" = new ExecutionContext((InternalPatternContext) ctx);");
            buffer.append(N);
            buffer.append("ctx_");
            buffer.append(id);
            buffer.append(".setValue(PatternContext.INJECTED_CONTEXT, ");
            buffer.append(toInject);
            buffer.append(");");
            buffer.append(N);
            buffer.append("CallHelper.executeWithContextInjection(\"");
            buffer.append(patternId);
            buffer.append("\", ctx_");
            buffer.append(id);
            buffer.append(");");
            buffer.append(N);
            this.generators.add(new JETScriptletGenerator(buffer.toString().toCharArray()));
        } else {
            super.handleDirective(directive, start, stop, attributes);
        }
    }

    protected void parse(JETCoreElement[] coreElements, Class<?>[] accept) throws JETException {
        JETParser.Directive directive = (JETParser.Directive)coreElements[0];
        directive.getDirectives().add(EGF_PATTERN_INJECTED_CALL);
        directive.getDirectives().add(EGF_PATTERN_CALL);
        super.parse(coreElements, (Class[])accept);
    }
}

