/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.application.internal.activity;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.egf.application.internal.activator.EGFApplicationPlugin;
import org.eclipse.egf.application.internal.l10n.ApplicationMessages;
import org.eclipse.egf.common.helper.EMFHelper;
import org.eclipse.egf.core.l10n.EGFCoreMessages;
import org.eclipse.egf.core.producer.InvocationException;
import org.eclipse.egf.model.fcore.Activity;
import org.eclipse.egf.producer.EGFProducerPlugin;
import org.eclipse.egf.producer.l10n.ProducerMessages;
import org.eclipse.egf.producer.manager.IActivityManager;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActivityRunner {
    protected List<Activity> _activities;

    public ActivityRunner(Activity activity) {
        if (activity != null) {
            this._activities = Collections.singletonList(activity);
        }
    }

    public ActivityRunner(List<Activity> activities) {
        this._activities = activities;
    }

    public void run(IProgressMonitor monitor) throws CoreException {
        if (this._activities == null || this._activities.isEmpty()) {
            return;
        }
        for (Activity activity : this._activities) {
            Diagnostic diagnostic;
            IActivityManager manager = null;
            try {
                manager = EGFProducerPlugin.getActivityManagerProducer((Activity)activity).createActivityManager(activity);
                manager.initializeContext();
            }
            catch (Throwable t) {
                throw new CoreException(EGFApplicationPlugin.getDefault().newStatus(4, NLS.bind((String)ApplicationMessages.ActivityRunner_ActivityRunner_Exception, (Object)EcoreUtil.getURI((EObject)activity)), t));
            }
            try {
                diagnostic = manager.canInvoke();
                if (diagnostic.getSeverity() == 4) {
                    throw DiagnosticException.toCoreException((DiagnosticException)new DiagnosticException(diagnostic));
                }
            }
            catch (CoreException ce) {
                throw ce;
            }
            catch (InvocationException ie) {
                throw new CoreException(EGFApplicationPlugin.getDefault().newStatus(4, NLS.bind((String)ApplicationMessages.ActivityRunner_PreInvokeProblems_message, (Object)EcoreUtil.getURI((EObject)activity)), ie));
            }
            diagnostic = null;
            try {
                int ticks = manager.getSteps();
                SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)NLS.bind((String)EGFCoreMessages.Production_Invoke, (Object)EMFHelper.getText((Object)manager.getElement())), (int)(1000 * ticks));
                if (ticks == 1) {
                    EGFApplicationPlugin.getDefault().logInfo(NLS.bind((String)ProducerMessages.Activity_Invocation, (Object)EMFHelper.getText((Object)activity)));
                } else {
                    EGFApplicationPlugin.getDefault().logInfo(NLS.bind((String)ProducerMessages.Activity_Invocations, (Object)EMFHelper.getText((Object)activity), (Object)ticks));
                }
                diagnostic = manager.invoke((IProgressMonitor)subMonitor.newChild(1000 * ticks, 0));
            }
            catch (Throwable t) {
                throw new CoreException(EGFApplicationPlugin.getDefault().newStatus(4, NLS.bind((String)ApplicationMessages.ActivityRunner_ActivityRunner_Exception, (Object)EcoreUtil.getURI((EObject)activity)), t));
            }
            if (diagnostic.getSeverity() == 4) {
                throw DiagnosticException.toCoreException((DiagnosticException)new DiagnosticException(diagnostic));
            }
            try {
                manager.dispose();
            }
            catch (Throwable t) {
                throw new CoreException(EGFApplicationPlugin.getDefault().newStatus(4, ApplicationMessages.ActivityRunner_ActivityRunner_Exception, t));
            }
        }
    }
}

