/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.common.helper;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.egf.common.EGFCommonPlugin;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.osgi.util.NLS;

public class EMFHelper {
    private static AdapterFactory __defaultFactory = new ReflectiveItemProviderAdapterFactory();
    private static AdapterFactory __factory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);

    private EMFHelper() {
    }

    public static IResource getWorkspaceResource(Resource resource) {
        URIConverter converter;
        if (resource == null) {
            return null;
        }
        URI uri = resource.getURI();
        if (uri != null && resource.getResourceSet() != null && (converter = resource.getResourceSet().getURIConverter()) != null) {
            uri = converter.normalize(uri);
        }
        if (uri != null && uri.isPlatformResource()) {
            return ResourcesPlugin.getWorkspace().getRoot().findMember(uri.toPlatformString(true));
        }
        return null;
    }

    public static IProject getProject(Resource resource) {
        IResource iResource = EMFHelper.getWorkspaceResource(resource);
        if (iResource != null) {
            return iResource.getProject();
        }
        return null;
    }

    public static IJavaProject getJavaProject(Resource resource) {
        IJavaProject javaProject;
        IProject project = EMFHelper.getProject(resource);
        if (project != null && (javaProject = JavaCore.create((IProject)project)).exists()) {
            return javaProject;
        }
        return null;
    }

    public static EPackage getRootPackage(EPackage ePackage) {
        if (ePackage == null) {
            EGFCommonPlugin.getDefault().logWarning("Unable to solve a Root EPackage for a null EPackage");
            return null;
        }
        EPackage result = null;
        EPackage rootPackage = ePackage;
        while (rootPackage != null) {
            result = rootPackage;
            rootPackage = result.getESuperPackage();
        }
        if (result == null) {
            EGFCommonPlugin.getDefault().logWarning(NLS.bind((String)"Unable to solve a Root EPackage for {0}", (Object)ePackage));
        }
        return result;
    }

    public static EPackage getStaticPackage(EPackage ePackage) {
        EPackage ePackageStatic = null;
        Object staticPackage = null;
        if (ePackage != null && ePackage.getNsURI() != null) {
            staticPackage = EPackage.Registry.INSTANCE.get((Object)ePackage.getNsURI());
        }
        if (staticPackage != null) {
            if (staticPackage instanceof EPackage) {
                ePackageStatic = (EPackage)staticPackage;
            } else if (staticPackage instanceof EPackage.Descriptor) {
                ePackageStatic = ((EPackage.Descriptor)staticPackage).getEPackage();
            }
        } else {
            if (ePackage != null) {
                EGFCommonPlugin.getDefault().logWarning(NLS.bind((String)"Unable to get static EPackage for {0}", (Object)ePackage));
            } else {
                EGFCommonPlugin.getDefault().logWarning("Unable to get static EPackage");
            }
            ePackageStatic = ePackage;
        }
        return ePackageStatic;
    }

    public static EClassifier solveAgainstStaticPackage(EClassifier eClassifier) {
        if (eClassifier == null) {
            return null;
        }
        EPackage ePackage = EMFHelper.getStaticPackage(EMFHelper.getRootPackage(eClassifier.getEPackage()));
        if (ePackage != null && ePackage.eResource() != null) {
            EClassifier solvedEClassifier;
            URI uri = EcoreUtil.getURI((EObject)eClassifier);
            if (uri == null) {
                return eClassifier;
            }
            EObject eObject = ePackage.eResource().getEObject(uri.fragment());
            Object object = solvedEClassifier = eObject instanceof EClassifier ? (EClassifier)eObject : eObject.eClass();
            if (solvedEClassifier != null) {
                return solvedEClassifier;
            }
        } else {
            EGFCommonPlugin.getDefault().logWarning(NLS.bind((String)"Unable to solve EClassifier {0} against its static EPackage", (Object)eClassifier));
        }
        return eClassifier;
    }

    public static EObject solveAgainstStaticPackage(EPackage ePackage, EObject eObject) {
        if (eObject == null) {
            return null;
        }
        EPackage solvedEPackage = EMFHelper.getStaticPackage(EMFHelper.getRootPackage(ePackage));
        if (solvedEPackage != null && solvedEPackage.eResource() != null) {
            URI uri = EcoreUtil.getURI((EObject)eObject);
            if (uri == null) {
                return eObject;
            }
            EObject solvedEObject = solvedEPackage.eResource().getEObject(uri.fragment());
            if (solvedEObject != null) {
                return solvedEObject;
            }
        } else {
            EGFCommonPlugin.getDefault().logWarning(NLS.bind((String)"Unable to solve EObject {0} against its static EPackage", (Object)eObject));
        }
        return eObject;
    }

    public static String getText(Object object) {
        String result;
        if (object == null || !(object instanceof EObject)) {
            if (object == null) {
                return null;
            }
            return object.toString();
        }
        EObject eObject = (EObject)object;
        IItemLabelProvider provider = (IItemLabelProvider)__factory.adapt((Notifier)eObject, IItemLabelProvider.class);
        if (provider == null) {
            provider = (IItemLabelProvider)EMFHelper.getRegisteredAdapter(eObject, IItemLabelProvider.class);
        }
        if (provider == null) {
            provider = (IItemLabelProvider)__defaultFactory.adapt((Notifier)eObject, IItemLabelProvider.class);
        }
        if ((result = provider.getText((Object)eObject)) != null) {
            result = result.trim();
        }
        return result;
    }

    public static IItemLabelProvider getItemLabelProvider(EObject eObject) {
        if (eObject == null) {
            return null;
        }
        IItemLabelProvider provider = (IItemLabelProvider)__factory.adapt((Notifier)eObject, IItemLabelProvider.class);
        if (provider == null) {
            provider = (IItemLabelProvider)EMFHelper.getRegisteredAdapter(eObject, IItemLabelProvider.class);
        }
        if (provider == null) {
            provider = (IItemLabelProvider)__defaultFactory.adapt((Notifier)eObject, IItemLabelProvider.class);
        }
        return provider;
    }

    private static Object getRegisteredAdapter(EObject eObject, Object type) {
        ResourceSet resourceSet;
        Resource resource;
        Adapter result = EcoreUtil.getExistingAdapter((Notifier)eObject, (Object)type);
        if (result == null && (resource = eObject.eResource()) != null && (resourceSet = resource.getResourceSet()) != null) {
            EList factories = resourceSet.getAdapterFactories();
            Iterator iter = factories.iterator();
            while (iter.hasNext() && result == null) {
                AdapterFactory next = (AdapterFactory)iter.next();
                if (!next.isFactoryForType(type)) continue;
                result = next.adapt((Notifier)eObject, type);
            }
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class URIProxyCrossReferencer
    extends EcoreUtil.CrossReferencer {
        private static final long serialVersionUID = 1L;
        private URI _uri;

        protected URIProxyCrossReferencer(Resource resource, URI uri) {
            super(Collections.singleton(resource));
            this._uri = uri;
        }

        protected boolean resolve() {
            return false;
        }

        protected boolean crossReference(EObject eObject, EReference eReference, EObject crossReferencedEObject) {
            if (!crossReferencedEObject.eIsProxy()) {
                return false;
            }
            URI uri = EcoreUtil.getURI((EObject)crossReferencedEObject);
            if (uri == null) {
                return false;
            }
            return this._uri.equals((Object)(uri = uri.trimFragment()));
        }

        protected Map<EObject, Collection<EStructuralFeature.Setting>> findProxyCrossReferences() {
            this.crossReference();
            this.done();
            return this;
        }

        public static Map<EObject, Collection<EStructuralFeature.Setting>> find(Resource resource, URI uri) {
            return new URIProxyCrossReferencer(resource, uri).findProxyCrossReferences();
        }
    }
}

