/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.model.editor.adapter;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.egf.common.ui.helper.ThrowableHandler;
import org.eclipse.egf.core.EGFCorePlugin;
import org.eclipse.egf.core.fcore.IPlatformFcore;
import org.eclipse.egf.core.pde.tools.ConvertProjectOperation;
import org.eclipse.egf.model.editor.EGFModelEditorPlugin;
import org.eclipse.egf.model.types.TypeClass;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPartSite;

public class TypeClassBundleAdapter
extends EContentAdapter {
    private Resource _resource;
    private Shell _shell;

    public TypeClassBundleAdapter(Resource resource) {
        this._shell = EGFModelEditorPlugin.getActiveWorkbenchShell();
        this._resource = resource;
    }

    public TypeClassBundleAdapter(Resource resource, IWorkbenchPartSite site) {
        this._shell = site != null ? site.getShell() : EGFModelEditorPlugin.getActiveWorkbenchShell();
        this._resource = resource;
    }

    public void notifyChanged(Notification notification) {
        super.notifyChanged(notification);
        if (notification.getNewValue() != null && notification.getNewValue() instanceof TypeClass) {
            this.handleNotification(notification);
        }
    }

    private void handleNotification(Notification notification) {
        if (notification.getEventType() == 1) {
            TypeClass typeClass = (TypeClass)notification.getNewValue();
            Resource resource = typeClass.eResource();
            if (resource != this._resource || ((ResourceImpl)resource).isLoading()) {
                return;
            }
            IPlatformFcore fcore = EGFCorePlugin.getPlatformFcore((Resource)typeClass.eResource());
            if (fcore == null || fcore.getPlatformBundle().getProject() == null) {
                return;
            }
            IJavaProject javaProject = JavaCore.create((IProject)fcore.getPlatformBundle().getProject());
            if (javaProject.exists()) {
                return;
            }
            ConvertProjectOperation operation = new ConvertProjectOperation(javaProject.getProject(), true, true){

                public List<String> addSourceFolders() {
                    ArrayList<String> sourceFolders = new ArrayList<String>(1);
                    sourceFolders.add("src");
                    return sourceFolders;
                }
            };
            try {
                new ProgressMonitorDialog(this._shell).run(true, false, (IRunnableWithProgress)operation);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Exception e) {
                ThrowableHandler.handleThrowable((String)EGFModelEditorPlugin.getPlugin().getSymbolicName(), (Throwable)e);
            }
        }
    }
}

