/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.model.editor.contributions;

import org.eclipse.egf.model.domain.DomainURI;
import org.eclipse.egf.model.domain.TypeDomainURI;
import org.eclipse.egf.model.editor.contributions.OpenEObjectMenuContributor;
import org.eclipse.egf.model.editor.l10n.ModelEditorMessages;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.IStructuredSelection;

public class OpenURIMenuContributor
extends OpenEObjectMenuContributor {
    public static final String OPEN_URI_ACTION_ID = "open-uri";
    private final OpenEObjectMenuContributor.OpenAction _openAction = new OpenEObjectMenuContributor.OpenAction(this, "open-uri"){

        public boolean isEnabled() {
            return true;
        }

        protected EObject getEObject() {
            if (OpenURIMenuContributor.this._selection == null) {
                return null;
            }
            IStructuredSelection sselection = (IStructuredSelection)OpenURIMenuContributor.this._selection;
            if (sselection.size() != 1) {
                return null;
            }
            Object object = sselection.getFirstElement();
            if (object instanceof DomainURI) {
                return (DomainURI)object;
            }
            if (object instanceof TypeDomainURI) {
                return (TypeDomainURI)object;
            }
            return null;
        }

        protected URI getURI() {
            EObject eObject = this.getEObject();
            if (eObject == null) {
                return null;
            }
            URI uri = null;
            if (eObject instanceof DomainURI) {
                uri = ((DomainURI)eObject).getUri();
            } else if (eObject instanceof TypeDomainURI) {
                uri = ((TypeDomainURI)eObject).getValue();
            }
            return uri;
        }
    };

    protected String getText() {
        if (this.getOpenAction().isAlreadyOpenedEditor()) {
            return ModelEditorMessages.URIMenuContributor_selectAction_label;
        }
        return ModelEditorMessages.URIMenuContributor_openAction_label;
    }

    protected OpenEObjectMenuContributor.OpenAction getOpenAction() {
        return this._openAction;
    }
}

