/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.model.editor.contributions;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.egf.common.ui.helper.ThrowableHandler;
import org.eclipse.egf.core.ui.contributor.DefaultPropertyEditorContributor;
import org.eclipse.egf.core.ui.dialogs.TypeSelectionDialog;
import org.eclipse.egf.model.editor.EGFModelEditorPlugin;
import org.eclipse.egf.model.fcore.Contract;
import org.eclipse.egf.model.types.TypeClass;
import org.eclipse.egf.model.types.TypesPackage;
import org.eclipse.emf.common.ui.celleditor.ExtendedDialogCellEditor;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;

public class TypeClassEditorContributor
extends DefaultPropertyEditorContributor {
    public boolean canApply(Object object, IItemPropertyDescriptor descriptor) {
        if (!(object instanceof TypeClass) || ((TypeClass)object).eResource() == null) {
            return false;
        }
        return this.checkFeature(object, descriptor, (EStructuralFeature)TypesPackage.Literals.TYPE_ABSTRACT_CLASS__VALUE) && ((TypeClass)object).eContainer() instanceof Contract;
    }

    public CellEditor createPropertyEditor(final Composite composite, final Object object, IItemPropertyDescriptor descriptor) {
        return new ExtendedDialogCellEditor(composite, this.getLabelProvider(object, descriptor)){

            protected Object openDialogBox(Control cellEditorWindow) {
                TypeClass typeClass = (TypeClass)object;
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(typeClass.eResource().getURI().segment(1));
                if (project == null) {
                    return null;
                }
                IJavaProject javaProject = null;
                try {
                    if (project.isAccessible() && project.hasNature("org.eclipse.jdt.core.javanature")) {
                        javaProject = JavaCore.create((IProject)project);
                    }
                }
                catch (CoreException ce) {
                    ThrowableHandler.handleThrowable((String)EGFModelEditorPlugin.getPlugin().getSymbolicName(), (Throwable)ce);
                    return null;
                }
                if (javaProject == null) {
                    return null;
                }
                try {
                    TypeSelectionDialog dialog = new TypeSelectionDialog(composite.getShell(), false, (IRunnableContext)PlatformUI.getWorkbench().getProgressService(), javaProject, 10);
                    if (dialog.open() != 0) {
                        return null;
                    }
                    Object[] innerResult = dialog.getResult();
                    if (innerResult != null && innerResult.length > 0 && innerResult[0] instanceof IType) {
                        String string = ((IType)innerResult[0]).getFullyQualifiedName();
                        return string;
                    }
                }
                finally {
                    try {
                        javaProject.close();
                    }
                    catch (JavaModelException jme) {
                        ThrowableHandler.handleThrowable((String)EGFModelEditorPlugin.getPlugin().getSymbolicName(), (Throwable)jme);
                    }
                }
                return null;
            }
        };
    }
}

