/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.model.editor.wizards;

import org.eclipse.egf.model.editor.EGFModelEditorPlugin;
import org.eclipse.egf.model.editor.commands.InvokeActivityCommand;
import org.eclipse.egf.model.editor.dialogs.EGFWizardDialog;
import org.eclipse.egf.model.editor.l10n.ModelEditorMessages;
import org.eclipse.egf.model.editor.wizards.ActivitySelectionWizardPage;
import org.eclipse.egf.model.fcore.Activity;
import org.eclipse.egf.model.fprod.ProductionPlan;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class InvokeActivityWizard
extends Wizard
implements INewWizard {
    protected IStructuredSelection _selection;
    protected IWorkbench _workbench;
    protected ActivitySelectionWizardPage _activitySelectionWizardPage;
    public boolean _isCanceled;

    protected ProductionPlan getProductionPlan() {
        if (this._selection == null || this._selection.size() != 1) {
            return null;
        }
        Object object = this._selection.getFirstElement();
        if (object instanceof ProductionPlan) {
            return (ProductionPlan)object;
        }
        return null;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this._workbench = workbench;
        this._selection = selection;
        this.setWindowTitle(EGFModelEditorPlugin.INSTANCE.getString("_UI_Wizard_Invoke_Activity_label"));
        this.setDefaultPageImageDescriptor(ExtendedImageRegistry.INSTANCE.getImageDescriptor(EGFModelEditorPlugin.INSTANCE.getImage("full/wizban/NewFcore")));
        this.setNeedsProgressMonitor(true);
    }

    public boolean performCancel() {
        this._isCanceled = true;
        return true;
    }

    public void finishWizardDialog() {
        if (this.getContainer() instanceof EGFWizardDialog) {
            ((EGFWizardDialog)this.getContainer()).finishDialog();
        }
    }

    public void addPages() {
        this._activitySelectionWizardPage = new ActivitySelectionWizardPage(){

            protected String getHeaderMessage() {
                return ModelEditorMessages.FilteredItemsSelectionDialog_patternLabel;
            }
        };
        this._activitySelectionWizardPage.setTitle(ModelEditorMessages.InvokeActivityWizard_Activity_title);
        this._activitySelectionWizardPage.setDescription(ModelEditorMessages.InvokeActivityWizard_Activity_description);
        this.addPage((IWizardPage)this._activitySelectionWizardPage);
    }

    public boolean performFinish() {
        Object[] result = this._activitySelectionWizardPage.getResult();
        if (result == null || result.length == 0) {
            return true;
        }
        Activity activity = (Activity)result[0];
        ProductionPlan productionPlan = this.getProductionPlan();
        if (productionPlan == null) {
            return true;
        }
        EditingDomain domain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)productionPlan);
        if (domain == null) {
            return false;
        }
        Command[] command = new Command[]{new InvokeActivityCommand(domain, productionPlan, (Activity)domain.getResourceSet().getEObject(EcoreUtil.getURI((EObject)activity), true))};
        if (domain instanceof TransactionalEditingDomain) {
            domain.getCommandStack().execute(new RecordingCommand((TransactionalEditingDomain)domain){

                protected void doExecute() {
                }
            }.chain(command[0]));
        } else {
            domain.getCommandStack().execute(command[0]);
        }
        return true;
    }
}

