/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.server.accesscontrol.authentication.factory;

import java.util.Properties;
import org.eclipse.emf.emfstore.server.ServerConfiguration;
import org.eclipse.emf.emfstore.server.accesscontrol.authentication.AbstractAuthenticationControl;
import org.eclipse.emf.emfstore.server.accesscontrol.authentication.LDAPVerifier;
import org.eclipse.emf.emfstore.server.accesscontrol.authentication.SimplePropertyFileVerifier;
import org.eclipse.emf.emfstore.server.accesscontrol.authentication.VerifierChain;
import org.eclipse.emf.emfstore.server.accesscontrol.authentication.factory.AuthenticationControlFactory;
import org.eclipse.emf.emfstore.server.exceptions.FatalEmfStoreException;
import org.eclipse.emf.emfstore.server.exceptions.InvalidPropertyException;

public class AuthenticationControlFactoryImpl
implements AuthenticationControlFactory {
    public AbstractAuthenticationControl createAuthenticationControl() throws FatalEmfStoreException {
        String property = ServerConfiguration.getProperties().getProperty("emfstore.accesscontrol.authentication.policy", "spfv");
        if (property.equals("ldap")) {
            VerifierChain chain = new VerifierChain();
            Properties properties = ServerConfiguration.getProperties();
            int count = 1;
            while (count != -1) {
                String ldapUrl = properties.getProperty("emfstore.accesscontrol.authentication.ldap." + count + "." + "url");
                String ldapBase = properties.getProperty("emfstore.accesscontrol.authentication.ldap." + count + "." + "base");
                String searchDn = properties.getProperty("emfstore.accesscontrol.authentication.ldap." + count + "." + "searchdn");
                String authUser = properties.getProperty("emfstore.accesscontrol.authentication.ldap." + count + "." + "authuser");
                String authPassword = properties.getProperty("emfstore.accesscontrol.authentication.ldap." + count + "." + "authpass");
                if (ldapUrl != null && ldapBase != null && searchDn != null) {
                    LDAPVerifier ldapVerifier = new LDAPVerifier(ldapUrl, ldapBase, searchDn, authUser, authPassword);
                    chain.getVerifier().add(ldapVerifier);
                    ++count;
                    continue;
                }
                count = -1;
            }
            return chain;
        }
        if (property.equals("spfv")) {
            return new SimplePropertyFileVerifier(ServerConfiguration.getProperties().getProperty("emfstore.accesscontrol.authentication.spfv", ServerConfiguration.getDefaultSPFVFilePath()));
        }
        throw new InvalidPropertyException();
    }
}

