/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.server.core.subinterfaces;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.emfstore.common.model.EMFStoreProperty;
import org.eclipse.emf.emfstore.server.core.AbstractEmfstoreInterface;
import org.eclipse.emf.emfstore.server.core.AbstractSubEmfstoreInterface;
import org.eclipse.emf.emfstore.server.core.MonitorProvider;
import org.eclipse.emf.emfstore.server.exceptions.EmfStoreException;
import org.eclipse.emf.emfstore.server.exceptions.FatalEmfStoreException;
import org.eclipse.emf.emfstore.server.model.ProjectHistory;
import org.eclipse.emf.emfstore.server.model.ProjectId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EMFStorePropertiesSubInterfaceImpl
extends AbstractSubEmfstoreInterface {
    private static final String EMFSTORE_PROPERTIES_MONITOR = "EmfStorePropertiesMonitor";
    private Map<ProjectHistory, Map<String, EMFStoreProperty>> cache = new HashMap<ProjectHistory, Map<String, EMFStoreProperty>>();

    public EMFStorePropertiesSubInterfaceImpl(AbstractEmfstoreInterface parentInterface) throws FatalEmfStoreException {
        super(parentInterface);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<EMFStoreProperty> setProperties(List<EMFStoreProperty> properties, ProjectId projectId) throws EmfStoreException {
        Object object = MonitorProvider.getInstance().getMonitor(EMFSTORE_PROPERTIES_MONITOR);
        synchronized (object) {
            ArrayList<EMFStoreProperty> rejectedProperties = new ArrayList<EMFStoreProperty>();
            ProjectHistory history = this.findHistory(projectId);
            if (history == null) {
                throw new EmfStoreException("The Project does not exist on the server. Cannot set the properties.");
            }
            EList sharedProperties = history.getSharedProperties();
            HashSet<EMFStoreProperty> replacedProperties = new HashSet<EMFStoreProperty>();
            for (EMFStoreProperty property : properties) {
                EMFStoreProperty foundProperty = this.findProperty(history, property.getKey());
                if (foundProperty == null) {
                    sharedProperties.add((Object)property);
                    this.updateCache(history, property);
                    if (!property.isVersioned()) continue;
                    property.increaseVersion();
                    continue;
                }
                if (property.isVersioned()) {
                    if (property.getVersion() == foundProperty.getVersion()) {
                        sharedProperties.set(sharedProperties.indexOf((Object)foundProperty), (Object)property);
                        replacedProperties.add(foundProperty);
                        property.increaseVersion();
                        continue;
                    }
                    rejectedProperties.add(foundProperty);
                    continue;
                }
                sharedProperties.set(sharedProperties.indexOf((Object)foundProperty), (Object)property);
                replacedProperties.add(foundProperty);
            }
            try {
                this.getServerSpace().save();
            }
            catch (IOException e) {
                sharedProperties.removeAll(properties);
                sharedProperties.addAll(replacedProperties);
                throw new EmfStoreException("Cannot set the properties on the server.", e);
            }
            return rejectedProperties;
        }
    }

    public List<EMFStoreProperty> getProperties(ProjectId projectId) throws EmfStoreException {
        ProjectHistory history = this.findHistory(projectId);
        if (history != null) {
            ArrayList<EMFStoreProperty> temp = new ArrayList<EMFStoreProperty>();
            for (EMFStoreProperty prop : history.getSharedProperties()) {
                temp.add(prop);
            }
            return temp;
        }
        throw new EmfStoreException("The Project does not exist on the server. Cannot set the properties.");
    }

    private ProjectHistory findHistory(ProjectId projectId) {
        EList serverProjects = this.getServerSpace().getProjects();
        for (ProjectHistory history : serverProjects) {
            if (!history.getProjectId().equals(projectId)) continue;
            return history;
        }
        return null;
    }

    private EMFStoreProperty findProperty(ProjectHistory projectHistory, String propertyName) {
        Map<String, EMFStoreProperty> propertiesMap = this.initCacheForHistory(projectHistory);
        return propertiesMap.get(propertyName);
    }

    private Map<String, EMFStoreProperty> initCacheForHistory(ProjectHistory projectHistory) {
        Map<String, EMFStoreProperty> propertiesMap = this.cache.get(projectHistory);
        if (propertiesMap == null) {
            propertiesMap = new HashMap<String, EMFStoreProperty>();
            for (EMFStoreProperty prop : projectHistory.getSharedProperties()) {
                propertiesMap.put(prop.getKey(), prop);
            }
        }
        return propertiesMap;
    }

    private void updateCache(ProjectHistory history, EMFStoreProperty property) {
        Map<String, EMFStoreProperty> properties = this.initCacheForHistory(history);
        properties.put(property.getKey(), property);
    }
}

