/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.server.eventmanager;

import java.util.ArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.emfstore.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.server.eventmanager.EMFStoreEventListener;
import org.eclipse.emf.emfstore.server.model.ProjectId;
import org.eclipse.emf.emfstore.server.model.versioning.events.server.ServerEvent;
import org.eclipse.emf.emfstore.server.model.versioning.events.server.ServerProjectEvent;

public final class EventManager
extends Thread {
    private static EventManager instance;
    private LinkedBlockingQueue<ServerEvent> queue = new LinkedBlockingQueue();
    private ArrayList<ListenerContainer> listeners = new ArrayList();

    private EventManager() {
        super("EventManager");
        this.start();
    }

    public static EventManager getInstance() {
        if (instance == null) {
            instance = new EventManager();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        ArrayList<ListenerContainer> tmp = new ArrayList<ListenerContainer>();
        while (!this.isInterrupted()) {
            try {
                ServerEvent event = this.queue.take();
                if (event == null) continue;
                EventManager eventManager = this;
                synchronized (eventManager) {
                    for (ListenerContainer e : this.listeners) {
                        boolean successful = e.handleEvent((ServerEvent)ModelUtil.clone((EObject)event));
                        if (successful) continue;
                        tmp.add(e);
                    }
                    this.listeners.removeAll(tmp);
                    tmp.clear();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerListener(EMFStoreEventListener listener, ProjectId projectId, EClass clazz) {
        if (listener == null) {
            return;
        }
        EventManager eventManager = this;
        synchronized (eventManager) {
            this.listeners.add(new ListenerContainer(listener, projectId, clazz));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterListener(EMFStoreEventListener listener) {
        if (listener == null) {
            return;
        }
        EventManager eventManager = this;
        synchronized (eventManager) {
            this.listeners.remove(listener);
        }
    }

    public void sendEvent(ServerEvent event) {
        if (event != null) {
            try {
                this.queue.put(event);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private class ListenerContainer {
        private final EMFStoreEventListener listener;
        private final ProjectId projectId;
        private final EClass clazz;

        public ListenerContainer(EMFStoreEventListener listener, ProjectId projectId, EClass clazz) {
            this.listener = listener;
            this.projectId = projectId;
            this.clazz = clazz;
        }

        public boolean handleEvent(ServerEvent event) {
            if (this.projectId != null && event instanceof ServerProjectEvent && !this.projectId.equals(((ServerProjectEvent)event).getProjectId())) {
                return true;
            }
            return this.listener.handleEvent(event);
        }
    }
}

