/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.editor.mecontrols;

import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.databinding.EMFDataBindingContext;
import org.eclipse.emf.databinding.edit.EMFEditObservables;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.editor.Activator;
import org.eclipse.emf.ecp.editor.mecontrols.AbstractMEControl;
import org.eclipse.emf.ecp.editor.mecontrols.IValidatableControl;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public class MEEnumControl
extends AbstractMEControl
implements IValidatableControl {
    private EAttribute attribute;
    private ComboViewer combo;
    private Composite composite;
    private Label labelWidgetImage;
    private static final int PRIORITY = 1;

    public Control createControl(Composite parent, int style) {
        Object feature = this.getItemPropertyDescriptor().getFeature((Object)this.getModelElement());
        this.attribute = (EAttribute)feature;
        this.composite = this.getToolkit().createComposite(parent, style);
        GridLayoutFactory.fillDefaults().numColumns(2).spacing(2, 0).applyTo(this.composite);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.composite);
        this.labelWidgetImage = this.getToolkit().createLabel(this.composite, "    ");
        this.labelWidgetImage.setBackground(parent.getBackground());
        final IItemLabelProvider labelProvider = this.getItemPropertyDescriptor().getLabelProvider((Object)this.getModelElement());
        this.combo = new ComboViewer(this.composite);
        this.combo.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.combo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return labelProvider.getText(element);
            }
        });
        this.combo.setInput(this.attribute.getEType().getInstanceClass().getEnumConstants());
        EMFDataBindingContext dbc = new EMFDataBindingContext();
        IObservableValue model = EMFEditObservables.observeValue((EditingDomain)this.getEditingDomain(), (EObject)this.getModelElement(), (EStructuralFeature)this.attribute);
        IViewerObservableValue comboObservable = ViewersObservables.observeSingleSelection((Viewer)this.combo);
        dbc.bindValue((IObservableValue)comboObservable, model);
        return this.composite;
    }

    public int canRender(IItemPropertyDescriptor itemPropertyDescriptor, EObject modelElement) {
        Object feature = itemPropertyDescriptor.getFeature((Object)modelElement);
        if (feature instanceof EAttribute && EEnum.class.isAssignableFrom(((EAttribute)feature).getEType().getClass())) {
            return 1;
        }
        return -1;
    }

    public void handleValidation(Diagnostic diagnostic) {
        if (diagnostic.getSeverity() == 4 || diagnostic.getSeverity() == 2) {
            Image image = Activator.getImageDescriptor("icons/validation_error.png").createImage();
            this.labelWidgetImage.setImage(image);
            this.labelWidgetImage.setToolTipText(diagnostic.getMessage());
        }
    }

    public void resetValidation() {
        this.labelWidgetImage.setImage(null);
        this.labelWidgetImage.setToolTipText("");
    }
}

