/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.editor.mecontrols.melinkcontrol.associationclasscontrol;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.common.commands.ECPCommand;
import org.eclipse.emf.ecp.editor.ModelElementChangeListener;
import org.eclipse.emf.ecp.editor.mecontrols.AbstractMEControl;
import org.eclipse.emf.ecp.editor.mecontrols.melinkcontrol.MELinkControl;
import org.eclipse.emf.ecp.editor.mecontrols.melinkcontrol.MELinkControlFactory;
import org.eclipse.emf.ecp.editor.mecontrols.melinkcontrol.associationclasscontrol.AddAssociationClassAction;
import org.eclipse.emf.ecp.editor.mecontrols.melinkcontrol.associationclasscontrol.NewAssociationClassAction;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class AssociationClassControl
extends AbstractMEControl {
    private static final int PRIORITY = 2;
    private EReference eReference;
    private int style;
    private ScrolledComposite scrollPane;
    private Section section;
    private Composite linkArea;
    private Composite composite;
    private Composite scrollClient;
    private GridLayout tableLayout;
    private ModelElementChangeListener modelElementChangeListener;
    private ArrayList<MELinkControl> linkControls;

    public int canRender(IItemPropertyDescriptor itemPropertyDescriptor, EObject modelElement) {
        Object feature = itemPropertyDescriptor.getFeature((Object)modelElement);
        if (this.getContext() != null && feature instanceof EReference && this.getContext().getMetaModelElementContext().isAssociationClassElement(((EReference)feature).getEReferenceType())) {
            return 2;
        }
        return -1;
    }

    public void dispose() {
        this.modelElementChangeListener.remove();
        for (MELinkControl link : this.linkControls) {
            link.dispose();
        }
    }

    protected Control createControl(Composite parent, int style) {
        this.linkControls = new ArrayList();
        this.eReference = (EReference)this.getItemPropertyDescriptor().getFeature((Object)this.getModelElement());
        this.modelElementChangeListener = new ModelElementChangeListener(this.getModelElement()){

            public void onChange(Notification notification) {
                if (notification.getEventType() != 9 && notification.getFeature().equals(AssociationClassControl.this.eReference)) {
                    AssociationClassControl.this.rebuildLinkSection();
                }
            }
        };
        this.style = style;
        this.tableLayout = new GridLayout(1, false);
        this.section = this.getToolkit().createSection(parent, 322);
        this.section.setText(this.getItemPropertyDescriptor().getDisplayName((Object)this.getModelElement()));
        this.createSectionToolbar(this.section, this.getToolkit());
        this.composite = this.getToolkit().createComposite((Composite)this.section, style);
        this.composite.setLayout((Layout)this.tableLayout);
        this.rebuildLinkSection();
        this.section.setClient((Control)this.composite);
        return this.section;
    }

    private void createSectionToolbar(Section section, FormToolkit toolkit) {
        ToolBarManager toolBarManager = new ToolBarManager(0x800000);
        ToolBar toolbar = toolBarManager.createControl((Composite)section);
        final Cursor handCursor = new Cursor((Device)Display.getCurrent(), 21);
        toolbar.setCursor(handCursor);
        toolbar.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (!handCursor.isDisposed()) {
                    handCursor.dispose();
                }
            }
        });
        toolBarManager.add((IAction)new AddAssociationClassAction(this.getModelElement(), this.eReference, this.getItemPropertyDescriptor(), this.getContext()));
        toolBarManager.add((IAction)new NewAssociationClassAction(this.getModelElement(), this.eReference, this.getItemPropertyDescriptor(), this.getContext()));
        toolBarManager.update(true);
        section.setTextClient((Control)toolbar);
    }

    private void rebuildLinkSection() {
        int sizeLimit = 5;
        for (MELinkControl link : this.linkControls) {
            link.dispose();
        }
        if (this.scrollPane != null) {
            this.scrollPane.dispose();
        }
        if (this.linkArea != null) {
            this.linkArea.dispose();
        }
        this.linkControls.clear();
        new RebuildLinksCommand(this.getModelElement(), 5).run(true);
    }

    private final class RebuildLinksCommand
    extends ECPCommand {
        private int sizeLimit;

        public RebuildLinksCommand(EObject eObject) {
            super(eObject);
        }

        public RebuildLinksCommand(EObject eObject, int sizeLimit) {
            this(eObject);
            this.sizeLimit = sizeLimit;
        }

        protected void doRun() {
            Object evaluatedFeature = AssociationClassControl.this.getModelElement().eGet((EStructuralFeature)AssociationClassControl.this.eReference);
            LinkedList<Object> associations = new LinkedList<Object>();
            if (AssociationClassControl.this.eReference.isMany()) {
                associations.addAll((List)evaluatedFeature);
            } else {
                associations.add(evaluatedFeature);
            }
            if (associations.size() <= this.sizeLimit) {
                AssociationClassControl.this.linkArea = AssociationClassControl.this.getToolkit().createComposite(AssociationClassControl.this.composite, AssociationClassControl.this.style);
                AssociationClassControl.this.linkArea.setLayout((Layout)AssociationClassControl.this.tableLayout);
                AssociationClassControl.this.linkArea.setLayoutData((Object)new GridData(768));
            } else {
                AssociationClassControl.this.scrollPane = new ScrolledComposite(AssociationClassControl.this.composite, 768);
                AssociationClassControl.this.scrollPane.setBackgroundMode(2);
                AssociationClassControl.this.scrollClient = new Composite((Composite)AssociationClassControl.this.scrollPane, AssociationClassControl.this.style);
                AssociationClassControl.this.scrollPane.setContent((Control)AssociationClassControl.this.scrollClient);
                AssociationClassControl.this.getToolkit().getColors().createColor("white", 255, 255, 255);
                AssociationClassControl.this.scrollClient.setBackground(AssociationClassControl.this.getToolkit().getColors().getColor("white"));
                AssociationClassControl.this.scrollPane.setExpandVertical(true);
                AssociationClassControl.this.scrollPane.setExpandHorizontal(true);
                RowLayout rowLayout = new RowLayout(512);
                rowLayout.wrap = true;
                AssociationClassControl.this.scrollClient.setLayout((Layout)rowLayout);
                GridData spec = new GridData(400, 150);
                spec.horizontalAlignment = 4;
                spec.grabExcessHorizontalSpace = true;
                AssociationClassControl.this.scrollPane.setLayoutData((Object)spec);
                AssociationClassControl.this.scrollPane.setMinSize(150, 150);
            }
            for (Object e : associations) {
                MELinkControlFactory controlFactory = new MELinkControlFactory();
                MELinkControl meControl = controlFactory.createMELinkControl(AssociationClassControl.this.getItemPropertyDescriptor(), (EObject)e, AssociationClassControl.this.getModelElement(), AssociationClassControl.this.getContext());
                meControl.createControl(associations.size() <= this.sizeLimit ? AssociationClassControl.this.linkArea : AssociationClassControl.this.scrollClient, AssociationClassControl.this.style, AssociationClassControl.this.getItemPropertyDescriptor(), (EObject)e, AssociationClassControl.this.getModelElement(), AssociationClassControl.this.getToolkit(), AssociationClassControl.this.getContext());
                AssociationClassControl.this.linkControls.add(meControl);
            }
            if (AssociationClassControl.this.scrollPane != null && !AssociationClassControl.this.scrollPane.isDisposed()) {
                AssociationClassControl.this.scrollPane.setMinSize(AssociationClassControl.this.scrollClient.computeSize(-1, -1));
                AssociationClassControl.this.scrollClient.layout();
                AssociationClassControl.this.scrollPane.layout();
            } else {
                AssociationClassControl.this.linkArea.layout();
            }
            if (associations.size() > 0) {
                AssociationClassControl.this.section.setExpanded(false);
                AssociationClassControl.this.section.setExpanded(true);
            }
        }
    }
}

