/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.common.model.provider;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.emfstore.common.model.provider.EMFStorePropertyItemProvider;
import org.eclipse.emf.emfstore.common.model.provider.ModelElementIdItemProvider;
import org.eclipse.emf.emfstore.common.model.provider.ModelVersionItemProvider;
import org.eclipse.emf.emfstore.common.model.provider.ProjectItemProvider;
import org.eclipse.emf.emfstore.common.model.provider.PropertyMapEntryItemProvider;
import org.eclipse.emf.emfstore.common.model.provider.PropertyStringValueItemProvider;
import org.eclipse.emf.emfstore.common.model.util.ModelAdapterFactory;

public class ModelItemProviderAdapterFactory
extends ModelAdapterFactory
implements ComposeableAdapterFactory,
IChangeNotifier,
IDisposable {
    protected ComposedAdapterFactory parentAdapterFactory;
    protected IChangeNotifier changeNotifier = new ChangeNotifier();
    protected Collection<Object> supportedTypes = new ArrayList<Object>();
    protected ProjectItemProvider projectItemProvider;
    protected ModelElementIdItemProvider modelElementIdItemProvider;
    protected ModelVersionItemProvider modelVersionItemProvider;
    protected EMFStorePropertyItemProvider emfStorePropertyItemProvider;
    protected PropertyMapEntryItemProvider propertyMapEntryItemProvider;
    protected PropertyStringValueItemProvider propertyStringValueItemProvider;

    public ModelItemProviderAdapterFactory() {
        this.supportedTypes.add(IEditingDomainItemProvider.class);
        this.supportedTypes.add(IStructuredItemContentProvider.class);
        this.supportedTypes.add(ITreeItemContentProvider.class);
        this.supportedTypes.add(IItemLabelProvider.class);
        this.supportedTypes.add(IItemPropertySource.class);
    }

    public Adapter createProjectAdapter() {
        if (this.projectItemProvider == null) {
            this.projectItemProvider = new ProjectItemProvider((AdapterFactory)this);
        }
        return this.projectItemProvider;
    }

    public Adapter createModelElementIdAdapter() {
        if (this.modelElementIdItemProvider == null) {
            this.modelElementIdItemProvider = new ModelElementIdItemProvider((AdapterFactory)this);
        }
        return this.modelElementIdItemProvider;
    }

    public Adapter createModelVersionAdapter() {
        if (this.modelVersionItemProvider == null) {
            this.modelVersionItemProvider = new ModelVersionItemProvider((AdapterFactory)this);
        }
        return this.modelVersionItemProvider;
    }

    public Adapter createEMFStorePropertyAdapter() {
        if (this.emfStorePropertyItemProvider == null) {
            this.emfStorePropertyItemProvider = new EMFStorePropertyItemProvider((AdapterFactory)this);
        }
        return this.emfStorePropertyItemProvider;
    }

    public Adapter createPropertyMapEntryAdapter() {
        if (this.propertyMapEntryItemProvider == null) {
            this.propertyMapEntryItemProvider = new PropertyMapEntryItemProvider((AdapterFactory)this);
        }
        return this.propertyMapEntryItemProvider;
    }

    public Adapter createPropertyStringValueAdapter() {
        if (this.propertyStringValueItemProvider == null) {
            this.propertyStringValueItemProvider = new PropertyStringValueItemProvider((AdapterFactory)this);
        }
        return this.propertyStringValueItemProvider;
    }

    public ComposeableAdapterFactory getRootAdapterFactory() {
        return this.parentAdapterFactory == null ? this : this.parentAdapterFactory.getRootAdapterFactory();
    }

    public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
        this.parentAdapterFactory = parentAdapterFactory;
    }

    public boolean isFactoryForType(Object type) {
        return this.supportedTypes.contains(type) || super.isFactoryForType(type);
    }

    public Adapter adapt(Notifier notifier, Object type) {
        return super.adapt(notifier, (Object)this);
    }

    public Object adapt(Object object, Object type) {
        if (this.isFactoryForType(type)) {
            Object adapter = super.adapt(object, type);
            if (!(type instanceof Class) || ((Class)type).isInstance(adapter)) {
                return adapter;
            }
        }
        return null;
    }

    public void addListener(INotifyChangedListener notifyChangedListener) {
        this.changeNotifier.addListener(notifyChangedListener);
    }

    public void removeListener(INotifyChangedListener notifyChangedListener) {
        this.changeNotifier.removeListener(notifyChangedListener);
    }

    public void fireNotifyChanged(Notification notification) {
        this.changeNotifier.fireNotifyChanged(notification);
        if (this.parentAdapterFactory != null) {
            this.parentAdapterFactory.fireNotifyChanged(notification);
        }
    }

    public void dispose() {
        if (this.projectItemProvider != null) {
            this.projectItemProvider.dispose();
        }
        if (this.modelElementIdItemProvider != null) {
            this.modelElementIdItemProvider.dispose();
        }
        if (this.modelVersionItemProvider != null) {
            this.modelVersionItemProvider.dispose();
        }
        if (this.emfStorePropertyItemProvider != null) {
            this.emfStorePropertyItemProvider.dispose();
        }
        if (this.propertyMapEntryItemProvider != null) {
            this.propertyMapEntryItemProvider.dispose();
        }
        if (this.propertyStringValueItemProvider != null) {
            this.propertyStringValueItemProvider.dispose();
        }
    }
}

