/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.client.ui.decorators;

import java.util.ArrayList;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.emfstore.client.model.ProjectSpace;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;

public class UsernameDecorator
extends AdapterImpl
implements ILightweightLabelDecorator {
    private ArrayList<ILabelProviderListener> listeners = new ArrayList();
    private ProjectSpace element;

    public void decorate(Object element, IDecoration decoration) {
        ProjectSpace projectSpace;
        if (element instanceof ProjectSpace && (projectSpace = (ProjectSpace)element).getUsersession() != null) {
            String string = " " + projectSpace.getUsersession().getUsername();
            decoration.addSuffix(string);
        }
    }

    public void addListener(ILabelProviderListener listener) {
        this.listeners.add(listener);
    }

    public void dispose() {
        this.listeners.removeAll(this.listeners);
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
        this.listeners.remove(listener);
    }

    public void decorationChanged() {
        LabelProviderChangedEvent event = new LabelProviderChangedEvent((IBaseLabelProvider)this, (Object)this.element);
        for (ILabelProviderListener listener : this.listeners) {
            listener.labelProviderChanged(event);
        }
    }

    public void notifyChanged(Notification msg) {
        this.decorationChanged();
    }
}

