/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.client.ui.dialogs.login;

import org.eclipse.emf.emfstore.client.model.ModelFactory;
import org.eclipse.emf.emfstore.client.model.Usersession;
import org.eclipse.emf.emfstore.client.ui.dialogs.login.ILoginDialogController;
import org.eclipse.emf.emfstore.server.exceptions.EmfStoreException;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.ResourceManager;

public class LoginDialog
extends TitleAreaDialog {
    private Text passwordField;
    private Button savePassword;
    private ComboViewer usernameCombo;
    private final ILoginDialogController controller;
    private Usersession selectedUsersession;
    private boolean passwordModified;
    private Usersession[] knownUsersessions;

    public LoginDialog(Shell parentShell, ILoginDialogController controller) {
        super(parentShell);
        this.controller = controller;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitleImage(ResourceManager.getPluginImage("org.eclipse.emf.emfstore.client.ui", "icons/login_icon.png"));
        this.setTitle("Log in to " + this.controller.getServerLabel());
        this.setMessage("Please enter your username and password");
        this.getShell().setText("Authentication required");
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayout((Layout)new GridLayout(1, false));
        container.setLayoutData((Object)new GridData(1808));
        Composite loginContainer = new Composite(container, 0);
        loginContainer.setLayout((Layout)new GridLayout(3, false));
        loginContainer.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        loginContainer.setBounds(0, 0, 64, 64);
        Label usernameLabel = new Label(loginContainer, 0);
        GridData gd_usernameLabel = new GridData(131072, 0x1000000, false, false, 1, 1);
        gd_usernameLabel.widthHint = 95;
        usernameLabel.setLayoutData((Object)gd_usernameLabel);
        usernameLabel.setText("Username");
        this.usernameCombo = new ComboViewer(loginContainer, 0);
        ComboListener comboListener = new ComboListener();
        this.usernameCombo.addPostSelectionChangedListener((ISelectionChangedListener)comboListener);
        Combo combo = this.usernameCombo.getCombo();
        combo.addModifyListener((ModifyListener)comboListener);
        GridData gd_usernameCombo = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_usernameCombo.widthHint = 235;
        combo.setLayoutData((Object)gd_usernameCombo);
        new Label(loginContainer, 0);
        Label passwordLabel = new Label(loginContainer, 0);
        GridData gd_passwordLabel = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_passwordLabel.widthHint = 80;
        passwordLabel.setLayoutData((Object)gd_passwordLabel);
        passwordLabel.setText("Password");
        this.passwordField = new Text(loginContainer, 0x400800);
        GridData gd_passwordField = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_passwordField.widthHint = 250;
        this.passwordField.setLayoutData((Object)gd_passwordField);
        this.passwordField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LoginDialog.this.passwordModified = true;
                LoginDialog.this.flushErrorMessage();
            }
        });
        new Label(loginContainer, 0);
        Label savePasswordLabel = new Label(loginContainer, 0);
        savePasswordLabel.setText("Save Password");
        this.savePassword = new Button(loginContainer, 32);
        new Label(loginContainer, 0);
        this.initData();
        if (this.controller.getUsersession() == null) {
            this.loadUsersession(this.controller.getServerInfo().getLastUsersession());
        } else {
            this.loadUsersession(this.controller.getUsersession());
        }
        return area;
    }

    private void initData() {
        this.usernameCombo.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.usernameCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof Usersession && ((Usersession)element).getUsername() != null) {
                    return ((Usersession)element).getUsername();
                }
                return super.getText(element);
            }
        });
        this.knownUsersessions = this.controller.getKnownUsersessions();
        if (!this.controller.isUsersessionLocked()) {
            this.usernameCombo.setInput((Object)this.knownUsersessions);
        }
    }

    private void loadUsersession(Usersession usersession) {
        if (usersession != null && this.selectedUsersession == usersession) {
            return;
        }
        this.selectedUsersession = usersession;
        this.passwordField.setMessage("");
        this.savePassword.setSelection(false);
        if (this.selectedUsersession != null) {
            if (!this.usernameCombo.getCombo().getText().equals(this.selectedUsersession.getUsername())) {
                this.usernameCombo.getCombo().setText(this.selectedUsersession.getUsername());
            }
            if (this.selectedUsersession.isSavePassword() && this.selectedUsersession.getPassword() != null) {
                this.passwordField.setMessage("<password is saved, reenter to change>");
                this.passwordField.setText("");
                this.savePassword.setSelection(true);
            }
            this.passwordModified = false;
        }
    }

    protected void okPressed() {
        try {
            String username = this.usernameCombo.getCombo().getText();
            String password = this.passwordField.getText();
            boolean savePass = this.savePassword.getSelection();
            Usersession candidate = this.selectedUsersession;
            if (candidate == null) {
                candidate = this.getUsersessionIfKnown(username);
            }
            if (candidate == null) {
                candidate = ModelFactory.eINSTANCE.createUsersession();
                candidate.setServerInfo(this.controller.getServerInfo());
                candidate.setUsername(username);
            }
            candidate.setSavePassword(savePass);
            if (this.passwordModified) {
                candidate.setPassword(password);
            }
            this.controller.validate(candidate);
        }
        catch (EmfStoreException e) {
            this.setErrorMessage(String.valueOf(e.getMessage()) + " Maybe your password changed.");
            return;
        }
        super.okPressed();
    }

    private Usersession getUsersessionIfKnown(String username) {
        Usersession[] usersessionArray = this.knownUsersessions;
        int n = this.knownUsersessions.length;
        int n2 = 0;
        while (n2 < n) {
            Usersession session = usersessionArray[n2];
            if (session.getUsername().equals(username)) {
                return session;
            }
            ++n2;
        }
        return null;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Point getInitialSize() {
        return new Point(400, 250);
    }

    private void flushErrorMessage() {
        this.setErrorMessage(null);
    }

    private final class ComboListener
    implements ISelectionChangedListener,
    ModifyListener {
        private String lastText = "";

        private ComboListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            Object firstElement;
            ISelection selection = event.getSelection();
            if (selection instanceof StructuredSelection && (firstElement = ((StructuredSelection)selection).getFirstElement()) instanceof Usersession) {
                LoginDialog.this.loadUsersession((Usersession)firstElement);
            }
        }

        public void modifyText(ModifyEvent e) {
            String text = LoginDialog.this.usernameCombo.getCombo().getText();
            if (text != null && !text.equals("") && !text.equals(this.lastText)) {
                LoginDialog.this.loadUsersession(LoginDialog.this.getUsersessionIfKnown(text));
                this.lastText = text;
            }
            LoginDialog.this.flushErrorMessage();
        }
    }
}

