/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.client.ui.dialogs.login;

import java.util.HashSet;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.emfstore.client.model.ServerInfo;
import org.eclipse.emf.emfstore.client.model.Usersession;
import org.eclipse.emf.emfstore.client.model.WorkspaceManager;
import org.eclipse.emf.emfstore.client.ui.dialogs.login.ILoginDialogController;
import org.eclipse.emf.emfstore.client.ui.dialogs.login.LoginDialog;
import org.eclipse.emf.emfstore.server.exceptions.AccessControlException;
import org.eclipse.emf.emfstore.server.exceptions.EmfStoreException;
import org.eclipse.swt.widgets.Display;

public class LoginDialogController
implements ILoginDialogController {
    private Usersession usersession;
    private ServerInfo serverInfo;

    public Usersession[] getKnownUsersessions() {
        HashSet<Usersession> set = new HashSet<Usersession>();
        for (Usersession session : WorkspaceManager.getInstance().getCurrentWorkspace().getUsersessions()) {
            if (!this.getServerInfo().equals(session.getServerInfo())) continue;
            set.add(session);
        }
        return set.toArray(new Usersession[set.size()]);
    }

    private Usersession login() throws EmfStoreException {
        LoginDialog dialog = new LoginDialog(Display.getCurrent().getActiveShell(), this);
        dialog.setBlockOnOpen(true);
        if (dialog.open() != 0 || this.usersession == null) {
            throw new AccessControlException("Couldn't login.");
        }
        return this.usersession;
    }

    public boolean isUsersessionLocked() {
        return this.getUsersession() != null;
    }

    public String getServerLabel() {
        return this.getServerInfo().getName();
    }

    public void validate(Usersession usersession) throws EmfStoreException {
        usersession.logIn();
        EList usersessions = WorkspaceManager.getInstance().getCurrentWorkspace().getUsersessions();
        if (!usersessions.contains((Object)usersession)) {
            usersessions.add((Object)usersession);
        }
        this.usersession = usersession;
        WorkspaceManager.getInstance().getCurrentWorkspace().save();
    }

    public Usersession getUsersession() {
        return this.usersession;
    }

    public ServerInfo getServerInfo() {
        if (this.serverInfo != null) {
            return this.serverInfo;
        }
        return this.usersession.getServerInfo();
    }

    public Usersession login(ServerInfo serverInfo) throws EmfStoreException {
        this.serverInfo = serverInfo;
        this.usersession = null;
        return this.login();
    }

    public void login(Usersession usersession) throws EmfStoreException {
        this.serverInfo = null;
        this.usersession = usersession;
        this.login();
    }
}

