/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.client.ui.views.historybrowserview;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.emfstore.client.model.ProjectSpace;
import org.eclipse.emf.emfstore.client.model.WorkspaceManager;
import org.eclipse.emf.emfstore.client.model.connectionmanager.ServerCall;
import org.eclipse.emf.emfstore.client.model.observers.OpenModelElementObserver;
import org.eclipse.emf.emfstore.client.model.util.ProjectSpaceContainer;
import org.eclipse.emf.emfstore.client.ui.Activator;
import org.eclipse.emf.emfstore.client.ui.util.EMFStoreMessageDialog;
import org.eclipse.emf.emfstore.client.ui.views.changes.ChangePackageVisualizationHelper;
import org.eclipse.emf.emfstore.client.ui.views.historybrowserview.LogMessageColumnLabelProvider;
import org.eclipse.emf.emfstore.client.ui.views.scm.SCMContentProvider;
import org.eclipse.emf.emfstore.client.ui.views.scm.SCMLabelProvider;
import org.eclipse.emf.emfstore.common.model.ModelElementId;
import org.eclipse.emf.emfstore.common.model.Project;
import org.eclipse.emf.emfstore.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.server.exceptions.EmfStoreException;
import org.eclipse.emf.emfstore.server.model.versioning.ChangePackage;
import org.eclipse.emf.emfstore.server.model.versioning.HistoryInfo;
import org.eclipse.emf.emfstore.server.model.versioning.HistoryQuery;
import org.eclipse.emf.emfstore.server.model.versioning.PrimaryVersionSpec;
import org.eclipse.emf.emfstore.server.model.versioning.TagVersionSpec;
import org.eclipse.emf.emfstore.server.model.versioning.VersionSpec;
import org.eclipse.emf.emfstore.server.model.versioning.VersioningFactory;
import org.eclipse.emf.emfstore.server.model.versioning.operations.AbstractOperation;
import org.eclipse.emf.emfstore.server.model.versioning.operations.CompositeOperation;
import org.eclipse.emf.emfstore.server.model.versioning.operations.OperationId;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.part.ViewPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HistoryBrowserView
extends ViewPart
implements ProjectSpaceContainer {
    private List<HistoryInfo> historyInfos = new ArrayList<HistoryInfo>();
    private ProjectSpace projectSpace;
    private int startOffset = 24;
    private int currentEnd;
    private int headVersion;
    private EObject modelElement;
    private TreeViewer viewer;
    private Map<Integer, ChangePackage> changePackageCache = new HashMap<Integer, ChangePackage>();
    private ChangePackageVisualizationHelper changePackageVisualizationHelper;
    private SCMContentProvider contentProvider;
    private SCMLabelProvider labelProvider;
    private Action showRoots;
    private Label noProjectHint;
    private Composite parent;
    private boolean isUnlinkedFromNavigator;
    private TreeViewerColumn changesColumn;
    private TreeViewerColumn logColumn;
    private LogMessageColumnLabelProvider logLabelProvider;
    private ComposedAdapterFactory adapterFactory;
    private AdapterFactoryLabelProvider adapterFactoryLabelProvider;

    public void createPartControl(Composite parent) {
        GridLayoutFactory.fillDefaults().applyTo(parent);
        this.parent = parent;
        this.noProjectHint = new Label(parent, 64);
        GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).grab(true, true).applyTo((Control)this.noProjectHint);
        this.noProjectHint.setText("Please call 'Show history' from the context menu of an element in the navigator.");
        this.viewer = new TreeViewerWithModelElementSelectionProvider(parent, 0);
        MenuManager menuMgr = new MenuManager();
        menuMgr.add((IContributionItem)new Separator("additions"));
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
        Control control = this.viewer.getControl();
        Menu menu = menuMgr.createContextMenu(control);
        control.setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        GridDataFactory.fillDefaults().grab(true, true).applyTo(this.viewer.getControl());
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.viewer);
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                Object element;
                if (event.getSelection() instanceof IStructuredSelection && (element = ((IStructuredSelection)event.getSelection()).getFirstElement()) instanceof EObject) {
                    ((OpenModelElementObserver)WorkspaceManager.getObserverBus().notify(OpenModelElementObserver.class)).openModelElement((EObject)element);
                }
            }
        });
        this.changesColumn = new TreeViewerColumn(this.viewer, 0);
        this.changesColumn.getColumn().setText("Changes");
        this.changesColumn.getColumn().setWidth(400);
        this.logColumn = new TreeViewerColumn(this.viewer, 0);
        this.logColumn.getColumn().setText("Commit information");
        this.logColumn.getColumn().setWidth(300);
        Tree tree = this.viewer.getTree();
        tree.setHeaderVisible(true);
        this.hookToobar();
    }

    private void hookToobar() {
        IActionBars bars = this.getViewSite().getActionBars();
        IToolBarManager menuManager = bars.getToolBarManager();
        this.addExpandAllAndCollapseAllAction(menuManager);
        this.addRefreshAction(menuManager);
        this.addShowRootAction(menuManager);
        this.addNextAndPreviousAction(menuManager);
        this.addJumpToRevisionAction(menuManager);
        this.addLinkWithNavigatorAction(menuManager);
    }

    private void addExpandAllAndCollapseAllAction(IToolBarManager menuManager) {
        final ImageDescriptor expandImg = Activator.getImageDescriptor("icons/expandall.gif");
        final ImageDescriptor collapseImg = Activator.getImageDescriptor("icons/collapseall.gif");
        Action expandAndCollapse = new Action("", 2){

            public void run() {
                if (!this.isChecked()) {
                    this.setImageDescriptor(expandImg);
                    HistoryBrowserView.this.viewer.collapseAll();
                } else {
                    this.setImageDescriptor(collapseImg);
                    HistoryBrowserView.this.viewer.expandToLevel(2);
                }
            }
        };
        expandAndCollapse.setImageDescriptor(expandImg);
        expandAndCollapse.setToolTipText("Use this toggle to expand or collapse all elements");
        menuManager.add((IAction)expandAndCollapse);
    }

    private void addRefreshAction(IToolBarManager menuManager) {
        Action refresh = new Action(){

            public void run() {
                HistoryBrowserView.this.refresh();
            }
        };
        refresh.setImageDescriptor(Activator.getImageDescriptor("/icons/refresh.png"));
        refresh.setToolTipText("Refresh");
        menuManager.add((IAction)refresh);
    }

    private void addShowRootAction(IToolBarManager menuManager) {
        this.showRoots = new Action("", 2){

            public void run() {
                if (this.isChecked()) {
                    HistoryBrowserView.this.contentProvider.setShowRootNodes(true);
                } else {
                    HistoryBrowserView.this.contentProvider.setShowRootNodes(false);
                }
                HistoryBrowserView.this.viewer.refresh();
            }
        };
        this.adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        this.adapterFactoryLabelProvider = new AdapterFactoryLabelProvider((AdapterFactory)this.adapterFactory);
        this.showRoots.setImageDescriptor(ImageDescriptor.createFromImage((Image)this.adapterFactoryLabelProvider.getImage((Object)VersioningFactory.eINSTANCE.createChangePackage())));
        this.showRoots.setToolTipText("Show revision nodes");
        this.showRoots.setChecked(true);
        menuManager.add((IAction)this.showRoots);
    }

    public void dispose() {
        if (this.adapterFactory != null) {
            this.adapterFactory.dispose();
        }
        if (this.changePackageVisualizationHelper != null) {
            this.changePackageVisualizationHelper.dispose();
        }
        super.dispose();
    }

    private void addNextAndPreviousAction(IToolBarManager menuManager) {
        Action prev = new Action(){

            public void run() {
                int temp = HistoryBrowserView.this.currentEnd + HistoryBrowserView.this.startOffset;
                if (temp <= HistoryBrowserView.this.headVersion) {
                    HistoryBrowserView.this.currentEnd = temp;
                }
                HistoryBrowserView.this.refresh();
            }
        };
        prev.setImageDescriptor(Activator.getImageDescriptor("/icons/prev.png"));
        prev.setToolTipText("Previous " + (this.startOffset + 1) + " items");
        menuManager.add((IAction)prev);
        Action next = new Action(){

            public void run() {
                int temp = HistoryBrowserView.this.currentEnd - HistoryBrowserView.this.startOffset;
                if (temp > 0) {
                    HistoryBrowserView.this.currentEnd = temp;
                }
                HistoryBrowserView.this.refresh();
            }
        };
        next.setImageDescriptor(Activator.getImageDescriptor("/icons/next.png"));
        next.setToolTipText("Next " + (this.startOffset + 1) + " items");
        menuManager.add((IAction)next);
    }

    private void addJumpToRevisionAction(IToolBarManager menuManager) {
        Action jumpTo = new Action(){

            public void run() {
                InputDialog inputDialog = new InputDialog(HistoryBrowserView.this.getSite().getShell(), "Go to revision", "Revision", "", null);
                if (inputDialog.open() == 0) {
                    try {
                        int temp = Integer.parseInt(inputDialog.getValue());
                        HistoryBrowserView.this.currentEnd = temp;
                        HistoryBrowserView.this.refresh();
                    }
                    catch (NumberFormatException e) {
                        MessageDialog.openError((Shell)HistoryBrowserView.this.getSite().getShell(), (String)"Error", (String)"A numeric value was expected!");
                        this.run();
                    }
                }
            }
        };
        jumpTo.setImageDescriptor(Activator.getImageDescriptor("/icons/magnifier.png"));
        jumpTo.setToolTipText("Go to revision...");
        menuManager.add((IAction)jumpTo);
    }

    private void addLinkWithNavigatorAction(IToolBarManager menuManager) {
        this.isUnlinkedFromNavigator = Activator.getDefault().getDialogSettings().getBoolean("LinkWithNavigator");
        Action linkWithNavigator = new Action("Link with navigator", 2){

            public void run() {
                Activator.getDefault().getDialogSettings().put("LinkWithNavigator", !this.isChecked());
                HistoryBrowserView.this.isUnlinkedFromNavigator = !this.isChecked();
            }
        };
        linkWithNavigator.setImageDescriptor(Activator.getImageDescriptor("icons/link_with_editor.gif"));
        linkWithNavigator.setToolTipText("Link with Navigator");
        linkWithNavigator.setChecked(!this.isUnlinkedFromNavigator);
        menuManager.add((IAction)linkWithNavigator);
    }

    public void refresh() {
        this.load(this.currentEnd);
        this.viewer.setContentProvider((IContentProvider)this.contentProvider);
        this.viewer.setInput(this.getHistoryInfos());
    }

    private void load(final int end) {
        try {
            new ServerCall<Void>(this.projectSpace.getUsersession()){

                protected Void run() throws EmfStoreException {
                    HistoryBrowserView.this.loadContent(end);
                    return null;
                }
            }.execute();
        }
        catch (EmfStoreException e) {
            EMFStoreMessageDialog.showExceptionDialog((Exception)((Object)e));
        }
    }

    private void loadContent(int end) throws EmfStoreException {
        if (this.projectSpace == null) {
            this.historyInfos.clear();
            return;
        }
        HistoryQuery query = this.getQuery(end);
        List historyInfo = this.projectSpace.getHistoryInfo(query);
        if (historyInfo != null) {
            for (HistoryInfo hi : historyInfo) {
                if (!hi.getPrimerySpec().equals(this.projectSpace.getBaseVersion())) continue;
                TagVersionSpec spec = VersioningFactory.eINSTANCE.createTagVersionSpec();
                spec.setName("BASE");
                hi.getTagSpecs().add((Object)spec);
                break;
            }
            this.historyInfos.clear();
            this.historyInfos.addAll(historyInfo);
        }
        ChangePackage changePackage = VersioningFactory.eINSTANCE.createChangePackage();
        changePackage.getOperations().addAll((Collection)ModelUtil.clone((List)this.projectSpace.getOperations()));
        this.changePackageCache.put(-1, changePackage);
        for (HistoryInfo hi : this.historyInfos) {
            if (hi.getChangePackage() == null) continue;
            this.changePackageCache.put(hi.getPrimerySpec().getIdentifier(), hi.getChangePackage());
        }
        this.changePackageVisualizationHelper = new ChangePackageVisualizationHelper(new ArrayList<ChangePackage>(this.changePackageCache.values()), this.projectSpace.getProject());
        this.labelProvider.setChangePackageVisualizationHelper(this.changePackageVisualizationHelper);
        this.logLabelProvider.setChangePackageVisualizationHelper(this.changePackageVisualizationHelper);
    }

    public void setInput(ProjectSpace projectSpace) {
        this.setInput(projectSpace, null);
    }

    public void setInput(ProjectSpace projectSpace, EObject me) {
        this.noProjectHint.dispose();
        this.parent.layout();
        this.projectSpace = projectSpace;
        this.modelElement = me;
        this.currentEnd = -1;
        String label = "History for ";
        Project project = projectSpace.getProject();
        this.contentProvider = new SCMContentProvider();
        if (me != null && project.containsInstance(me)) {
            label = String.valueOf(label) + this.adapterFactoryLabelProvider.getText((Object)me);
            this.showRoots.setChecked(false);
            this.contentProvider.setShowRootNodes(false);
        } else {
            label = String.valueOf(label) + projectSpace.getProjectName();
            this.showRoots.setChecked(true);
            this.contentProvider.setShowRootNodes(true);
        }
        this.setContentDescription(label);
        this.labelProvider = new SCMLabelProvider(project);
        this.changesColumn.setLabelProvider((CellLabelProvider)this.labelProvider);
        this.logLabelProvider = new LogMessageColumnLabelProvider(project);
        this.logColumn.setLabelProvider((CellLabelProvider)this.logLabelProvider);
        this.refresh();
    }

    private void getHeadVersionIdentifier() throws EmfStoreException {
        int identifier;
        PrimaryVersionSpec resolveVersionSpec = this.projectSpace.resolveVersionSpec(VersionSpec.HEAD_VERSION);
        this.headVersion = identifier = resolveVersionSpec.getIdentifier();
    }

    private HistoryQuery getQuery(int end) throws EmfStoreException {
        HistoryQuery query = VersioningFactory.eINSTANCE.createHistoryQuery();
        this.getHeadVersionIdentifier();
        if (end == -1) {
            end = this.headVersion;
            this.currentEnd = -1;
        } else {
            this.currentEnd = end;
            PrimaryVersionSpec tempVersionSpec = VersioningFactory.eINSTANCE.createPrimaryVersionSpec();
            tempVersionSpec.setIdentifier(end);
            end = this.projectSpace.resolveVersionSpec((VersionSpec)tempVersionSpec).getIdentifier();
        }
        int temp = end - this.startOffset;
        int start = temp > 0 ? temp : 0;
        PrimaryVersionSpec source = VersioningFactory.eINSTANCE.createPrimaryVersionSpec();
        source.setIdentifier(start);
        PrimaryVersionSpec target = VersioningFactory.eINSTANCE.createPrimaryVersionSpec();
        target.setIdentifier(end);
        query.setSource(source);
        query.setTarget(target);
        query.setIncludeChangePackage(true);
        if (this.modelElement != null && !(this.modelElement instanceof ProjectSpace)) {
            query.getModelElements().add((Object)ModelUtil.getProject((EObject)this.modelElement).getModelElementId(this.modelElement));
        }
        return query;
    }

    public List<HistoryInfo> getHistoryInfos() {
        ArrayList<HistoryInfo> revisions = new ArrayList<HistoryInfo>();
        if (this.projectSpace != null) {
            HistoryInfo localHistoryInfo = VersioningFactory.eINSTANCE.createHistoryInfo();
            ChangePackage changePackage = this.projectSpace.getLocalChangePackage(false);
            if (this.modelElement != null && this.projectSpace.getProject().containsInstance(this.modelElement)) {
                HashSet<AbstractOperation> operationsToRemove = new HashSet<AbstractOperation>();
                for (AbstractOperation ao : changePackage.getOperations()) {
                    if (ao.getAllInvolvedModelElements().contains(ModelUtil.getProject((EObject)this.modelElement).getModelElementId(this.modelElement))) continue;
                    operationsToRemove.add(ao);
                }
                changePackage.getOperations().removeAll(operationsToRemove);
            }
            localHistoryInfo.setChangePackage(changePackage);
            PrimaryVersionSpec versionSpec = VersioningFactory.eINSTANCE.createPrimaryVersionSpec();
            versionSpec.setIdentifier(-1);
            localHistoryInfo.setPrimerySpec(versionSpec);
            revisions.add(localHistoryInfo);
        }
        revisions.addAll(this.historyInfos);
        return revisions;
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public ChangePackageVisualizationHelper getChangePackageVisualizationHelper() {
        return this.changePackageVisualizationHelper;
    }

    public void highlightOperations(List<OperationId> operations) {
        this.labelProvider.getHighlighted().clear();
        this.labelProvider.getHighlighted().addAll(operations);
        this.refresh();
    }

    public ProjectSpace getProjectSpace() {
        if (this.isUnlinkedFromNavigator) {
            return null;
        }
        return this.projectSpace;
    }

    private final class TreeViewerWithModelElementSelectionProvider
    extends TreeViewer {
        private TreeViewerWithModelElementSelectionProvider(Composite parent, int style) {
            super(parent, style);
        }

        public ISelection getSelection() {
            Control control = this.getControl();
            if (control == null || control.isDisposed()) {
                return super.getSelection();
            }
            Item[] items = this.getSelection(this.getControl());
            if (items.length != 1) {
                return super.getSelection();
            }
            Item item = items[0];
            Object data = item.getData();
            if (data == null) {
                return super.getSelection();
            }
            Object element = data;
            EObject selectedModelElement = null;
            if (element instanceof CompositeOperation) {
                selectedModelElement = this.handleCompositeOperation((CompositeOperation)element);
            } else if (element instanceof AbstractOperation) {
                selectedModelElement = this.handleAbstractOperation((AbstractOperation)element);
            } else if (element instanceof ProjectSpace) {
                selectedModelElement = ((ProjectSpace)element).getProject();
            } else if (element instanceof ModelElementId && HistoryBrowserView.this.projectSpace.getProject().contains((ModelElementId)element)) {
                selectedModelElement = HistoryBrowserView.this.projectSpace.getProject().getModelElement((ModelElementId)element);
            } else if (HistoryBrowserView.this.projectSpace.getProject().containsInstance((EObject)element)) {
                selectedModelElement = (EObject)element;
            }
            if (selectedModelElement != null) {
                return new StructuredSelection((Object)selectedModelElement);
            }
            return super.getSelection();
        }

        private EObject handleCompositeOperation(CompositeOperation op) {
            AbstractOperation mainOperation = op.getMainOperation();
            if (mainOperation != null) {
                ModelElementId modelElementId = mainOperation.getModelElementId();
                EObject modelElement = HistoryBrowserView.this.projectSpace.getProject().getModelElement(modelElementId);
                return modelElement;
            }
            return null;
        }

        private EObject handleAbstractOperation(AbstractOperation op) {
            ModelElementId modelElementId = op.getModelElementId();
            EObject modelElement = HistoryBrowserView.this.projectSpace.getProject().getModelElement(modelElementId);
            return modelElement;
        }
    }
}

