/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.client.ui.views.historybrowserview;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.emfstore.server.model.versioning.HistoryInfo;
import org.eclipse.emf.emfstore.server.model.versioning.TagVersionSpec;

public class HistoryTableLabelProvider
extends AdapterFactoryLabelProvider {
    private static final int REVISION_COLUMN = 0;
    private static final int TAG_COLUMN = 1;
    private static final int DATE_COLUMN = 2;
    private static final int AUTHOR_COLUMN = 3;
    private static final int LOGMSG_COLUMN = 4;

    public HistoryTableLabelProvider() {
        super((AdapterFactory)new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE));
    }

    public String getColumnText(Object object, int columnIndex) {
        if (object instanceof HistoryInfo) {
            HistoryInfo historyInfo = (HistoryInfo)object;
            switch (columnIndex) {
                case 0: {
                    return Integer.toString(historyInfo.getPrimerySpec().getIdentifier());
                }
                case 1: {
                    String tags = "";
                    for (TagVersionSpec tag : historyInfo.getTagSpecs()) {
                        tags = String.valueOf(tags) + tag.getName() + " ";
                    }
                    return tags;
                }
                case 2: {
                    return historyInfo.getLogMessage().getDate().toString();
                }
                case 3: {
                    return historyInfo.getLogMessage().getAuthor();
                }
                case 4: {
                    return historyInfo.getLogMessage().getMessage();
                }
            }
            return "";
        }
        return super.getColumnText(object, columnIndex);
    }
}

