/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.server.model.versioning.operations.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.emfstore.common.model.IdEObjectCollection;
import org.eclipse.emf.emfstore.server.model.versioning.operations.AbstractOperation;
import org.eclipse.emf.emfstore.server.model.versioning.operations.AttributeOperation;
import org.eclipse.emf.emfstore.server.model.versioning.operations.OperationsFactory;
import org.eclipse.emf.emfstore.server.model.versioning.operations.OperationsPackage;
import org.eclipse.emf.emfstore.server.model.versioning.operations.UnkownFeatureException;
import org.eclipse.emf.emfstore.server.model.versioning.operations.impl.FeatureOperationImpl;

public class AttributeOperationImpl
extends FeatureOperationImpl
implements AttributeOperation {
    protected static final Object OLD_VALUE_EDEFAULT = null;
    protected Object oldValue = OLD_VALUE_EDEFAULT;
    protected static final Object NEW_VALUE_EDEFAULT = null;
    protected Object newValue = NEW_VALUE_EDEFAULT;

    protected AttributeOperationImpl() {
    }

    protected EClass eStaticClass() {
        return OperationsPackage.Literals.ATTRIBUTE_OPERATION;
    }

    public Object getOldValue() {
        return this.oldValue;
    }

    public void setOldValue(Object newOldValue) {
        Object oldOldValue = this.oldValue;
        this.oldValue = newOldValue;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 7, oldOldValue, this.oldValue));
        }
    }

    public Object getNewValue() {
        return this.newValue;
    }

    public void setNewValue(Object newNewValue) {
        Object oldNewValue = this.newValue;
        this.newValue = newNewValue;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 8, oldNewValue, this.newValue));
        }
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 7: {
                return this.getOldValue();
            }
            case 8: {
                return this.getNewValue();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 7: {
                this.setOldValue(newValue);
                return;
            }
            case 8: {
                this.setNewValue(newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 7: {
                this.setOldValue(OLD_VALUE_EDEFAULT);
                return;
            }
            case 8: {
                this.setNewValue(NEW_VALUE_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 7: {
                return OLD_VALUE_EDEFAULT == null ? this.oldValue != null : !OLD_VALUE_EDEFAULT.equals(this.oldValue);
            }
            case 8: {
                return NEW_VALUE_EDEFAULT == null ? this.newValue != null : !NEW_VALUE_EDEFAULT.equals(this.newValue);
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (oldValue: ");
        result.append(this.oldValue);
        result.append(", newValue: ");
        result.append(this.newValue);
        result.append(')');
        return result.toString();
    }

    public void apply(IdEObjectCollection project) {
        EObject object = project.getModelElement(this.getModelElementId());
        if (object == null) {
            return;
        }
        try {
            EAttribute attribute = (EAttribute)this.getFeature(object);
            object.eSet((EStructuralFeature)attribute, this.getNewValue());
        }
        catch (UnkownFeatureException e) {
            return;
        }
    }

    public AbstractOperation reverse() {
        AttributeOperation attributeOperation = OperationsFactory.eINSTANCE.createAttributeOperation();
        super.reverse(attributeOperation);
        attributeOperation.setNewValue(this.getOldValue());
        attributeOperation.setOldValue(this.getNewValue());
        return attributeOperation;
    }

    public String getDescription() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.getOldValue() == null) {
            stringBuilder.append("Set ");
            stringBuilder.append(this.getFeatureName());
            stringBuilder.append(" to ");
            stringBuilder.append("\"");
            stringBuilder.append(this.getNewValue());
            stringBuilder.append("\"");
        } else {
            stringBuilder.append("Changed ");
            stringBuilder.append(this.getFeatureName());
            stringBuilder.append(" from ");
            stringBuilder.append("\"");
            stringBuilder.append(this.getOldValue());
            stringBuilder.append("\"");
            stringBuilder.append(" to ");
            stringBuilder.append("\"");
            stringBuilder.append(this.getNewValue());
            stringBuilder.append("\"");
        }
        String name = stringBuilder.toString();
        return name;
    }

    public String getName() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Set ");
        stringBuilder.append(this.getFeatureName());
        stringBuilder.append(" attribute");
        String name = stringBuilder.toString();
        return name;
    }
}

