/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.common.dialogs;

import java.util.Collection;
import java.util.Comparator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecp.common.Activator;
import org.eclipse.emf.ecp.common.model.ECPModelelementContext;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ModelElementSelectionDialog
extends FilteredItemsSelectionDialog {
    private static final String DIALOG_SETTINGS = "STANDARD_DIALOG_SETTING";
    private static final String DIALOG_MESSAGE = "Enter model element name prefix or pattern (e.g. *Trun?)";
    private static final String DIALOG_TITLE = "Search Model Element";
    private static final String DIALOG_INITIAL_PATTERN = "**";
    private ILabelProvider labelProvider;
    private Collection<EObject> modelElements;
    private ComposedAdapterFactory adapterFactory;

    public ModelElementSelectionDialog() {
        this(false);
    }

    public ModelElementSelectionDialog(ECPModelelementContext context) {
        this(context, false);
    }

    public ModelElementSelectionDialog(boolean multiSelection) {
        this(null, multiSelection);
    }

    public ModelElementSelectionDialog(ECPModelelementContext context, boolean multiSelection) {
        super(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), multiSelection);
        if (context != null) {
            this.modelElements = context.getAllModelElements();
        }
        this.setLabelProvider(this.createLabelProvider());
        this.setListLabelProvider(this.getLabelProvider());
        this.setDetailsLabelProvider(this.getLabelProvider());
        this.setBlockOnOpen(true);
        this.setTitle(DIALOG_TITLE);
        this.setMessage(DIALOG_MESSAGE);
        this.setInitialPattern(DIALOG_INITIAL_PATTERN);
    }

    public ModelElementSelectionDialog(ECPModelelementContext context, EClass classType, boolean multiSelection) {
        this(multiSelection);
        this.modelElements = context.getAllModelElementsbyClass(classType, true);
    }

    public ModelElementSelectionDialog(ECPModelelementContext context, EClass classType) {
        this(context, classType, false);
    }

    protected ILabelProvider createLabelProvider() {
        this.adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        return new AdapterFactoryLabelProvider((AdapterFactory)this.adapterFactory);
    }

    public boolean close() {
        this.adapterFactory.dispose();
        return super.close();
    }

    public void setLabelProvider(ILabelProvider labelProvider) {
        this.labelProvider = labelProvider;
    }

    public ILabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    public Collection<EObject> getModelElements() {
        return this.modelElements;
    }

    public void setModelElements(Collection<EObject> modelElements) {
        this.modelElements = modelElements;
    }

    protected Control createExtendedContentArea(Composite parent) {
        return null;
    }

    protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
        return new ModelElementFilter();
    }

    protected void fillContentProvider(FilteredItemsSelectionDialog.AbstractContentProvider contentProvider, FilteredItemsSelectionDialog.ItemsFilter itemsFilter, IProgressMonitor progressMonitor) {
        progressMonitor.beginTask("Searching", this.modelElements.size());
        for (EObject modelElement : this.modelElements) {
            contentProvider.add((Object)modelElement, itemsFilter);
            progressMonitor.worked(1);
        }
        progressMonitor.done();
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings settings = Activator.getDefault().getDialogSettings().getSection(DIALOG_SETTINGS);
        if (settings == null) {
            settings = Activator.getDefault().getDialogSettings().addNewSection(DIALOG_SETTINGS);
        }
        return settings;
    }

    public String getElementName(Object item) {
        if (item instanceof EObject) {
            return this.getLabelProvider().getText(item);
        }
        return item.toString();
    }

    protected Comparator<EObject> getItemsComparator() {
        return new Comparator<EObject>(){

            @Override
            public int compare(EObject arg0, EObject arg1) {
                return arg0.toString().compareTo(arg1.toString());
            }
        };
    }

    protected IStatus validateItem(Object item) {
        return Status.OK_STATUS;
    }

    public class ModelElementFilter
    extends FilteredItemsSelectionDialog.ItemsFilter {
        public ModelElementFilter() {
            super((FilteredItemsSelectionDialog)ModelElementSelectionDialog.this);
        }

        public boolean isConsistentItem(Object item) {
            return true;
        }

        public boolean matchItem(Object item) {
            String label = ModelElementSelectionDialog.this.getLabelProvider().getText(item);
            if (!this.patternMatcher.getPattern().startsWith("*")) {
                this.patternMatcher.setPattern("*" + this.patternMatcher.getPattern() + "*");
            }
            return this.matches(label);
        }
    }
}

