/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.client.model.filetransfer;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.emfstore.client.model.Configuration;
import org.eclipse.emf.emfstore.client.model.ProjectSpace;
import org.eclipse.emf.emfstore.server.exceptions.FileTransferException;

public final class FileTransferUtil {
    private FileTransferUtil() {
    }

    public static void openFile(File file) throws FileTransferException {
        block4: {
            String os = System.getProperty("os.name");
            try {
                if (os.toLowerCase().contains("windows")) {
                    Runtime.getRuntime().exec("rundll32 SHELL32.DLL,ShellExec_RunDLL " + file.getAbsolutePath());
                    break block4;
                }
                if (os.toLowerCase().contains("mac os")) {
                    Runtime.getRuntime().exec("open " + file.getAbsolutePath());
                    break block4;
                }
                throw new FileTransferException("Opening files is not yet supported for " + os + ". Please go to " + file);
            }
            catch (IOException e) {
                throw new FileTransferException("Could not open the specified file!");
            }
        }
    }

    public static File getOpenFileLocation(ProjectSpace ps, String fileName) {
        if (fileName == null) {
            return null;
        }
        File cacheFolder = new File(String.valueOf(Configuration.getWorkspaceDirectory()) + "ps-" + ps.getIdentifier() + File.separatorChar + "files");
        File openCacheFolder = new File(cacheFolder, "openedFiles");
        File openFile = new File(openCacheFolder, fileName);
        openFile.deleteOnExit();
        return openFile;
    }

    public static void copyFileWithProgress(File source, File destination, IProgressMonitor monitor) throws IOException {
        int read;
        FileInputStream inputStream = new FileInputStream(source);
        FileOutputStream outputStream = new FileOutputStream(destination);
        monitor.beginTask("Copying file...", inputStream.available());
        byte[] buffer = new byte[4096];
        while ((read = inputStream.read(buffer)) != -1) {
            outputStream.write(buffer, 0, read);
            monitor.worked(4096);
        }
        inputStream.close();
        outputStream.close();
    }
}

