/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.client.model.impl;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.emf.emfstore.client.model.util.WorkspaceUtil;
import org.eclipse.emf.emfstore.common.EMFStoreResource;
import org.eclipse.emf.emfstore.common.model.IdEObjectCollection;
import org.eclipse.emf.emfstore.common.model.ModelElementId;
import org.eclipse.emf.emfstore.common.model.impl.IdEObjectCollectionImpl;
import org.eclipse.emf.emfstore.common.model.util.ModelUtil;

public class DirtyResourceSet {
    private Set<Resource> resources;
    private final IdEObjectCollectionImpl collection;
    private boolean resourcesPending;

    public DirtyResourceSet(IdEObjectCollectionImpl collection) {
        this.collection = collection;
        this.resources = new HashSet<Resource>();
    }

    public void addDirtyResource(Resource resource) {
        this.resources.add(resource);
    }

    public void save() {
        HashSet<Resource> resourcesToRemove = new HashSet<Resource>();
        for (Resource resource : this.resources) {
            if (resource.getURI() == null || resource.getURI().toString().equals("")) continue;
            if (resource instanceof EMFStoreResource) {
                ((EMFStoreResource)resource).setIdToEObjectMap(this.collection.getIdToEObjectMap(), this.collection.getEObjectToIdMap());
            } else {
                Set modelElements = ModelUtil.getAllContainedModelElements((Resource)resource, (boolean)false, (boolean)false);
                for (EObject modelElement : modelElements) {
                    this.setModelElementIdOnResource((XMIResource)resource, modelElement);
                }
            }
            try {
                resource.save(ModelUtil.getResourceSaveOptions());
                resourcesToRemove.add(resource);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.resources.removeAll(resourcesToRemove);
        if (this.resources.size() > 0 || this.resourcesPending) {
            String message = String.valueOf(this.resources.size()) + " unsaved resources remained in the dirty resource set!";
            WorkspaceUtil.logWarning(message, null);
            this.resourcesPending = this.resources.size() != 0;
        } else {
            this.resourcesPending = false;
        }
    }

    private void setModelElementIdOnResource(XMIResource resource, EObject modelElement) {
        if (modelElement instanceof IdEObjectCollection) {
            return;
        }
        ModelElementId modelElementId = this.getIDForEObject(modelElement);
        String modelElementIdString = modelElementId.getId();
        resource.setID(modelElement, modelElementIdString);
    }

    private ModelElementId getIDForEObject(EObject modelElement) {
        ModelElementId modelElementId = this.collection.getModelElementId(modelElement);
        if (modelElementId == null) {
            modelElementId = this.collection.getDeletedModelElementId(modelElement);
        }
        if (modelElementId == null) {
            WorkspaceUtil.handleException(new IllegalStateException("No ID for model element" + modelElement));
        }
        return modelElementId;
    }
}

