/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.client.model.impl;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.BasicEMap;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.emf.emfstore.client.model.CompositeOperationHandle;
import org.eclipse.emf.emfstore.client.model.Configuration;
import org.eclipse.emf.emfstore.client.model.ModelFactory;
import org.eclipse.emf.emfstore.client.model.ModifiedModelElementsCache;
import org.eclipse.emf.emfstore.client.model.OperationComposite;
import org.eclipse.emf.emfstore.client.model.ProjectSpace;
import org.eclipse.emf.emfstore.client.model.Usersession;
import org.eclipse.emf.emfstore.client.model.WorkspaceManager;
import org.eclipse.emf.emfstore.client.model.changeTracking.commands.EMFStoreCommandStack;
import org.eclipse.emf.emfstore.client.model.changeTracking.notification.recording.NotificationRecorder;
import org.eclipse.emf.emfstore.client.model.connectionmanager.ConnectionManager;
import org.eclipse.emf.emfstore.client.model.controller.CommitController;
import org.eclipse.emf.emfstore.client.model.controller.ShareController;
import org.eclipse.emf.emfstore.client.model.controller.UpdateController;
import org.eclipse.emf.emfstore.client.model.controller.callbacks.CommitCallback;
import org.eclipse.emf.emfstore.client.model.controller.callbacks.UpdateCallback;
import org.eclipse.emf.emfstore.client.model.exceptions.IllegalProjectSpaceStateException;
import org.eclipse.emf.emfstore.client.model.exceptions.MEUrlResolutionException;
import org.eclipse.emf.emfstore.client.model.exceptions.PropertyNotFoundException;
import org.eclipse.emf.emfstore.client.model.filetransfer.FileDownloadStatus;
import org.eclipse.emf.emfstore.client.model.filetransfer.FileInformation;
import org.eclipse.emf.emfstore.client.model.filetransfer.FileTransferManager;
import org.eclipse.emf.emfstore.client.model.impl.AutoSplitAndSaveResourceContainmentList;
import org.eclipse.emf.emfstore.client.model.impl.OperationManager;
import org.eclipse.emf.emfstore.client.model.impl.OperationRecorder;
import org.eclipse.emf.emfstore.client.model.impl.StatePersister;
import org.eclipse.emf.emfstore.client.model.importexport.impl.ExportChangesController;
import org.eclipse.emf.emfstore.client.model.importexport.impl.ExportProjectController;
import org.eclipse.emf.emfstore.client.model.observers.ConflictResolver;
import org.eclipse.emf.emfstore.client.model.observers.LoginObserver;
import org.eclipse.emf.emfstore.client.model.util.WorkspaceUtil;
import org.eclipse.emf.emfstore.client.properties.PropertyManager;
import org.eclipse.emf.emfstore.common.model.IdEObjectCollection;
import org.eclipse.emf.emfstore.common.model.ModelElementId;
import org.eclipse.emf.emfstore.common.model.Project;
import org.eclipse.emf.emfstore.common.model.impl.IdEObjectCollectionImpl;
import org.eclipse.emf.emfstore.common.model.impl.IdentifiableElementImpl;
import org.eclipse.emf.emfstore.common.model.impl.ProjectImpl;
import org.eclipse.emf.emfstore.common.model.util.EObjectChangeNotifier;
import org.eclipse.emf.emfstore.common.model.util.FileUtil;
import org.eclipse.emf.emfstore.common.model.util.IdEObjectCollectionChangeObserver;
import org.eclipse.emf.emfstore.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.common.observer.IObserver;
import org.eclipse.emf.emfstore.server.exceptions.EmfStoreException;
import org.eclipse.emf.emfstore.server.exceptions.FileTransferException;
import org.eclipse.emf.emfstore.server.model.FileIdentifier;
import org.eclipse.emf.emfstore.server.model.ProjectId;
import org.eclipse.emf.emfstore.server.model.ProjectInfo;
import org.eclipse.emf.emfstore.server.model.accesscontrol.ACUser;
import org.eclipse.emf.emfstore.server.model.accesscontrol.OrgUnitProperty;
import org.eclipse.emf.emfstore.server.model.url.ModelElementUrlFragment;
import org.eclipse.emf.emfstore.server.model.versioning.ChangePackage;
import org.eclipse.emf.emfstore.server.model.versioning.HistoryInfo;
import org.eclipse.emf.emfstore.server.model.versioning.HistoryQuery;
import org.eclipse.emf.emfstore.server.model.versioning.LogMessage;
import org.eclipse.emf.emfstore.server.model.versioning.PrimaryVersionSpec;
import org.eclipse.emf.emfstore.server.model.versioning.TagVersionSpec;
import org.eclipse.emf.emfstore.server.model.versioning.VersionSpec;
import org.eclipse.emf.emfstore.server.model.versioning.VersioningFactory;
import org.eclipse.emf.emfstore.server.model.versioning.operations.AbstractOperation;
import org.eclipse.emf.emfstore.server.model.versioning.operations.CompositeOperation;
import org.eclipse.emf.emfstore.server.model.versioning.operations.semantic.SemanticCompositeOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ProjectSpaceBase
extends IdentifiableElementImpl
implements ProjectSpace,
LoginObserver {
    private FileTransferManager fileTransferManager;
    private boolean initCompleted;
    private boolean isTransient;
    private ModifiedModelElementsCache modifiedModelElementsCache;
    private AutoSplitAndSaveResourceContainmentList<AbstractOperation> operationsList;
    private OperationManager operationManager;
    private OperationRecorder operationRecorder;
    private PropertyManager propertyManager;
    private HashMap<String, OrgUnitProperty> propertyMap = new HashMap();
    private StatePersister statePersister;
    private ResourceSet resourceSet;

    public ProjectSpaceBase() {
        this.modifiedModelElementsCache = new ModifiedModelElementsCache(this);
        WorkspaceManager.getObserverBus().register((IObserver)this.modifiedModelElementsCache);
    }

    @Override
    public FileIdentifier addFile(File file) throws FileTransferException {
        return this.fileTransferManager.addFile(file);
    }

    @Override
    public void addOperations(List<? extends AbstractOperation> operations) {
        this.getOperations().addAll(operations);
        this.updateDirtyState();
        for (AbstractOperation abstractOperation : operations) {
            if (abstractOperation instanceof CompositeOperation && ((CompositeOperation)abstractOperation).getMainOperation() == null) {
                return;
            }
            this.operationManager.notifyOperationExecuted(abstractOperation);
        }
    }

    @Override
    public void addTag(PrimaryVersionSpec versionSpec, TagVersionSpec tag) throws EmfStoreException {
        ConnectionManager cm = WorkspaceManager.getInstance().getConnectionManager();
        cm.addTag(this.getUsersession().getSessionId(), this.getProjectId(), versionSpec, tag);
    }

    public void applyOperations(List<AbstractOperation> operations) {
        this.applyOperations(operations, true);
    }

    public void applyOperations(List<AbstractOperation> operations, boolean addOperations) {
        this.stopChangeRecording();
        try {
            for (AbstractOperation operation : operations) {
                try {
                    operation.apply((IdEObjectCollection)this.getProject());
                }
                catch (RuntimeException e) {
                    WorkspaceUtil.handleException(e);
                }
            }
            if (addOperations) {
                this.addOperations(operations);
            }
        }
        finally {
            this.startChangeRecording();
        }
    }

    public void applyOperationsWithRecording(List<AbstractOperation> operations, boolean force) {
        this.applyOperationsWithRecording(operations, force, false);
    }

    public void applyOperationsWithRecording(List<AbstractOperation> operations, boolean force, boolean semanticApply) {
        for (AbstractOperation operation : operations) {
            try {
                if (semanticApply && operation instanceof SemanticCompositeOperation) {
                    ((SemanticCompositeOperation)operation).semanticApply(this.getProject());
                    continue;
                }
                operation.apply((IdEObjectCollection)this.getProject());
            }
            catch (IllegalStateException e) {
                if (force) continue;
                throw e;
            }
        }
    }

    private void assignElementToResource(Resource resource, EObject modelElement) {
        resource.getContents().add((Object)modelElement);
        ((XMIResource)resource).setID(modelElement, this.getProject().getModelElementId(modelElement).getId());
    }

    @Override
    public CompositeOperationHandle beginCompositeOperation() {
        return this.operationManager.beginCompositeOperation();
    }

    public void cleanCutElements() {
        for (EObject cutElement : this.getProject().getCutElements()) {
            this.getProject().deleteModelElement(cutElement);
        }
    }

    @Override
    public PrimaryVersionSpec commit(LogMessage logMessage, CommitCallback callback, IProgressMonitor monitor) throws EmfStoreException {
        return (PrimaryVersionSpec)new CommitController(this, logMessage, callback, monitor).execute();
    }

    @Override
    public void exportLocalChanges(File file, IProgressMonitor progressMonitor) throws IOException {
        new ExportChangesController(this).execute(file, progressMonitor);
    }

    @Override
    public void exportLocalChanges(File file) throws IOException {
        new ExportChangesController(this).execute(file, (IProgressMonitor)new NullProgressMonitor());
    }

    @Override
    public void exportProject(File file, IProgressMonitor progressMonitor) throws IOException {
        new ExportProjectController(this).execute(file, progressMonitor);
    }

    @Override
    public void exportProject(File file) throws IOException {
        new ExportProjectController(this).execute(file, (IProgressMonitor)new NullProgressMonitor());
    }

    @Override
    public List<ChangePackage> getChanges(VersionSpec sourceVersion, VersionSpec targetVersion) throws EmfStoreException {
        ConnectionManager connectionManager = WorkspaceManager.getInstance().getConnectionManager();
        List changes = connectionManager.getChanges(this.getUsersession().getSessionId(), this.getProjectId(), sourceVersion, targetVersion);
        return changes;
    }

    @Override
    public FileDownloadStatus getFile(FileIdentifier fileIdentifier) throws FileTransferException {
        return this.fileTransferManager.getFile(fileIdentifier);
    }

    @Override
    public FileInformation getFileInfo(FileIdentifier fileIdentifier) {
        return this.fileTransferManager.getFileInfo(fileIdentifier);
    }

    @Override
    public List<HistoryInfo> getHistoryInfo(HistoryQuery query) throws EmfStoreException {
        return this.getWorkspace().getHistoryInfo(this.getUsersession(), this.getProjectId(), query);
    }

    @Override
    public ChangePackage getLocalChangePackage(boolean canonize) {
        ChangePackage changePackage = VersioningFactory.eINSTANCE.createChangePackage();
        for (AbstractOperation abstractOperation : this.getOperations()) {
            AbstractOperation copy = (AbstractOperation)ModelUtil.clone((EObject)abstractOperation);
            changePackage.getOperations().add((Object)copy);
        }
        return changePackage;
    }

    @Override
    public ModifiedModelElementsCache getModifiedModelElementsCache() {
        return this.modifiedModelElementsCache;
    }

    public NotificationRecorder getNotificationRecorder() {
        return this.operationRecorder.getNotificationRecorder();
    }

    @Override
    public OperationManager getOperationManager() {
        return this.operationManager;
    }

    @Override
    public List<AbstractOperation> getOperations() {
        OperationComposite operationComposite = this.getLocalOperations();
        if (operationComposite == null) {
            this.setLocalOperations(ModelFactory.eINSTANCE.createOperationComposite());
            operationComposite = this.getLocalOperations();
        }
        if (this.isTransient) {
            return operationComposite.getOperations();
        }
        if (this.operationsList == null) {
            this.operationsList = new AutoSplitAndSaveResourceContainmentList<AbstractOperation>(operationComposite, operationComposite.getOperations(), this.eResource().getResourceSet(), String.valueOf(Configuration.getWorkspaceDirectory()) + "ps-" + this.getIdentifier() + File.separatorChar + "operations", ".off");
        }
        return this.operationsList;
    }

    @Override
    public ProjectInfo getProjectInfo() {
        ProjectInfo projectInfo = org.eclipse.emf.emfstore.server.model.ModelFactory.eINSTANCE.createProjectInfo();
        projectInfo.setProjectId((ProjectId)ModelUtil.clone((EObject)this.getProjectId()));
        projectInfo.setName(this.getProjectName());
        projectInfo.setDescription(this.getProjectDescription());
        projectInfo.setVersion((PrimaryVersionSpec)ModelUtil.clone((EObject)this.getBaseVersion()));
        return projectInfo;
    }

    @Override
    public PropertyManager getPropertyManager() {
        if (this.propertyManager == null) {
            this.propertyManager = new PropertyManager(this);
        }
        return this.propertyManager;
    }

    private OrgUnitProperty getProperty(String name) throws PropertyNotFoundException {
        OrgUnitProperty orgUnitProperty;
        if (this.getUsersession() != null && this.getUsersession().getACUser() != null && (orgUnitProperty = this.propertyMap.get(name)) != null) {
            return orgUnitProperty;
        }
        throw new PropertyNotFoundException();
    }

    public StatePersister getStatePersister() {
        return this.statePersister;
    }

    @Override
    public void importLocalChanges(String fileName) throws IOException {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource resource = resourceSet.getResource(URI.createFileURI((String)fileName), true);
        EList directContents = resource.getContents();
        if (directContents.size() != 1 && !(directContents.get(0) instanceof ChangePackage)) {
            throw new IOException("File is corrupt, does not contain Changes.");
        }
        ChangePackage changePackage = (ChangePackage)directContents.get(0);
        this.applyOperationsWithRecording((List<AbstractOperation>)changePackage.getOperations(), true);
    }

    @Override
    public void init() {
        EObjectChangeNotifier changeNotifier = this.getProject().getChangeNotifier();
        this.initCompleted = true;
        this.fileTransferManager = new FileTransferManager(this);
        this.operationRecorder = new OperationRecorder((IdEObjectCollectionImpl)this.getProject(), changeNotifier);
        this.operationManager = new OperationManager(this.operationRecorder, this);
        this.operationManager.addOperationListener(this.modifiedModelElementsCache);
        this.statePersister = new StatePersister(changeNotifier, (EMFStoreCommandStack)Configuration.getEditingDomain().getCommandStack(), (IdEObjectCollectionImpl)this.getProject());
        this.getProject().addIdEObjectCollectionChangeObserver((IdEObjectCollectionChangeObserver)this.operationRecorder);
        this.getProject().addIdEObjectCollectionChangeObserver((IdEObjectCollectionChangeObserver)this.statePersister);
        if (this.getProject() instanceof ProjectImpl) {
            ((ProjectImpl)this.getProject()).setUndetachable((IdEObjectCollectionChangeObserver)this.operationRecorder);
            ((ProjectImpl)this.getProject()).setUndetachable((IdEObjectCollectionChangeObserver)this.statePersister);
        }
        if (this.getUsersession() != null) {
            WorkspaceManager.getObserverBus().register((IObserver)this, new Class[]{LoginObserver.class});
            ACUser acUser = this.getUsersession().getACUser();
            if (acUser != null) {
                for (OrgUnitProperty p : acUser.getProperties()) {
                    if (p.getProject() == null || !p.getProject().equals(this.getProjectId())) continue;
                    this.propertyMap.put(p.getName(), p);
                }
            }
        }
        this.modifiedModelElementsCache.initializeCache();
        this.startChangeRecording();
        this.cleanCutElements();
    }

    public FileTransferManager getFileTransferManager() {
        return this.fileTransferManager;
    }

    @Override
    public void initResources(ResourceSet resourceSet) {
        this.resourceSet = resourceSet;
        this.initCompleted = true;
        String projectSpaceFileNamePrefix = String.valueOf(Configuration.getWorkspaceDirectory()) + Configuration.getProjectSpaceDirectoryPrefix() + this.getIdentifier() + File.separatorChar;
        String projectSpaceFileName = String.valueOf(projectSpaceFileNamePrefix) + this.getIdentifier() + Configuration.getProjectSpaceFileExtension();
        String operationsCompositeFileName = String.valueOf(projectSpaceFileNamePrefix) + this.getIdentifier() + Configuration.getOperationCompositeFileExtension();
        String projectFragementsFileNamePrefix = String.valueOf(projectSpaceFileNamePrefix) + Configuration.getProjectFolderName() + File.separatorChar;
        URI projectSpaceURI = URI.createFileURI((String)projectSpaceFileName);
        URI operationCompositeURI = URI.createFileURI((String)operationsCompositeFileName);
        this.setResourceCount(0);
        String fileName = String.valueOf(projectFragementsFileNamePrefix) + this.getResourceCount() + Configuration.getProjectFragmentFileExtension();
        URI fileURI = URI.createFileURI((String)fileName);
        ArrayList<Resource> resources = new ArrayList<Resource>();
        Resource resource = resourceSet.createResource(fileURI);
        resource.getContents().add((Object)this.getProject());
        resources.add(resource);
        this.setResourceCount(this.getResourceCount() + 1);
        if (Configuration.isResourceSplittingEnabled()) {
            this.splitResources(resourceSet, projectFragementsFileNamePrefix, resources, this.getProject());
        } else {
            for (EObject modelElement : this.getProject().getAllModelElements()) {
                ((XMIResource)resource).setID(modelElement, this.getProject().getModelElementId(modelElement).getId());
            }
        }
        Resource operationCompositeResource = resourceSet.createResource(operationCompositeURI);
        if (this.getLocalOperations() == null) {
            this.setLocalOperations(ModelFactory.eINSTANCE.createOperationComposite());
        }
        operationCompositeResource.getContents().add((Object)this.getLocalOperations());
        resources.add(operationCompositeResource);
        Resource projectSpaceResource = resourceSet.createResource(projectSpaceURI);
        projectSpaceResource.getContents().add((Object)this);
        resources.add(projectSpaceResource);
        for (Resource currentResource : resources) {
            try {
                currentResource.save(Configuration.getResourceSaveOptions());
            }
            catch (IOException e) {
                WorkspaceUtil.logException("Project Space resource init failed!", e);
            }
        }
        this.init();
    }

    @Override
    public void delete() throws IOException {
        this.operationManager.removeOperationListener(this.modifiedModelElementsCache);
        WorkspaceManager.getObserverBus().unregister((IObserver)this.modifiedModelElementsCache);
        WorkspaceManager.getObserverBus().unregister((IObserver)this);
        String pathToProject = String.valueOf(Configuration.getWorkspaceDirectory()) + Configuration.getProjectSpaceDirectoryPrefix() + this.getIdentifier();
        ArrayList<Resource> toDelete = new ArrayList<Resource>();
        for (Resource resource : this.resourceSet.getResources()) {
            if (!resource.getURI().toFileString().startsWith(pathToProject)) continue;
            toDelete.add(resource);
        }
        for (Resource resource : toDelete) {
            resource.delete(null);
        }
        this.resourceSet.getResources().clear();
        FileUtil.deleteFolder((File)new File(pathToProject));
    }

    @Override
    public boolean isTransient() {
        return this.isTransient;
    }

    @Override
    public boolean isUpdated() throws EmfStoreException {
        PrimaryVersionSpec headVersion = this.resolveVersionSpec(VersionSpec.HEAD_VERSION);
        return this.getBaseVersion().equals(headVersion);
    }

    @Override
    public void loginCompleted(Usersession session) {
        if (this.getUsersession() == null || !this.getUsersession().equals(session)) {
            return;
        }
        try {
            this.transmitProperties();
        }
        catch (RuntimeException e) {
            WorkspaceUtil.logException("Resuming file transfers or transmitting properties failed!", e);
        }
    }

    @Override
    public void makeTransient() {
        if (this.initCompleted) {
            throw new IllegalAccessError("Project Space cannot be set to transient after init.");
        }
        this.isTransient = true;
    }

    @Override
    public boolean merge(PrimaryVersionSpec target, ConflictResolver conflictResolver) throws EmfStoreException {
        ChangePackage myCp = this.getLocalChangePackage(true);
        List<ChangePackage> theirCps = this.getChanges((VersionSpec)this.getBaseVersion(), (VersionSpec)target);
        if (conflictResolver.resolveConflicts(this.getProject(), theirCps, myCp, this.getBaseVersion(), target)) {
            this.revert();
            for (ChangePackage changePackage : theirCps) {
                this.applyOperations((List<AbstractOperation>)changePackage.getOperations(), false);
            }
            List<AbstractOperation> acceptedMine = conflictResolver.getAcceptedMine();
            List<AbstractOperation> rejectedTheirs = conflictResolver.getRejectedTheirs();
            ArrayList<AbstractOperation> mergeResult = new ArrayList<AbstractOperation>();
            for (AbstractOperation operationToReverse : rejectedTheirs) {
                mergeResult.add(0, operationToReverse.reverse());
            }
            mergeResult.addAll(acceptedMine);
            this.applyOperations(mergeResult, true);
            this.setBaseVersion(target);
            this.saveProjectSpaceOnly();
            return true;
        }
        return false;
    }

    @Override
    public void removeTag(PrimaryVersionSpec versionSpec, TagVersionSpec tag) throws EmfStoreException {
        ConnectionManager cm = WorkspaceManager.getInstance().getConnectionManager();
        cm.removeTag(this.getUsersession().getSessionId(), this.getProjectId(), versionSpec, tag);
    }

    @Override
    public EObject resolve(ModelElementUrlFragment modelElementUrlFragment) throws MEUrlResolutionException {
        ModelElementId modelElementId = modelElementUrlFragment.getModelElementId();
        EObject modelElement = this.getProject().getModelElement(modelElementId);
        if (modelElement == null) {
            throw new MEUrlResolutionException();
        }
        return modelElement;
    }

    @Override
    public PrimaryVersionSpec resolveVersionSpec(VersionSpec versionSpec) throws EmfStoreException {
        ConnectionManager connectionManager = WorkspaceManager.getInstance().getConnectionManager();
        return connectionManager.resolveVersionSpec(this.getUsersession().getSessionId(), this.getProjectId(), versionSpec);
    }

    @Override
    public void revert() {
        while (!this.getOperations().isEmpty()) {
            this.undoLastOperation();
        }
        this.updateDirtyState();
    }

    public void saveProjectSpaceOnly() {
        this.saveResource(this.eResource());
    }

    public void save() {
        this.saveProjectSpaceOnly();
        this.operationsList.save();
        this.statePersister.saveDirtyResources(true);
    }

    public void saveResource(Resource resource) {
        try {
            if (resource == null) {
                if (!this.isTransient) {
                    WorkspaceUtil.logException("Resources of project space are not properly initialized!", (Exception)((Object)new IllegalProjectSpaceStateException("Resource to save is null")));
                }
                return;
            }
            resource.save(Configuration.getResourceSaveOptions());
        }
        catch (IOException e) {
            WorkspaceUtil.logException("An error in the data was detected during save! The safest way to deal with this problem is to delete this project and checkout again.", e);
        }
    }

    @Override
    public void setProperty(OrgUnitProperty property) {
        if (this.getUsersession() != null && this.getUsersession().getACUser() != null) {
            try {
                if (property.getProject() == null) {
                    property.setProject((ProjectId)ModelUtil.clone((EObject)this.getProjectId()));
                } else if (!property.getProject().equals(this.getProjectId())) {
                    return;
                }
                OrgUnitProperty prop = this.getProperty(property.getName());
                prop.setValue(property.getValue());
            }
            catch (PropertyNotFoundException e) {
                this.getUsersession().getACUser().getProperties().add((Object)property);
                this.propertyMap.put(property.getName(), property);
            }
            for (OrgUnitProperty changedProperty : this.getUsersession().getChangedProperties()) {
                if (!changedProperty.getName().equals(property.getName()) || !changedProperty.getProject().equals(this.getProjectId())) continue;
                changedProperty.setValue(property.getValue());
                WorkspaceManager.getInstance().getCurrentWorkspace().save();
                return;
            }
            this.getUsersession().getChangedProperties().add((Object)property);
            WorkspaceManager.getInstance().getCurrentWorkspace().save();
        }
    }

    @Override
    public void shareProject() throws EmfStoreException {
        this.shareProject(null, null);
    }

    @Override
    public void shareProject(Usersession session, IProgressMonitor monitor) throws EmfStoreException {
        new ShareController(this, session, monitor).execute();
    }

    private void splitResources(ResourceSet resourceSet, String projectFragementsFileNamePrefix, List<Resource> resources, Project project) {
        Resource resource = project.eResource();
        int counter = 0;
        for (EObject modelElement : project.getAllModelElements()) {
            if (modelElement instanceof BasicEMap.Entry) {
                ((XMIResource)modelElement.eContainer().eResource()).setID(modelElement, this.getProject().getModelElementId(modelElement).getId());
                continue;
            }
            if (counter > Configuration.getMaxMECountPerResource()) {
                String fileName = String.valueOf(projectFragementsFileNamePrefix) + this.getResourceCount() + Configuration.getProjectFragmentFileExtension();
                URI fileURI = URI.createFileURI((String)fileName);
                resource = resourceSet.createResource(fileURI);
                this.setResourceCount(this.getResourceCount() + 1);
                resources.add(resource);
                counter = 0;
            }
            ++counter;
            this.assignElementToResource(resource, modelElement);
        }
    }

    public void startChangeRecording() {
        this.operationRecorder.startChangeRecording();
        this.updateDirtyState();
    }

    public void stopChangeRecording() {
        this.operationRecorder.stopChangeRecording();
    }

    @Override
    public void transmitProperties() {
        ArrayList<OrgUnitProperty> temp = new ArrayList<OrgUnitProperty>();
        for (OrgUnitProperty changedProperty : this.getUsersession().getChangedProperties()) {
            if (changedProperty.getProject() == null || !changedProperty.getProject().equals(this.getProjectId())) continue;
            temp.add(changedProperty);
        }
        ListIterator iterator = temp.listIterator();
        while (iterator.hasNext()) {
            try {
                WorkspaceManager.getInstance().getConnectionManager().transmitProperty(this.getUsersession().getSessionId(), (OrgUnitProperty)iterator.next(), this.getUsersession().getACUser(), this.getProjectId());
                iterator.remove();
            }
            catch (EmfStoreException e) {
                WorkspaceUtil.logException("Transmission of properties failed with exception", (Exception)((Object)e));
            }
        }
    }

    @Override
    public void undoLastOperation() {
        this.undoLastOperations(1);
    }

    @Override
    public void undoLastOperations(int numberOfOperations) {
        if (numberOfOperations <= 0) {
            return;
        }
        if (!this.getOperations().isEmpty()) {
            AbstractOperation lastOperation;
            List<AbstractOperation> operations;
            block7: {
                operations = this.getOperations();
                lastOperation = operations.get(operations.size() - 1);
                this.stopChangeRecording();
                try {
                    try {
                        lastOperation.reverse().apply((IdEObjectCollection)this.getProject());
                        this.operationManager.notifyOperationUndone(lastOperation);
                    }
                    catch (RuntimeException exception) {
                        WorkspaceUtil.handleException(exception);
                        this.startChangeRecording();
                        break block7;
                    }
                }
                catch (Throwable throwable) {
                    this.startChangeRecording();
                    throw throwable;
                }
                this.startChangeRecording();
            }
            operations.remove(lastOperation);
            this.undoLastOperations(--numberOfOperations);
        }
        this.updateDirtyState();
    }

    @Override
    public PrimaryVersionSpec update() throws EmfStoreException {
        return this.update(VersionSpec.HEAD_VERSION);
    }

    @Override
    public PrimaryVersionSpec update(VersionSpec version) throws EmfStoreException {
        return this.update(version, null, null);
    }

    @Override
    public PrimaryVersionSpec update(VersionSpec version, UpdateCallback callback, IProgressMonitor progress) throws EmfStoreException {
        return (PrimaryVersionSpec)new UpdateController(this, version, callback, progress).execute();
    }

    public void updateDirtyState() {
        this.setDirty(!this.getOperations().isEmpty());
    }
}

