/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.client.model.importexport.impl;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.emfstore.client.model.ProjectSpace;
import org.eclipse.emf.emfstore.client.model.Workspace;
import org.eclipse.emf.emfstore.client.model.WorkspaceManager;
import org.eclipse.emf.emfstore.client.model.importexport.ExportImportDataUnits;
import org.eclipse.emf.emfstore.client.model.importexport.IExportImportController;
import org.eclipse.emf.emfstore.client.model.util.ResourceHelper;
import org.eclipse.emf.emfstore.common.model.Project;
import org.eclipse.emf.emfstore.common.model.util.ModelUtil;

public class ExportWorkspaceController
implements IExportImportController {
    public String getLabel() {
        return "workspace";
    }

    public String[] getFilteredNames() {
        return new String[]{"EMFStore Workspace Files (*" + ExportImportDataUnits.Workspace.getExtension() + ")", "All Files (*.*)"};
    }

    public String[] getFilteredExtensions() {
        return new String[]{"*" + ExportImportDataUnits.Workspace.getExtension() + ", *.*"};
    }

    public String getFilename() {
        return "Workspace_" + new Date();
    }

    public String getParentFolderPropertyKey() {
        return "org.eclipse.emf.emfstore.client.ui.exportWorkSpacePath";
    }

    public void execute(File file, IProgressMonitor progressMonitor) throws IOException {
        Workspace copy = (Workspace)ModelUtil.clone((EObject)WorkspaceManager.getInstance().getCurrentWorkspace());
        int i = 0;
        for (ProjectSpace copiedProjectSpace : copy.getProjectSpaces()) {
            Project orgProject = ((ProjectSpace)WorkspaceManager.getInstance().getCurrentWorkspace().getProjectSpaces().get(i++)).getProject();
            copiedProjectSpace.setProject((Project)ModelUtil.clone((EObject)orgProject));
        }
        ResourceHelper.putWorkspaceIntoNewResource(file.getAbsolutePath(), copy);
    }

    public boolean isExport() {
        return true;
    }
}

