/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.server.backchannel;

import java.util.Set;
import org.eclipse.emf.emfstore.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.server.EmfStoreInterface;
import org.eclipse.emf.emfstore.server.accesscontrol.AccessControlImpl;
import org.eclipse.emf.emfstore.server.accesscontrol.AuthenticationControl;
import org.eclipse.emf.emfstore.server.accesscontrol.AuthorizationControl;
import org.eclipse.emf.emfstore.server.backchannel.BackchannelImpl;
import org.eclipse.emf.emfstore.server.backchannel.connection.server.XmlRpcBackchannelConnectionHandler;
import org.eclipse.emf.emfstore.server.connection.ConnectionHandler;
import org.eclipse.emf.emfstore.server.exceptions.FatalEmfStoreException;
import org.eclipse.emf.emfstore.server.model.ServerSpace;
import org.eclipse.emf.emfstore.server.startup.PostStartupListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BachchannelInitiator
implements PostStartupListener {
    public void postStartUp(ServerSpace serverspace, AccessControlImpl accessControl, Set<ConnectionHandler<? extends EmfStoreInterface>> connectionHandlers) {
        try {
            BackchannelImpl backchannelImpl = new BackchannelImpl(serverspace, (AuthorizationControl)accessControl);
            XmlRpcBackchannelConnectionHandler connectionHandler = new XmlRpcBackchannelConnectionHandler();
            connectionHandler.init(backchannelImpl, (AuthenticationControl)accessControl);
            connectionHandlers.add(connectionHandler);
            ModelUtil.logInfo((String)"Backchannel initiated successfully.");
        }
        catch (FatalEmfStoreException e) {
            ModelUtil.logException((String)"Couldn't initiate bachchannel.", (Throwable)e);
        }
    }
}

