/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.server.accesscontrol;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.emfstore.internal.common.APIUtil;
import org.eclipse.emf.emfstore.internal.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.internal.server.core.MonitorProvider;
import org.eclipse.emf.emfstore.internal.server.exceptions.AccessControlException;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.ACGroup;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.ACOrgUnit;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.ACUser;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.roles.Role;
import org.eclipse.emf.emfstore.internal.server.model.impl.api.ESGroupImpl;
import org.eclipse.emf.emfstore.internal.server.model.impl.api.ESOrgUnitIdImpl;
import org.eclipse.emf.emfstore.internal.server.model.impl.api.ESOrgUnitImpl;
import org.eclipse.emf.emfstore.internal.server.model.impl.api.ESUserImpl;
import org.eclipse.emf.emfstore.server.auth.ESOrgUnitResolver;
import org.eclipse.emf.emfstore.server.model.ESAuthenticationInformation;
import org.eclipse.emf.emfstore.server.model.ESGroup;
import org.eclipse.emf.emfstore.server.model.ESOrgUnit;
import org.eclipse.emf.emfstore.server.model.ESOrgUnitId;
import org.eclipse.emf.emfstore.server.model.ESOrgUnitProvider;
import org.eclipse.emf.emfstore.server.model.ESRole;
import org.eclipse.emf.emfstore.server.model.ESUser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultESOrgUnitResolverService
implements ESOrgUnitResolver {
    private ESOrgUnitProvider orgUnitProvider;

    @Override
    public List<ESRole> getRolesFromGroups(ESOrgUnit orgUnit) {
        ArrayList<ESRole> roles = new ArrayList<ESRole>();
        for (ESGroup group : this.getGroups(orgUnit)) {
            roles.addAll(group.getRoles());
        }
        return roles;
    }

    @Override
    public ESUser resolveRoles(ESAuthenticationInformation authInfo) throws AccessControlException {
        return this.copyAndResolveUser(authInfo.getUser());
    }

    @Override
    public ESUser copyAndResolveUser(ESUser esUser) {
        ACUser tmpUser = (ACUser)((ESUserImpl)ESUserImpl.class.cast(esUser)).toInternalAPI();
        ACUser user = (ACUser)ModelUtil.clone((EObject)tmpUser);
        List<ESRole> rolesFromGroups = this.getRolesFromGroups((ESOrgUnit)esUser);
        List internal = APIUtil.toInternal(rolesFromGroups);
        for (Role role : internal) {
            user.getRoles().add((Object)((Role)ModelUtil.clone((EObject)role)));
        }
        List<ESGroup> groups = this.getGroups((ESOrgUnit)esUser);
        List internal2 = APIUtil.toInternal(groups);
        for (ACGroup group : internal2) {
            if (user.getEffectiveGroups().contains((Object)group)) continue;
            ACGroup copy = (ACGroup)ModelUtil.clone((EObject)group);
            user.getEffectiveGroups().add((Object)copy);
            copy.getMembers().clear();
        }
        return (ESUser)user.toAPI();
    }

    @Override
    public ESUser resolveUser(ESOrgUnitId orgUnitId) throws AccessControlException {
        Preconditions.checkNotNull((Object)orgUnitId);
        Object object = MonitorProvider.getInstance().getMonitor();
        synchronized (object) {
            Set users = this.orgUnitProvider.getUsers();
            Set internal = APIUtil.toInternal((Set)users);
            for (ACUser user : internal) {
                if (!user.getId().equals(((ESOrgUnitIdImpl)ESOrgUnitIdImpl.class.cast(orgUnitId)).toInternalAPI())) continue;
                return (ESUser)user.toAPI();
            }
            throw new AccessControlException();
        }
    }

    @Override
    public List<ESGroup> getGroups(ESOrgUnitId orgUnitId) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ESGroup> getGroups(ESOrgUnit esOrgUnit) {
        ACOrgUnit orgUnit = (ACOrgUnit)((ESOrgUnitImpl)ESOrgUnitImpl.class.cast(esOrgUnit)).toInternalAPI();
        Object object = MonitorProvider.getInstance().getMonitor();
        synchronized (object) {
            ArrayList<ESGroup> groups = new ArrayList<ESGroup>();
            for (ESGroup esGroup : this.orgUnitProvider.getGroups()) {
                ACGroup group = (ACGroup)((ESGroupImpl)ESGroupImpl.class.cast(esGroup)).toInternalAPI();
                if (!group.getMembers().contains((Object)orgUnit)) continue;
                groups.add((ESGroup)group.toAPI());
                for (ESGroup esG : this.getGroups((ESOrgUnit)group.toAPI())) {
                    ACGroup g = (ACGroup)((ESGroupImpl)ESGroupImpl.class.cast(esG)).toInternalAPI();
                    if (groups.contains(g)) continue;
                    groups.add((ESGroup)g.toAPI());
                }
            }
            return groups;
        }
    }

    @Override
    public void init(ESOrgUnitProvider orgUnitProvider) {
        this.orgUnitProvider = orgUnitProvider;
    }
}

