/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.common;

import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.emfstore.common.ESSafeRunnable;
import org.eclipse.emf.emfstore.internal.common.CommonUtil;

public final class ESSafeRunner {
    private ESSafeRunner() {
    }

    public static void run(ESSafeRunnable code) {
        Assert.isNotNull((Object)code);
        try {
            code.run();
        }
        catch (Exception e) {
            ESSafeRunner.handleException(code, e);
        }
        catch (LinkageError e) {
            ESSafeRunner.handleException(code, e);
        }
        catch (AssertionError e) {
            ESSafeRunner.handleException(code, (Throwable)((Object)e));
        }
    }

    private static void handleException(ESSafeRunnable code, Throwable exception) {
        code.handleException(exception);
        if (CommonUtil.isTesting()) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new RuntimeException(exception);
        }
    }
}

