/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.expr;

import java.util.Objects;
import org.apache.jena.query.Query;
import org.apache.jena.sparql.ARQConstants;
import org.apache.jena.sparql.ARQInternalErrorException;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprFunction1;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.expr.nodevalue.NodeFunctions;
import org.apache.jena.sparql.function.FunctionEnv;
import org.apache.jena.sparql.serializer.SerializationContext;

public class E_IRI
extends ExprFunction1 {
    private static final String sparqlPrintName = "IRI";
    private static final String sseFunctionName = "iri";
    protected final String parserBase;
    protected final Expr relExpr;

    public E_IRI(Expr relExpr) {
        this(null, relExpr);
    }

    public E_IRI(String parserBaseURI, Expr relExpr) {
        this(parserBaseURI, relExpr, sparqlPrintName, sseFunctionName);
    }

    protected E_IRI(String baseStr, Expr relExpr, String sparqlName, String sseName) {
        super(relExpr, sseName);
        this.parserBase = baseStr;
        this.relExpr = relExpr;
    }

    @Override
    protected NodeValue evalSpecial(Binding binding, FunctionEnv env) {
        String baseIRI = this.parserBase;
        NodeValue nvRel = this.relExpr.eval(binding, env);
        return E_IRI.resolve(nvRel, baseIRI, env);
    }

    static NodeValue resolve(NodeValue relative, String baseIRI, FunctionEnv env) {
        Query query;
        if (baseIRI == null && env.getContext() != null && (query = (Query)env.getContext().get(ARQConstants.sysCurrentQuery)) != null) {
            baseIRI = query.getBaseURI();
        }
        if (NodeFunctions.isIRI(relative.asNode())) {
            relative = NodeValue.makeString(relative.asString());
        }
        return NodeFunctions.iri(relative, baseIRI);
    }

    @Override
    public NodeValue eval(NodeValue v, FunctionEnv env) {
        return E_IRI.resolve(v, this.parserBase, env);
    }

    @Override
    public Expr copy(Expr expr) {
        return new E_IRI(this.parserBase, expr);
    }

    @Override
    public NodeValue eval(NodeValue v) {
        throw new ARQInternalErrorException("Should not be called");
    }

    @Override
    public String getFunctionPrintName(SerializationContext cxt) {
        return sparqlPrintName;
    }

    public String getParserBase() {
        return this.parserBase;
    }

    public Expr getRelExpr() {
        return this.relExpr;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.parserBase);
        return result;
    }

    @Override
    public boolean equals(Expr obj, boolean bySyntax) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        E_IRI other = (E_IRI)obj;
        return Objects.equals(this.parserBase, other.parserBase) && Objects.equals(this.relExpr, other.relExpr);
    }
}

