/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.emc.simulink.types;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.epsilon.emc.simulink.engine.MatlabEngine;
import org.eclipse.epsilon.emc.simulink.types.AbstractType;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;

public class CellStr
extends AbstractType {
    private static final String CELL_STR_MATLAB_CLASS = "com.mathworks.matlab.types.CellStr";
    private static Class<?> cell_str_class;
    protected Method getStringArrayMethod;
    protected Method equalsMethod;

    public static boolean is(Object obj) {
        return CellStr.getMatlabClass() == null ? false : CellStr.getMatlabClass().isInstance(obj);
    }

    protected static Class<?> getMatlabClass() {
        if (cell_str_class == null) {
            try {
                cell_str_class = ClassLoader.getSystemClassLoader().loadClass(CELL_STR_MATLAB_CLASS);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        return cell_str_class;
    }

    public CellStr(Object cellStr) {
        if (CellStr.is(cellStr)) {
            this.object = cellStr;
            this.init();
        }
    }

    public CellStr(MatlabEngine engine) {
        super(engine);
    }

    public CellStr(String[] stringArray) {
        try {
            Constructor<?> constructor = CellStr.getMatlabClass().getConstructor(String[].class);
            this.object = constructor.newInstance(new Object[]{stringArray});
        }
        catch (NoSuchMethodException | SecurityException e) {
            e.printStackTrace();
            System.out.println("Problem retrieving constructor of the complex type");
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            System.out.println("Problem instantiating the complex type");
            e.printStackTrace();
        }
    }

    public CellStr(String[][] stringArray) {
        try {
            Constructor<?> constructor = CellStr.getMatlabClass().getConstructor(String[][].class);
            this.object = constructor.newInstance(new Object[]{stringArray});
        }
        catch (NoSuchMethodException | SecurityException e) {
            e.printStackTrace();
            System.out.println("Problem retrieving constructor of the complex type");
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            System.out.println("Problem instantiating the complex type");
            e.printStackTrace();
        }
    }

    @Override
    protected void init() {
        Class<?> clazz = CellStr.getMatlabClass();
        try {
            this.getStringArrayMethod = this.getStringArrayMethod == null ? clazz.getDeclaredMethod("getStringArray", new Class[0]) : null;
            this.equalsMethod = this.equalsMethod == null ? clazz.getDeclaredMethod("equals", Object.class) : null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Object getStringArray() {
        try {
            return (Integer)this.getStringArrayMethod.invoke(this.object, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalStateException(e.getMessage());
        }
    }

    @Override
    public boolean equals(Object object) {
        try {
            return (Boolean)this.equalsMethod.invoke(object, object);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalStateException(e.getMessage());
        }
    }

    @Override
    public Object getProperty(String property) throws EolRuntimeException {
        return null;
    }

    @Override
    public void setProperty(String property, Object value) throws EolRuntimeException {
    }

    @Override
    protected Object getObject() {
        return this.object;
    }
}

