/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.dctools.ast.internal;

import java.util.Objects;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.fsm.fSM.AbstractInterfaceItem;
import org.eclipse.etrice.core.room.Attribute;
import org.eclipse.etrice.core.room.InterfaceItem;
import org.eclipse.etrice.core.room.Message;
import org.eclipse.etrice.core.room.Operation;
import org.eclipse.etrice.core.room.Port;
import org.eclipse.etrice.core.room.VarDecl;
import org.eclipse.etrice.dctools.ast.ITranslationProvider;
import org.eclipse.etrice.dctools.fsm.ast.nodes.DCAstArrayAccessNode;
import org.eclipse.etrice.dctools.fsm.ast.nodes.DCAstBracketNode;
import org.eclipse.etrice.dctools.fsm.ast.nodes.DCAstFeatureCallNode;
import org.eclipse.etrice.dctools.fsm.ast.nodes.DCAstIdentifierNode;
import org.eclipse.etrice.dctools.fsm.ast.nodes.DCAstNode;
import org.eclipse.etrice.dctools.fsm.ast.nodes.DCAstOperationCallNode;
import org.eclipse.etrice.dctools.fsm.ast.nodes.DCAstOtherNode;
import org.eclipse.etrice.dctools.fsm.ast.nodes.DCAstPeriodNode;
import org.eclipse.etrice.dctools.fsm.ast.nodes.DCAstWhitespaceNode;
import org.eclipse.etrice.dctools.fsm.ast.util.DCAstPrinter;
import org.eclipse.etrice.dctools.fsm.ast.util.IDCAstNodeVisitor;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class DCTranslatorVisitor
implements IDCAstNodeVisitor {
    private ITranslationProvider translationProvider;
    private final StringBuilder sb;
    private StringBuilder currentSB;

    public DCTranslatorVisitor(ITranslationProvider translationProvider) {
        this.currentSB = this.sb = new StringBuilder();
        this.translationProvider = translationProvider;
    }

    public String getTranslatedCode() {
        return this.sb.toString();
    }

    public boolean visitBegin(DCAstNode node) {
        if (node instanceof DCAstBracketNode) {
            boolean bl = this.shouldCollectArguments((DCAstBracketNode)node);
            if (bl) {
                StringBuilder stringBuilder;
                this.currentSB = stringBuilder = new StringBuilder();
                ((DCAstBracketNode)node).setLinkedData((Object)this.currentSB);
            } else {
                this.currentSB.append(((DCAstBracketNode)node).left());
            }
        } else {
            boolean bl;
            boolean bl2 = this.skipOutput(node);
            boolean bl3 = bl = !bl2;
            if (bl) {
                boolean bl4 = false;
                if (node instanceof DCAstIdentifierNode) {
                    bl4 = true;
                    this.currentSB.append(((DCAstIdentifierNode)node).getId());
                }
                if (!bl4 && node instanceof DCAstPeriodNode) {
                    bl4 = true;
                    this.currentSB.append(".");
                }
                if (!bl4 && node instanceof DCAstWhitespaceNode) {
                    bl4 = true;
                    this.currentSB.append(((DCAstWhitespaceNode)node).getText());
                }
                if (!bl4 && node instanceof DCAstOtherNode) {
                    bl4 = true;
                    this.currentSB.append(((DCAstOtherNode)node).getText());
                }
            }
        }
        return true;
    }

    public void visitEnd(DCAstNode node) {
        boolean bl;
        boolean bl2 = false;
        if (node instanceof DCAstBracketNode) {
            boolean bl3;
            bl2 = true;
            Object object = ((DCAstBracketNode)node).getLinkedData();
            boolean bl4 = bl3 = object != null;
            if (bl3) {
                this.currentSB = this.getEnclosingSB((DCAstBracketNode)node);
            } else {
                boolean bl5 = ((DCAstBracketNode)node).isClosed();
                if (bl5) {
                    this.currentSB.append(((DCAstBracketNode)node).right());
                }
            }
        }
        if (!bl2 && node instanceof DCAstFeatureCallNode && (bl = this.canTranslate((DCAstFeatureCallNode)node))) {
            bl2 = true;
            this.translate((DCAstFeatureCallNode)node);
        }
    }

    private boolean canTranslate(DCAstFeatureCallNode node) {
        int i = 0;
        while (i < node.getChildren().size()) {
            boolean bl;
            EObject eObject = node.c(i).getLinkedObject();
            boolean bl2 = bl = eObject == null;
            if (bl) {
                return false;
            }
            i += 2;
        }
        DCAstNode lastNode = (DCAstNode)IterableExtensions.lastOrNull((Iterable)node.getChildren());
        return !(lastNode instanceof DCAstPeriodNode);
    }

    private void translate(DCAstFeatureCallNode node) {
        DCAstNode lastNode = (DCAstNode)IterableExtensions.lastOrNull((Iterable)node.getChildren());
        EObject linkedObject = lastNode.getLinkedObject();
        if (lastNode instanceof DCAstOperationCallNode && linkedObject instanceof Message) {
            this.handleSendMessage((DCAstOperationCallNode)lastNode, (Message)linkedObject);
            return;
        }
        this.handleCallChain(node);
    }

    public StringBuilder handleCallChain(DCAstFeatureCallNode node) {
        StringBuilder stringBuilder = null;
        String instance = null;
        int i = 0;
        while (i < node.getChildren().size()) {
            Object index;
            String string;
            DCAstNode childNode = node.c(i);
            EObject linkedObject = childNode.getLinkedObject();
            boolean bl = false;
            if (linkedObject instanceof Attribute) {
                bl = true;
                string = null;
                if (childNode instanceof DCAstArrayAccessNode) {
                    Object object = ((DCAstArrayAccessNode)childNode).bracketNode().getLinkedData();
                    string = ((StringBuilder)object).toString();
                }
                index = string;
                instance = this.translationProvider.getAttributeGetter((Attribute)linkedObject, instance, (String)index, this.getOriginalText(childNode));
            }
            if (!bl && linkedObject instanceof VarDecl) {
                bl = true;
                instance = ((VarDecl)linkedObject).getName();
            }
            if (!bl && linkedObject instanceof Operation) {
                bl = true;
                string = null;
                if (childNode instanceof DCAstOperationCallNode) {
                    index = ((DCAstOperationCallNode)childNode).bracketNode().getLinkedData();
                    string = ((StringBuilder)index).toString();
                }
                String args = string;
                instance = this.translationProvider.getOperationText((Operation)linkedObject, instance, args, this.getOriginalText(childNode));
            }
            i += 2;
        }
        stringBuilder = this.currentSB.append(instance);
        return stringBuilder;
    }

    private StringBuilder handleSendMessage(DCAstOperationCallNode msgNode, Message msg) {
        StringBuilder stringBuilder = null;
        Object object = msgNode.bracketNode().getLinkedData();
        String args = ((StringBuilder)object).toString();
        DCAstNode ifItemNode = msgNode.getParent().c(0);
        EObject eObject = ifItemNode.getLinkedObject();
        InterfaceItem ifItem = (InterfaceItem)eObject;
        String string = null;
        if (ifItemNode instanceof DCAstIdentifierNode) {
            var10_10 = null;
            String inst = ((DCAstIdentifierNode)ifItemNode).getId();
            string = var10_10 = this.translationProvider.getInterfaceItemMessageText((AbstractInterfaceItem)ifItem, (EObject)msg, inst, args, null, this.getOriginalText((DCAstNode)msgNode));
        } else {
            var10_10 = null;
            if (ifItemNode instanceof DCAstArrayAccessNode) {
                String string2 = null;
                String inst = ((DCAstArrayAccessNode)ifItemNode).id();
                Object object2 = ((DCAstArrayAccessNode)ifItemNode).bracketNode().getLinkedData();
                String index = ((StringBuilder)object2).toString();
                var10_10 = string2 = this.translationProvider.getInterfaceItemMessageText((AbstractInterfaceItem)ifItem, (EObject)msg, inst, args, index, this.getOriginalText((DCAstNode)msgNode));
            } else {
                var10_10 = "internal translator error";
            }
            string = var10_10;
        }
        String translated = string;
        stringBuilder = this.currentSB.append(translated);
        return stringBuilder;
    }

    private boolean skipOutput(DCAstNode node) {
        DCAstNode surroundingContext = this.getEnclosingBracketOrFeatureCall(node);
        if (surroundingContext instanceof DCAstBracketNode) {
            return false;
        }
        if (surroundingContext instanceof DCAstFeatureCallNode) {
            return this.canTranslate((DCAstFeatureCallNode)surroundingContext);
        }
        return false;
    }

    private DCAstNode getEnclosingBracketOrFeatureCall(DCAstNode node) {
        DCAstNode parent = node.getParent();
        while (parent != null) {
            if (parent instanceof DCAstFeatureCallNode || parent instanceof DCAstBracketNode) {
                return parent;
            }
            parent = parent.getParent();
        }
        return null;
    }

    private String getOriginalText(DCAstNode node) {
        DCAstPrinter printer = new DCAstPrinter();
        node.visit((IDCAstNodeVisitor)printer);
        return printer.getText();
    }

    private StringBuilder getEnclosingSB(DCAstBracketNode node) {
        DCAstNode parent = node.getParent();
        while (parent != null) {
            if (parent instanceof DCAstBracketNode && parent.getLinkedData() instanceof StringBuilder) {
                Object object = parent.getLinkedData();
                return (StringBuilder)object;
            }
            parent = parent.getParent();
        }
        return this.sb;
    }

    private boolean shouldCollectArguments(DCAstBracketNode node) {
        boolean bl = false;
        EObject linkedObject = node.getParent().getLinkedObject();
        boolean bl2 = false;
        DCAstBracketNode.BracketType bracketType = node.getType();
        boolean bl3 = Objects.equals(bracketType, DCAstBracketNode.BracketType.CURLY);
        if (bl3) {
            bl2 = false;
        } else {
            boolean bl4 = false;
            if (linkedObject instanceof Operation) {
                bl4 = true;
            } else {
                boolean bl5 = false;
                if (linkedObject instanceof Message) {
                    bl5 = true;
                } else {
                    boolean bl6 = false;
                    if (linkedObject instanceof Attribute) {
                        bl6 = true;
                    } else {
                        boolean bl7 = false;
                        bl7 = linkedObject instanceof Port;
                        bl6 = bl7;
                    }
                    bl5 = bl6;
                }
                bl4 = bl5;
            }
            bl2 = bl4;
        }
        bl = bl2;
        return bl;
    }
}

