/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare;

import org.eclipse.compare.Splitter;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class CompareViewerPane
extends ViewForm
implements ISelectionProvider,
IDoubleClickListener,
ISelectionChangedListener,
IOpenListener,
IAdaptable {
    private ToolBarManager fToolBarManager;
    private Object fInput;
    private ListenerList<ISelectionChangedListener> fSelectionListeners = new ListenerList();
    private ListenerList<IDoubleClickListener> fDoubleClickListener = new ListenerList();
    private ListenerList<IOpenListener> fOpenListener = new ListenerList();

    public CompareViewerPane(Composite container, int style) {
        super(container, style);
        this.marginWidth = 0;
        this.marginHeight = 0;
        Control topLeft = this.createTopLeft((Composite)this);
        this.setTopLeft(topLeft);
        MouseAdapter ml = new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                Control content = CompareViewerPane.this.getContent();
                if (content != null && content.getBounds().contains(e.x, e.y)) {
                    return;
                }
                Composite parent = CompareViewerPane.this.getParent();
                if (parent instanceof Splitter) {
                    ((Splitter)parent).setMaximizedControl((Control)CompareViewerPane.this);
                }
            }
        };
        this.addMouseListener((MouseListener)ml);
        this.getTopLeft().addMouseListener((MouseListener)ml);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (CompareViewerPane.this.fToolBarManager != null) {
                    CompareViewerPane.this.fToolBarManager.removeAll();
                    CompareViewerPane.this.fToolBarManager.dispose();
                }
                CompareViewerPane.this.fInput = null;
                CompareViewerPane.this.fSelectionListeners = null;
                CompareViewerPane.this.setImage(null);
            }
        });
    }

    protected Control createTopLeft(Composite parent) {
        CLabel label = new CLabel((Composite)this, 0){

            public Point computeSize(int wHint, int hHint, boolean changed) {
                return super.computeSize(wHint, Math.max(24, hHint), changed);
            }
        };
        return label;
    }

    public void setText(String label) {
        CLabel cl = (CLabel)this.getTopLeft();
        if (cl != null && !cl.isDisposed()) {
            cl.setText(label);
        }
    }

    public void setImage(Image image) {
        CLabel cl = (CLabel)this.getTopLeft();
        if (cl != null) {
            cl.setImage(image);
        }
    }

    public static ToolBarManager getToolBarManager(Composite parent) {
        if (parent instanceof CompareViewerPane) {
            CompareViewerPane pane = (CompareViewerPane)parent;
            return pane.getToolBarManager();
        }
        return null;
    }

    public static void clearToolBar(Composite parent) {
        ToolBarManager tbm = CompareViewerPane.getToolBarManager(parent);
        if (tbm != null) {
            tbm.removeAll();
            tbm.update(true);
        }
    }

    private ToolBarManager getToolBarManager() {
        if (this.fToolBarManager != null && this.fToolBarManager.getControl() == null) {
            return null;
        }
        if (this.fToolBarManager == null) {
            final ToolBar tb = new ToolBar((Composite)this, 0x800000);
            this.setTopCenter((Control)tb);
            this.fToolBarManager = new ToolBarManager(tb);
            tb.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

                public void getName(AccessibleEvent e) {
                    String toolTip;
                    ToolItem item;
                    if (e.childID != -1 && (item = tb.getItem(e.childID)) != null && (toolTip = item.getToolTipText()) != null) {
                        e.result = toolTip;
                    }
                }
            });
        }
        return this.fToolBarManager;
    }

    public Object getInput() {
        return this.fInput;
    }

    public void setInput(Object input) {
        if (this.fInput != input) {
            this.fInput = input;
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener l) {
        this.fSelectionListeners.add((Object)l);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener l) {
        this.fSelectionListeners.remove((Object)l);
    }

    public ISelection getSelection() {
        return null;
    }

    public void setSelection(ISelection s) {
    }

    public void selectionChanged(SelectionChangedEvent ev) {
        for (ISelectionChangedListener listener : this.fSelectionListeners) {
            listener.selectionChanged(ev);
        }
    }

    public void doubleClick(DoubleClickEvent event) {
        for (IDoubleClickListener listener : this.fDoubleClickListener) {
            listener.doubleClick(event);
        }
    }

    public void addDoubleClickListener(IDoubleClickListener listener) {
        this.fDoubleClickListener.add((Object)listener);
    }

    public void removeDoubleClickListener(IDoubleClickListener listener) {
        this.fDoubleClickListener.remove((Object)listener);
    }

    public void addOpenListener(IOpenListener listener) {
        this.fOpenListener.add((Object)listener);
    }

    public void removeOpenListener(IOpenListener listener) {
        this.fOpenListener.remove((Object)listener);
    }

    public void open(OpenEvent event) {
        Object[] listeners = this.fOpenListener.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((IOpenListener)listeners[i]).open(event);
            ++i;
        }
    }

    public <T> T getAdapter(Class<T> adapter) {
        return (T)Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }
}

