/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.ccslkernel.compiler;

import fr.inria.aoste.timesquare.ccslkernel.compiler.ClassicalExpressionCompiler;
import fr.inria.aoste.timesquare.ccslkernel.compiler.CompilerParameters;
import fr.inria.aoste.timesquare.ccslkernel.compiler.NameProvider;
import fr.inria.aoste.timesquare.ccslkernel.compiler.codemodel.AbstractStatement;
import fr.inria.aoste.timesquare.ccslkernel.compiler.codemodel.ClassDefinition;
import fr.inria.aoste.timesquare.ccslkernel.compiler.codemodel.Comment;
import fr.inria.aoste.timesquare.ccslkernel.compiler.codemodel.IfStatement;
import fr.inria.aoste.timesquare.ccslkernel.compiler.codemodel.MemberFunction;
import fr.inria.aoste.timesquare.ccslkernel.compiler.codemodel.MemberVariable;
import fr.inria.aoste.timesquare.ccslkernel.compiler.codemodel.SimpleStatement;
import fr.inria.aoste.timesquare.ccslkernel.compiler.exceptions.CompilerException;
import fr.inria.aoste.timesquare.ccslkernel.compiler.helpers.PluginProjectHelper;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.BasicType.BasicTypePackage;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.BasicType.BooleanElement;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.BasicType.DenseClockType;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.BasicType.DiscreteClockType;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.BasicType.Element;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.BasicType.IntegerElement;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.BasicType.PrimitiveElement;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.BasicType.RealElement;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.BasicType.SequenceElement;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.BasicType.SequenceType;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.BasicType.StringElement;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.BasicType.Type;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.BasicType.util.BasicTypeSwitch;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.Block;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClassicalExpression.BooleanExpression;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClassicalExpression.BooleanRef;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClassicalExpression.BooleanVariableRef;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClassicalExpression.ClassicalExpression;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClassicalExpression.IntegerRef;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClassicalExpression.IntegerVariableRef;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClassicalExpression.NumberSeqVariableRef;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockConstraintSystem;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.AbstractEntity;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.BindableEntity;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.Binding;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.ClockExpressionAndRelationFactory;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.ConcreteEntity;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.ConditionalExpressionDefinition;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.ConditionalRelationDefinition;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.ExprCase;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.Expression;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.ExpressionDeclaration;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.ExpressionDefinition;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.KernelExpression.Concatenation;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.KernelExpression.Death;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.KernelExpression.Defer;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.KernelExpression.Discretization;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.KernelExpression.Inf;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.KernelExpression.Intersection;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.KernelExpression.KernelExpressionDeclaration;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.KernelExpression.NonStrictSampling;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.KernelExpression.StrictSampling;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.KernelExpression.Sup;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.KernelExpression.Union;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.KernelExpression.UpTo;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.KernelExpression.Wait;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.KernelExpression.util.KernelExpressionSwitch;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.KernelRelation.Coincidence;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.KernelRelation.KernelRelationDeclaration;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.Library;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.RelCase;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.Relation;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.RelationDeclaration;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.RelationDefinition;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.UserExpressionDefinition;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.UserRelationDefinition;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.Clock;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.NamedElement;
import fr.inria.aoste.timesquare.ccslkernel.modelunfolding.EqualitySolver;
import fr.inria.aoste.timesquare.ccslkernel.modelunfolding.RecursiveDefinitionChecker;
import fr.inria.aoste.timesquare.ccslkernel.modelunfolding.UnfoldModel;
import fr.inria.aoste.timesquare.ccslkernel.modelunfolding.exception.UnfoldingException;
import fr.inria.aoste.timesquare.ccslkernel.runtime.AbstractRuntimeBlock;
import fr.inria.aoste.timesquare.ccslkernel.runtime.AbstractRuntimeModel;
import fr.inria.aoste.timesquare.ccslkernel.runtime.ICCSLConstraint;
import fr.inria.aoste.timesquare.ccslkernel.runtime.IRuntimeContainer;
import fr.inria.aoste.timesquare.ccslkernel.runtime.ValueProvider;
import fr.inria.aoste.timesquare.ccslkernel.runtime.elements.RuntimeClock;
import fr.inria.aoste.timesquare.ccslkernel.runtime.exceptions.SimulationException;
import fr.inria.aoste.timesquare.ccslkernel.runtime.expressions.AbstractRuntimeExpression;
import fr.inria.aoste.timesquare.ccslkernel.runtime.expressions.RuntimeConcatenation;
import fr.inria.aoste.timesquare.ccslkernel.runtime.helpers.AbstractSemanticHelper;
import fr.inria.aoste.timesquare.ccslkernel.runtime.helpers.AbstractUpdateHelper;
import fr.inria.aoste.timesquare.ccslkernel.runtime.helpers.BDDHelper;
import fr.inria.aoste.timesquare.ccslkernel.runtime.relations.AbstractRuntimeRelation;
import fr.inria.aoste.timesquare.ccslkernel.runtime.simulation.CCSLSimulationEngine;
import fr.inria.aoste.timesquare.ccslkernel.runtime.simulation.CCSLStepExecutionEngine;
import fr.inria.aoste.timesquare.trace.util.QualifiedNameBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.junit.Test;

public class Compiler {
    private CompilerParameters parameters;
    private PluginProjectHelper pluginHelper;
    private NameProvider nameProvider;
    private UnfoldModel unfoldModel;
    Set<RelationDefinition> usedRelationDefinitions = new HashSet<RelationDefinition>();
    Set<ExpressionDefinition> usedExpressionDefinitions = new HashSet<ExpressionDefinition>();

    public Compiler(CompilerParameters params) {
        this.parameters = params;
        this.pluginHelper = new PluginProjectHelper();
    }

    public IProject compile(Resource model) throws CompilerException {
        try {
            this.unfoldModel = UnfoldModel.unfoldModel((Resource)model);
        }
        catch (UnfoldingException | IOException e) {
            e.printStackTrace();
        }
        if (this.unfoldModel != null) {
            IProject project = this.createDestinationProject();
            this.compile(this.unfoldModel, project);
            if (this.parameters.generateTests) {
                this.generateTestClass(this.unfoldModel, project);
            }
            if (this.parameters.generateMain) {
                this.generateMainClass(this.unfoldModel, project);
            }
            return project;
        }
        return null;
    }

    private IProject createDestinationProject() throws CompilerException {
        String projectName = this.parameters.outputProjectName != null ? this.parameters.outputProjectName : String.valueOf(this.parameters.outputProjectNamePrefix) + this.unfoldModel.getModel().getName().toLowerCase();
        IProject project = null;
        try {
            project = this.pluginHelper.createPluginProject(projectName);
        }
        catch (CoreException e) {
            throw new CompilerException("Caught CoreException while creating output project: ", e);
        }
        String[] stringArray = this.parameters.requiredDependencies;
        int n = this.parameters.requiredDependencies.length;
        int n2 = 0;
        while (n2 < n) {
            String bundle = stringArray[n2];
            try {
                this.pluginHelper.addRequiredBundle(project, bundle);
            }
            catch (CoreException e) {
                throw new CompilerException("Caught CoreException while adding dependency: ", e);
            }
            ++n2;
        }
        if (this.parameters.generateTests) {
            try {
                this.pluginHelper.addRequiredBundle(project, "org.junit");
            }
            catch (CoreException e) {
                throw new CompilerException("Caught CoreException while adding dependency: ", e);
            }
        }
        return project;
    }

    private void compile(UnfoldModel unfoldModel, IProject project) throws CompilerException {
        try {
            this.generateModelCode(unfoldModel, project);
            while (!this.usedExpressionDefinitions.isEmpty() || !this.usedRelationDefinitions.isEmpty()) {
                ArrayList<ExpressionDefinition> edefs = new ArrayList<ExpressionDefinition>(this.usedExpressionDefinitions);
                ArrayList<RelationDefinition> rdefs = new ArrayList<RelationDefinition>(this.usedRelationDefinitions);
                this.usedExpressionDefinitions.clear();
                this.usedRelationDefinitions.clear();
                for (ExpressionDefinition expressionDefinition : edefs) {
                    if (expressionDefinition instanceof ConditionalExpressionDefinition) {
                        this.compileConditionalExpressionDefinition((ConditionalExpressionDefinition)expressionDefinition, project);
                        continue;
                    }
                    if (!(expressionDefinition instanceof UserExpressionDefinition)) continue;
                    this.compileUserExpressionDefinition((UserExpressionDefinition)expressionDefinition, project);
                }
                for (RelationDefinition relationDefinition : rdefs) {
                    if (relationDefinition instanceof ConditionalRelationDefinition) {
                        this.compileConditionalRelationDefinition((ConditionalRelationDefinition)relationDefinition, project);
                        continue;
                    }
                    this.compileUserRelationDefinition((UserRelationDefinition)relationDefinition, project);
                }
            }
        }
        catch (CoreException e) {
            throw new CompilerException("Caught CoreException when compiling model " + project.getName() + ": ", e);
        }
    }

    private void generateModelCode(UnfoldModel unfoldModel, IProject project) throws CoreException, CompilerException {
        this.nameProvider = new NameProvider(this.parameters, unfoldModel);
        ClockConstraintSystem model = unfoldModel.getModel();
        String packageName = this.nameProvider.getPackageName((NamedElement)model);
        String className = this.nameProvider.getClassName((NamedElement)model);
        ClassDefinition classDef = new ClassDefinition(className, packageName);
        classDef.setProject(project);
        classDef.addImportedPackage(AbstractRuntimeModel.class.getName());
        classDef.addImportedPackage(AbstractRuntimeBlock.class.getName());
        classDef.setParentClassName(AbstractRuntimeModel.class.getSimpleName());
        MemberFunction constructor1 = new MemberFunction(className);
        constructor1.setConstructor(true);
        if (this.parameters.modelsAreSingleton) {
            constructor1.addModifier("private");
        } else {
            constructor1.addModifier("public");
        }
        constructor1.addStatement("super(\"" + model.getName() + "\")");
        constructor1.addStatement("init()");
        classDef.addMemberFunction(constructor1);
        MemberFunction constructor2 = new MemberFunction(className);
        constructor2.setConstructor(true);
        if (this.parameters.modelsAreSingleton) {
            constructor2.addModifier("private");
        } else {
            constructor2.addModifier("public");
        }
        constructor2.addParameter(IRuntimeContainer.class.getSimpleName(), "parent");
        constructor2.addStatement("super(\"" + model.getName() + "\", parent)");
        constructor2.addStatement("init()");
        classDef.addMemberFunction(constructor2);
        classDef.addImportedPackage(IRuntimeContainer.class.getName());
        if (this.parameters.modelsAreSingleton) {
            ClassDefinition holderClass = new ClassDefinition("SingletonHolder");
            holderClass.addModifier("private");
            holderClass.addModifier("static");
            MemberVariable instance = new MemberVariable("INSTANCE", className);
            instance.setInitializer("new " + className + "()");
            instance.addModifier("private");
            instance.addModifier("final");
            instance.addModifier("static");
            holderClass.addMemberVariable(instance);
            classDef.addInnerClass(holderClass);
            MemberFunction getInstanceFunction = new MemberFunction("getInstance", className);
            getInstanceFunction.addModifier("public");
            getInstanceFunction.addModifier("static");
            getInstanceFunction.addStatement("return SingletonHolder.INSTANCE");
            classDef.addMemberFunction(getInstanceFunction);
        }
        MemberFunction initFunction = new MemberFunction("init", "void");
        initFunction.addModifier("protected");
        classDef.addMemberFunction(initFunction);
        ArrayList<String> importedModelNames = new ArrayList<String>();
        for (UnfoldModel imported : unfoldModel.getImportedModels()) {
            ClockConstraintSystem importedModel = imported.getModel();
            String importedPackage = this.nameProvider.getPackageName((NamedElement)importedModel);
            String importedClassName = this.nameProvider.getClassName((NamedElement)importedModel);
            String variableName = this.nameProvider.getVariableName((NamedElement)importedModel);
            MemberVariable variable = new MemberVariable(variableName, importedClassName);
            variable.addModifier("private");
            variable.setInitializer("null");
            classDef.addMemberVariable(variable);
            classDef.addImportedPackage(String.valueOf(importedPackage) + "." + importedClassName);
            String getterName = this.nameProvider.getVariableGetterName((NamedElement)importedModel);
            MemberFunction getter = new MemberFunction(getterName, importedClassName);
            getter.addModifier("public");
            if (this.parameters.modelsAreSingleton) {
                initFunction.addStatement(String.valueOf(variableName) + " = " + importedClassName + ".getInstance()");
            } else {
                IfStatement ifNotExists = new IfStatement(String.valueOf(variableName) + " == null");
                ifNotExists.addThenStatement(String.valueOf(variableName) + " = new " + importedClassName + "(this)");
                getter.addStatement(ifNotExists);
                initFunction.addStatement(ifNotExists);
            }
            getter.addStatement("return " + variableName);
            classDef.addMemberFunction(getter);
            importedModelNames.add(variableName);
        }
        MemberFunction getImportedFunction = new MemberFunction("getImportedModels", String.valueOf(AbstractRuntimeModel.class.getSimpleName()) + "[]");
        getImportedFunction.setOverrides(true);
        getImportedFunction.addModifier("public");
        String initializer = new String();
        Iterator it = importedModelNames.iterator();
        while (it.hasNext()) {
            initializer = String.valueOf(initializer) + (String)it.next();
            if (!it.hasNext()) continue;
            initializer = String.valueOf(initializer) + ", ";
        }
        getImportedFunction.addStatement(String.valueOf(AbstractRuntimeModel.class.getSimpleName()) + "[] subs = { " + initializer + " }");
        getImportedFunction.addStatement("return subs");
        classDef.addMemberFunction(getImportedFunction);
        ArrayList<String> names = new ArrayList<String>();
        for (Block block : model.getSubBlock()) {
            String variableName = this.nameProvider.getVariableName((NamedElement)block);
            String blockTypeName = this.nameProvider.getClassName((NamedElement)block);
            String blockPackageName = this.nameProvider.getPackageName((NamedElement)block);
            MemberVariable blockVariable = new MemberVariable(variableName, blockTypeName);
            blockVariable.addModifier("private");
            blockVariable.setInitializer("null");
            classDef.addMemberVariable(blockVariable);
            classDef.addImportedPackage(String.valueOf(blockPackageName) + "." + blockTypeName);
            names.add(variableName);
            String getterName = this.nameProvider.getVariableGetterName((NamedElement)block);
            MemberFunction getter = new MemberFunction(getterName, blockTypeName);
            getter.addModifier("public");
            IfStatement ifNotExists = new IfStatement(String.valueOf(variableName) + " == null");
            ifNotExists.addThenStatement(String.valueOf(variableName) + " = new " + blockTypeName + "(this, \"" + block.getName() + "\")");
            getter.addStatement(ifNotExists);
            getter.addStatement("return " + variableName);
            classDef.addMemberFunction(getter);
            initFunction.addStatement(ifNotExists);
        }
        MemberFunction subBlocksFunction = new MemberFunction("getSubBlocks", String.valueOf(AbstractRuntimeBlock.class.getSimpleName()) + "[]");
        subBlocksFunction.addModifier("public");
        subBlocksFunction.setOverrides(true);
        String initializer2 = new String();
        Iterator it2 = names.iterator();
        while (it2.hasNext()) {
            initializer2 = String.valueOf(initializer2) + (String)it2.next();
            if (!it2.hasNext()) continue;
            initializer2 = String.valueOf(initializer2) + ", ";
        }
        subBlocksFunction.addStatement(String.valueOf(AbstractRuntimeBlock.class.getSimpleName()) + "[] subs = { " + initializer2 + " }");
        subBlocksFunction.addStatement("return subs");
        classDef.addMemberFunction(subBlocksFunction);
        String entryBlockVariable = this.nameProvider.getVariableName((NamedElement)model.getSuperBlock());
        MemberFunction entryBlockFunction = new MemberFunction("getEntryBlock", AbstractRuntimeBlock.class.getSimpleName());
        entryBlockFunction.addModifier("public");
        entryBlockFunction.setOverrides(true);
        entryBlockFunction.addStatement("return " + entryBlockVariable);
        classDef.addMemberFunction(entryBlockFunction);
        classDef.generate(this.pluginHelper);
        for (Block block : model.getSubBlock()) {
            this.generateBlockCode(block, project);
        }
        for (UnfoldModel imported : unfoldModel.getImportedModels()) {
            UnfoldModel saved = this.unfoldModel;
            this.unfoldModel = imported;
            this.generateModelCode(imported, project);
            this.unfoldModel = saved;
        }
    }

    private void generateMainClass(UnfoldModel unfoldModel, IProject project) throws CompilerException {
        ClockConstraintSystem model = unfoldModel.getModel();
        String packageName = this.nameProvider.getMainPackageName(model);
        String className = this.nameProvider.getMainClassName(model);
        String modelClassName = this.nameProvider.getClassName((NamedElement)model);
        String modelPackageName = this.nameProvider.getPackageName((NamedElement)model);
        ClassDefinition classDef = new ClassDefinition(className, packageName);
        classDef.setProject(project);
        classDef.addImportedPackage("java.util.Set");
        classDef.addImportedPackage(String.valueOf(modelPackageName) + "." + modelClassName);
        classDef.addImportedPackage(RuntimeClock.class.getName());
        classDef.addImportedPackage(CCSLSimulationEngine.class.getName());
        classDef.addImportedPackage(CCSLStepExecutionEngine.class.getName());
        classDef.addImportedPackage(SimulationException.class.getName());
        MemberFunction mainFunction = new MemberFunction("main", "void");
        mainFunction.addModifier("public");
        mainFunction.addModifier("static");
        mainFunction.addParameter("String[]", "args");
        mainFunction.addException(SimulationException.class.getSimpleName());
        if (this.parameters.modelsAreSingleton) {
            mainFunction.addStatement(String.valueOf(modelClassName) + " model = " + modelClassName + ".getInstance()");
        } else {
            mainFunction.addStatement(String.valueOf(modelClassName) + " model = new " + modelClassName + "()");
        }
        mainFunction.addStatement("CCSLSimulationEngine engine = new CCSLSimulationEngine(model)");
        mainFunction.addStatement("engine.initSimulation()");
        mainFunction.addStatement("CCSLStepExecutionEngine stepEngine = new CCSLStepExecutionEngine(engine)");
        mainFunction.addStatement(new Comment("First simulation step."));
        mainFunction.addStatement("stepEngine.executeStep()");
        mainFunction.addStatement("Set<RuntimeClock> firedClocks = stepEngine.getFiredClocks()");
        mainFunction.addStatement("System.out.println(firedClocks)");
        mainFunction.addStatement(new Comment("Second simulation step. The CCSLStepExecutionEngine object can be reused."));
        mainFunction.addStatement("stepEngine.executeStep()");
        mainFunction.addStatement(new Comment("Third simulation step."));
        mainFunction.addStatement("stepEngine.executeStep()");
        mainFunction.addStatement("engine.endSimulation()");
        classDef.addMemberFunction(mainFunction);
        try {
            classDef.generate(this.pluginHelper);
        }
        catch (CoreException e) {
            throw new CompilerException("Caught CoreException when generating tests for model " + project.getName() + ": ", e);
        }
    }

    private void generateTestClass(UnfoldModel unfoldModel, IProject project) throws CompilerException {
        ClockConstraintSystem model = unfoldModel.getModel();
        String packageName = this.nameProvider.getTestPackageName(model);
        String className = this.nameProvider.getTestClassName(model);
        String modelClassName = this.nameProvider.getClassName((NamedElement)model);
        String modelPackageName = this.nameProvider.getPackageName((NamedElement)model);
        ClassDefinition classDef = new ClassDefinition(className, packageName);
        classDef.setProject(project);
        classDef.addImportedPackage("java.util.Set");
        classDef.addImportedPackage("org.junit.Test");
        classDef.addImportedPackage("static org.junit.Assert.*");
        classDef.addImportedPackage(String.valueOf(modelPackageName) + "." + modelClassName);
        classDef.addImportedPackage(RuntimeClock.class.getName());
        classDef.addImportedPackage(CCSLSimulationEngine.class.getName());
        classDef.addImportedPackage(CCSLStepExecutionEngine.class.getName());
        classDef.addImportedPackage(SimulationException.class.getName());
        MemberFunction testFunction = new MemberFunction("test", "void");
        testFunction.addModifier("public");
        testFunction.addAnnotation(Test.class.getSimpleName());
        testFunction.addException(SimulationException.class.getSimpleName());
        if (this.parameters.modelsAreSingleton) {
            testFunction.addStatement(String.valueOf(modelClassName) + " model = " + modelClassName + ".getInstance()");
        } else {
            testFunction.addStatement(String.valueOf(modelClassName) + " model = new " + modelClassName + "()");
        }
        testFunction.addStatement("assertNotNull(model)");
        testFunction.addStatement("assertNotNull(model.getEntryBlock())");
        testFunction.addStatement("CCSLSimulationEngine engine = new CCSLSimulationEngine(model)");
        testFunction.addStatement("engine.initSimulation()");
        testFunction.addStatement("CCSLStepExecutionEngine stepEngine = new CCSLStepExecutionEngine(engine)");
        testFunction.addStatement(new Comment("First simulation step."));
        testFunction.addStatement("stepEngine.executeStep()");
        testFunction.addStatement("Set<RuntimeClock> firedClocks = stepEngine.getFiredClocks()");
        testFunction.addStatement(new Comment("Second simulation step. The CCSLStepExecutionEngine object can be reused."));
        testFunction.addStatement("stepEngine.executeStep()");
        testFunction.addStatement(new Comment("Third simulation step."));
        testFunction.addStatement("stepEngine.executeStep()");
        testFunction.addStatement("engine.endSimulation()");
        classDef.addMemberFunction(testFunction);
        try {
            classDef.generate(this.pluginHelper);
        }
        catch (CoreException e) {
            throw new CompilerException("Caught CoreException when generating tests for model " + project.getName() + ": ", e);
        }
    }

    private EqualitySolver<String> blockClockEqualityAnalysis(Block block) {
        boolean foundCoincidence = false;
        EqualitySolver equalityRegister = new EqualitySolver();
        for (Relation relation : block.getRelations()) {
            if (relation.getIsAnAssertion().booleanValue() || !(relation.getType() instanceof Coincidence)) continue;
            foundCoincidence = true;
            AbstractEntity left = ((Coincidence)relation.getType()).getLeftEntity();
            AbstractEntity right = ((Coincidence)relation.getType()).getRightEntity();
            BindableEntity leftValue = this.resolveAbstract(left, (List<Binding>)relation.getBindings());
            BindableEntity rightValue = this.resolveAbstract(right, (List<Binding>)relation.getBindings());
            String leftName = null;
            if (leftValue.eContainer() != block) {
                leftName = this.generateAccessCode((NamedElement)block, (NamedElement)relation, (NamedElement)leftValue, null);
            } else if (leftValue instanceof Clock) {
                leftName = this.nameProvider.getVariableName((NamedElement)leftValue);
            } else if (leftValue instanceof Expression) {
                leftName = this.nameProvider.getClockName((Expression)leftValue);
            }
            String rightName = null;
            if (rightValue instanceof Clock) {
                rightName = this.nameProvider.getVariableName((NamedElement)rightValue);
            } else if (rightValue instanceof Expression) {
                rightName = this.nameProvider.getClockName((Expression)rightValue);
            }
            if (leftName == null || rightName == null) continue;
            equalityRegister.registerEquality((Object)leftName, (Object)rightName);
        }
        if (!foundCoincidence) {
            return null;
        }
        return equalityRegister;
    }

    private void generateBlockCode(Block block, IProject project) throws CoreException, CompilerException {
        String packageName = this.nameProvider.getPackageName((NamedElement)block);
        String className = this.nameProvider.getClassName((NamedElement)block);
        ClassDefinition classDef = new ClassDefinition(className, packageName);
        classDef.setParentClassName(AbstractRuntimeBlock.class.getSimpleName());
        classDef.addImportedPackage(AbstractRuntimeBlock.class.getName());
        classDef.addImportedPackage(IRuntimeContainer.class.getName());
        classDef.setProject(project);
        MemberFunction constructor = new MemberFunction(className);
        constructor.setConstructor(true);
        constructor.addModifier("public");
        constructor.addParameter(IRuntimeContainer.class.getSimpleName(), "parent");
        constructor.addParameter("String", "name");
        constructor.addStatement("super(parent, name)");
        constructor.addStatement("init()");
        classDef.addMemberFunction(constructor);
        MemberFunction initFunction = new MemberFunction("init", "void");
        initFunction.addModifier("protected");
        classDef.addMemberFunction(initFunction);
        ArrayList<String> elementNames = new ArrayList<String>();
        EqualitySolver<String> equalityRegister = this.blockClockEqualityAnalysis(block);
        for (Element element : block.getElements()) {
            String name;
            if (element instanceof Clock) {
                name = this.generateClockCode((Clock)element, "private", classDef, initFunction, elementNames, equalityRegister);
                if (elementNames.contains(name)) {
                    throw new CompilerException("Duplicate clock name \"" + element.getName() + "\" in block " + block.getName());
                }
                elementNames.add(name);
                continue;
            }
            name = this.generateElementCode((NamedElement)element, "public", classDef, true);
            if (elementNames.contains(name)) {
                throw new CompilerException("Duplicate element name \"" + element.getName() + "\" in block " + block.getName());
            }
            elementNames.add(name);
        }
        ArrayList<Object> constraintNames = new ArrayList<Object>();
        ArrayList<Object> relationNames = new ArrayList<Object>();
        ArrayList<String> expressionNames = new ArrayList<String>();
        ArrayList<ConcreteEntity> expressionsAndRelations = new ArrayList<ConcreteEntity>((Collection<ConcreteEntity>)block.getExpressions());
        expressionsAndRelations.addAll((Collection<ConcreteEntity>)block.getRelations());
        List<ConcreteEntity> buildOrder = this.getBuildOrder(expressionsAndRelations);
        for (ConcreteEntity entity : buildOrder) {
            if (entity instanceof Expression) {
                String clockVariableName = this.nameProvider.getClockName((Expression)entity);
                String clockName = entity.getName();
                this.generateDiscreteClockCode(clockVariableName, clockName, this.nameProvider.implicitClockClassName, this.nameProvider.implicitClockPackage, "public", classDef, initFunction, elementNames, equalityRegister, null);
                elementNames.add(clockVariableName);
                String varName = this.generateExpressionCode((NamedElement)block, (Expression)entity, false, project, classDef);
                if (constraintNames.contains(varName) || expressionNames.contains(varName)) {
                    throw new CompilerException("Duplicate expression name \"" + entity.getName() + "\" in block " + block.getName());
                }
                constraintNames.add(varName);
                expressionNames.add(varName);
                continue;
            }
            if (!(entity instanceof Relation)) continue;
            String varName = this.generateRelationCode((NamedElement)block, (Relation)entity, classDef, project);
            if (constraintNames.contains(varName) || expressionNames.contains(varName)) {
                throw new CompilerException("Duplicate relation name \"" + entity.getName() + "\" in block " + block.getName());
            }
            constraintNames.add(varName);
            relationNames.add(varName);
        }
        ArrayList<String> subBlockNames = new ArrayList<String>();
        for (Block subBlock : block.getSubBlock()) {
            this.generateBlockCode(subBlock, project);
            String subVariableName = this.nameProvider.getVariableName((NamedElement)subBlock);
            String subclassName = this.nameProvider.getClassName((NamedElement)subBlock);
            MemberVariable variable = new MemberVariable(subVariableName, subclassName);
            variable.addModifier("public");
            classDef.addMemberVariable(variable);
            initFunction.addStatement(String.valueOf(subVariableName) + " = new " + subclassName + "(this, \"" + subBlock.getName() + "\")");
            subBlockNames.add(subVariableName);
            classDef.addImportedPackage(String.valueOf(this.nameProvider.getPackageName((NamedElement)subBlock)) + "." + subclassName);
        }
        String tempSymbol = this.nameProvider.genSym();
        MemberFunction getConstraintsFunction = new MemberFunction("getConstraints", String.valueOf(ICCSLConstraint.class.getSimpleName()) + "[]");
        getConstraintsFunction.setOverrides(true);
        getConstraintsFunction.addModifier("protected");
        String initializer = new String();
        Iterator iter = constraintNames.iterator();
        while (iter.hasNext()) {
            initializer = String.valueOf(initializer) + (String)iter.next();
            if (!iter.hasNext()) continue;
            initializer = String.valueOf(initializer) + ", ";
        }
        getConstraintsFunction.addStatement(String.valueOf(ICCSLConstraint.class.getSimpleName()) + "[] " + tempSymbol + " = { " + initializer + " }");
        getConstraintsFunction.addStatement("return " + tempSymbol);
        classDef.addMemberFunction(getConstraintsFunction);
        classDef.addImportedPackage(ICCSLConstraint.class.getName());
        MemberFunction subblocksFunction = new MemberFunction("getSubBlocks", String.valueOf(AbstractRuntimeBlock.class.getSimpleName()) + "[]");
        subblocksFunction.setOverrides(true);
        subblocksFunction.addModifier("public");
        initializer = new String();
        Iterator it = subBlockNames.iterator();
        while (it.hasNext()) {
            initializer = String.valueOf(initializer) + (String)it.next();
            if (!it.hasNext()) continue;
            initializer = String.valueOf(initializer) + ", ";
        }
        subblocksFunction.addStatement(String.valueOf(AbstractRuntimeBlock.class.getSimpleName()) + "[] " + tempSymbol + " = { " + initializer + " }");
        subblocksFunction.addStatement("return " + tempSymbol);
        classDef.addMemberFunction(subblocksFunction);
        classDef.generate(this.pluginHelper);
    }

    private String generateRelationCode(NamedElement context, Relation relation, ClassDefinition enclosingClass, IProject project) throws CoreException {
        Object parameters;
        RelationDefinition definition;
        String variableName = this.nameProvider.getVariableName((NamedElement)relation);
        String relationClassName = this.nameProvider.getClassName((NamedElement)relation);
        String relationPackageName = this.nameProvider.getPackageName((NamedElement)relation);
        RelationDeclaration declaration = relation.getType();
        if (!(declaration instanceof KernelRelationDeclaration) && (definition = this.unfoldModel.getUsedRelationDefinition(declaration)) != null) {
            this.usedRelationDefinitions.add(definition);
        }
        ArrayList<String> arguments = new ArrayList<String>();
        if (declaration instanceof KernelRelationDeclaration) {
            parameters = new ArrayList();
            KernelRelationDeclaration kdecl = (KernelRelationDeclaration)declaration;
            parameters.add(kdecl.getLeftEntity());
            parameters.add(kdecl.getRightEntity());
        } else {
            parameters = declaration.getParameters();
        }
        Iterator iterator = parameters.iterator();
        while (iterator.hasNext()) {
            AbstractEntity parameter = (AbstractEntity)iterator.next();
            if (context instanceof UserRelationDefinition || context instanceof UserExpressionDefinition) {
                BindableEntity value = this.resolveAbstract(parameter, (List<Binding>)relation.getBindings());
                if (value instanceof Expression) {
                    arguments.add(this.nameProvider.getClockName((Expression)value));
                    continue;
                }
                if (value instanceof ClassicalExpression) {
                    arguments.add(this.nameProvider.getProviderName((NamedElement)value));
                    continue;
                }
                arguments.add(this.nameProvider.getVariableName((NamedElement)value));
                continue;
            }
            BindableEntity modelObject = this.resolveAbstract(parameter, (List<Binding>)relation.getBindings());
            arguments.add(this.generateAccessCode(context, (NamedElement)relation, (NamedElement)modelObject, enclosingClass));
        }
        MemberVariable variable = new MemberVariable(variableName, relationClassName);
        variable.addModifier("public");
        enclosingClass.addMemberVariable(variable);
        MemberFunction initFunction = enclosingClass.getMemberFunction("init");
        String initializer = String.valueOf(variableName) + " = new " + relationClassName + "(";
        Iterator iter = arguments.iterator();
        while (iter.hasNext()) {
            initializer = String.valueOf(initializer) + (String)iter.next();
            if (!iter.hasNext()) continue;
            initializer = String.valueOf(initializer) + ", ";
        }
        initializer = String.valueOf(initializer) + ")";
        initFunction.addStatement(initializer);
        initFunction.addStatement(String.valueOf(variableName) + ".setParent(this)");
        initFunction.addStatement(String.valueOf(variableName) + ".setName(\"" + relation.getName() + "\")");
        enclosingClass.addImportedPackage(String.valueOf(relationPackageName) + "." + relationClassName);
        if (relation.getIsAnAssertion().booleanValue()) {
            initFunction.addStatement(String.valueOf(variableName) + ".setAssertion(true)");
        } else {
            initFunction.addStatement(String.valueOf(variableName) + ".setAssertion(false)");
        }
        return variableName;
    }

    private BindableEntity resolveAbstract(AbstractEntity parameter, List<Binding> bindings) {
        for (Binding binding : bindings) {
            if (parameter != binding.getAbstract()) continue;
            BindableEntity target = binding.getBindable();
            return target;
        }
        return null;
    }

    private EqualitySolver<String> definitionClockEqualityAnalysis(List<Relation> relations) {
        boolean foundCoincidence = false;
        EqualitySolver equalityRegister = new EqualitySolver();
        for (Relation relation : relations) {
            if (relation.getIsAnAssertion().booleanValue() || !(relation.getType() instanceof Coincidence)) continue;
            foundCoincidence = true;
            AbstractEntity left = ((Coincidence)relation.getType()).getLeftEntity();
            AbstractEntity right = ((Coincidence)relation.getType()).getRightEntity();
            BindableEntity leftValue = this.resolveAbstract(left, (List<Binding>)relation.getBindings());
            BindableEntity rightValue = this.resolveAbstract(right, (List<Binding>)relation.getBindings());
            String leftName = null;
            if (leftValue instanceof Clock) {
                leftName = this.nameProvider.getVariableName((NamedElement)leftValue);
            } else if (leftValue instanceof Expression) {
                leftName = this.nameProvider.getClockName((Expression)leftValue);
            }
            String rightName = null;
            if (rightValue instanceof Clock) {
                rightName = this.nameProvider.getVariableName((NamedElement)rightValue);
            } else if (rightValue instanceof Expression) {
                rightName = this.nameProvider.getClockName((Expression)rightValue);
            }
            if (leftName == null || rightName == null) continue;
            equalityRegister.registerEquality((Object)leftName, (Object)rightName);
        }
        if (!foundCoincidence) {
            return null;
        }
        return equalityRegister;
    }

    private void compileUserRelationDefinition(UserRelationDefinition definition, IProject project) throws CoreException {
        String definitionClassName = this.nameProvider.getClassName((NamedElement)definition);
        String definitionClassPackage = this.nameProvider.getPackageName((NamedElement)definition);
        ClassDefinition classDef = new ClassDefinition(definitionClassName, definitionClassPackage);
        classDef.setParentClassName(AbstractRuntimeRelation.class.getSimpleName());
        classDef.addImportedPackage(AbstractRuntimeRelation.class.getName());
        classDef.setProject(project);
        ArrayList<Relation> allRelations = new ArrayList<Relation>();
        for (ConcreteEntity entity : definition.getConcreteEntities()) {
            if (!(entity instanceof Relation)) continue;
            allRelations.add((Relation)entity);
        }
        EqualitySolver<String> equalityRegister = this.definitionClockEqualityAnalysis(allRelations);
        allRelations.clear();
        ArrayList<String> elementNames = new ArrayList<String>();
        ArrayList<String> constraintNames = new ArrayList<String>();
        ArrayList<String> relationNames = new ArrayList<String>();
        ArrayList<String> expressionNames = new ArrayList<String>();
        ArrayList<String> clockNames = new ArrayList<String>();
        List<AbstractEntity> nonClockParameters = this.getNonClockParameters(definition);
        MemberFunction initFunction = new MemberFunction("init", "void");
        initFunction.addModifier("protected");
        classDef.addMemberFunction(initFunction);
        this.generateArgumentsPrivateMembers((RelationDefinition)definition, classDef, nonClockParameters);
        this.generateRelationDefinitionConstructor((RelationDefinition)definition, definitionClassName, classDef, nonClockParameters);
        for (ClassicalExpression expression : definition.getClassicalExpressions()) {
            this.generateClassicalExpression(expression, (NamedElement)definition, classDef);
        }
        for (ConcreteEntity entity : definition.getConcreteEntities()) {
            if (entity instanceof Relation) {
                String relationVarName = this.generateRelationCode((NamedElement)definition, (Relation)entity, classDef, project);
                constraintNames.add(relationVarName);
                relationNames.add(relationVarName);
                continue;
            }
            if (entity instanceof Expression) {
                String clockVariableName = this.nameProvider.getClockName((Expression)entity);
                String clockName = entity.getName();
                clockNames.add(clockVariableName);
                this.generateDiscreteClockCode(clockVariableName, clockName, this.nameProvider.implicitClockClassName, this.nameProvider.implicitClockPackage, "public", classDef, initFunction, clockNames, equalityRegister, null);
                elementNames.add(clockVariableName);
                String expressionVarName = this.generateExpressionCode((NamedElement)definition, (Expression)entity, false, project, classDef);
                constraintNames.add(expressionVarName);
                expressionNames.add(expressionVarName);
                continue;
            }
            if (entity instanceof Clock) {
                String clockName = entity.getName();
                String variableName = this.nameProvider.getVariableName((NamedElement)entity);
                Iterator clockClassName = this.nameProvider.clockClassName;
                String clockPackageName = this.nameProvider.clockClassPackage;
                this.generateDiscreteClockCode(variableName, clockName, (String)((Object)clockClassName), clockPackageName, "private", classDef, initFunction, clockNames, equalityRegister, null);
                this.generateDiscreteClockGetter(this.nameProvider.getVariableGetterName((NamedElement)entity), variableName, clockName, (String)((Object)clockClassName), clockPackageName, "public", classDef, initFunction);
                clockNames.add(variableName);
                continue;
            }
            if (!(entity instanceof Element)) continue;
            String elementVarName = this.generateElementCode((NamedElement)entity, "private", classDef, true);
            elementNames.add(elementVarName);
        }
        MemberFunction getConstraintsFunction = new MemberFunction("getConstraints", String.valueOf(ICCSLConstraint.class.getSimpleName()) + "[]");
        getConstraintsFunction.setOverrides(true);
        getConstraintsFunction.addModifier("protected");
        String initializer = new String();
        Iterator iter = constraintNames.iterator();
        while (iter.hasNext()) {
            initializer = String.valueOf(initializer) + (String)iter.next();
            if (!iter.hasNext()) continue;
            initializer = String.valueOf(initializer) + ", ";
        }
        getConstraintsFunction.addStatement(String.valueOf(ICCSLConstraint.class.getSimpleName()) + "[] res = { " + initializer + " }");
        getConstraintsFunction.addStatement("return res");
        classDef.addMemberFunction(getConstraintsFunction);
        MemberFunction setAssertionFunction = new MemberFunction("setAssertion");
        setAssertionFunction.setOverrides(true);
        setAssertionFunction.addModifier("public");
        setAssertionFunction.addParameter("boolean", "assertion");
        setAssertionFunction.addStatement("super.setAssertion(assertion)");
        for (String subRelationName : relationNames) {
            setAssertionFunction.addStatement(String.valueOf(subRelationName) + ".setAssertion(assertion)");
        }
        classDef.addMemberFunction(setAssertionFunction);
        MemberFunction startFunction = new MemberFunction("start");
        startFunction.setOverrides(true);
        startFunction.addModifier("public");
        startFunction.addException("SimulationException");
        startFunction.addParameter("AbstractSemanticHelper", "helper");
        IfStatement st = new IfStatement("! canCallStart()");
        st.addThenStatement(new SimpleStatement("return"));
        startFunction.addStatement(st);
        startFunction.addStatement("super.start(helper)");
        for (AbstractEntity parameter : nonClockParameters) {
            Iterator providerTest = new IfStatement();
            ((IfStatement)((Object)providerTest)).setTestCode(String.valueOf(this.nameProvider.getProviderName((NamedElement)parameter)) + " != null");
            ((IfStatement)((Object)providerTest)).addThenStatement(String.valueOf(this.nameProvider.getVariableName((NamedElement)parameter)) + " = " + this.nameProvider.getProviderName((NamedElement)parameter) + ".getValue()");
            startFunction.addStatement((AbstractStatement)((Object)providerTest));
        }
        for (String relationName : relationNames) {
            startFunction.addStatement(String.valueOf(relationName) + ".start(helper)");
        }
        for (String expressionName : expressionNames) {
            startFunction.addStatement(String.valueOf(expressionName) + ".start(helper)");
        }
        classDef.addMemberFunction(startFunction);
        classDef.addImportedPackage(SimulationException.class.getName());
        MemberFunction semanticFunction = new MemberFunction("semantic");
        semanticFunction.setOverrides(true);
        semanticFunction.addModifier("public");
        semanticFunction.addException("SimulationException");
        semanticFunction.addParameter("AbstractSemanticHelper", "helper");
        IfStatement st2 = new IfStatement("! canCallSemantic()");
        st2.addThenStatement(new SimpleStatement("return"));
        semanticFunction.addStatement(st2);
        semanticFunction.addStatement("super.semantic(helper)");
        for (String relationName : relationNames) {
            semanticFunction.addStatement(String.valueOf(relationName) + ".semantic(helper)");
        }
        for (String expressionName : expressionNames) {
            semanticFunction.addStatement(String.valueOf(expressionName) + ".semantic(helper)");
        }
        classDef.addMemberFunction(semanticFunction);
        MemberFunction assertionSemFunction = new MemberFunction("assertionSemantic");
        assertionSemFunction.setOverrides(true);
        assertionSemFunction.addModifier("public");
        assertionSemFunction.addParameter("AbstractSemanticHelper", "helper");
        for (String subRelationName : relationNames) {
            assertionSemFunction.addStatement(String.valueOf(subRelationName) + ".assertionSemantic(helper)");
        }
        assertionSemFunction.addStatement("BuDDyBDD andTerm = helper.createOne()");
        for (String subRelationName : relationNames) {
            String bddVar = this.nameProvider.genSym("bddVar");
            assertionSemFunction.addStatement("BuDDyBDD " + bddVar + " = helper.getAssertionVariable(" + subRelationName + ")");
            assertionSemFunction.addStatement("andTerm = helper.createAnd(andTerm, " + bddVar + ")");
        }
        assertionSemFunction.addStatement("helper.assertionSemantic(this, andTerm)");
        classDef.addMemberFunction(assertionSemFunction);
        MemberFunction updateFunction = new MemberFunction("update");
        updateFunction.setOverrides(true);
        updateFunction.addModifier("public");
        updateFunction.addParameter("AbstractUpdateHelper", "helper");
        updateFunction.addException("SimulationException");
        IfStatement st3 = new IfStatement("! canCallUpdate()");
        st3.addThenStatement(new SimpleStatement("return"));
        updateFunction.addStatement(st3);
        updateFunction.addStatement("super.update(helper)");
        for (String relationName : relationNames) {
            updateFunction.addStatement(String.valueOf(relationName) + ".update(helper)");
        }
        for (String expressionName : expressionNames) {
            updateFunction.addStatement(String.valueOf(expressionName) + ".update(helper)");
        }
        classDef.addMemberFunction(updateFunction);
        classDef.addImportedPackage(ICCSLConstraint.class.getName());
        classDef.addImportedPackage(AbstractSemanticHelper.class.getName());
        classDef.addImportedPackage(AbstractUpdateHelper.class.getName());
        classDef.generate(this.pluginHelper);
    }

    private void compileConditionalRelationDefinition(ConditionalRelationDefinition definition, IProject project) throws CoreException, CompilerException {
        String definitionClassName = this.nameProvider.getClassName((NamedElement)definition);
        String definitionClassPackage = this.nameProvider.getPackageName((NamedElement)definition);
        ClassDefinition classDef = new ClassDefinition(definitionClassName, definitionClassPackage);
        classDef.setParentClassName(AbstractRuntimeRelation.class.getSimpleName());
        classDef.addImportedPackage(AbstractRuntimeRelation.class.getName());
        classDef.setProject(project);
        MemberFunction initFunction = new MemberFunction("init", "void");
        initFunction.addModifier("protected");
        classDef.addMemberFunction(initFunction);
        classDef.addImportedPackage(ICCSLConstraint.class.getName());
        classDef.addImportedPackage(AbstractSemanticHelper.class.getName());
        classDef.addImportedPackage(AbstractUpdateHelper.class.getName());
        List<AbstractEntity> nonClockParameters = this.getNonClockParameters((UserRelationDefinition)definition);
        this.generateArgumentsPrivateMembers((RelationDefinition)definition, classDef, nonClockParameters);
        this.generateRelationDefinitionConstructor((RelationDefinition)definition, definitionClassName, classDef, nonClockParameters);
        classDef.addImportedPackage(String.valueOf(this.nameProvider.clockClassPackage) + "." + this.nameProvider.clockClassName);
        HashMap<ClassicalExpression, String> classicalExprNames = new HashMap<ClassicalExpression, String>();
        HashMap<ClassicalExpression, Object> classicalExprProviderNames = new HashMap<ClassicalExpression, Object>();
        HashMap<Relation, String> relationNames = new HashMap<Relation, String>();
        HashMap<Expression, String> expressionNames = new HashMap<Expression, String>();
        ArrayList<String> constraintNames = new ArrayList<String>();
        for (ClassicalExpression expression : definition.getClassicalExpressions()) {
            ClassicalExpressionCompiler generator = new ClassicalExpressionCompiler(this.parameters, this.pluginHelper, this.nameProvider);
            String fctName = generator.generateClassicalExpression(expression, (NamedElement)definition, classDef);
            classicalExprNames.put(expression, fctName);
            String providerTypeName = String.valueOf(ValueProvider.class.getSimpleName()) + "<" + generator.getReturnTypeName() + ">";
            String providerName = this.nameProvider.getProviderName((NamedElement)expression);
            MemberVariable providerVariable = new MemberVariable(providerName, providerTypeName);
            providerVariable.addModifier("private");
            String initializer = " new " + providerTypeName + "() {\n";
            initializer = String.valueOf(initializer) + "      public " + generator.getReturnTypeName() + " getValue() {\n";
            initializer = String.valueOf(initializer) + "        return " + fctName + "();\n";
            initializer = String.valueOf(initializer) + "      }\n    }";
            providerVariable.setInitializer(initializer);
            classDef.addMemberVariable(providerVariable);
            classDef.addImportedPackage(ValueProvider.class.getName());
            classicalExprProviderNames.put(expression, providerName);
        }
        for (ConcreteEntity entity : definition.getConcreteEntities()) {
            String clockVariableName;
            if (entity instanceof Relation) {
                String relationVarName = this.generateRelationCode((NamedElement)definition, (Relation)entity, classDef, project);
                constraintNames.add(relationVarName);
                relationNames.put((Relation)entity, relationVarName);
                continue;
            }
            if (entity instanceof Expression) {
                clockVariableName = this.nameProvider.getClockName((Expression)entity);
                String clockName = entity.getName();
                this.generateDiscreteClockCode(clockVariableName, clockName, this.nameProvider.implicitClockClassName, this.nameProvider.implicitClockPackage, "public", classDef, initFunction, null, null, null);
                String expressionVarName = this.generateExpressionCode((NamedElement)definition, (Expression)entity, false, project, classDef);
                constraintNames.add(expressionVarName);
                expressionNames.put((Expression)entity, expressionVarName);
                continue;
            }
            if (!(entity instanceof Element)) continue;
            clockVariableName = this.generateElementCode((NamedElement)entity, "private", classDef, true);
        }
        HashMap<RelCase, String> switchTestNames = new HashMap<RelCase, String>();
        HashMap<RelCase, Integer> switchTestIndices = new HashMap<RelCase, Integer>();
        int switchTestCounter = 0;
        MemberVariable selectionVar = new MemberVariable("selectedCase", "int");
        selectionVar.addModifier("private");
        selectionVar.setInitializer("-1");
        classDef.addMemberVariable(selectionVar);
        for (RelCase swCase : definition.getRelCases()) {
            BooleanExpression test = swCase.getCondition();
            String testFunctionName = this.generateClassicalExpression((ClassicalExpression)test, (NamedElement)definition, classDef);
            switchTestNames.put(swCase, testFunctionName);
            EList relations = swCase.getRelation();
            for (Relation relation : relations) {
                String relationVarName = this.generateRelationCode((NamedElement)definition, relation, classDef, project);
                if (relationNames.get(relationVarName) != null) {
                    throw new CompilerException("Duplicate relation name \"" + relation.getName() + "\" in conditional relation definition " + definition.getName());
                }
                relationNames.put(relation, relationVarName);
                constraintNames.add(relationVarName);
            }
            switchTestIndices.put(swCase, ++switchTestCounter);
        }
        if (definition.getDefaultRelation() != null) {
            EList defaultRelations = definition.getDefaultRelation();
            for (Relation relation : defaultRelations) {
                String relationVarName = this.generateRelationCode((NamedElement)definition, relation, classDef, project);
                if (relationNames.get(relationVarName) != null) {
                    throw new CompilerException("Duplicate relation name \"" + relation.getName() + "\" in conditional relation definition " + definition.getName());
                }
                relationNames.put(relation, relationVarName);
                constraintNames.add(relationVarName);
            }
        }
        MemberFunction getConstraintsFunction = new MemberFunction("getConstraints", String.valueOf(ICCSLConstraint.class.getSimpleName()) + "[]");
        getConstraintsFunction.setOverrides(true);
        getConstraintsFunction.addModifier("protected");
        String initializer = new String();
        Iterator iter = constraintNames.iterator();
        while (iter.hasNext()) {
            initializer = String.valueOf(initializer) + (String)iter.next();
            if (!iter.hasNext()) continue;
            initializer = String.valueOf(initializer) + ", ";
        }
        getConstraintsFunction.addStatement(String.valueOf(ICCSLConstraint.class.getSimpleName()) + "[] res = { " + initializer + " }");
        getConstraintsFunction.addStatement("return res");
        classDef.addMemberFunction(getConstraintsFunction);
        this.generateConditionalRelationStartFunction(definition, classDef, switchTestNames, switchTestIndices, relationNames, expressionNames, nonClockParameters);
        this.generateConditionalRelationSemanticFunction(definition, classDef, switchTestNames, switchTestIndices, relationNames, expressionNames, nonClockParameters);
        MemberFunction setAssertionFunction = new MemberFunction("setAssertion");
        setAssertionFunction.setOverrides(true);
        setAssertionFunction.addModifier("public");
        setAssertionFunction.addParameter("boolean", "assertion");
        setAssertionFunction.addStatement("super.setAssertion(assertion)");
        for (String subRelationName : relationNames.values()) {
            setAssertionFunction.addStatement(String.valueOf(subRelationName) + ".setAssertion(assertion)");
        }
        classDef.addMemberFunction(setAssertionFunction);
        this.generateConditionalRelationAssertionSemanticFunction(definition, classDef, switchTestNames, relationNames, expressionNames, nonClockParameters);
        this.generateConditionalRelationUpdateFunction(definition, classDef, switchTestNames, relationNames, expressionNames, nonClockParameters);
        this.generateConditionalRelationDeathSemanticFunction(definition, classDef, switchTestNames, relationNames, expressionNames, nonClockParameters);
        classDef.generate(this.pluginHelper);
    }

    private void generateRelationDefinitionConstructor(RelationDefinition definition, String definitionClassName, ClassDefinition classDefinition, List<AbstractEntity> nonClockParameters) {
        String paramClassName;
        Class<?> parameterClass;
        Type parameterType;
        EList parameters = definition.getDeclaration().getParameters();
        MemberFunction constructor = new MemberFunction(definitionClassName);
        constructor.setConstructor(true);
        constructor.addModifier("public");
        for (Object parameter : parameters) {
            parameterType = parameter.getType();
            parameterClass = this.nameProvider.getJavaClass((NamedElement)parameterType);
            paramClassName = this.nameProvider.getClassName((NamedElement)parameter);
            constructor.addParameter(paramClassName, this.nameProvider.getVariableName((NamedElement)parameter));
            classDefinition.addImportedPackage(parameterClass.getName());
        }
        constructor.addStatement("super()");
        for (AbstractEntity parameter : parameters) {
            constructor.addStatement("this." + this.nameProvider.getVariableName((NamedElement)parameter) + " = " + this.nameProvider.getVariableName((NamedElement)parameter));
        }
        constructor.addStatement("init()");
        classDefinition.addMemberFunction(constructor);
        if (!nonClockParameters.isEmpty()) {
            constructor = new MemberFunction(definitionClassName);
            constructor.setConstructor(true);
            constructor.addModifier("public");
            for (Object parameter : parameters) {
                parameterType = parameter.getType();
                parameterClass = this.nameProvider.getJavaClass((NamedElement)parameterType);
                paramClassName = this.nameProvider.getClassName((NamedElement)parameter);
                if (nonClockParameters.contains(parameter)) {
                    constructor.addParameter(String.valueOf(ValueProvider.class.getSimpleName()) + "<" + paramClassName + ">", this.nameProvider.getVariableName((NamedElement)parameter));
                } else {
                    constructor.addParameter(paramClassName, this.nameProvider.getVariableName((NamedElement)parameter));
                }
                classDefinition.addImportedPackage(parameterClass.getName());
                classDefinition.addImportedPackage(ValueProvider.class.getName());
            }
            for (AbstractEntity parameter : parameters) {
                String var = nonClockParameters.contains(parameter) ? this.nameProvider.getProviderName((NamedElement)parameter) : this.nameProvider.getVariableName((NamedElement)parameter);
                constructor.addStatement("this." + var + " = " + this.nameProvider.getVariableName((NamedElement)parameter));
            }
            constructor.addStatement("init()");
            classDefinition.addMemberFunction(constructor);
        }
    }

    private void generateConditionalRelationStartFunction(ConditionalRelationDefinition definition, ClassDefinition classDefinition, HashMap<RelCase, String> switchTestNames, HashMap<RelCase, Integer> switchTestIndices, HashMap<Relation, String> relationNames, HashMap<Expression, String> expressionNames, List<AbstractEntity> nonClockParameters) {
        MemberFunction startFunction = new MemberFunction("start", "void");
        startFunction.setOverrides(true);
        startFunction.addModifier("public");
        startFunction.addException(SimulationException.class.getSimpleName());
        startFunction.addParameter(AbstractSemanticHelper.class.getSimpleName(), "helper");
        classDefinition.addMemberFunction(startFunction);
        classDefinition.addImportedPackage(SimulationException.class.getName());
        IfStatement st = new IfStatement("! canCallStart()");
        st.addThenStatement(new SimpleStatement("return"));
        startFunction.addStatement(st);
        startFunction.addStatement("super.start(helper)");
        for (AbstractEntity parameter : nonClockParameters) {
            IfStatement providerTest = new IfStatement();
            providerTest.setTestCode(String.valueOf(this.nameProvider.getProviderName((NamedElement)parameter)) + " != null");
            providerTest.addThenStatement(String.valueOf(this.nameProvider.getVariableName((NamedElement)parameter)) + " = " + this.nameProvider.getProviderName((NamedElement)parameter) + ".getValue()");
            startFunction.addStatement(providerTest);
        }
        IfStatement caseIfStatement = new IfStatement();
        startFunction.addStatement(caseIfStatement);
        Iterator iter = definition.getRelCases().iterator();
        while (iter.hasNext()) {
            RelCase swCase = (RelCase)iter.next();
            String testFunctionName = switchTestNames.get(swCase);
            caseIfStatement.setTestCode(String.valueOf(testFunctionName) + "()");
            caseIfStatement.addThenStatement("selectedCase = " + switchTestIndices.get(swCase));
            for (Relation relation : swCase.getRelation()) {
                String relationVarName = relationNames.get(relation);
                caseIfStatement.addThenStatement(String.valueOf(relationVarName) + ".start(helper)");
                List<Expression> subExpressions = this.getExpressionTree(relation, true, false);
                for (Expression expr : subExpressions) {
                    String exprName = expressionNames.get(expr);
                    caseIfStatement.addThenStatement(String.valueOf(exprName) + ".start(helper)");
                }
            }
            if (!iter.hasNext()) continue;
            IfStatement elseifStatement = new IfStatement();
            caseIfStatement.addElseStatement(elseifStatement);
            caseIfStatement = elseifStatement;
        }
        if (definition.getDefaultRelation() != null && !definition.getDefaultRelation().isEmpty()) {
            caseIfStatement.addElseStatement("selectedCase = 0");
            for (Relation relation : definition.getDefaultRelation()) {
                caseIfStatement.addElseStatement(String.valueOf(relationNames.get(relation)) + ".start(helper)");
                List<Expression> subExpressions = this.getExpressionTree(relation, true, false);
                for (Expression expr : subExpressions) {
                    String exprName = expressionNames.get(expr);
                    caseIfStatement.addThenStatement(String.valueOf(exprName) + ".start(helper)");
                }
            }
        }
    }

    private void generateConditionalRelationSemanticFunction(ConditionalRelationDefinition definition, ClassDefinition classDefinition, HashMap<RelCase, String> switchTestNames, HashMap<RelCase, Integer> switchTestIndices, HashMap<Relation, String> relationNames, HashMap<Expression, String> expressionNames, List<AbstractEntity> nonClockParameters) {
        MemberFunction semanticFunction = new MemberFunction("semantic", "void");
        semanticFunction.setOverrides(true);
        semanticFunction.addModifier("public");
        semanticFunction.addException(SimulationException.class.getSimpleName());
        semanticFunction.addParameter(AbstractSemanticHelper.class.getSimpleName(), "helper");
        classDefinition.addMemberFunction(semanticFunction);
        classDefinition.addImportedPackage(SimulationException.class.getName());
        IfStatement st = new IfStatement("! canCallSemantic()");
        st.addThenStatement(new SimpleStatement("return"));
        semanticFunction.addStatement(st);
        semanticFunction.addStatement("super.semantic(helper)");
        IfStatement caseIfStatement = new IfStatement();
        semanticFunction.addStatement(caseIfStatement);
        Iterator iter = definition.getRelCases().iterator();
        while (iter.hasNext()) {
            String exprName;
            List<Expression> subExpressions;
            Object relationVarName;
            RelCase swCase = (RelCase)iter.next();
            String testFunctionName = switchTestNames.get(swCase);
            caseIfStatement.setTestCode(String.valueOf(testFunctionName) + "()");
            IfStatement selectionChangedIf = new IfStatement("selectedCase != " + switchTestIndices.get(swCase));
            for (Relation relation : swCase.getRelation()) {
                relationVarName = relationNames.get(relation);
                selectionChangedIf.addThenStatement(String.valueOf(relationVarName) + ".start(helper)");
                subExpressions = this.getExpressionTree(relation, true, false);
                for (Expression expr : subExpressions) {
                    exprName = expressionNames.get(expr);
                    selectionChangedIf.addThenStatement(String.valueOf(exprName) + ".start(helper)");
                }
            }
            caseIfStatement.addThenStatement(selectionChangedIf);
            caseIfStatement.addThenStatement("selectedCase = " + switchTestIndices.get(swCase));
            for (Relation relation : swCase.getRelation()) {
                relationVarName = relationNames.get(relation);
                caseIfStatement.addThenStatement(String.valueOf(relationVarName) + ".semantic(helper)");
                subExpressions = this.getExpressionTree(relation, true, false);
                for (Expression expr : subExpressions) {
                    exprName = expressionNames.get(expr);
                    caseIfStatement.addThenStatement(String.valueOf(exprName) + ".semantic(helper)");
                }
            }
            if (!iter.hasNext()) continue;
            IfStatement elseifStatement = new IfStatement();
            caseIfStatement.addElseStatement(elseifStatement);
            caseIfStatement = elseifStatement;
        }
        if (definition.getDefaultRelation() != null && !definition.getDefaultRelation().isEmpty()) {
            IfStatement selectionChangedIf = new IfStatement("selectedCase != 0");
            for (Relation relation : definition.getDefaultRelation()) {
                String relationVarName = relationNames.get(relation);
                selectionChangedIf.addThenStatement(String.valueOf(relationVarName) + ".start(helper)");
                List<Expression> subExpressions = this.getExpressionTree(relation, true, false);
                for (Expression expr : subExpressions) {
                    String exprName = expressionNames.get(expr);
                    selectionChangedIf.addThenStatement(String.valueOf(exprName) + ".start(helper)");
                }
            }
            caseIfStatement.addElseStatement(selectionChangedIf);
            caseIfStatement.addElseStatement("selectedCase = 0");
            for (Relation relation : definition.getDefaultRelation()) {
                caseIfStatement.addElseStatement(String.valueOf(relationNames.get(relation)) + ".semantic(helper)");
                List<Expression> subExpressions = this.getExpressionTree(relation, true, false);
                for (Expression expr : subExpressions) {
                    String exprName = expressionNames.get(expr);
                    caseIfStatement.addThenStatement(String.valueOf(exprName) + ".semantic(helper)");
                }
            }
        }
    }

    private void generateConditionalRelationAssertionSemanticFunction(ConditionalRelationDefinition definition, ClassDefinition classDef, HashMap<RelCase, String> switchTestNames, HashMap<Relation, String> relationNames, HashMap<Expression, String> expressionNames, List<AbstractEntity> nonClockParameters) {
        MemberFunction assertSemanticFunction = new MemberFunction("assertionSemantic", "void");
        assertSemanticFunction.setOverrides(true);
        assertSemanticFunction.addModifier("public");
        assertSemanticFunction.addParameter(AbstractSemanticHelper.class.getSimpleName(), "helper");
        classDef.addMemberFunction(assertSemanticFunction);
        assertSemanticFunction.addStatement("BuDDyBDD andTerm = helper.createOne()");
        IfStatement caseIfStatement = new IfStatement();
        assertSemanticFunction.addStatement(caseIfStatement);
        Iterator iter = definition.getRelCases().iterator();
        while (iter.hasNext()) {
            RelCase swCase = (RelCase)iter.next();
            String testFunctionName = switchTestNames.get(swCase);
            caseIfStatement.setTestCode(String.valueOf(testFunctionName) + "()");
            for (Relation relation : swCase.getRelation()) {
                String relationVarName = relationNames.get(relation);
                caseIfStatement.addThenStatement(String.valueOf(relationVarName) + ".assertionSemantic(helper)");
                String bddVar = this.nameProvider.genSym("bddVar");
                caseIfStatement.addThenStatement("BuDDyBDD " + bddVar + " = helper.getAssertionVariable(" + relationVarName + ")");
                caseIfStatement.addThenStatement("andTerm = helper.createAnd(andTerm, " + bddVar + ")");
            }
            if (!iter.hasNext()) continue;
            IfStatement elseifStatement = new IfStatement();
            caseIfStatement.addElseStatement(elseifStatement);
            caseIfStatement = elseifStatement;
        }
        if (definition.getDefaultRelation() != null && !definition.getDefaultRelation().isEmpty()) {
            for (Relation relation : definition.getDefaultRelation()) {
                String relationVarName = relationNames.get(relation);
                caseIfStatement.addElseStatement(String.valueOf(relationVarName) + ".assertionSemantic(helper)");
                String bddVar = this.nameProvider.genSym("bddVar");
                caseIfStatement.addThenStatement("BuDDyBDD " + bddVar + " = helper.getAssertionVariable(" + relationVarName + ")");
                caseIfStatement.addThenStatement("andTerm = helper.createAnd(andTerm, " + bddVar + ")");
            }
        }
        assertSemanticFunction.addStatement("helper.assertionSemantic(this, andTerm)");
    }

    private void generateConditionalRelationUpdateFunction(ConditionalRelationDefinition definition, ClassDefinition classDefinition, HashMap<RelCase, String> switchTestNames, HashMap<Relation, String> relationNames, HashMap<Expression, String> expressionNames, List<AbstractEntity> nonClockParameters) {
        MemberFunction updateFunction = new MemberFunction("update", "void");
        updateFunction.setOverrides(true);
        updateFunction.addModifier("public");
        updateFunction.addException(SimulationException.class.getSimpleName());
        updateFunction.addParameter(AbstractUpdateHelper.class.getSimpleName(), "helper");
        classDefinition.addMemberFunction(updateFunction);
        classDefinition.addImportedPackage(SimulationException.class.getName());
        IfStatement st = new IfStatement("! canCallUpdate()");
        st.addThenStatement(new SimpleStatement("return"));
        updateFunction.addStatement(st);
        updateFunction.addStatement("super.update(helper)");
        IfStatement caseIfStatement = new IfStatement();
        updateFunction.addStatement(caseIfStatement);
        Iterator iter = definition.getRelCases().iterator();
        while (iter.hasNext()) {
            RelCase swCase = (RelCase)iter.next();
            String testFunctionName = switchTestNames.get(swCase);
            caseIfStatement.setTestCode(String.valueOf(testFunctionName) + "()");
            for (Relation relation : swCase.getRelation()) {
                String relationVarName = relationNames.get(relation);
                caseIfStatement.addThenStatement(String.valueOf(relationVarName) + ".update(helper)");
                List<Expression> subExpressions = this.getExpressionTree(relation, true, false);
                for (Expression expr : subExpressions) {
                    String exprName = expressionNames.get(expr);
                    caseIfStatement.addThenStatement(String.valueOf(exprName) + ".update(helper)");
                }
            }
            if (!iter.hasNext()) continue;
            IfStatement elseifStatement = new IfStatement();
            caseIfStatement.addElseStatement(elseifStatement);
            caseIfStatement = elseifStatement;
        }
        if (definition.getDefaultRelation() != null && !definition.getDefaultRelation().isEmpty()) {
            for (Relation relation : definition.getDefaultRelation()) {
                caseIfStatement.addElseStatement(String.valueOf(relationNames.get(relation)) + ".update(helper)");
                List<Expression> subExpressions = this.getExpressionTree(relation, true, false);
                for (Expression expr : subExpressions) {
                    String exprName = expressionNames.get(expr);
                    caseIfStatement.addThenStatement(String.valueOf(exprName) + ".update(helper)");
                }
            }
        }
    }

    private void generateConditionalRelationDeathSemanticFunction(ConditionalRelationDefinition definition, ClassDefinition classDefinition, HashMap<RelCase, String> switchTestNames, HashMap<Relation, String> relationNames, HashMap<Expression, String> expressionNames, List<AbstractEntity> nonClockParameters) {
        MemberFunction deathSemanticFunction = new MemberFunction("deathSemantic", "void");
        deathSemanticFunction.setOverrides(true);
        deathSemanticFunction.addModifier("public");
        deathSemanticFunction.addException(SimulationException.class.getSimpleName());
        deathSemanticFunction.addParameter(AbstractSemanticHelper.class.getSimpleName(), "helper");
        classDefinition.addMemberFunction(deathSemanticFunction);
        classDefinition.addImportedPackage(SimulationException.class.getName());
        deathSemanticFunction.addStatement("super.deathSemantic(helper)");
        IfStatement caseIfStatement = new IfStatement();
        deathSemanticFunction.addStatement(caseIfStatement);
        Iterator iter = definition.getRelCases().iterator();
        while (iter.hasNext()) {
            RelCase swCase = (RelCase)iter.next();
            String testFunctionName = switchTestNames.get(swCase);
            caseIfStatement.setTestCode(String.valueOf(testFunctionName) + "()");
            for (Relation relation : swCase.getRelation()) {
                String relationVarName = relationNames.get(relation);
                caseIfStatement.addThenStatement(String.valueOf(relationVarName) + ".deathSemantic(helper)");
                List<Expression> subExpressions = this.getExpressionTree(relation, true, false);
                for (Expression expr : subExpressions) {
                    String exprName = expressionNames.get(expr);
                    caseIfStatement.addThenStatement(String.valueOf(exprName) + ".deathSemantic(helper)");
                }
            }
            if (!iter.hasNext()) continue;
            IfStatement elseifStatement = new IfStatement();
            caseIfStatement.addElseStatement(elseifStatement);
            caseIfStatement = elseifStatement;
        }
        if (definition.getDefaultRelation() != null && !definition.getDefaultRelation().isEmpty()) {
            for (Relation relation : definition.getDefaultRelation()) {
                caseIfStatement.addElseStatement(String.valueOf(relationNames.get(relation)) + ".deathSemantic(helper)");
                List<Expression> subExpressions = this.getExpressionTree(relation, true, false);
                for (Expression expr : subExpressions) {
                    String exprName = expressionNames.get(expr);
                    caseIfStatement.addThenStatement(String.valueOf(exprName) + ".deathSemantic(helper)");
                }
            }
        }
    }

    private String generateClockCode(Clock clock, String modifiers, ClassDefinition enclosingClass, MemberFunction initFunction, List<String> otherGeneratedClocks, EqualitySolver<String> equalityRegister) {
        String variableName = this.nameProvider.getVariableName((NamedElement)clock);
        String clockClassName = this.nameProvider.getClassName((NamedElement)clock);
        String clockPackageName = this.nameProvider.getPackageName((NamedElement)clock);
        Type type = clock.getType();
        if (type != null && type instanceof DenseClockType) {
            MemberVariable variable = new MemberVariable(variableName, clockClassName);
            variable.addModifier(modifiers);
            variable.setInitializer("new " + clockClassName + "(\"" + clock.getName() + "\")");
            enclosingClass.addMemberVariable(variable);
            enclosingClass.addImportedPackage(String.valueOf(clockPackageName) + "." + clockClassName);
            return variableName;
        }
        this.generateDiscreteClockGetter(this.nameProvider.getVariableGetterName((NamedElement)clock), variableName, clock.getName(), clockClassName, clockPackageName, "public", enclosingClass, initFunction);
        if (clock.getTickingEvent() == null) {
            return this.generateDiscreteClockCode(variableName, clock.getName(), clockClassName, clockPackageName, modifiers, enclosingClass, initFunction, otherGeneratedClocks, equalityRegister, null);
        }
        return this.generateDiscreteClockCode(variableName, clock.getName(), clockClassName, clockPackageName, modifiers, enclosingClass, initFunction, otherGeneratedClocks, equalityRegister, (EList<EObject>)clock.getTickingEvent().getReferencedObjectRefs());
    }

    private String generateDiscreteClockCode(String variableName, String clockName, String clockClassName, String clockPackageName, String modifiers, ClassDefinition enclosingClass, MemberFunction initFunction, List<String> otherGeneratedClocks, EqualitySolver<String> equalityRegister, EList<EObject> referencedObjects) {
        MemberVariable variable = new MemberVariable(variableName, clockClassName);
        variable.addModifier(modifiers);
        variable.setInitializer("null");
        enclosingClass.addMemberVariable(variable);
        enclosingClass.addImportedPackage(String.valueOf(clockPackageName) + "." + clockClassName);
        IfStatement ifNotExists = new IfStatement(String.valueOf(variableName) + " == null");
        ifNotExists.addThenStatement(String.valueOf(variableName) + " = new " + clockClassName + "(\"" + clockName + "\")");
        initFunction.addStatement(ifNotExists);
        initFunction.addStatement(String.valueOf(variableName) + ".setDense(false)");
        initFunction.addStatement(String.valueOf(variableName) + ".setParent(this)");
        if (referencedObjects != null) {
            for (EObject eObject : referencedObjects) {
                if (eObject.eIsProxy()) continue;
                initFunction.addStatement(String.valueOf(variableName) + ".linkedElements.add(\"" + QualifiedNameBuilder.buildQualifiedName((EObject)eObject, (String)"::") + "\")");
            }
        }
        if (equalityRegister == null || equalityRegister.getEqualityClass((Object)variableName) == null) {
            initFunction.addStatement(String.valueOf(variableName) + ".bddVariableNumber = " + "BDDHelper.newBDDVariableNumber()");
        } else {
            Set equiClass = equalityRegister.getEqualityClass((Object)variableName);
            boolean foundEquivalentClock = false;
            for (String other : equiClass) {
                if (other.compareTo(variableName) == 0 || !otherGeneratedClocks.contains(other)) continue;
                initFunction.addStatement(String.valueOf(variableName) + ".bddVariableNumber = " + other + ".bddVariableNumber");
                foundEquivalentClock = true;
                break;
            }
            if (!foundEquivalentClock) {
                initFunction.addStatement(String.valueOf(variableName) + ".bddVariableNumber = " + "BDDHelper.newBDDVariableNumber()");
            }
        }
        enclosingClass.addImportedPackage(BDDHelper.class.getName());
        return variableName;
    }

    private String generateDiscreteClockGetter(String getterName, String variableName, String clockName, String clockClassName, String clockPackageName, String modifiers, ClassDefinition enclosingClass, MemberFunction initFunction) {
        IfStatement ifNotExists = new IfStatement(String.valueOf(variableName) + " == null");
        ifNotExists.addThenStatement(String.valueOf(variableName) + " = new " + clockClassName + "(\"" + clockName + "\")");
        MemberFunction getterFunction = new MemberFunction(getterName, clockClassName);
        getterFunction.addModifier("public");
        getterFunction.addStatement(ifNotExists);
        getterFunction.addStatement("return " + variableName);
        enclosingClass.addMemberFunction(getterFunction);
        return getterName;
    }

    private String generateElementCode(NamedElement element, String modifiers, ClassDefinition enclosingClass, boolean initialize) {
        MemberFunction initFunction;
        if (element.eClass().getEPackage() == BasicTypePackage.eINSTANCE) {
            return (String)new ElementCodeGenerator(enclosingClass, modifiers).doSwitch((EObject)element);
        }
        String variableName = this.nameProvider.getVariableName(element);
        String elementClassName = this.nameProvider.getClassName(element);
        String elementPackageName = this.nameProvider.getPackageName(element);
        MemberVariable variable = new MemberVariable(variableName, elementClassName);
        variable.addModifier(modifiers);
        variable.setInitializer("new " + elementClassName + "(\"" + element.getName() + "\")");
        enclosingClass.addMemberVariable(variable);
        enclosingClass.addImportedPackage(String.valueOf(elementPackageName) + "." + elementClassName);
        if (initialize && (initFunction = enclosingClass.getMemberFunction("init")) != null) {
            if (element instanceof Clock) {
                Type type = ((Clock)element).getType();
                if (type != null && type instanceof DenseClockType) {
                    initFunction.addStatement(String.valueOf(variableName) + ".setDense(true)");
                } else {
                    initFunction.addStatement(String.valueOf(variableName) + ".setDense(false)");
                }
            }
            initFunction.addStatement(String.valueOf(variableName) + ".setParent(this)");
        }
        return variableName;
    }

    private String getRepresentation(PrimitiveElement element) {
        if (element instanceof IntegerElement) {
            return ((IntegerElement)element).getValue().toString();
        }
        if (element instanceof BooleanElement) {
            return ((BooleanElement)element).getValue().toString();
        }
        if (element instanceof RealElement) {
            return ((RealElement)element).getValue().toString();
        }
        if (element instanceof StringElement) {
            return "\"" + ((StringElement)element).getValue() + "\"";
        }
        if (element instanceof IntegerVariableRef) {
            return this.nameProvider.getVariableName((NamedElement)((IntegerVariableRef)element).getReferencedVar());
        }
        if (element instanceof IntegerRef) {
            return ((IntegerRef)element).getIntegerElem().getValue().toString();
        }
        if (element instanceof BooleanVariableRef) {
            return this.nameProvider.getVariableName((NamedElement)((BooleanVariableRef)element).getReferencedVar());
        }
        if (element instanceof BooleanRef) {
            return ((BooleanRef)element).getReferencedBool().getValue().toString();
        }
        if (element instanceof NumberSeqVariableRef) {
            return this.nameProvider.getVariableName((NamedElement)((NumberSeqVariableRef)element).getReferencedVar());
        }
        return element.toString();
    }

    private String generateClassicalExpression(ClassicalExpression expression, NamedElement context, ClassDefinition enclosingClass) {
        ClassicalExpressionCompiler generator = new ClassicalExpressionCompiler(this.parameters, this.pluginHelper, this.nameProvider);
        String fctName = generator.generateClassicalExpression(expression, context, enclosingClass);
        return fctName;
    }

    private String generateCrossReferenceAccessCode(NamedElement context, NamedElement source, NamedElement target, ClockConstraintSystem targetRoot, ClassDefinition enclosingClass) {
        String code = "this";
        NamedElement current = context;
        while (current.eContainer() != null) {
            NamedElement container = (NamedElement)current.eContainer();
            String typeName = null;
            if (container instanceof Block && !(container instanceof ClockConstraintSystem)) {
                typeName = String.valueOf(this.nameProvider.getPackageName(container)) + "." + this.nameProvider.getClassName(container);
            } else {
                typeName = this.nameProvider.getClassName(container);
                enclosingClass.addImportedPackage(String.valueOf(this.nameProvider.getPackageName(container)) + "." + typeName);
            }
            code = "((" + typeName + ")(" + code + ").getParent())";
            current = container;
        }
        String code2 = "";
        current = target;
        while (current != null) {
            code2 = "." + this.nameProvider.getVariableGetterName(current) + "()" + code2;
            current = (NamedElement)current.eContainer();
        }
        code = String.valueOf(code) + code2;
        return code;
    }

    private String generateAccessCode(NamedElement context, NamedElement source, NamedElement target, ClassDefinition enclosingClass) {
        if (context == null) {
            return null;
        }
        if (source.eResource() != target.eResource()) {
            EObject targetRoot = EcoreUtil.getRootContainer((EObject)target, (boolean)true);
            if (targetRoot instanceof Library) {
                if (target instanceof PrimitiveElement) {
                    return this.generateElementCode(target, "private", enclosingClass, true);
                }
            } else if (targetRoot instanceof ClockConstraintSystem) {
                return this.generateCrossReferenceAccessCode(context, source, target, (ClockConstraintSystem)targetRoot, enclosingClass);
            }
        } else {
            if (context instanceof Block) {
                if (target.eContainer() == context) {
                    if (target instanceof Expression) {
                        return this.nameProvider.getClockName((Expression)target);
                    }
                    return this.nameProvider.getVariableName(target);
                }
                Block upperBlock = (Block)context.eContainer();
                String upperBlockType = this.nameProvider.getClassName((NamedElement)upperBlock);
                return "((" + upperBlockType + ")getParent())." + this.generateAccessCode((NamedElement)context.eContainer(), source, target, enclosingClass);
            }
            if (context instanceof UserRelationDefinition || context instanceof UserExpressionDefinition) {
                if (target instanceof Expression) {
                    return this.nameProvider.getClockName((Expression)target);
                }
                return String.valueOf(this.nameProvider.getVariableGetterName(target)) + "()";
            }
        }
        return null;
    }

    private String generateExpressionCode(NamedElement context, Expression expression, boolean useParentExpressionClock, IProject project, ClassDefinition enclosingClass) throws CoreException {
        ExpressionDefinition definition;
        String variableName = this.nameProvider.getVariableName((NamedElement)expression);
        String exprClassName = this.nameProvider.getClassName((NamedElement)expression);
        String exprPackageName = this.nameProvider.getPackageName((NamedElement)expression);
        ExpressionDeclaration declaration = expression.getType();
        if (!(declaration instanceof KernelExpressionDeclaration || this.parameters.useRuntimeFilterBy && declaration.getName().compareTo(CompilerParameters.FILTERBYNAME) == 0 || (definition = this.unfoldModel.getUsedExpressionDefinition(declaration)) == null)) {
            this.usedExpressionDefinitions.add(definition);
        }
        ArrayList<String> arguments = new ArrayList<String>();
        String clockName = useParentExpressionClock ? "getExpressionClock()" : this.nameProvider.getClockName(expression);
        arguments.add(clockName);
        Object parameters = declaration instanceof KernelExpressionDeclaration ? this.getKernelExpressionParameters((KernelExpressionDeclaration)declaration) : declaration.getParameters();
        for (AbstractEntity parameter : parameters) {
            if (context instanceof UserRelationDefinition || context instanceof UserExpressionDefinition) {
                BindableEntity value = this.resolveAbstract(parameter, (List<Binding>)expression.getBindings());
                if (value instanceof Expression) {
                    if (value == expression) {
                        arguments.add(clockName);
                        continue;
                    }
                    arguments.add(this.nameProvider.getClockName((Expression)value));
                    continue;
                }
                if (value instanceof ClassicalExpression) {
                    arguments.add(this.nameProvider.getProviderName((NamedElement)((ClassicalExpression)value)));
                    continue;
                }
                arguments.add(this.nameProvider.getVariableName((NamedElement)value));
                continue;
            }
            BindableEntity modelObject = this.resolveAbstract(parameter, (List<Binding>)expression.getBindings());
            arguments.add(this.generateAccessCode(context, (NamedElement)expression, (NamedElement)modelObject, enclosingClass));
        }
        MemberVariable exprVariable = new MemberVariable(variableName, exprClassName);
        exprVariable.addModifier("public");
        enclosingClass.addMemberVariable(exprVariable);
        MemberFunction initFunction = enclosingClass.getMemberFunction("init");
        String initializer = String.valueOf(variableName) + " = new " + exprClassName + "(";
        Iterator iter = arguments.iterator();
        while (iter.hasNext()) {
            initializer = String.valueOf(initializer) + (String)iter.next();
            if (!iter.hasNext()) continue;
            initializer = String.valueOf(initializer) + ", ";
        }
        initializer = String.valueOf(initializer) + ")";
        initFunction.addStatement(initializer);
        initFunction.addStatement(String.valueOf(variableName) + ".setName(\"" + expression.getName() + "\")");
        initFunction.addStatement(String.valueOf(variableName) + ".setParent(this)");
        enclosingClass.addImportedPackage(String.valueOf(exprPackageName) + "." + exprClassName);
        return variableName;
    }

    private List<NamedElement> computeStartOrder(NamedElement root, NamedElement context) {
        if (root instanceof Clock) {
            return Collections.emptyList();
        }
        boolean cfr_ignored_0 = root instanceof Expression;
        return Collections.emptyList();
    }

    private void generateArgumentsPrivateMembers(RelationDefinition definition, ClassDefinition enclosingClass, List<AbstractEntity> nonClockParameters) {
        EList parameters = definition.getDeclaration().getParameters();
        this.generateArgumentsPrivateMembers((List<AbstractEntity>)parameters, enclosingClass, nonClockParameters);
    }

    private void generateArgumentsPrivateMembers(ExpressionDefinition definition, ClassDefinition enclosingClass, List<AbstractEntity> nonClockParameters) {
        EList parameters = definition.getDeclaration().getParameters();
        this.generateArgumentsPrivateMembers((List<AbstractEntity>)parameters, enclosingClass, nonClockParameters);
    }

    private void generateArgumentsPrivateMembers(List<AbstractEntity> parameters, ClassDefinition enclosingClass, List<AbstractEntity> nonClockParameters) {
        for (AbstractEntity parameter : parameters) {
            Type parameterType = parameter.getType();
            Class<?> parameterClass = this.nameProvider.getJavaClass((NamedElement)parameterType);
            String paramClassName = this.nameProvider.getClassName((NamedElement)parameter);
            MemberVariable variable = new MemberVariable(this.nameProvider.getVariableName((NamedElement)parameter), paramClassName);
            variable.addModifier("private");
            enclosingClass.addImportedPackage(parameterClass.getName());
            enclosingClass.addMemberVariable(variable);
            if (!nonClockParameters.contains(parameter)) continue;
            String providerVar = this.nameProvider.getProviderName((NamedElement)parameter);
            MemberVariable pvar = new MemberVariable(providerVar, String.valueOf(ValueProvider.class.getSimpleName()) + "<" + paramClassName + ">");
            pvar.addModifier("private");
            enclosingClass.addImportedPackage(ValueProvider.class.getName());
            enclosingClass.addMemberVariable(pvar);
        }
    }

    private void generateExpressionDefinitionConstructor(ExpressionDefinition definition, String definitionClassName, ClassDefinition classDefinition, List<AbstractEntity> nonClockParameters) {
        String paramClassName;
        Class<?> parameterClass;
        Type parameterType;
        EList parameters = definition.getDeclaration().getParameters();
        MemberFunction constructor = new MemberFunction(definitionClassName);
        constructor.setConstructor(true);
        constructor.addModifier("public");
        constructor.addParameter(this.nameProvider.implicitClockClassName, "implicitClock");
        for (Object parameter : parameters) {
            parameterType = parameter.getType();
            parameterClass = this.nameProvider.getJavaClass((NamedElement)parameterType);
            paramClassName = this.nameProvider.getClassName((NamedElement)parameter);
            constructor.addParameter(paramClassName, this.nameProvider.getVariableName((NamedElement)parameter));
            classDefinition.addImportedPackage(parameterClass.getName());
        }
        constructor.addStatement("super(implicitClock)");
        for (AbstractEntity parameter : parameters) {
            constructor.addStatement("this." + this.nameProvider.getVariableName((NamedElement)parameter) + " = " + this.nameProvider.getVariableName((NamedElement)parameter));
        }
        constructor.addStatement("init()");
        classDefinition.addMemberFunction(constructor);
        if (!nonClockParameters.isEmpty()) {
            constructor = new MemberFunction(definitionClassName);
            constructor.setConstructor(true);
            constructor.addModifier("public");
            constructor.addParameter(this.nameProvider.implicitClockClassName, "implicitClock");
            for (Object parameter : parameters) {
                parameterType = parameter.getType();
                parameterClass = this.nameProvider.getJavaClass((NamedElement)parameterType);
                paramClassName = this.nameProvider.getClassName((NamedElement)parameter);
                if (nonClockParameters.contains(parameter)) {
                    constructor.addParameter(String.valueOf(ValueProvider.class.getSimpleName()) + "<" + paramClassName + ">", this.nameProvider.getVariableName((NamedElement)parameter));
                } else {
                    constructor.addParameter(paramClassName, this.nameProvider.getVariableName((NamedElement)parameter));
                }
                classDefinition.addImportedPackage(parameterClass.getName());
                classDefinition.addImportedPackage(ValueProvider.class.getName());
            }
            constructor.addStatement("super(implicitClock)");
            for (AbstractEntity parameter : parameters) {
                String var = nonClockParameters.contains(parameter) ? this.nameProvider.getProviderName((NamedElement)parameter) : this.nameProvider.getVariableName((NamedElement)parameter);
                constructor.addStatement("this." + var + " = " + this.nameProvider.getVariableName((NamedElement)parameter));
            }
            constructor.addStatement("init()");
            classDefinition.addMemberFunction(constructor);
        }
    }

    private List<ConcreteEntity> getBuildOrder(List<ConcreteEntity> entities) {
        final HashMap<ConcreteEntity, Integer> ranks = new HashMap<ConcreteEntity, Integer>();
        for (ConcreteEntity entity : entities) {
            ranks.put(entity, 0);
        }
        for (ConcreteEntity entity : entities) {
            if (!(entity instanceof Expression) && !(entity instanceof Relation)) continue;
            this.setDepths(entity, ranks);
        }
        ArrayList<ConcreteEntity> result = new ArrayList<ConcreteEntity>(entities);
        Collections.sort(result, new Comparator<ConcreteEntity>(){

            @Override
            public int compare(ConcreteEntity o1, ConcreteEntity o2) {
                return (Integer)ranks.get(o2) - (Integer)ranks.get(o1);
            }
        });
        return result;
    }

    private void setDepths(ConcreteEntity root, HashMap<ConcreteEntity, Integer> depths) {
        ExpressionDeclaration declaration;
        int parentDepth = depths.get(root);
        Object parameters = Collections.emptyList();
        EList bindings = Collections.emptyList();
        if (root instanceof Expression) {
            declaration = ((Expression)root).getType();
            parameters = declaration instanceof KernelExpressionDeclaration ? this.getKernelExpressionParameters((KernelExpressionDeclaration)declaration) : declaration.getParameters();
            bindings = ((Expression)root).getBindings();
        } else if (root instanceof Relation) {
            declaration = ((Relation)root).getType();
            if (declaration instanceof KernelRelationDeclaration) {
                parameters = new ArrayList();
                parameters.add(((KernelRelationDeclaration)declaration).getLeftEntity());
                parameters.add(((KernelRelationDeclaration)declaration).getRightEntity());
            } else {
                parameters = declaration.getParameters();
            }
            bindings = ((Relation)root).getBindings();
        }
        Iterator iterator = parameters.iterator();
        while (iterator.hasNext()) {
            AbstractEntity parameter = (AbstractEntity)iterator.next();
            BindableEntity value = this.resolveAbstract(parameter, (List<Binding>)bindings);
            if (!(value instanceof Expression)) continue;
            int currentDepth = depths.get(value);
            int newDepth = parentDepth + 1 > currentDepth ? parentDepth + 1 : currentDepth;
            depths.put((ConcreteEntity)value, newDepth);
        }
    }

    private List<Expression> getExpressionTree(Relation root, boolean includeConcatLeft, boolean includeConcatRight) {
        ArrayList<Expression> result = new ArrayList<Expression>();
        ArrayList<AbstractEntity> parameters = new ArrayList<AbstractEntity>();
        RelationDeclaration declaration = root.getType();
        if (declaration instanceof KernelRelationDeclaration) {
            parameters.add(((KernelRelationDeclaration)declaration).getLeftEntity());
            parameters.add(((KernelRelationDeclaration)declaration).getRightEntity());
        } else {
            parameters.addAll((Collection<AbstractEntity>)declaration.getParameters());
        }
        for (AbstractEntity parameter : parameters) {
            BindableEntity value = this.resolveAbstract(parameter, (List<Binding>)root.getBindings());
            if (!(value instanceof Expression)) continue;
            result.add((Expression)value);
            result.addAll(this.getExpressionTree((Expression)value, includeConcatLeft, includeConcatRight));
        }
        return result;
    }

    private List<Expression> getExpressionTree(Expression root, boolean includeConcatLeft, boolean includeConcatRight) {
        Object parameters;
        ArrayList<Expression> result = new ArrayList<Expression>();
        ExpressionDeclaration declaration = root.getType();
        if (declaration instanceof Concatenation) {
            parameters = new ArrayList();
            if (includeConcatLeft) {
                parameters.add(((Concatenation)declaration).getLeftClock());
            }
            if (includeConcatRight) {
                parameters.add(((Concatenation)declaration).getRightClock());
            }
        } else {
            parameters = declaration instanceof KernelExpressionDeclaration ? this.getKernelExpressionParameters((KernelExpressionDeclaration)declaration) : declaration.getParameters();
        }
        Iterator iterator = parameters.iterator();
        while (iterator.hasNext()) {
            AbstractEntity parameter = (AbstractEntity)iterator.next();
            BindableEntity value = this.resolveAbstract(parameter, (List<Binding>)root.getBindings());
            if (!(value instanceof Expression)) continue;
            result.add((Expression)value);
            result.addAll(this.getExpressionTree((Expression)value, includeConcatLeft, includeConcatRight));
        }
        return result;
    }

    private String compileConditionalExpressionDefinition(ConditionalExpressionDefinition definition, IProject project) throws CoreException, CompilerException {
        RecursiveDefinitionChecker checker = new RecursiveDefinitionChecker((ExpressionDefinition)definition);
        Expression recursiveCall = null;
        if (checker.isTailRecursive()) {
            recursiveCall = checker.getRecursiveCall();
        }
        String definitionClassName = this.nameProvider.getClassName((NamedElement)definition);
        String definitionClassPackage = this.nameProvider.getPackageName((NamedElement)definition);
        ClassDefinition classDefinition = new ClassDefinition(definitionClassName, definitionClassPackage);
        classDefinition.setProject(project);
        classDefinition.setParentClassName(AbstractRuntimeExpression.class.getSimpleName());
        classDefinition.addInterface(IRuntimeContainer.class.getSimpleName());
        classDefinition.addImportedPackage(IRuntimeContainer.class.getName());
        ArrayList<String> constraintNames = new ArrayList<String>();
        MemberFunction initFunction = new MemberFunction("init", "void");
        initFunction.addModifier("protected");
        classDefinition.addMemberFunction(initFunction);
        classDefinition.addImportedPackage(AbstractRuntimeExpression.class.getName());
        List<AbstractEntity> nonClockParameters = this.getNonClockParameters((UserExpressionDefinition)definition);
        this.generateArgumentsPrivateMembers((ExpressionDefinition)definition, classDefinition, nonClockParameters);
        this.generateExpressionDefinitionConstructor((ExpressionDefinition)definition, definitionClassName, classDefinition, nonClockParameters);
        classDefinition.addImportedPackage(String.valueOf(this.nameProvider.clockClassPackage) + "." + this.nameProvider.clockClassName);
        HashMap<ClassicalExpression, String> classicalExprNames = new HashMap<ClassicalExpression, String>();
        HashMap<ClassicalExpression, String> classicalExprProviderNames = new HashMap<ClassicalExpression, String>();
        HashMap<Expression, String> expressionNames = new HashMap<Expression, String>();
        for (ClassicalExpression expression : definition.getClassicalExpressions()) {
            ClassicalExpressionCompiler generator = new ClassicalExpressionCompiler(this.parameters, this.pluginHelper, this.nameProvider);
            String fctName = generator.generateClassicalExpression(expression, (NamedElement)definition, classDefinition);
            if (checker.isTailRecursive() && checker.getRecursionArguments().contains(expression)) {
                MemberVariable variable = new MemberVariable(this.nameProvider.getVariableName((NamedElement)expression), generator.getReturnTypeName());
                variable.addModifier("private");
                classDefinition.addMemberVariable(variable);
            }
            classicalExprNames.put(expression, fctName);
            String providerTypeName = String.valueOf(ValueProvider.class.getSimpleName()) + "<" + generator.getReturnTypeName() + ">";
            String providerName = this.nameProvider.getProviderName((NamedElement)expression);
            MemberVariable providerVariable = new MemberVariable(providerName, providerTypeName);
            providerVariable.addModifier("private");
            Object initializer = " new " + providerTypeName + "() {\n";
            initializer = String.valueOf(initializer) + "      public " + generator.getReturnTypeName() + " getValue() {\n";
            initializer = String.valueOf(initializer) + "        return " + fctName + "();\n";
            initializer = String.valueOf(initializer) + "      }\n    }";
            providerVariable.setInitializer((String)initializer);
            classDefinition.addMemberVariable(providerVariable);
            classDefinition.addImportedPackage(ValueProvider.class.getName());
            classicalExprProviderNames.put(expression, providerName);
        }
        for (ConcreteEntity entity : definition.getConcreteEntities()) {
            String clockVariableName;
            if (entity instanceof Relation) {
                String relationVarName = this.generateRelationCode((NamedElement)definition, (Relation)entity, classDefinition, project);
                constraintNames.add(relationVarName);
                continue;
            }
            if (entity instanceof Expression && (recursiveCall == null || recursiveCall != null && entity != recursiveCall)) {
                clockVariableName = this.nameProvider.getClockName((Expression)entity);
                String clockName = entity.getName();
                this.generateDiscreteClockCode(clockVariableName, clockName, this.nameProvider.implicitClockClassName, this.nameProvider.implicitClockPackage, "public", classDefinition, initFunction, null, null, null);
                String expressionVarName = this.generateExpressionCode((NamedElement)definition, (Expression)entity, false, project, classDefinition);
                constraintNames.add(expressionVarName);
                if (expressionNames.get(expressionVarName) != null) {
                    throw new CompilerException("Duplicate expression name \"" + entity.getName() + "\" in Conditional Expression Definition " + definition.getName());
                }
                expressionNames.put((Expression)entity, expressionVarName);
                continue;
            }
            if (!(entity instanceof Element)) continue;
            clockVariableName = this.generateElementCode((NamedElement)entity, "private", classDefinition, true);
        }
        ExprCase defaultCase = ClockExpressionAndRelationFactory.eINSTANCE.createExprCase();
        HashMap<ExprCase, String> switchTestNames = new HashMap<ExprCase, String>();
        HashMap<ExprCase, String> switchExprNames = new HashMap<ExprCase, String>();
        HashMap<ExprCase, Integer> switchTestIndices = new HashMap<ExprCase, Integer>();
        int switchTestCounter = 0;
        MemberVariable selectionVar = new MemberVariable("selectedCase", "int");
        selectionVar.addModifier("private");
        selectionVar.setInitializer("-1");
        classDefinition.addMemberVariable(selectionVar);
        for (ExprCase swCase : definition.getExprCases()) {
            BooleanExpression test = swCase.getCondition();
            Expression expression = swCase.getExpression();
            String testFunctionName = this.generateClassicalExpression((ClassicalExpression)test, (NamedElement)definition, classDefinition);
            switchTestNames.put(swCase, testFunctionName);
            switchTestIndices.put(swCase, ++switchTestCounter);
            if (checker.isRecursive() && checker.getRecursionPath().contains(expression) && expression.getType() instanceof Concatenation) {
                InlineConcatenationGenerator generator = new InlineConcatenationGenerator(expression, classDefinition, initFunction);
                String stateName = generator.generate();
                switchExprNames.put(swCase, stateName);
                continue;
            }
            if (recursiveCall != null && (recursiveCall == null || expression == recursiveCall)) continue;
            String exprFunctionName = this.generateExpressionCode((NamedElement)definition, expression, false, project, classDefinition);
            switchExprNames.put(swCase, exprFunctionName);
            expressionNames.put(expression, exprFunctionName);
            String clockVariableName = this.nameProvider.getClockName(expression);
            String clockName = expression.getName();
            this.generateDiscreteClockCode(clockVariableName, clockName, this.nameProvider.implicitClockClassName, this.nameProvider.implicitClockPackage, "public", classDefinition, initFunction, null, null, null);
        }
        if (definition.getDefaultExpression() != null) {
            Expression expression = definition.getDefaultExpression();
            if (checker.isRecursive() && checker.getRecursionPath().contains(expression) && expression.getType() instanceof Concatenation) {
                InlineConcatenationGenerator generator = new InlineConcatenationGenerator(expression, classDefinition, initFunction);
                String stateName = generator.generate();
                switchExprNames.put(defaultCase, stateName);
            } else if (recursiveCall == null || recursiveCall != null && recursiveCall != definition.getDefaultExpression()) {
                String exprFunctionName = this.generateExpressionCode((NamedElement)definition, definition.getDefaultExpression(), false, project, classDefinition);
                switchExprNames.put(defaultCase, exprFunctionName);
                expressionNames.put(definition.getDefaultExpression(), exprFunctionName);
                String clockVariableName = this.nameProvider.getClockName(expression);
                String clockName = expression.getName();
                this.generateDiscreteClockCode(clockVariableName, clockName, this.nameProvider.implicitClockClassName, this.nameProvider.implicitClockPackage, "public", classDefinition, initFunction, null, null, null);
            }
        }
        this.generateConditionalStartFunction(definition, classDefinition, checker, switchTestNames, switchExprNames, switchTestIndices, defaultCase, expressionNames, nonClockParameters);
        this.generateConditionalSemanticFunction(definition, classDefinition, checker, switchTestNames, switchExprNames, switchTestIndices, defaultCase, expressionNames);
        this.generateConditionalUpdateFunction(definition, classDefinition, checker, switchTestNames, switchExprNames, defaultCase, expressionNames, classicalExprNames);
        classDefinition.generate(this.pluginHelper);
        return "";
    }

    private void generateConditionalStartFunction(ConditionalExpressionDefinition definition, ClassDefinition classDefinition, RecursiveDefinitionChecker checker, HashMap<ExprCase, String> switchTestNames, HashMap<ExprCase, String> switchExprNames, HashMap<ExprCase, Integer> switchTestIndices, ExprCase defaultCase, HashMap<Expression, String> expressionNames, List<AbstractEntity> nonClockParameters) {
        MemberFunction startFunction = new MemberFunction("start", "void");
        startFunction.setOverrides(true);
        startFunction.addModifier("public");
        startFunction.addException("SimulationException");
        startFunction.addParameter("AbstractSemanticHelper", "helper");
        classDefinition.addMemberFunction(startFunction);
        IfStatement st = new IfStatement("! canCallStart()");
        st.addThenStatement(new SimpleStatement("return"));
        startFunction.addStatement(st);
        startFunction.addStatement("super.start(helper)");
        for (AbstractEntity parameter : nonClockParameters) {
            IfStatement providerTest = new IfStatement();
            providerTest.setTestCode(String.valueOf(this.nameProvider.getProviderName((NamedElement)parameter)) + " != null");
            providerTest.addThenStatement(String.valueOf(this.nameProvider.getVariableName((NamedElement)parameter)) + " = " + this.nameProvider.getProviderName((NamedElement)parameter) + ".getValue()");
            startFunction.addStatement(providerTest);
        }
        IfStatement caseIfStatement = new IfStatement();
        startFunction.addStatement(caseIfStatement);
        Iterator iter = definition.getExprCases().iterator();
        while (iter.hasNext()) {
            ExprCase swCase = (ExprCase)iter.next();
            String testFunctionName = switchTestNames.get(swCase);
            String exprFunctionName = switchExprNames.get(swCase);
            caseIfStatement.setTestCode(String.valueOf(testFunctionName) + "()");
            caseIfStatement.addThenStatement("selectedCase = " + switchTestIndices.get(swCase));
            if (swCase.getExpression().getType() instanceof Concatenation && checker.isTailRecursive() && checker.getRecursionPath().contains(swCase.getExpression())) {
                caseIfStatement.addThenStatement(String.valueOf(exprFunctionName) + " = " + RuntimeConcatenation.ConcatState.class.getSimpleName() + "." + RuntimeConcatenation.ConcatState.FOLLOWLEFT.name());
            } else {
                caseIfStatement.addThenStatement(String.valueOf(exprFunctionName) + ".start(helper)");
            }
            List<Expression> subExpressions = this.getExpressionTree(swCase.getExpression(), true, false);
            for (Expression expr : subExpressions) {
                String exprName = expressionNames.get(expr);
                caseIfStatement.addThenStatement(String.valueOf(exprName) + ".start(helper)");
            }
            if (!iter.hasNext()) continue;
            IfStatement elseifStatement = new IfStatement();
            caseIfStatement.addElseStatement(elseifStatement);
            caseIfStatement = elseifStatement;
        }
        if (definition.getDefaultExpression() != null) {
            caseIfStatement.addElseStatement("selectedCase = 0");
            if (definition.getDefaultExpression().getType() instanceof Concatenation && checker.isTailRecursive() && checker.getRecursionPath().contains(definition.getDefaultExpression())) {
                caseIfStatement.addElseStatement(String.valueOf(switchExprNames.get(defaultCase)) + " = " + RuntimeConcatenation.ConcatState.class.getSimpleName() + "." + RuntimeConcatenation.ConcatState.FOLLOWLEFT.name());
            } else {
                caseIfStatement.addElseStatement(String.valueOf(switchExprNames.get(defaultCase)) + ".start(helper)");
            }
            List<Expression> subExpressions = this.getExpressionTree(definition.getDefaultExpression(), true, false);
            for (Expression expr : subExpressions) {
                String exprName = expressionNames.get(expr);
                caseIfStatement.addElseStatement(String.valueOf(exprName) + ".start(helper)");
            }
        }
    }

    private void generateConditionalSemanticFunction(ConditionalExpressionDefinition definition, ClassDefinition classDefinition, RecursiveDefinitionChecker checker, HashMap<ExprCase, String> switchTestNames, HashMap<ExprCase, String> switchExprNames, HashMap<ExprCase, Integer> switchTestIndices, ExprCase defaultCase, HashMap<Expression, String> expressionNames) {
        MemberFunction semanticFunction = new MemberFunction("semantic", "void");
        semanticFunction.setOverrides(true);
        semanticFunction.addModifier("public");
        semanticFunction.addParameter(AbstractSemanticHelper.class.getSimpleName(), "helper");
        semanticFunction.addException(SimulationException.class.getSimpleName());
        classDefinition.addMemberFunction(semanticFunction);
        classDefinition.addImportedPackage(AbstractSemanticHelper.class.getName());
        classDefinition.addImportedPackage(SimulationException.class.getName());
        IfStatement ifStatement = new IfStatement("! canCallSemantic()");
        ifStatement.addThenStatement("return");
        semanticFunction.addStatement(ifStatement);
        semanticFunction.addStatement("super.semantic(helper)");
        IfStatement caseIfStatement = new IfStatement();
        semanticFunction.addStatement(caseIfStatement);
        Iterator iter = definition.getExprCases().iterator();
        while (iter.hasNext()) {
            block12: {
                IfStatement selectionChangedIf;
                String exprFunctionName;
                ExprCase swCase;
                block10: {
                    BindableEntity rightValue;
                    IfStatement concatRightIf;
                    Expression concatExp;
                    block11: {
                        swCase = (ExprCase)iter.next();
                        String testFunctionName = switchTestNames.get(swCase);
                        exprFunctionName = switchExprNames.get(swCase);
                        caseIfStatement.setTestCode(String.valueOf(testFunctionName) + "()");
                        selectionChangedIf = new IfStatement("selectedCase != " + switchTestIndices.get(swCase));
                        caseIfStatement.addThenStatement(selectionChangedIf);
                        caseIfStatement.addThenStatement("selectedCase = " + switchTestIndices.get(swCase));
                        caseIfStatement.addThenStatement("helper.registerClockEquality(" + this.nameProvider.getClockName(swCase.getExpression()) + ", getExpressionClock()" + ")");
                        caseIfStatement.addThenStatement("helper.registerClockUse(" + this.nameProvider.getClockName(swCase.getExpression()) + ")");
                        caseIfStatement.addThenStatement("helper.registerClockUse( getExpressionClock() )");
                        if (!(swCase.getExpression().getType() instanceof Concatenation) || !checker.isTailRecursive() || !checker.getRecursionPath().contains(swCase.getExpression())) break block10;
                        selectionChangedIf.addThenStatement(String.valueOf(exprFunctionName) + " = " + RuntimeConcatenation.ConcatState.class.getSimpleName() + "." + RuntimeConcatenation.ConcatState.FOLLOWLEFT.name());
                        concatExp = swCase.getExpression();
                        Concatenation concatDecl = (Concatenation)concatExp.getType();
                        IfStatement concatLeftIf = new IfStatement();
                        concatLeftIf.setTestCode(String.valueOf(exprFunctionName) + " == " + RuntimeConcatenation.ConcatState.class.getSimpleName() + "." + RuntimeConcatenation.ConcatState.FOLLOWLEFT.name());
                        caseIfStatement.addThenStatement(concatLeftIf);
                        BindableEntity leftValue = this.resolveAbstract(concatDecl.getLeftClock(), (List<Binding>)concatExp.getBindings());
                        if (leftValue instanceof Expression) {
                            if (expressionNames.get(leftValue) != null) {
                                selectionChangedIf.addThenStatement(String.valueOf(expressionNames.get(leftValue)) + ".start(helper)");
                                concatLeftIf.addThenStatement(String.valueOf(expressionNames.get(leftValue)) + ".semantic(helper)");
                            }
                            concatLeftIf.addThenStatement("helper.registerClockEquality(" + this.nameProvider.getClockName((Expression)leftValue) + ", " + this.nameProvider.getClockName(concatExp) + ")");
                            concatLeftIf.addThenStatement("helper.registerClockUse(" + this.nameProvider.getClockName((Expression)leftValue) + ")");
                            concatLeftIf.addThenStatement("helper.registerClockUse(" + this.nameProvider.getClockName(concatExp) + ")");
                        } else if (leftValue instanceof Clock) {
                            concatLeftIf.addThenStatement("helper.registerClockEquality(" + this.nameProvider.getVariableName((NamedElement)leftValue) + ", " + this.nameProvider.getClockName(concatExp) + ")");
                            concatLeftIf.addThenStatement("helper.registerClockUse(" + this.nameProvider.getVariableName((NamedElement)leftValue) + ")");
                            concatLeftIf.addThenStatement("helper.registerClockUse(" + this.nameProvider.getClockName(concatExp) + ")");
                        }
                        concatRightIf = new IfStatement();
                        concatRightIf.setTestCode(String.valueOf(exprFunctionName) + " == " + RuntimeConcatenation.ConcatState.class.getSimpleName() + "." + RuntimeConcatenation.ConcatState.FOLLOWRIGHT.name());
                        concatLeftIf.addElseStatement(concatRightIf);
                        rightValue = this.resolveAbstract(concatDecl.getRightClock(), (List<Binding>)concatExp.getBindings());
                        if (!(rightValue instanceof Expression) || rightValue == checker.getRecursiveCall()) break block11;
                        if (expressionNames.get(rightValue) != null) {
                            selectionChangedIf.addThenStatement(String.valueOf(expressionNames.get(rightValue)) + ".start(helper)");
                            concatRightIf.addThenStatement(String.valueOf(expressionNames.get(rightValue)) + ".semantic(helper)");
                        }
                        concatRightIf.addThenStatement("helper.registerClockEquality(" + this.nameProvider.getClockName((Expression)rightValue) + ", " + this.nameProvider.getClockName(concatExp) + ")");
                        concatRightIf.addThenStatement("helper.registerClockUse(" + this.nameProvider.getClockName((Expression)rightValue) + ")");
                        concatRightIf.addThenStatement("helper.registerClockUse(" + this.nameProvider.getClockName(concatExp) + ")");
                        break block12;
                    }
                    if (!(rightValue instanceof Clock)) break block12;
                    concatRightIf.addThenStatement("helper.registerClockEquality(" + this.nameProvider.getVariableName((NamedElement)rightValue) + ", " + this.nameProvider.getClockName(concatExp) + ")");
                    concatRightIf.addThenStatement("helper.registerClockUse(" + this.nameProvider.getVariableName((NamedElement)rightValue) + ")");
                    concatRightIf.addThenStatement("helper.registerClockUse(" + this.nameProvider.getClockName(concatExp) + ")");
                    break block12;
                }
                if (!checker.isRecursive() || checker.getRecursiveCall() != swCase.getExpression()) {
                    selectionChangedIf.addThenStatement(String.valueOf(exprFunctionName) + ".start(helper)");
                    caseIfStatement.addThenStatement(String.valueOf(exprFunctionName) + ".semantic(helper)");
                    List<Expression> subExpressions = this.getExpressionTree(swCase.getExpression(), true, true);
                    for (Expression expr : subExpressions) {
                        String exprName = expressionNames.get(expr);
                        selectionChangedIf.addThenStatement(String.valueOf(exprName) + ".start(helper)");
                        caseIfStatement.addThenStatement(String.valueOf(exprName) + ".semantic(helper)");
                    }
                }
            }
            if (!iter.hasNext()) continue;
            IfStatement elseifStatement = new IfStatement();
            caseIfStatement.addElseStatement(elseifStatement);
            caseIfStatement = elseifStatement;
        }
        if (definition.getDefaultExpression() != null) {
            IfStatement selectionChangedIf = new IfStatement("selectedCase != 0");
            selectionChangedIf.addThenStatement(String.valueOf(switchExprNames.get(defaultCase)) + ".start(helper)");
            caseIfStatement.addElseStatement(selectionChangedIf);
            caseIfStatement.addElseStatement("selectedCase = 0");
            caseIfStatement.addElseStatement("helper.registerClockEquality(" + this.nameProvider.getClockName(definition.getDefaultExpression()) + ", getExpressionClock()" + ")");
            caseIfStatement.addElseStatement("helper.registerClockUse(" + this.nameProvider.getClockName(definition.getDefaultExpression()) + ")");
            caseIfStatement.addElseStatement("helper.registerClockUse( getExpressionClock() )");
            caseIfStatement.addElseStatement(String.valueOf(switchExprNames.get(defaultCase)) + ".semantic(helper)");
            List<Expression> subExpressions = this.getExpressionTree(definition.getDefaultExpression(), true, false);
            for (Expression expr : subExpressions) {
                String exprName = expressionNames.get(expr);
                selectionChangedIf.addThenStatement(String.valueOf(exprName) + ".start(helper)");
                caseIfStatement.addElseStatement(String.valueOf(exprName) + ".semantic(helper)");
            }
        }
    }

    private void generateConditionalDeathSemanticFunction(ConditionalExpressionDefinition definition, ClassDefinition classDefinition, RecursiveDefinitionChecker checker, HashMap<ExprCase, String> switchTestNames, HashMap<ExprCase, String> switchExprNames, ExprCase defaultCase, HashMap<Expression, String> expressionNames, HashMap<ClassicalExpression, String> classicalExprNames) {
        MemberFunction deathSemFunction = new MemberFunction("deathSemantic", "void");
        deathSemFunction.addModifier("public");
        deathSemFunction.addParameter(AbstractSemanticHelper.class.getSimpleName(), "helper");
        deathSemFunction.addException(SimulationException.class.getSimpleName());
        classDefinition.addMemberFunction(deathSemFunction);
        classDefinition.addImportedPackage(AbstractSemanticHelper.class.getName());
        classDefinition.addImportedPackage(SimulationException.class.getName());
        deathSemFunction.addStatement("super.deathSemantic(helper)");
        IfStatement caseIfStatement = new IfStatement();
        deathSemFunction.addStatement(caseIfStatement);
        Iterator iter = definition.getExprCases().iterator();
        while (iter.hasNext()) {
            block12: {
                String exprFunctionName;
                ExprCase swCase;
                block10: {
                    BindableEntity rightValue;
                    IfStatement concatRightIf;
                    Expression concatExp;
                    block11: {
                        swCase = (ExprCase)iter.next();
                        String testFunctionName = switchTestNames.get(swCase);
                        exprFunctionName = switchExprNames.get(swCase);
                        caseIfStatement.setTestCode(String.valueOf(testFunctionName) + "()");
                        caseIfStatement.addThenStatement("helper.registerDeathEquality(" + this.nameProvider.getClockName(swCase.getExpression()) + ", getExpressionClock()" + ")");
                        if (!(swCase.getExpression().getType() instanceof Concatenation) || !checker.isTailRecursive() || !checker.getRecursionPath().contains(swCase.getExpression())) break block10;
                        concatExp = swCase.getExpression();
                        Concatenation concatDecl = (Concatenation)concatExp.getType();
                        IfStatement concatLeftIf = new IfStatement();
                        concatLeftIf.setTestCode(String.valueOf(exprFunctionName) + " == " + RuntimeConcatenation.ConcatState.class.getSimpleName() + "." + RuntimeConcatenation.ConcatState.FOLLOWLEFT.name());
                        caseIfStatement.addThenStatement(concatLeftIf);
                        BindableEntity leftValue = this.resolveAbstract(concatDecl.getLeftClock(), (List<Binding>)concatExp.getBindings());
                        if (leftValue instanceof Expression) {
                            if (expressionNames.get(leftValue) != null) {
                                concatLeftIf.addThenStatement(String.valueOf(expressionNames.get(leftValue)) + ".deathSemantic(helper)");
                            }
                            concatLeftIf.addThenStatement("helper.registerDeathEquality(" + this.nameProvider.getClockName((Expression)leftValue) + ", " + this.nameProvider.getClockName(concatExp) + ")");
                        } else if (leftValue instanceof Clock) {
                            concatLeftIf.addThenStatement("helper.registerDeathEquality(" + this.nameProvider.getVariableName((NamedElement)leftValue) + ", " + this.nameProvider.getClockName(concatExp) + ")");
                        }
                        concatRightIf = new IfStatement();
                        concatRightIf.setTestCode(String.valueOf(exprFunctionName) + " == " + RuntimeConcatenation.ConcatState.class.getSimpleName() + "." + RuntimeConcatenation.ConcatState.FOLLOWRIGHT.name());
                        concatLeftIf.addElseStatement(concatRightIf);
                        rightValue = this.resolveAbstract(concatDecl.getRightClock(), (List<Binding>)concatExp.getBindings());
                        if (!(rightValue instanceof Expression) || rightValue == checker.getRecursiveCall()) break block11;
                        if (expressionNames.get(rightValue) != null) {
                            concatRightIf.addThenStatement(String.valueOf(expressionNames.get(rightValue)) + ".deathSemantic(helper)");
                        }
                        concatRightIf.addThenStatement("helper.registerDeathEquality(" + this.nameProvider.getClockName((Expression)rightValue) + ", " + this.nameProvider.getClockName(concatExp) + ")");
                        break block12;
                    }
                    if (!(rightValue instanceof Clock)) break block12;
                    concatRightIf.addThenStatement("helper.registerDeathEquality(" + this.nameProvider.getVariableName((NamedElement)rightValue) + ", " + this.nameProvider.getClockName(concatExp) + ")");
                    break block12;
                }
                if (!checker.isRecursive() || checker.getRecursiveCall() != swCase.getExpression()) {
                    caseIfStatement.addThenStatement(String.valueOf(exprFunctionName) + ".deathSemantic(helper)");
                    List<Expression> subExpressions = this.getExpressionTree(swCase.getExpression(), true, true);
                    for (Expression expr : subExpressions) {
                        String exprName = expressionNames.get(expr);
                        caseIfStatement.addThenStatement(String.valueOf(exprName) + ".deathSemantic(helper)");
                    }
                }
            }
            if (!iter.hasNext()) continue;
            IfStatement elseifStatement = new IfStatement();
            caseIfStatement.addElseStatement(elseifStatement);
            caseIfStatement = elseifStatement;
        }
        if (definition.getDefaultExpression() != null) {
            caseIfStatement.addElseStatement("helper.registerDeathEquality(" + this.nameProvider.getClockName(definition.getDefaultExpression()) + ", getExpressionClock()" + ")");
            caseIfStatement.addElseStatement(String.valueOf(switchExprNames.get(defaultCase)) + ".deathSemantic(helper)");
            List<Expression> subExpressions = this.getExpressionTree(definition.getDefaultExpression(), true, false);
            for (Expression expr : subExpressions) {
                String exprName = expressionNames.get(expr);
                caseIfStatement.addElseStatement(String.valueOf(exprName) + ".deathSemantic(helper)");
            }
        }
    }

    private void generateConditionalUpdateFunction(ConditionalExpressionDefinition definition, ClassDefinition classDefinition, RecursiveDefinitionChecker checker, HashMap<ExprCase, String> switchTestNames, HashMap<ExprCase, String> switchExprNames, ExprCase defaultCase, HashMap<Expression, String> expressionNames, HashMap<ClassicalExpression, String> classicalExprNames) {
        MemberFunction updateFunction = new MemberFunction("update", "void");
        updateFunction.addModifier("public");
        updateFunction.addParameter(AbstractUpdateHelper.class.getSimpleName(), "helper");
        updateFunction.addException(SimulationException.class.getSimpleName());
        updateFunction.setOverrides(true);
        classDefinition.addMemberFunction(updateFunction);
        classDefinition.addImportedPackage(AbstractUpdateHelper.class.getName());
        classDefinition.addImportedPackage(SimulationException.class.getName());
        IfStatement ifSt = new IfStatement("! canCallUpdate()");
        ifSt.addThenStatement("return");
        updateFunction.addStatement(ifSt);
        updateFunction.addStatement("super.update(helper)");
        IfStatement caseIfStatement = new IfStatement();
        updateFunction.addStatement(caseIfStatement);
        Iterator iter = definition.getExprCases().iterator();
        while (iter.hasNext()) {
            ExprCase swCase = (ExprCase)iter.next();
            String testFunctionName = switchTestNames.get(swCase);
            String exprFunctionName = switchExprNames.get(swCase);
            caseIfStatement.setTestCode(String.valueOf(testFunctionName) + "()");
            if (swCase.getExpression().getType() instanceof Concatenation && checker.isTailRecursive() && checker.getRecursionPath().contains(swCase.getExpression())) {
                BindableEntity val;
                AbstractEntity param;
                Expression concatExp = swCase.getExpression();
                Concatenation concatDecl = (Concatenation)concatExp.getType();
                IfStatement concatIfLeft = new IfStatement(String.valueOf(exprFunctionName) + " == ConcatState.FOLLOWLEFT");
                caseIfStatement.addThenStatement(concatIfLeft);
                BindableEntity leftValue = this.resolveAbstract(concatDecl.getLeftClock(), (List<Binding>)concatExp.getBindings());
                BindableEntity rightValue = this.resolveAbstract(concatDecl.getRightClock(), (List<Binding>)concatExp.getBindings());
                if (leftValue instanceof Expression) {
                    if (expressionNames.get(leftValue) != null) {
                        concatIfLeft.addThenStatement(String.valueOf(expressionNames.get(leftValue)) + ".update(helper)");
                        IfStatement deadTest = new IfStatement(String.valueOf(expressionNames.get(leftValue)) + ".isDead()");
                        concatIfLeft.addThenStatement(deadTest);
                        if (rightValue instanceof Expression && rightValue != checker.getRecursiveCall()) {
                            deadTest.addThenStatement(String.valueOf(exprFunctionName) + " = ConcatState.FOLLOWRIGHT");
                            deadTest.addThenStatement("helper.registerClockToStart(" + this.nameProvider.getClockName((Expression)rightValue) + ")");
                        } else if (rightValue instanceof Expression && rightValue == checker.getRecursiveCall()) {
                            deadTest.addThenStatement(new Comment("Recursive call here."));
                            for (Binding binding : ((Expression)rightValue).getBindings()) {
                                param = binding.getAbstract();
                                if (param == (val = this.resolveAbstract(param, (List<Binding>)((Expression)rightValue).getBindings())) || !(val instanceof ClassicalExpression)) continue;
                                deadTest.addThenStatement(String.valueOf(this.nameProvider.getVariableName((NamedElement)param)) + " = " + classicalExprNames.get(val) + "()");
                            }
                            deadTest.addThenStatement(String.valueOf(exprFunctionName) + " = ConcatState.FOLLOWLEFT");
                            if (leftValue instanceof Expression && leftValue != checker.getRecursiveCall()) {
                                deadTest.addThenStatement("helper.registerClockToStart(" + this.nameProvider.getClockName((Expression)leftValue) + ")");
                            }
                        }
                    }
                } else {
                    boolean cfr_ignored_0 = leftValue instanceof Clock;
                }
                IfStatement concatIfRight = new IfStatement(String.valueOf(exprFunctionName) + " == ConcatState.FOLLOWRIGHT");
                concatIfLeft.addElseStatement(concatIfRight);
                if (rightValue instanceof Expression) {
                    if (rightValue == checker.getRecursiveCall()) {
                        concatIfRight.addThenStatement(new Comment("Recursive call. Code is here but will never run because of previous test."));
                        for (Binding binding : ((Expression)rightValue).getBindings()) {
                            param = binding.getAbstract();
                            if (param == (val = this.resolveAbstract(param, (List<Binding>)((Expression)rightValue).getBindings())) || !(val instanceof ClassicalExpression)) continue;
                            concatIfRight.addThenStatement(String.valueOf(this.nameProvider.getVariableName((NamedElement)param)) + " = " + classicalExprNames.get(val) + "()");
                        }
                        concatIfRight.addThenStatement(String.valueOf(exprFunctionName) + " = ConcatState.FOLLOWLEFT");
                        if (leftValue instanceof Expression && leftValue != checker.getRecursiveCall()) {
                            concatIfRight.addThenStatement("helper.registerClockToStart(" + this.nameProvider.getClockName((Expression)leftValue) + ")");
                        }
                    } else if (expressionNames.get(rightValue) != null) {
                        concatIfRight.addThenStatement(String.valueOf(expressionNames.get(rightValue)) + ".update(helper)");
                    }
                } else {
                    boolean cfr_ignored_1 = rightValue instanceof Clock;
                }
            } else if (checker.getRecursiveCall() == null || checker.getRecursiveCall() != swCase.getExpression()) {
                List<Expression> subExpressions = this.getExpressionTree(swCase.getExpression(), true, true);
                for (Expression expr : subExpressions) {
                    String exprName = expressionNames.get(expr);
                    caseIfStatement.addThenStatement(String.valueOf(exprName) + ".update(helper)");
                }
                caseIfStatement.addThenStatement(String.valueOf(exprFunctionName) + ".update(helper)");
                IfStatement deadTest = new IfStatement(String.valueOf(exprFunctionName) + ".isDead()");
                caseIfStatement.addThenStatement(deadTest);
                deadTest.addThenStatement("terminate(helper)");
            }
            if (!iter.hasNext()) continue;
            IfStatement elseifStatement = new IfStatement();
            caseIfStatement.addElseStatement(elseifStatement);
            caseIfStatement = elseifStatement;
        }
        if (definition.getDefaultExpression() != null) {
            Expression expression = definition.getDefaultExpression();
            List<Expression> subExpressions = this.getExpressionTree(definition.getDefaultExpression(), true, true);
            for (Expression expr : subExpressions) {
                String exprName = expressionNames.get(expr);
                caseIfStatement.addElseStatement(String.valueOf(exprName) + ".update(helper)");
            }
            caseIfStatement.addElseStatement(String.valueOf(expressionNames.get(expression)) + ".update(helper)");
            IfStatement deadTest = new IfStatement(String.valueOf(expressionNames.get(expression)) + ".isDead()");
            caseIfStatement.addElseStatement(deadTest);
            deadTest.addThenStatement("terminate(helper)");
        }
    }

    private void compileUserExpressionDefinition(UserExpressionDefinition definition, IProject project) throws CoreException {
        Object providerName;
        RecursiveDefinitionChecker checker = new RecursiveDefinitionChecker((ExpressionDefinition)definition);
        String definitionClassName = this.nameProvider.getClassName((NamedElement)definition);
        String definitionClassPackage = this.nameProvider.getPackageName((NamedElement)definition);
        ClassDefinition classDef = new ClassDefinition(definitionClassName, definitionClassPackage);
        classDef.setProject(project);
        classDef.setParentClassName(AbstractRuntimeExpression.class.getSimpleName());
        classDef.addImportedPackage(AbstractRuntimeExpression.class.getName());
        ArrayList<Relation> allRelations = new ArrayList<Relation>();
        for (ConcreteEntity entity : definition.getConcreteEntities()) {
            if (!(entity instanceof Relation)) continue;
            allRelations.add((Relation)entity);
        }
        EqualitySolver<String> equalityRegister = this.definitionClockEqualityAnalysis(allRelations);
        allRelations.clear();
        ArrayList<String> elementNames = new ArrayList<String>();
        ArrayList<String> constraintNames = new ArrayList<String>();
        ArrayList<String> relationNames = new ArrayList<String>();
        ArrayList<String> expressionNames = new ArrayList<String>();
        MemberFunction initFunction = new MemberFunction("init", "void");
        initFunction.addModifier("protected");
        classDef.addMemberFunction(initFunction);
        List<AbstractEntity> nonClockParameters = this.getNonClockParameters(definition);
        this.generateArgumentsPrivateMembers((ExpressionDefinition)definition, classDef, nonClockParameters);
        this.generateExpressionDefinitionConstructor((ExpressionDefinition)definition, definitionClassName, classDef, nonClockParameters);
        classDef.addImportedPackage(String.valueOf(this.nameProvider.clockClassPackage) + "." + this.nameProvider.clockClassName);
        classDef.addImportedPackage(String.valueOf(this.nameProvider.implicitClockPackage) + "." + this.nameProvider.implicitClockClassName);
        for (ClassicalExpression expression : definition.getClassicalExpressions()) {
            ClassicalExpressionCompiler generator = new ClassicalExpressionCompiler(this.parameters, this.pluginHelper, this.nameProvider);
            String fctName = generator.generateClassicalExpression(expression, (NamedElement)definition, classDef);
            String providerTypeName = String.valueOf(ValueProvider.class.getSimpleName()) + "<" + generator.getReturnTypeName() + ">";
            providerName = this.nameProvider.getProviderName((NamedElement)expression);
            MemberVariable providerVariable = new MemberVariable((String)providerName, providerTypeName);
            providerVariable.addModifier("private");
            String initializer = "new " + (String)providerTypeName + "() {";
            initializer = String.valueOf(initializer) + " public " + generator.getReturnTypeName() + " getValue() { ";
            initializer = String.valueOf(initializer) + "return " + fctName + "();";
            initializer = String.valueOf(initializer) + " } }";
            providerVariable.setInitializer(initializer);
            classDef.addMemberVariable(providerVariable);
        }
        String rootExpressionVariable = null;
        ArrayList<ConcreteEntity> relationsAndExpressions = new ArrayList<ConcreteEntity>();
        ArrayList<ConcreteEntity> otherEntities = new ArrayList<ConcreteEntity>();
        for (ConcreteEntity entity : definition.getConcreteEntities()) {
            if (entity instanceof Relation || entity instanceof Expression) {
                relationsAndExpressions.add(entity);
                continue;
            }
            otherEntities.add(entity);
        }
        for (ConcreteEntity entity : otherEntities) {
            if (!(entity instanceof Element)) continue;
            providerName = this.generateElementCode((NamedElement)entity, "private", classDef, true);
        }
        List<ConcreteEntity> entitiesBuildOrder = this.getBuildOrder(relationsAndExpressions);
        for (ConcreteEntity entity : entitiesBuildOrder) {
            Object expressionVarName;
            if (entity instanceof Relation) {
                String relationVarName = this.generateRelationCode((NamedElement)definition, (Relation)entity, classDef, project);
                constraintNames.add(relationVarName);
                relationNames.add(relationVarName);
                initFunction.addStatement(String.valueOf(relationVarName) + ".setParent(this)");
                continue;
            }
            if (!(entity instanceof Expression)) continue;
            if (entity == definition.getRootExpression()) {
                expressionVarName = this.generateExpressionCode((NamedElement)definition, (Expression)entity, true, project, classDef);
                rootExpressionVariable = expressionVarName;
            } else {
                String clockVariableName = this.nameProvider.getClockName((Expression)entity);
                String clockName = entity.getName();
                this.generateDiscreteClockCode(clockVariableName, clockName, this.nameProvider.implicitClockClassName, this.nameProvider.implicitClockPackage, "public", classDef, initFunction, elementNames, equalityRegister, null);
                elementNames.add(clockVariableName);
                expressionVarName = this.generateExpressionCode((NamedElement)definition, (Expression)entity, false, project, classDef);
            }
            constraintNames.add((String)expressionVarName);
            expressionNames.add((String)expressionVarName);
            initFunction.addStatement(String.valueOf(expressionVarName) + ".setParent(this)");
        }
        if (rootExpressionVariable != null) {
            MemberFunction getRootFunction = new MemberFunction("getRootExpression");
            getRootFunction.addModifier("public");
            getRootFunction.setReturnType(AbstractRuntimeExpression.class.getSimpleName());
            getRootFunction.addStatement("return " + rootExpressionVariable);
            classDef.addMemberFunction(getRootFunction);
        }
        MemberFunction startFunction = new MemberFunction("start", "void");
        startFunction.setOverrides(true);
        startFunction.addModifier("public");
        startFunction.addException(SimulationException.class.getSimpleName());
        startFunction.addParameter(AbstractSemanticHelper.class.getSimpleName(), "helper");
        startFunction.addStatement(new IfStatement(" ! canCallStart()").addThenStatement("return"));
        startFunction.addStatement("super.start(helper)");
        for (AbstractEntity parameter : nonClockParameters) {
            String providerVar = this.nameProvider.getProviderName((NamedElement)parameter);
            String parameterVar = this.nameProvider.getVariableName((NamedElement)parameter);
            startFunction.addStatement(new IfStatement(String.valueOf(providerVar) + " != null").addThenStatement(String.valueOf(parameterVar) + " = " + (String)providerVar + ".getValue()"));
        }
        startFunction.addStatement("getRootExpression().start(helper)");
        for (String relationName : relationNames) {
            startFunction.addStatement(String.valueOf(relationName) + ".start(helper)");
        }
        classDef.addMemberFunction(startFunction);
        classDef.addImportedPackage(AbstractSemanticHelper.class.getName());
        classDef.addImportedPackage(SimulationException.class.getName());
        MemberFunction semanticFunction = new MemberFunction("semantic", "void");
        semanticFunction.setOverrides(true);
        semanticFunction.addModifier("public");
        semanticFunction.addException(SimulationException.class.getSimpleName());
        semanticFunction.addParameter(AbstractSemanticHelper.class.getSimpleName(), "helper");
        semanticFunction.addStatement(new IfStatement(" ! canCallSemantic()").addThenStatement("return"));
        semanticFunction.addStatement("super.semantic(helper)");
        semanticFunction.addStatement("getRootExpression().semantic(helper)");
        for (String relationName : relationNames) {
            semanticFunction.addStatement(String.valueOf(relationName) + ".semantic(helper)");
        }
        classDef.addMemberFunction(semanticFunction);
        classDef.addImportedPackage(AbstractSemanticHelper.class.getName());
        MemberFunction updateFunction = new MemberFunction("update", "void");
        updateFunction.setOverrides(true);
        updateFunction.addModifier("public");
        updateFunction.addException(SimulationException.class.getSimpleName());
        updateFunction.addParameter(AbstractUpdateHelper.class.getSimpleName(), "helper");
        updateFunction.addStatement(new IfStatement(" ! canCallUpdate()").addThenStatement("return"));
        updateFunction.addStatement("super.update(helper)");
        updateFunction.addStatement("getRootExpression().update(helper)");
        for (String relationName : relationNames) {
            updateFunction.addStatement(String.valueOf(relationName) + ".update(helper)");
        }
        classDef.addMemberFunction(updateFunction);
        classDef.addImportedPackage(AbstractUpdateHelper.class.getName());
        classDef.generate(this.pluginHelper);
    }

    private List<AbstractEntity> getNonClockParameters(UserRelationDefinition definition) {
        RelationDeclaration declaration = definition.getDeclaration();
        return this.getNonClockParameters((List<AbstractEntity>)declaration.getParameters());
    }

    private List<AbstractEntity> getNonClockParameters(UserExpressionDefinition definition) {
        ExpressionDeclaration declaration = definition.getDeclaration();
        return this.getNonClockParameters((List<AbstractEntity>)declaration.getParameters());
    }

    private List<AbstractEntity> getNonClockParameters(List<AbstractEntity> parameters) {
        ArrayList<AbstractEntity> res = new ArrayList<AbstractEntity>();
        for (AbstractEntity parameter : parameters) {
            Type type = parameter.getType();
            if (type instanceof DiscreteClockType) continue;
            res.add(parameter);
        }
        return res;
    }

    private List<AbstractEntity> getKernelExpressionParameters(KernelExpressionDeclaration declaration) {
        ExpressionParametersBuilder selector = new ExpressionParametersBuilder();
        return (List)selector.doSwitch((EObject)declaration);
    }

    private class ElementCodeGenerator
    extends BasicTypeSwitch<String> {
        private ClassDefinition enclosingClass;
        private String modifiers;

        public ElementCodeGenerator(ClassDefinition enclosingClass, String modifiers) {
            this.enclosingClass = enclosingClass;
            this.modifiers = modifiers;
        }

        public String caseSequenceElement(SequenceElement object) {
            PrimitiveElement elt;
            Iterator iter;
            StringBuilder initializer;
            String initializerName;
            String variableName = Compiler.this.nameProvider.getVariableName((NamedElement)object);
            String sequenceClassName = Compiler.this.nameProvider.getJavaClass((NamedElement)object).getSimpleName();
            SequenceType seqType = (SequenceType)object.getType();
            String elementClassName = seqType == null ? "Integer" : Compiler.this.nameProvider.getClassName((NamedElement)seqType.getElementType());
            String fullTypeName = String.valueOf(sequenceClassName) + "<" + elementClassName + ">";
            MemberVariable variable = new MemberVariable(variableName, fullTypeName);
            variable.addModifier(this.modifiers);
            variable.setInitializer("new " + fullTypeName + "()");
            MemberFunction initFunction = this.enclosingClass.getMemberFunction("init");
            if (object.getFinitePart() != null && !object.getFinitePart().isEmpty()) {
                initializerName = Compiler.this.nameProvider.genSym();
                initializer = new StringBuilder();
                initializer.append(String.valueOf(elementClassName) + " " + initializerName + "[]");
                initializer.append(" = { ");
                iter = object.getFinitePart().iterator();
                while (iter.hasNext()) {
                    elt = (PrimitiveElement)iter.next();
                    initializer.append(Compiler.this.getRepresentation(elt));
                    if (!iter.hasNext()) continue;
                    initializer.append(", ");
                }
                initializer.append(" }");
                initFunction.addStatement(initializer.toString());
                initFunction.addStatement(String.valueOf(variableName) + ".setFinitePart(" + initializerName + ")");
            }
            if (object.getNonFinitePart() != null && !object.getNonFinitePart().isEmpty()) {
                initializerName = Compiler.this.nameProvider.genSym();
                initializer = new StringBuilder();
                initializer.append(String.valueOf(elementClassName) + " " + initializerName + "[]");
                initializer.append(" = { ");
                iter = object.getNonFinitePart().iterator();
                while (iter.hasNext()) {
                    elt = (PrimitiveElement)iter.next();
                    initializer.append(Compiler.this.getRepresentation(elt));
                    if (!iter.hasNext()) continue;
                    initializer.append(", ");
                }
                initializer.append(" }");
                initFunction.addStatement(initializer.toString());
                initFunction.addStatement(String.valueOf(variableName) + ".setInfinitePart(" + initializerName + ")");
            }
            this.enclosingClass.addMemberVariable(variable);
            this.enclosingClass.addImportedPackage(Compiler.this.nameProvider.getJavaClass((NamedElement)object).getName());
            return variableName;
        }

        public String caseIntegerElement(IntegerElement object) {
            String variableName = Compiler.this.nameProvider.getVariableName((NamedElement)object);
            MemberVariable variable = new MemberVariable(variableName, "Integer");
            variable.addModifier(this.modifiers);
            variable.setInitializer(object.getValue().toString());
            this.enclosingClass.addMemberVariable(variable);
            return variableName;
        }

        public String caseRealElement(RealElement object) {
            String variableName = Compiler.this.nameProvider.getVariableName((NamedElement)object);
            MemberVariable variable = new MemberVariable(variableName, "Float");
            variable.addModifier(this.modifiers);
            variable.setInitializer(object.getValue().toString());
            this.enclosingClass.addMemberVariable(variable);
            return variableName;
        }
    }

    private final class ExpressionParametersBuilder
    extends KernelExpressionSwitch<List<AbstractEntity>> {
        private ExpressionParametersBuilder() {
        }

        public List<AbstractEntity> caseUnion(Union object) {
            ArrayList<AbstractEntity> params = new ArrayList<AbstractEntity>();
            params.add(object.getClock1());
            params.add(object.getClock2());
            return params;
        }

        public List<AbstractEntity> caseDefer(Defer object) {
            ArrayList<AbstractEntity> params = new ArrayList<AbstractEntity>();
            params.add(object.getBaseClock());
            params.add(object.getDelayClock());
            params.add(object.getDelayPattern());
            return params;
        }

        public List<AbstractEntity> caseInf(Inf object) {
            ArrayList<AbstractEntity> params = new ArrayList<AbstractEntity>();
            params.add(object.getClock1());
            params.add(object.getClock2());
            return params;
        }

        public List<AbstractEntity> caseSup(Sup object) {
            ArrayList<AbstractEntity> params = new ArrayList<AbstractEntity>();
            params.add(object.getClock1());
            params.add(object.getClock2());
            return params;
        }

        public List<AbstractEntity> caseIntersection(Intersection object) {
            ArrayList<AbstractEntity> params = new ArrayList<AbstractEntity>();
            params.add(object.getClock1());
            params.add(object.getClock2());
            return params;
        }

        public List<AbstractEntity> caseUpTo(UpTo object) {
            ArrayList<AbstractEntity> params = new ArrayList<AbstractEntity>();
            params.add(object.getClockToFollow());
            params.add(object.getKillerClock());
            return params;
        }

        public List<AbstractEntity> caseConcatenation(Concatenation object) {
            ArrayList<AbstractEntity> params = new ArrayList<AbstractEntity>();
            params.add(object.getLeftClock());
            params.add(object.getRightClock());
            return params;
        }

        public List<AbstractEntity> caseWait(Wait object) {
            ArrayList<AbstractEntity> params = new ArrayList<AbstractEntity>();
            params.add(object.getWaitingClock());
            params.add(object.getWaitingValue());
            return params;
        }

        public List<AbstractEntity> caseNonStrictSampling(NonStrictSampling object) {
            ArrayList<AbstractEntity> params = new ArrayList<AbstractEntity>();
            params.add(object.getSampledClock());
            params.add(object.getSamplingClock());
            return params;
        }

        public List<AbstractEntity> caseStrictSampling(StrictSampling object) {
            ArrayList<AbstractEntity> params = new ArrayList<AbstractEntity>();
            params.add(object.getSampledClock());
            params.add(object.getSamplingClock());
            return params;
        }

        public List<AbstractEntity> caseDiscretization(Discretization object) {
            ArrayList<AbstractEntity> params = new ArrayList<AbstractEntity>();
            params.add(object.getDenseClock());
            params.add(object.getDiscretizationFactor());
            return params;
        }

        public List<AbstractEntity> caseDeath(Death object) {
            return new ArrayList<AbstractEntity>();
        }
    }

    private class InlineConcatenationGenerator {
        private Expression expression;
        private ClassDefinition classDefinition;
        private MemberFunction initFunction;
        private String concatStateVariable;
        private String concatClockName;

        public InlineConcatenationGenerator(Expression expression, ClassDefinition classDefinition, MemberFunction initFunction) {
            this.expression = expression;
            this.classDefinition = classDefinition;
            this.initFunction = initFunction;
        }

        public String generate() {
            this.classDefinition.addImportedPackage(RuntimeConcatenation.class.getName());
            this.classDefinition.addImportedPackage(String.valueOf(RuntimeConcatenation.class.getName()) + ".ConcatState");
            this.concatStateVariable = String.valueOf(Compiler.this.nameProvider.getVariableName((NamedElement)this.expression)) + "ConcatState";
            String concatStateVariableType = RuntimeConcatenation.ConcatState.class.getSimpleName();
            MemberVariable variable = new MemberVariable(this.concatStateVariable, concatStateVariableType);
            variable.addModifier("public");
            this.classDefinition.addMemberVariable(variable);
            this.classDefinition.addImportedPackage(RuntimeClock.class.getName());
            this.concatClockName = Compiler.this.nameProvider.getClockName(this.expression);
            MemberVariable clockVar = new MemberVariable(this.concatClockName, RuntimeClock.class.getSimpleName());
            clockVar.addModifier("public");
            this.classDefinition.addMemberVariable(clockVar);
            clockVar.setInitializer("new " + RuntimeClock.class.getSimpleName() + "(\"" + this.concatClockName + "\")");
            this.initFunction.addStatement(String.valueOf(this.concatClockName) + ".setDense(false)");
            this.initFunction.addStatement(String.valueOf(this.concatClockName) + ".setParent(this)");
            this.initFunction.addStatement(String.valueOf(this.concatClockName) + ".bddVariableNumber = BDDHelper.newBDDVariableNumber()");
            return this.concatStateVariable;
        }
    }
}

