/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.utils.extensionpoint;

import fr.inria.aoste.timesquare.utils.extensionpoint.Activator;
import fr.inria.aoste.timesquare.utils.extensionpoint.IExtensionManager;
import java.util.ArrayList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Bundle;

public final class ExtensionPointManager {
    private static ArrayList<IStatus> liststatus = new ArrayList();

    public static <T> Class<? extends T> getPointExtensionClass(IConfigurationElement ice, String namefield, Class<T> cbase) throws Throwable {
        String classname = ice.getAttribute(namefield);
        if (classname == null) {
            throw new NullPointerException("flag :" + namefield + ": Class name is null");
        }
        String plugin = ExtensionPointManager.getPluginName(ice);
        Bundle b = Platform.getBundle((String)plugin);
        Class c = b.loadClass(classname);
        if (c == null) {
            throw new NullPointerException("flag :" + namefield + ": cannot load the class " + classname + " from plugin " + plugin);
        }
        if (!cbase.isAssignableFrom(c)) {
            throw new ClassCastException("flag :" + namefield + ": " + classname + "cannot cast to " + c.getName());
        }
        return c.asSubclass(cbase);
    }

    public static String getPluginName(IConfigurationElement ice) {
        String s = ice.getDeclaringExtension().getContributor().getName();
        return s;
    }

    public static void findAllExtensions(IExtensionManager extensionManager) {
        IConfigurationElement[] extensions;
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IExtensionPoint iep = reg.getExtensionPoint(extensionManager.getExtensionPointName());
        if (iep == null) {
            throw new Error("not found " + extensionManager.getExtensionPointName() + " id for Point Extention Manager");
        }
        IConfigurationElement[] iConfigurationElementArray = extensions = iep.getConfigurationElements();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ice = iConfigurationElementArray[n2];
            try {
                extensionManager.initExtension(ice);
            }
            catch (Throwable e) {
                System.err.println(ice + " failed ");
                ExtensionPointManager.addException(e, ice + "Failed", extensionManager.getPluginName());
            }
            ++n2;
        }
        if (liststatus.size() != 0) {
            MultiStatus mst = new MultiStatus(extensionManager.getPluginName(), 4, liststatus.toArray(new IStatus[liststatus.size()]), "Error on Point Extension Manager :\"" + extensionManager.getExtensionPointName() + "\" init", null);
            Activator.getDefault().getLog().log((IStatus)mst);
        }
    }

    private static final void addException(Throwable e, String message, String pluginName) {
        if (message == null) {
            message = e != null ? e.getMessage() : "UK";
        } else {
            if (e == null) {
                e = new Exception("null exception");
            }
            if (e.getMessage() != null) {
                message = String.valueOf(message) + e;
            }
        }
        liststatus.add((IStatus)new Status(4, pluginName, message, e));
    }
}

