/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.diverse.k3.ui.xtend.ide.support;

import com.google.inject.Injector;
import fr.inria.diverse.k3.ui.Activator;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IExecutableExtensionFactory;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.xtend.ide.internal.XtendActivator;
import org.osgi.framework.Bundle;

public class K3XtendExecutableExtensionFactory
implements IExecutableExtensionFactory,
IExecutableExtension {
    public static final String GUICEKEY = "guicekey";
    protected String clazzName;
    protected IConfigurationElement config;

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        if (data instanceof String) {
            this.clazzName = (String)data;
        } else if (data instanceof Map) {
            this.clazzName = (String)((Map)data).get(GUICEKEY);
        }
        if (this.clazzName == null) {
            throw new IllegalArgumentException("couldn't handle passed data : " + data);
        }
        this.config = config;
    }

    public Object create() throws CoreException {
        try {
            Class clazz = this.getBundle().loadClass(this.clazzName);
            Injector injector = this.getInjector();
            Object result = injector.getInstance(clazz);
            if (result instanceof IExecutableExtension) {
                ((IExecutableExtension)result).setInitializationData(this.config, null, null);
            }
            return result;
        }
        catch (Exception e) {
            Activator.logErrorMessage(e.getMessage(), e);
            throw new CoreException((IStatus)new Status(4, this.getBundle().getSymbolicName(), String.valueOf(e.getMessage()) + " ExtensionFactory: " + this.getClass().getName(), (Throwable)e));
        }
    }

    protected Bundle getBundle() {
        return Activator.getDefault().getBundle();
    }

    protected Injector getInjector() {
        return XtendActivator.getInstance().getInjector("org.eclipse.xtend.core.Xtend");
    }
}

