/**
 * Copyright (c) 2017 Inria and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Inria - initial API and implementation
 */
package fr.inria.diverse.melange.jvmmodel;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import fr.inria.diverse.melange.adapters.EListAdapter;
import fr.inria.diverse.melange.adapters.EObjectAdapter;
import fr.inria.diverse.melange.ast.AspectExtensions;
import fr.inria.diverse.melange.ast.LanguageExtensions;
import fr.inria.diverse.melange.ast.ModelingElementExtensions;
import fr.inria.diverse.melange.ast.NamingHelper;
import fr.inria.diverse.melange.jvmmodel.JvmModelInferrerHelper;
import fr.inria.diverse.melange.jvmmodel.MelangeTypesBuilder;
import fr.inria.diverse.melange.lib.EcoreExtensions;
import fr.inria.diverse.melange.lib.MappingExtensions;
import fr.inria.diverse.melange.metamodel.melange.Aspect;
import fr.inria.diverse.melange.metamodel.melange.Mapping;
import fr.inria.diverse.melange.metamodel.melange.Metamodel;
import fr.inria.diverse.melange.metamodel.melange.ModelType;
import fr.inria.diverse.melange.utils.AspectToEcore;
import fr.inria.diverse.melange.utils.TypeReferencesHelper;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.emf.codegen.ecore.genmodel.GenClass;
import org.eclipse.emf.codegen.ecore.genmodel.GenFeature;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypeParameter;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.common.types.JvmAnnotationReference;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeConstraint;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeParameterDeclarator;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmUpperBound;
import org.eclipse.xtext.common.types.JvmVisibility;
import org.eclipse.xtext.common.types.TypesFactory;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.util.internal.Stopwatches;
import org.eclipse.xtext.xbase.jvmmodel.IJvmDeclaredTypeAcceptor;
import org.eclipse.xtext.xbase.jvmmodel.JvmAnnotationReferenceBuilder;
import org.eclipse.xtext.xbase.jvmmodel.JvmTypeReferenceBuilder;
import org.eclipse.xtext.xbase.jvmmodel.JvmTypesBuilder;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure2;

/**
 * Generates a Java adapter for a given {@link EClass} in a pair (MM, MT)
 * where MM implements (<#) MT.
 */
@SuppressWarnings("all")
public class MetaclassAdapterInferrer {
  @Inject
  @Extension
  private JvmModelInferrerHelper _jvmModelInferrerHelper;
  
  @Inject
  @Extension
  private JvmTypesBuilder _jvmTypesBuilder;
  
  @Inject
  @Extension
  private NamingHelper _namingHelper;
  
  @Inject
  @Extension
  private AspectExtensions _aspectExtensions;
  
  @Inject
  @Extension
  private ModelingElementExtensions _modelingElementExtensions;
  
  @Inject
  @Extension
  private LanguageExtensions _languageExtensions;
  
  @Inject
  @Extension
  private EcoreExtensions _ecoreExtensions;
  
  @Inject
  @Extension
  private AspectToEcore _aspectToEcore;
  
  @Inject
  @Extension
  private MelangeTypesBuilder _melangeTypesBuilder;
  
  @Inject
  @Extension
  private TypeReferencesHelper _typeReferencesHelper;
  
  @Inject
  @Extension
  private JvmAnnotationReferenceBuilder.Factory jvmAnnRefBuilderFact;
  
  @Inject
  @Extension
  private MappingExtensions _mappingExtensions;
  
  @Inject
  @Extension
  private IQualifiedNameProvider _iQualifiedNameProvider;
  
  @Extension
  private JvmAnnotationReferenceBuilder jvmAnnRefBuilder;
  
  @Extension
  private JvmTypeReferenceBuilder typeRefBuilder;
  
  /**
   * Generates the appropriate Java adapter between {@code mm} and {@code mt}
   * for the {@link EClass} {@code cls}. The adapter essentially implements
   * the methods defined in the interface materialized by {@code mt} and
   * delegates the implementation to the corresponding meta-class in the
   * implementing {@link Metamodel} {@code mm}.
   * 
   * @see EObjectAdapter
   */
  public void generateAdapter(final Metamodel mm, final ModelType superType, final EClass cls, final IJvmDeclaredTypeAcceptor acceptor, @Extension final JvmTypeReferenceBuilder builder) {
    final Stopwatches.StoppedTask task = Stopwatches.forTask("generate metaclass adapters");
    task.start();
    this.typeRefBuilder = builder;
    this.jvmAnnRefBuilder = this.jvmAnnRefBuilderFact.create(mm.eResource().getResourceSet());
    final Function1<Mapping, Boolean> _function = new Function1<Mapping, Boolean>() {
      @Override
      public Boolean apply(final Mapping it) {
        ModelType _to = it.getTo();
        return Boolean.valueOf(Objects.equal(_to, superType));
      }
    };
    final Mapping mapping = IterableExtensions.<Mapping>findFirst(mm.getOwningLanguage().getMappings(), _function);
    final Function1<EClass, Boolean> _function_1 = new Function1<EClass, Boolean>() {
      @Override
      public Boolean apply(final EClass it) {
        return Boolean.valueOf(MetaclassAdapterInferrer.this._mappingExtensions.namesMatch(mapping, it, cls));
      }
    };
    final EClass mmCls = IterableExtensions.<EClass>findFirst(this._modelingElementExtensions.getAllClasses(mm), _function_1);
    final Procedure1<JvmGenericType> _function_2 = new Procedure1<JvmGenericType>() {
      @Override
      public void apply(final JvmGenericType jvmCls) {
        final Consumer<ETypeParameter> _function = new Consumer<ETypeParameter>() {
          @Override
          public void accept(final ETypeParameter p) {
            EList<JvmTypeParameter> _typeParameters = jvmCls.getTypeParameters();
            JvmTypeParameter _createJvmTypeParameter = TypesFactory.eINSTANCE.createJvmTypeParameter();
            final Procedure1<JvmTypeParameter> _function = new Procedure1<JvmTypeParameter>() {
              @Override
              public void apply(final JvmTypeParameter it) {
                it.setName(p.getName());
              }
            };
            JvmTypeParameter _doubleArrow = ObjectExtensions.<JvmTypeParameter>operator_doubleArrow(_createJvmTypeParameter, _function);
            MetaclassAdapterInferrer.this._jvmTypesBuilder.<JvmTypeParameter>operator_add(_typeParameters, _doubleArrow);
          }
        };
        cls.getETypeParameters().forEach(_function);
        EList<JvmTypeReference> _superTypes = jvmCls.getSuperTypes();
        JvmTypeReference _typeRef = builder.typeRef(EObjectAdapter.class, MetaclassAdapterInferrer.this._melangeTypesBuilder.typeRef(mm, mmCls, Collections.<JvmGenericType>unmodifiableList(CollectionLiterals.<JvmGenericType>newArrayList(jvmCls))));
        MetaclassAdapterInferrer.this._jvmTypesBuilder.<JvmTypeReference>operator_add(_superTypes, _typeRef);
        EList<JvmTypeReference> _superTypes_1 = jvmCls.getSuperTypes();
        JvmTypeReference _typeRef_1 = MetaclassAdapterInferrer.this._melangeTypesBuilder.typeRef(superType, cls, Collections.<JvmGenericType>unmodifiableList(CollectionLiterals.<JvmGenericType>newArrayList(jvmCls)));
        MetaclassAdapterInferrer.this._jvmTypesBuilder.<JvmTypeReference>operator_add(_superTypes_1, _typeRef_1);
        final Consumer<EGenericType> _function_1 = new Consumer<EGenericType>() {
          @Override
          public void accept(final EGenericType sup) {
          }
        };
        cls.getEGenericSuperTypes().forEach(_function_1);
        final String adaptersFactoryFqn = MetaclassAdapterInferrer.this._namingHelper.getAdaptersFactoryNameFor(mm, superType);
        EList<JvmMember> _members = jvmCls.getMembers();
        JvmField _field = MetaclassAdapterInferrer.this._jvmTypesBuilder.toField(mm, "adaptersFactory", builder.typeRef(adaptersFactoryFqn));
        MetaclassAdapterInferrer.this._jvmTypesBuilder.<JvmField>operator_add(_members, _field);
        EList<JvmMember> _members_1 = jvmCls.getMembers();
        final Procedure1<JvmConstructor> _function_2 = new Procedure1<JvmConstructor>() {
          @Override
          public void apply(final JvmConstructor it) {
            StringConcatenationClient _client = new StringConcatenationClient() {
              @Override
              protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append("super(");
                _builder.append(adaptersFactoryFqn);
                _builder.append(".getInstance());");
                _builder.newLineIfNotEmpty();
                _builder.append("adaptersFactory = ");
                _builder.append(adaptersFactoryFqn);
                _builder.append(".getInstance();");
                _builder.newLineIfNotEmpty();
              }
            };
            MetaclassAdapterInferrer.this._jvmTypesBuilder.setBody(it, _client);
          }
        };
        JvmConstructor _constructor = MetaclassAdapterInferrer.this._jvmTypesBuilder.toConstructor(mm, _function_2);
        MetaclassAdapterInferrer.this._jvmTypesBuilder.<JvmConstructor>operator_add(_members_1, _constructor);
        final Function1<EAttribute, Boolean> _function_3 = new Function1<EAttribute, Boolean>() {
          @Override
          public Boolean apply(final EAttribute it) {
            boolean _isAspectSpecific = MetaclassAdapterInferrer.this._ecoreExtensions.isAspectSpecific(it);
            return Boolean.valueOf((!_isAspectSpecific));
          }
        };
        final Consumer<EAttribute> _function_4 = new Consumer<EAttribute>() {
          @Override
          public void accept(final EAttribute it) {
            MetaclassAdapterInferrer.this.processAttribute(it, mmCls, mm, superType, mapping, jvmCls);
          }
        };
        IterableExtensions.<EAttribute>filter(cls.getEAllAttributes(), _function_3).forEach(_function_4);
        final Function1<EReference, Boolean> _function_5 = new Function1<EReference, Boolean>() {
          @Override
          public Boolean apply(final EReference it) {
            boolean _isAspectSpecific = MetaclassAdapterInferrer.this._ecoreExtensions.isAspectSpecific(it);
            return Boolean.valueOf((!_isAspectSpecific));
          }
        };
        final Consumer<EReference> _function_6 = new Consumer<EReference>() {
          @Override
          public void accept(final EReference it) {
            MetaclassAdapterInferrer.this.processReference(it, mmCls, mm, superType, mapping, jvmCls);
          }
        };
        IterableExtensions.<EReference>filter(cls.getEAllReferences(), _function_5).forEach(_function_6);
        final Function1<EOperation, Boolean> _function_7 = new Function1<EOperation, Boolean>() {
          @Override
          public Boolean apply(final EOperation it) {
            return Boolean.valueOf(((!MetaclassAdapterInferrer.this._ecoreExtensions.hasSuppressedVisibility(it)) && (!MetaclassAdapterInferrer.this._ecoreExtensions.isAspectSpecific(it))));
          }
        };
        final Consumer<EOperation> _function_8 = new Consumer<EOperation>() {
          @Override
          public void accept(final EOperation it) {
            MetaclassAdapterInferrer.this.processOperation(it, mm, superType, jvmCls);
          }
        };
        IterableExtensions.<EOperation>filter(MetaclassAdapterInferrer.this._ecoreExtensions.sortByOverridingPriority(cls.getEAllOperations()), _function_7).forEach(_function_8);
        final Consumer<Aspect> _function_9 = new Consumer<Aspect>() {
          @Override
          public void accept(final Aspect it) {
            MetaclassAdapterInferrer.this.processAspect(it, mm, superType, jvmCls);
          }
        };
        MetaclassAdapterInferrer.this._aspectExtensions.sortByOverridingPriority(MetaclassAdapterInferrer.this._languageExtensions.findAspectsOn(mm.getOwningLanguage(), cls)).forEach(_function_9);
        MetaclassAdapterInferrer.this.processReflectiveLayer(cls, mm, superType, jvmCls);
      }
    };
    acceptor.<JvmGenericType>accept(this._jvmTypesBuilder.toClass(mm, this._namingHelper.adapterNameFor(mm, superType, cls)), _function_2);
    task.stop();
  }
  
  /**
   * Creates accessors/mutators for the {@link EAttribute} {@code attr}
   * and adds them to the currently generated {@code jvmCls}
   */
  private void processAttribute(final EAttribute attr, final EClass mmCls, final Metamodel mm, final ModelType superType, final Mapping mapping, final JvmGenericType jvmCls) {
    final JvmTypeReference attrType = this._melangeTypesBuilder.typeRef(superType, attr, Collections.<JvmGenericType>unmodifiableList(CollectionLiterals.<JvmGenericType>newArrayList(jvmCls)));
    final EStructuralFeature mmAttr = this._mappingExtensions.findCorrespondingFeature(mapping, mmCls, attr);
    EList<JvmMember> _members = jvmCls.getMembers();
    final Procedure1<JvmOperation> _function = new Procedure1<JvmOperation>() {
      @Override
      public void apply(final JvmOperation it) {
        EList<JvmAnnotationReference> _annotations = it.getAnnotations();
        JvmAnnotationReference _annotationRef = MetaclassAdapterInferrer.this.jvmAnnRefBuilder.annotationRef(Override.class);
        MetaclassAdapterInferrer.this._jvmTypesBuilder.<JvmAnnotationReference>operator_add(_annotations, _annotationRef);
        EClassifier _eType = attr.getEType();
        if ((_eType instanceof EEnum)) {
          StringConcatenationClient _client = new StringConcatenationClient() {
            @Override
            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
              _builder.append("return ");
              String _fqnFor = MetaclassAdapterInferrer.this._namingHelper.getFqnFor(superType, attr.getEType());
              _builder.append(_fqnFor);
              _builder.append(".get(adaptee.");
              String _getterName = MetaclassAdapterInferrer.this._namingHelper.getGetterName(mmAttr);
              _builder.append(_getterName);
              _builder.append("().getValue());");
              _builder.newLineIfNotEmpty();
            }
          };
          MetaclassAdapterInferrer.this._jvmTypesBuilder.setBody(it, _client);
        } else {
          StringConcatenationClient _client_1 = new StringConcatenationClient() {
            @Override
            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
              _builder.append("return adaptee.");
              String _getterName = MetaclassAdapterInferrer.this._namingHelper.getGetterName(mmAttr);
              _builder.append(_getterName);
              _builder.append("();");
              _builder.newLineIfNotEmpty();
            }
          };
          MetaclassAdapterInferrer.this._jvmTypesBuilder.setBody(it, _client_1);
        }
      }
    };
    JvmOperation _method = this._jvmTypesBuilder.toMethod(mm, this._namingHelper.getGetterName(attr), attrType, _function);
    this._jvmTypesBuilder.<JvmOperation>operator_add(_members, _method);
    boolean _needsSetterImplementation = this._ecoreExtensions.needsSetterImplementation(attr);
    if (_needsSetterImplementation) {
      EList<JvmMember> _members_1 = jvmCls.getMembers();
      final Procedure1<JvmOperation> _function_1 = new Procedure1<JvmOperation>() {
        @Override
        public void apply(final JvmOperation it) {
          boolean _needsSetterInterface = MetaclassAdapterInferrer.this._ecoreExtensions.needsSetterInterface(attr);
          if (_needsSetterInterface) {
            EList<JvmAnnotationReference> _annotations = it.getAnnotations();
            JvmAnnotationReference _annotationRef = MetaclassAdapterInferrer.this.jvmAnnRefBuilder.annotationRef(Override.class);
            MetaclassAdapterInferrer.this._jvmTypesBuilder.<JvmAnnotationReference>operator_add(_annotations, _annotationRef);
          }
          EList<JvmFormalParameter> _parameters = it.getParameters();
          JvmFormalParameter _parameter = MetaclassAdapterInferrer.this._jvmTypesBuilder.toParameter(mm, "o", attrType);
          MetaclassAdapterInferrer.this._jvmTypesBuilder.<JvmFormalParameter>operator_add(_parameters, _parameter);
          EClassifier _eType = attr.getEType();
          if ((_eType instanceof EEnum)) {
            StringConcatenationClient _client = new StringConcatenationClient() {
              @Override
              protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append("adaptee.");
                String _setterName = MetaclassAdapterInferrer.this._namingHelper.getSetterName(mmAttr);
                _builder.append(_setterName);
                _builder.append("(");
                String _fqnFor = MetaclassAdapterInferrer.this._namingHelper.getFqnFor(mm, attr.getEType());
                _builder.append(_fqnFor);
                _builder.append(".get(o.getValue()));");
                _builder.newLineIfNotEmpty();
              }
            };
            MetaclassAdapterInferrer.this._jvmTypesBuilder.setBody(it, _client);
          } else {
            StringConcatenationClient _client_1 = new StringConcatenationClient() {
              @Override
              protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append("adaptee.");
                String _setterName = MetaclassAdapterInferrer.this._namingHelper.getSetterName(mmAttr);
                _builder.append(_setterName);
                _builder.append("(o);");
                _builder.newLineIfNotEmpty();
              }
            };
            MetaclassAdapterInferrer.this._jvmTypesBuilder.setBody(it, _client_1);
          }
        }
      };
      JvmOperation _method_1 = this._jvmTypesBuilder.toMethod(mm, this._namingHelper.getSetterName(attr), this.typeRefBuilder.typeRef(Void.TYPE), _function_1);
      this._jvmTypesBuilder.<JvmOperation>operator_add(_members_1, _method_1);
    }
    boolean _needsUnsetterImplementation = this._ecoreExtensions.needsUnsetterImplementation(attr);
    if (_needsUnsetterImplementation) {
      EList<JvmMember> _members_2 = jvmCls.getMembers();
      JvmOperation _unsetter = this._jvmModelInferrerHelper.toUnsetter(mm, attr, mm);
      this._jvmTypesBuilder.<JvmOperation>operator_add(_members_2, _unsetter);
    }
    boolean _needsUnsetterCheckerImplementation = this._ecoreExtensions.needsUnsetterCheckerImplementation(attr);
    if (_needsUnsetterCheckerImplementation) {
      EList<JvmMember> _members_3 = jvmCls.getMembers();
      JvmOperation _unsetterCheck = this._jvmModelInferrerHelper.toUnsetterCheck(mm, attr, mm);
      this._jvmTypesBuilder.<JvmOperation>operator_add(_members_3, _unsetterCheck);
    }
  }
  
  /**
   * Creates accessors/mutators for the {@link EReference} {@code ref}
   * and adds them to the currently generated {@code jvmCls}
   */
  private void processReference(final EReference ref, final EClass mmCls, final Metamodel mm, final ModelType superType, final Mapping mapping, final JvmGenericType jvmCls) {
    final JvmTypeReference refType = this._melangeTypesBuilder.typeRef(superType, ref, Collections.<JvmGenericType>unmodifiableList(CollectionLiterals.<JvmGenericType>newArrayList(jvmCls)));
    final EStructuralFeature mmRef = this._mappingExtensions.findCorrespondingFeature(mapping, mmCls, ref);
    final String adapName = this._namingHelper.adapterNameFor(mm, superType, ref.getEReferenceType());
    boolean _isEMFMapDetails = this._ecoreExtensions.isEMFMapDetails(ref);
    if (_isEMFMapDetails) {
      final JvmTypeReference eMapTypeRef = this.typeRefBuilder.typeRef(EMap.class, this.typeRefBuilder.typeRef(String.class), this.typeRefBuilder.typeRef(String.class));
      EList<JvmMember> _members = jvmCls.getMembers();
      final Procedure1<JvmOperation> _function = new Procedure1<JvmOperation>() {
        @Override
        public void apply(final JvmOperation it) {
          StringConcatenationClient _client = new StringConcatenationClient() {
            @Override
            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
              _builder.append("return adaptee.getDetails();");
            }
          };
          MetaclassAdapterInferrer.this._jvmTypesBuilder.setBody(it, _client);
        }
      };
      JvmOperation _method = this._jvmTypesBuilder.toMethod(mm, "getDetails", eMapTypeRef, _function);
      this._jvmTypesBuilder.<JvmOperation>operator_add(_members, _method);
    } else {
      String _name = ref.getName();
      final String refFieldName = (_name + "_");
      boolean _isMany = ref.isMany();
      if (_isMany) {
        EList<JvmMember> _members_1 = jvmCls.getMembers();
        JvmField _field = this._jvmTypesBuilder.toField(mm, refFieldName, refType);
        this._jvmTypesBuilder.<JvmField>operator_add(_members_1, _field);
      }
      EList<JvmMember> _members_2 = jvmCls.getMembers();
      final Procedure1<JvmOperation> _function_1 = new Procedure1<JvmOperation>() {
        @Override
        public void apply(final JvmOperation it) {
          EList<JvmAnnotationReference> _annotations = it.getAnnotations();
          JvmAnnotationReference _annotationRef = MetaclassAdapterInferrer.this.jvmAnnRefBuilder.annotationRef(Override.class);
          MetaclassAdapterInferrer.this._jvmTypesBuilder.<JvmAnnotationReference>operator_add(_annotations, _annotationRef);
          StringConcatenationClient _client = new StringConcatenationClient() {
            @Override
            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
              {
                boolean _hasAdapterFor = MetaclassAdapterInferrer.this._languageExtensions.hasAdapterFor(mm.getOwningLanguage(), superType, ref.getEReferenceType());
                if (_hasAdapterFor) {
                  {
                    boolean _isMany = ref.isMany();
                    if (_isMany) {
                      _builder.append("if (");
                      _builder.append(refFieldName);
                      _builder.append(" == null)");
                      _builder.newLineIfNotEmpty();
                      _builder.append("\t");
                      _builder.append(refFieldName, "\t");
                      _builder.append(" = ");
                      String _canonicalName = EListAdapter.class.getCanonicalName();
                      _builder.append(_canonicalName, "\t");
                      _builder.append(".newInstance(adaptee.");
                      String _getterName = MetaclassAdapterInferrer.this._namingHelper.getGetterName(mmRef);
                      _builder.append(_getterName, "\t");
                      _builder.append("(),");
                      _builder.append(" adaptersFactory, eResource);");
                      _builder.newLineIfNotEmpty();
                      _builder.append("return ");
                      _builder.append(refFieldName);
                      _builder.append(";");
                      _builder.newLineIfNotEmpty();
                    } else {
                      _builder.append("return (");
                      JvmType _type = refType.getType();
                      _builder.append(_type);
                      _builder.append(") adaptersFactory.createAdapter");
                      _builder.append("(adaptee.");
                      String _getterName_1 = MetaclassAdapterInferrer.this._namingHelper.getGetterName(mmRef);
                      _builder.append(_getterName_1);
                      _builder.append("(), eResource);");
                      _builder.newLineIfNotEmpty();
                    }
                  }
                } else {
                  _builder.append("return adaptee.");
                  String _getterName_2 = MetaclassAdapterInferrer.this._namingHelper.getGetterName(mmRef);
                  _builder.append(_getterName_2);
                  _builder.append("();");
                  _builder.newLineIfNotEmpty();
                }
              }
            }
          };
          MetaclassAdapterInferrer.this._jvmTypesBuilder.setBody(it, _client);
        }
      };
      JvmOperation _method_1 = this._jvmTypesBuilder.toMethod(mm, this._namingHelper.getGetterName(ref), refType, _function_1);
      this._jvmTypesBuilder.<JvmOperation>operator_add(_members_2, _method_1);
    }
    boolean _needsSetterImplementation = this._ecoreExtensions.needsSetterImplementation(ref);
    if (_needsSetterImplementation) {
      EList<JvmMember> _members_3 = jvmCls.getMembers();
      final Procedure1<JvmOperation> _function_2 = new Procedure1<JvmOperation>() {
        @Override
        public void apply(final JvmOperation it) {
          boolean _needsSetterInterface = MetaclassAdapterInferrer.this._ecoreExtensions.needsSetterInterface(ref);
          if (_needsSetterInterface) {
            EList<JvmAnnotationReference> _annotations = it.getAnnotations();
            JvmAnnotationReference _annotationRef = MetaclassAdapterInferrer.this.jvmAnnRefBuilder.annotationRef(Override.class);
            MetaclassAdapterInferrer.this._jvmTypesBuilder.<JvmAnnotationReference>operator_add(_annotations, _annotationRef);
          }
          EList<JvmFormalParameter> _parameters = it.getParameters();
          JvmFormalParameter _parameter = MetaclassAdapterInferrer.this._jvmTypesBuilder.toParameter(mm, "o", refType);
          MetaclassAdapterInferrer.this._jvmTypesBuilder.<JvmFormalParameter>operator_add(_parameters, _parameter);
          StringConcatenationClient _client = new StringConcatenationClient() {
            @Override
            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
              _builder.append("if (o != null)");
              _builder.newLine();
              _builder.append("\t");
              _builder.append("adaptee.");
              String _setterName = MetaclassAdapterInferrer.this._namingHelper.getSetterName(mmRef);
              _builder.append(_setterName, "\t");
              _builder.append("(((");
              _builder.append(adapName, "\t");
              _builder.append(") o).getAdaptee());");
              _builder.newLineIfNotEmpty();
              _builder.append("else adaptee.");
              String _setterName_1 = MetaclassAdapterInferrer.this._namingHelper.getSetterName(mmRef);
              _builder.append(_setterName_1);
              _builder.append("(null);");
              _builder.newLineIfNotEmpty();
            }
          };
          MetaclassAdapterInferrer.this._jvmTypesBuilder.setBody(it, _client);
        }
      };
      JvmOperation _method_2 = this._jvmTypesBuilder.toMethod(mm, this._namingHelper.getSetterName(ref), this.typeRefBuilder.typeRef(Void.TYPE), _function_2);
      this._jvmTypesBuilder.<JvmOperation>operator_add(_members_3, _method_2);
    }
    boolean _needsUnsetterImplementation = this._ecoreExtensions.needsUnsetterImplementation(ref);
    if (_needsUnsetterImplementation) {
      EList<JvmMember> _members_4 = jvmCls.getMembers();
      JvmOperation _unsetter = this._jvmModelInferrerHelper.toUnsetter(mm, ref, mm);
      this._jvmTypesBuilder.<JvmOperation>operator_add(_members_4, _unsetter);
    }
    boolean _needsUnsetterCheckerImplementation = this._ecoreExtensions.needsUnsetterCheckerImplementation(ref);
    if (_needsUnsetterCheckerImplementation) {
      EList<JvmMember> _members_5 = jvmCls.getMembers();
      JvmOperation _unsetterCheck = this._jvmModelInferrerHelper.toUnsetterCheck(mm, ref, mm);
      this._jvmTypesBuilder.<JvmOperation>operator_add(_members_5, _unsetterCheck);
    }
  }
  
  /**
   * Implements the {@link EOperation} {@code op}, delegates its execution
   * to the corresponding operation in the implementing language, and adds
   * it to the currently created {@code jvmCls}
   */
  private void processOperation(final EOperation op, final Metamodel mm, final ModelType superType, final JvmGenericType jvmCls) {
    String _xifexpression = null;
    boolean _isUml = this._ecoreExtensions.isUml(op.getEContainingClass().getEPackage());
    boolean _not = (!_isUml);
    if (_not) {
      _xifexpression = op.getName();
    } else {
      _xifexpression = this._namingHelper.formatUmlOperationName(op);
    }
    final String opName = _xifexpression;
    final Procedure1<JvmOperation> _function = new Procedure1<JvmOperation>() {
      @Override
      public void apply(final JvmOperation m) {
        EList<JvmAnnotationReference> _annotations = m.getAnnotations();
        JvmAnnotationReference _annotationRef = MetaclassAdapterInferrer.this.jvmAnnRefBuilder.annotationRef(Override.class);
        MetaclassAdapterInferrer.this._jvmTypesBuilder.<JvmAnnotationReference>operator_add(_annotations, _annotationRef);
        final StringBuilder paramsList = new StringBuilder();
        final Consumer<ETypeParameter> _function = new Consumer<ETypeParameter>() {
          @Override
          public void accept(final ETypeParameter t) {
            EList<JvmTypeParameter> _typeParameters = m.getTypeParameters();
            JvmTypeParameter _createJvmTypeParameter = TypesFactory.eINSTANCE.createJvmTypeParameter();
            final Procedure1<JvmTypeParameter> _function = new Procedure1<JvmTypeParameter>() {
              @Override
              public void apply(final JvmTypeParameter tp) {
                tp.setName(t.getName());
              }
            };
            JvmTypeParameter _doubleArrow = ObjectExtensions.<JvmTypeParameter>operator_doubleArrow(_createJvmTypeParameter, _function);
            MetaclassAdapterInferrer.this._jvmTypesBuilder.<JvmTypeParameter>operator_add(_typeParameters, _doubleArrow);
          }
        };
        op.getETypeParameters().forEach(_function);
        final Consumer<ETypeParameter> _function_1 = new Consumer<ETypeParameter>() {
          @Override
          public void accept(final ETypeParameter t) {
            final Consumer<EGenericType> _function = new Consumer<EGenericType>() {
              @Override
              public void accept(final EGenericType b) {
                final Function1<JvmTypeParameter, Boolean> _function = new Function1<JvmTypeParameter, Boolean>() {
                  @Override
                  public Boolean apply(final JvmTypeParameter it) {
                    String _name = it.getName();
                    String _name_1 = t.getName();
                    return Boolean.valueOf(Objects.equal(_name, _name_1));
                  }
                };
                final JvmTypeParameter tp = IterableExtensions.<JvmTypeParameter>findFirst(m.getTypeParameters(), _function);
                EClassifier _eClassifier = b.getEClassifier();
                boolean _tripleNotEquals = (_eClassifier != null);
                if (_tripleNotEquals) {
                  EList<JvmTypeConstraint> _constraints = tp.getConstraints();
                  JvmUpperBound _createJvmUpperBound = TypesFactory.eINSTANCE.createJvmUpperBound();
                  final Procedure1<JvmUpperBound> _function_1 = new Procedure1<JvmUpperBound>() {
                    @Override
                    public void apply(final JvmUpperBound it) {
                      it.setTypeReference(MetaclassAdapterInferrer.this._melangeTypesBuilder.typeRef(superType, b, Collections.<EObject>unmodifiableList(CollectionLiterals.<EObject>newArrayList(m, jvmCls))));
                    }
                  };
                  JvmUpperBound _doubleArrow = ObjectExtensions.<JvmUpperBound>operator_doubleArrow(_createJvmUpperBound, _function_1);
                  MetaclassAdapterInferrer.this._jvmTypesBuilder.<JvmTypeConstraint>operator_add(_constraints, _doubleArrow);
                } else {
                  ETypeParameter _eTypeParameter = b.getETypeParameter();
                  boolean _tripleNotEquals_1 = (_eTypeParameter != null);
                  if (_tripleNotEquals_1) {
                    EList<JvmTypeConstraint> _constraints_1 = tp.getConstraints();
                    JvmUpperBound _createJvmUpperBound_1 = TypesFactory.eINSTANCE.createJvmUpperBound();
                    final Procedure1<JvmUpperBound> _function_2 = new Procedure1<JvmUpperBound>() {
                      @Override
                      public void apply(final JvmUpperBound it) {
                        it.setTypeReference(MetaclassAdapterInferrer.this._melangeTypesBuilder.createTypeParameterReference(
                          new JvmTypeParameterDeclarator[] { m, jvmCls }, b.getETypeParameter().getName()));
                      }
                    };
                    JvmUpperBound _doubleArrow_1 = ObjectExtensions.<JvmUpperBound>operator_doubleArrow(_createJvmUpperBound_1, _function_2);
                    MetaclassAdapterInferrer.this._jvmTypesBuilder.<JvmTypeConstraint>operator_add(_constraints_1, _doubleArrow_1);
                  }
                }
              }
            };
            t.getEBounds().forEach(_function);
          }
        };
        op.getETypeParameters().forEach(_function_1);
        StringConcatenation _builder = new StringConcatenation();
        {
          EList<EParameter> _eParameters = op.getEParameters();
          boolean _hasElements = false;
          for(final EParameter p : _eParameters) {
            if (!_hasElements) {
              _hasElements = true;
            } else {
              _builder.appendImmediate(",", "");
            }
            _builder.newLineIfNotEmpty();
            {
              if (((p.getEType() instanceof EClass) && MetaclassAdapterInferrer.this._languageExtensions.hasAdapterFor(mm.getOwningLanguage(), superType, p.getEType()))) {
                {
                  boolean _isMany = p.isMany();
                  if (_isMany) {
                    _builder.append("((");
                    String _canonicalName = EListAdapter.class.getCanonicalName();
                    _builder.append(_canonicalName);
                    _builder.append(") ");
                    String _name = p.getName();
                    _builder.append(_name);
                    _builder.append(").getAdaptee()");
                    _builder.newLineIfNotEmpty();
                  } else {
                    _builder.append("((");
                    EClassifier _eType = p.getEType();
                    String _adapterNameFor = MetaclassAdapterInferrer.this._namingHelper.adapterNameFor(mm, superType, ((EClass) _eType));
                    _builder.append(_adapterNameFor);
                    _builder.append(")");
                    _builder.append(" ");
                    String _name_1 = p.getName();
                    _builder.append(_name_1);
                    _builder.append(").getAdaptee()");
                    _builder.newLineIfNotEmpty();
                  }
                }
              } else {
                EClassifier _eType_1 = p.getEType();
                if ((_eType_1 instanceof EEnum)) {
                  String _fqnFor = MetaclassAdapterInferrer.this._namingHelper.getFqnFor(mm, p.getEType());
                  _builder.append(_fqnFor);
                  _builder.append(".get(");
                  String _name_2 = p.getName();
                  _builder.append(_name_2);
                  _builder.append(".getValue())");
                  _builder.newLineIfNotEmpty();
                } else {
                  String _name_3 = p.getName();
                  _builder.append(_name_3);
                  _builder.newLineIfNotEmpty();
                }
              }
            }
          }
        }
        paramsList.append(_builder);
        final Consumer<EParameter> _function_2 = new Consumer<EParameter>() {
          @Override
          public void accept(final EParameter p) {
            EList<JvmFormalParameter> _parameters = m.getParameters();
            JvmFormalParameter _parameter = MetaclassAdapterInferrer.this._jvmTypesBuilder.toParameter(mm, p.getName(), MetaclassAdapterInferrer.this._melangeTypesBuilder.typeRef(superType, p, Collections.<EObject>unmodifiableList(CollectionLiterals.<EObject>newArrayList(m, jvmCls))));
            MetaclassAdapterInferrer.this._jvmTypesBuilder.<JvmFormalParameter>operator_add(_parameters, _parameter);
          }
        };
        op.getEParameters().forEach(_function_2);
        final Consumer<EClassifier> _function_3 = new Consumer<EClassifier>() {
          @Override
          public void accept(final EClassifier e) {
            EList<JvmTypeReference> _exceptions = m.getExceptions();
            String _xifexpression = null;
            Class<?> _instanceClass = e.getInstanceClass();
            boolean _tripleNotEquals = (_instanceClass != null);
            if (_tripleNotEquals) {
              _xifexpression = e.getInstanceClass().getName();
            } else {
              _xifexpression = e.getInstanceTypeName();
            }
            JvmTypeReference _typeRef = MetaclassAdapterInferrer.this.typeRefBuilder.typeRef(_xifexpression);
            MetaclassAdapterInferrer.this._jvmTypesBuilder.<JvmTypeReference>operator_add(_exceptions, _typeRef);
          }
        };
        op.getEExceptions().forEach(_function_3);
        final Consumer<EGenericType> _function_4 = new Consumer<EGenericType>() {
          @Override
          public void accept(final EGenericType e) {
          }
        };
        op.getEGenericExceptions().forEach(_function_4);
        StringConcatenationClient _client = new StringConcatenationClient() {
          @Override
          protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
            {
              if (((op.getEType() instanceof EClass) && MetaclassAdapterInferrer.this._languageExtensions.hasAdapterFor(mm.getOwningLanguage(), superType, op.getEType()))) {
                {
                  boolean _isMany = op.isMany();
                  if (_isMany) {
                    _builder.append("return ");
                    String _canonicalName = EListAdapter.class.getCanonicalName();
                    _builder.append(_canonicalName);
                    _builder.append(".newInstance");
                    _builder.append("(adaptee.");
                    _builder.append(opName);
                    _builder.append("(");
                    _builder.append(paramsList);
                    _builder.append("), adaptersFactory, eResource);");
                    _builder.newLineIfNotEmpty();
                  } else {
                    _builder.append("return (");
                    JvmType _type = MetaclassAdapterInferrer.this._melangeTypesBuilder.typeRef(superType, op, Collections.<JvmGenericType>unmodifiableList(CollectionLiterals.<JvmGenericType>newArrayList(jvmCls))).getType();
                    _builder.append(_type);
                    _builder.append(") ");
                    _builder.append("adaptersFactory.createAdapter(");
                    _builder.append("adaptee.");
                    _builder.append(opName);
                    _builder.append("(");
                    _builder.append(paramsList);
                    _builder.append("), eResource);");
                    _builder.newLineIfNotEmpty();
                  }
                }
              } else {
                EClassifier _eType = op.getEType();
                boolean _tripleNotEquals = (_eType != null);
                if (_tripleNotEquals) {
                  _builder.append("return adaptee.");
                  _builder.append(opName);
                  _builder.append("(");
                  _builder.append(paramsList);
                  _builder.append(");");
                  _builder.newLineIfNotEmpty();
                } else {
                  _builder.append("adaptee.");
                  _builder.append(opName);
                  _builder.append("(");
                  _builder.append(paramsList);
                  _builder.append(");");
                  _builder.newLineIfNotEmpty();
                }
              }
            }
          }
        };
        MetaclassAdapterInferrer.this._jvmTypesBuilder.setBody(m, _client);
      }
    };
    final JvmOperation newOp = this._jvmTypesBuilder.toMethod(mm, opName, null, _function);
    newOp.setReturnType(this._melangeTypesBuilder.typeRef(superType, op, Collections.<EObject>unmodifiableList(CollectionLiterals.<EObject>newArrayList(newOp, jvmCls))));
    EList<JvmMember> _members = jvmCls.getMembers();
    this._jvmTypesBuilder.<JvmOperation>operator_add(_members, newOp);
  }
  
  /**
   * Browse the meaningful (ie. not _privk3, super_) methods of the
   * {@code aspect}, infer the corresponding implementation in the adapter,
   * and add them to the currently processed {@code jvmCls}
   */
  private void processAspect(final Aspect aspect, final Metamodel mm, final ModelType superType, final JvmGenericType jvmCls) {
    boolean _isValid = this._aspectExtensions.isValid(aspect);
    boolean _not = (!_isValid);
    if (_not) {
      return;
    }
    final JvmTypeReference oldRef = aspect.getAspectTypeRef();
    JvmTypeReference _xifexpression = null;
    boolean _isDefinedOver = this._aspectExtensions.isDefinedOver(aspect.getAspectTypeRef(), mm);
    boolean _not_1 = (!_isDefinedOver);
    if (_not_1) {
      StringConcatenation _builder = new StringConcatenation();
      String _aspectsNamespace = this._languageExtensions.getAspectsNamespace(mm.getOwningLanguage());
      _builder.append(_aspectsNamespace);
      _builder.append(".");
      String _simpleName = aspect.getAspectTypeRef().getSimpleName();
      _builder.append(_simpleName);
      _xifexpression = this.typeRefBuilder.typeRef(_builder.toString());
    } else {
      _xifexpression = oldRef;
    }
    aspect.setAspectTypeRef(_xifexpression);
    final JvmType aspType = aspect.getAspectTypeRef().getType();
    if ((aspType != null)) {
      if ((aspType instanceof JvmDeclaredType)) {
        final Function1<JvmOperation, Boolean> _function = new Function1<JvmOperation, Boolean>() {
          @Override
          public Boolean apply(final JvmOperation op) {
            return Boolean.valueOf(((((!op.getSimpleName().startsWith("_privk3")) && (!op.getSimpleName().startsWith("super_"))) && (!IterableExtensions.<JvmMember>exists(jvmCls.getMembers(), new Function1<JvmMember, Boolean>() {
              @Override
              public Boolean apply(final JvmMember opp) {
                String _simpleName = opp.getSimpleName();
                String _simpleName_1 = op.getSimpleName();
                return Boolean.valueOf(Objects.equal(_simpleName, _simpleName_1));
              }
            }))) && Objects.equal(op.getVisibility(), JvmVisibility.PUBLIC)));
          }
        };
        final Consumer<JvmOperation> _function_1 = new Consumer<JvmOperation>() {
          @Override
          public void accept(final JvmOperation it) {
            MetaclassAdapterInferrer.this.processAspectOperation(it, aspect, mm, superType, jvmCls);
          }
        };
        IterableExtensions.<JvmOperation>filter(((JvmDeclaredType)aspType).getDeclaredOperations(), _function).forEach(_function_1);
      }
    }
    aspect.setAspectTypeRef(oldRef);
  }
  
  /**
   * Wololo, wololo wololo.
   */
  private void processAspectOperation(final JvmOperation op, final Aspect aspect, final Metamodel mm, final ModelType superType, final JvmGenericType jvmCls) {
    JvmType _type = aspect.getAspectTypeRef().getType();
    final JvmDeclaredType asp = ((JvmDeclaredType) _type);
    final StringBuilder paramsList = new StringBuilder();
    final String featureName = this._aspectToEcore.findFeatureNameFor(asp, op, this.typeRefBuilder);
    String _xifexpression = null;
    boolean _isCollection = this._typeReferencesHelper.isCollection(op.getReturnType());
    if (_isCollection) {
      JvmTypeReference _returnType = op.getReturnType();
      _xifexpression = IterableExtensions.<JvmTypeReference>head(((JvmParameterizedTypeReference) _returnType).getArguments()).getType().getQualifiedName();
    } else {
      _xifexpression = op.getReturnType().getQualifiedName();
    }
    final String realType = _xifexpression;
    EClass _xifexpression_1 = null;
    boolean _isCollection_1 = this._typeReferencesHelper.isCollection(op.getReturnType());
    if (_isCollection_1) {
      _xifexpression_1 = this._modelingElementExtensions.findClass(superType, realType);
    } else {
      _xifexpression_1 = this._modelingElementExtensions.findClass(superType, realType);
    }
    final EClass mtCls = _xifexpression_1;
    JvmTypeReference _xifexpression_2 = null;
    String _simpleName = op.getReturnType().getSimpleName();
    boolean _equals = Objects.equal(_simpleName, "void");
    if (_equals) {
      _xifexpression_2 = this.typeRefBuilder.typeRef(Void.TYPE);
    } else {
      JvmTypeReference _xifexpression_3 = null;
      if ((mtCls != null)) {
        JvmTypeReference _xifexpression_4 = null;
        boolean _isCollection_2 = this._typeReferencesHelper.isCollection(op.getReturnType());
        if (_isCollection_2) {
          _xifexpression_4 = this.typeRefBuilder.typeRef("org.eclipse.emf.common.util.EList", 
            this._melangeTypesBuilder.typeRef(superType, mtCls, Collections.<JvmGenericType>unmodifiableList(CollectionLiterals.<JvmGenericType>newArrayList(jvmCls))));
        } else {
          _xifexpression_4 = this._melangeTypesBuilder.typeRef(superType, mtCls, Collections.<JvmGenericType>unmodifiableList(CollectionLiterals.<JvmGenericType>newArrayList(jvmCls)));
        }
        _xifexpression_3 = _xifexpression_4;
      } else {
        JvmTypeReference _xifexpression_5 = null;
        boolean _isCollection_3 = this._typeReferencesHelper.isCollection(op.getReturnType());
        if (_isCollection_3) {
          JvmTypeReference _returnType_1 = op.getReturnType();
          _xifexpression_5 = this.typeRefBuilder.typeRef("org.eclipse.emf.common.util.EList", 
            this.typeRefBuilder.typeRef(IterableExtensions.<JvmTypeReference>head(((JvmParameterizedTypeReference) _returnType_1).getArguments()).getQualifiedName()));
        } else {
          _xifexpression_5 = this.typeRefBuilder.typeRef(op.getReturnType().getQualifiedName());
        }
        _xifexpression_3 = _xifexpression_5;
      }
      _xifexpression_2 = _xifexpression_3;
    }
    final JvmTypeReference retType = _xifexpression_2;
    paramsList.append("adaptee");
    final Procedure2<JvmFormalParameter, Integer> _function = new Procedure2<JvmFormalParameter, Integer>() {
      @Override
      public void apply(final JvmFormalParameter p, final Integer i) {
        String _xifexpression = null;
        boolean _isCollection = MetaclassAdapterInferrer.this._typeReferencesHelper.isCollection(p.getParameterType());
        if (_isCollection) {
          JvmTypeReference _parameterType = p.getParameterType();
          _xifexpression = IterableExtensions.<JvmTypeReference>head(((JvmParameterizedTypeReference) _parameterType).getArguments()).getType().getQualifiedName();
        } else {
          _xifexpression = p.getParameterType().getQualifiedName();
        }
        final String realTypeP = _xifexpression;
        StringConcatenation _builder = new StringConcatenation();
        {
          boolean _hasAdapterFor = MetaclassAdapterInferrer.this._languageExtensions.hasAdapterFor(mm.getOwningLanguage(), superType, p.getParameterType().getQualifiedName());
          if (_hasAdapterFor) {
            _builder.append(", (");
            String _qualifiedName = p.getParameterType().getQualifiedName();
            _builder.append(_qualifiedName);
            _builder.append(")((EObjectAdapter)");
            String _name = p.getName();
            _builder.append(_name);
            _builder.append(").getAdaptee()");
            _builder.newLineIfNotEmpty();
          } else {
            if ((MetaclassAdapterInferrer.this._typeReferencesHelper.isCollection(p.getParameterType()) && MetaclassAdapterInferrer.this._languageExtensions.hasAdapterFor(mm.getOwningLanguage(), superType, realTypeP))) {
              _builder.append(", ((");
              String _canonicalName = EListAdapter.class.getCanonicalName();
              _builder.append(_canonicalName);
              _builder.append(") ");
              String _name_1 = p.getName();
              _builder.append(_name_1);
              _builder.append(").getAdaptee()");
              _builder.newLineIfNotEmpty();
            } else {
              _builder.append(", ");
              String _name_2 = p.getName();
              _builder.append(_name_2);
              _builder.newLineIfNotEmpty();
            }
          }
        }
        paramsList.append(_builder);
      }
    };
    IterableExtensions.<JvmFormalParameter>forEach(IterableExtensions.<JvmFormalParameter>drop(op.getParameters(), 1), _function);
    String _xifexpression_6 = null;
    if ((featureName == null)) {
      _xifexpression_6 = op.getSimpleName();
    } else {
      String _xifexpression_7 = null;
      int _size = op.getParameters().size();
      boolean _equals_1 = (_size == 1);
      if (_equals_1) {
        _xifexpression_7 = this._namingHelper.getGetterName(op);
      } else {
        _xifexpression_7 = this._namingHelper.getSetterName(op);
      }
      _xifexpression_6 = _xifexpression_7;
    }
    final String opName = _xifexpression_6;
    EClass _aspectedClass = aspect.getAspectedClass();
    QualifiedName _fullyQualifiedName = null;
    if (_aspectedClass!=null) {
      _fullyQualifiedName=this._iQualifiedNameProvider.getFullyQualifiedName(_aspectedClass);
    }
    final EClass correspondingCls = this._modelingElementExtensions.findClass(superType, _fullyQualifiedName.toString());
    final Function1<EStructuralFeature, Boolean> _function_1 = new Function1<EStructuralFeature, Boolean>() {
      @Override
      public Boolean apply(final EStructuralFeature it) {
        String _name = it.getName();
        return Boolean.valueOf(Objects.equal(_name, featureName));
      }
    };
    final EStructuralFeature correspondingFeature = IterableExtensions.<EStructuralFeature>findFirst(correspondingCls.getEAllStructuralFeatures(), _function_1);
    final boolean isSetter = ((correspondingFeature != null) && (op.getParameters().size() == 2));
    if ((((correspondingFeature != null) || IterableExtensions.<EOperation>exists(correspondingCls.getEAllOperations(), new Function1<EOperation, Boolean>() {
      @Override
      public Boolean apply(final EOperation it) {
        String _name = it.getName();
        return Boolean.valueOf(Objects.equal(_name, opName));
      }
    })) && ((!isSetter) || this._ecoreExtensions.needsSetterInterface(correspondingFeature)))) {
      EList<JvmMember> _members = jvmCls.getMembers();
      final Procedure1<JvmOperation> _function_2 = new Procedure1<JvmOperation>() {
        @Override
        public void apply(final JvmOperation it) {
          EList<JvmAnnotationReference> _annotations = it.getAnnotations();
          JvmAnnotationReference _annotationRef = MetaclassAdapterInferrer.this.jvmAnnRefBuilder.annotationRef(Override.class);
          MetaclassAdapterInferrer.this._jvmTypesBuilder.<JvmAnnotationReference>operator_add(_annotations, _annotationRef);
          final Consumer<JvmFormalParameter> _function = new Consumer<JvmFormalParameter>() {
            @Override
            public void accept(final JvmFormalParameter p) {
              String _xifexpression = null;
              boolean _isCollection = MetaclassAdapterInferrer.this._typeReferencesHelper.isCollection(p.getParameterType());
              if (_isCollection) {
                JvmTypeReference _parameterType = p.getParameterType();
                _xifexpression = IterableExtensions.<JvmTypeReference>head(((JvmParameterizedTypeReference) _parameterType).getArguments()).getType().getSimpleName();
              } else {
                _xifexpression = p.getParameterType().getSimpleName();
              }
              final String realTypeP = _xifexpression;
              final EClassifier pCls = MetaclassAdapterInferrer.this._modelingElementExtensions.findClassifier(superType, realTypeP);
              JvmTypeReference _xifexpression_1 = null;
              if ((pCls != null)) {
                JvmTypeReference _xifexpression_2 = null;
                boolean _isCollection_1 = MetaclassAdapterInferrer.this._typeReferencesHelper.isCollection(p.getParameterType());
                if (_isCollection_1) {
                  _xifexpression_2 = MetaclassAdapterInferrer.this.typeRefBuilder.typeRef(p.getParameterType().getType(), 
                    MetaclassAdapterInferrer.this._melangeTypesBuilder.typeRef(superType, pCls, Collections.<JvmGenericType>unmodifiableList(CollectionLiterals.<JvmGenericType>newArrayList(jvmCls))));
                } else {
                  _xifexpression_2 = MetaclassAdapterInferrer.this._melangeTypesBuilder.typeRef(superType, pCls, Collections.<JvmGenericType>unmodifiableList(CollectionLiterals.<JvmGenericType>newArrayList(jvmCls)));
                }
                _xifexpression_1 = _xifexpression_2;
              } else {
                _xifexpression_1 = MetaclassAdapterInferrer.this.typeRefBuilder.typeRef(p.getParameterType().getQualifiedName());
              }
              final JvmTypeReference pType = _xifexpression_1;
              EList<JvmFormalParameter> _parameters = it.getParameters();
              JvmFormalParameter _parameter = MetaclassAdapterInferrer.this._jvmTypesBuilder.toParameter(mm, p.getName(), pType);
              MetaclassAdapterInferrer.this._jvmTypesBuilder.<JvmFormalParameter>operator_add(_parameters, _parameter);
            }
          };
          IterableExtensions.<JvmFormalParameter>drop(op.getParameters(), 1).forEach(_function);
          StringConcatenationClient _client = new StringConcatenationClient() {
            @Override
            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
              {
                boolean _isValidReturnType = MetaclassAdapterInferrer.this.isValidReturnType(retType);
                if (_isValidReturnType) {
                  {
                    boolean _hasAdapterFor = MetaclassAdapterInferrer.this._languageExtensions.hasAdapterFor(mm.getOwningLanguage(), superType, realType);
                    if (_hasAdapterFor) {
                      {
                        boolean _isCollection = MetaclassAdapterInferrer.this._typeReferencesHelper.isCollection(op.getReturnType());
                        if (_isCollection) {
                          _builder.append("return ");
                          String _canonicalName = EListAdapter.class.getCanonicalName();
                          _builder.append(_canonicalName);
                          _builder.append(".");
                          _builder.append("newInstance(");
                          String _qualifiedName = asp.getQualifiedName();
                          _builder.append(_qualifiedName);
                          _builder.append(".");
                          String _simpleName = op.getSimpleName();
                          _builder.append(_simpleName);
                          _builder.append("(");
                          _builder.append(paramsList);
                          _builder.append("), adaptersFactory, eResource);");
                          _builder.newLineIfNotEmpty();
                        } else {
                          _builder.append("return (");
                          JvmType _type = retType.getType();
                          _builder.append(_type);
                          _builder.append(") adaptersFactory.");
                          _builder.append("createAdapter(");
                          String _qualifiedName_1 = asp.getQualifiedName();
                          _builder.append(_qualifiedName_1);
                          _builder.append(".");
                          String _simpleName_1 = op.getSimpleName();
                          _builder.append(_simpleName_1);
                          _builder.append("(");
                          _builder.append(paramsList);
                          _builder.append("), eResource);");
                          _builder.newLineIfNotEmpty();
                        }
                      }
                    } else {
                      _builder.append("return ");
                      String _qualifiedName_2 = asp.getQualifiedName();
                      _builder.append(_qualifiedName_2);
                      _builder.append(".");
                      String _simpleName_2 = op.getSimpleName();
                      _builder.append(_simpleName_2);
                      _builder.append("(");
                      _builder.append(paramsList);
                      _builder.append(");");
                      _builder.newLineIfNotEmpty();
                    }
                  }
                } else {
                  String _qualifiedName_3 = asp.getQualifiedName();
                  _builder.append(_qualifiedName_3);
                  _builder.append(".");
                  String _simpleName_3 = op.getSimpleName();
                  _builder.append(_simpleName_3);
                  _builder.append("(");
                  _builder.append(paramsList);
                  _builder.append(");");
                  _builder.newLineIfNotEmpty();
                }
              }
            }
          };
          MetaclassAdapterInferrer.this._jvmTypesBuilder.setBody(it, _client);
        }
      };
      JvmOperation _method = this._jvmTypesBuilder.toMethod(mm, opName, retType, _function_2);
      this._jvmTypesBuilder.<JvmOperation>operator_add(_members, _method);
    }
  }
  
  /**
   * Generates the necessary methods in {@code jvmCls} for handling
   * reflective EMF calls on elements through a model type, ie.
   * eClass(), eSet(), eGet(), eUnset(), eIsSet().
   * <br>
   * Closely inspired by the code generation of EMF for those methods.
   */
  private void processReflectiveLayer(final EClass cls, final Metamodel mm, final ModelType superType, final JvmGenericType jvmCls) {
    final GenClass genCls = this._modelingElementExtensions.getGenClsFor(superType, cls);
    String _xifexpression = null;
    boolean _hasOffsetCorrection = genCls.hasOffsetCorrection();
    if (_hasOffsetCorrection) {
      String _offsetCorrectionField = genCls.getOffsetCorrectionField(null);
      _xifexpression = (" - " + _offsetCorrectionField);
    }
    final String negativeOffsetCorrection = _xifexpression;
    String _xifexpression_1 = null;
    boolean _hasOffsetCorrection_1 = genCls.hasOffsetCorrection();
    if (_hasOffsetCorrection_1) {
      String _offsetCorrectionField_1 = genCls.getOffsetCorrectionField(null);
      _xifexpression_1 = (" + " + _offsetCorrectionField_1);
    }
    final String positiveOffsetCorrection = _xifexpression_1;
    final Function1<GenFeature, Boolean> _function = new Function1<GenFeature, Boolean>() {
      @Override
      public Boolean apply(final GenFeature it) {
        return Boolean.valueOf((it.hasEDefault() && (!it.getEcoreFeature().isMany())));
      }
    };
    final Consumer<GenFeature> _function_1 = new Consumer<GenFeature>() {
      @Override
      public void accept(final GenFeature genFeature) {
        EList<JvmMember> _members = jvmCls.getMembers();
        final Procedure1<JvmField> _function = new Procedure1<JvmField>() {
          @Override
          public void apply(final JvmField it) {
            it.setVisibility(JvmVisibility.PROTECTED);
            it.setStatic(true);
            it.setFinal(true);
            StringConcatenationClient _client = new StringConcatenationClient() {
              @Override
              protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                String _staticDefaultValue = genFeature.getStaticDefaultValue();
                _builder.append(_staticDefaultValue);
              }
            };
            MetaclassAdapterInferrer.this._jvmTypesBuilder.setInitializer(it, _client);
          }
        };
        JvmField _field = MetaclassAdapterInferrer.this._jvmTypesBuilder.toField(mm, genFeature.getEDefault(), 
          MetaclassAdapterInferrer.this.typeRefBuilder.typeRef(genFeature.getImportedType(genCls)), _function);
        MetaclassAdapterInferrer.this._jvmTypesBuilder.<JvmField>operator_add(_members, _field);
      }
    };
    IterableExtensions.<GenFeature>filter(genCls.getAllGenFeatures(), _function).forEach(_function_1);
    EList<JvmMember> _members = jvmCls.getMembers();
    final Procedure1<JvmOperation> _function_2 = new Procedure1<JvmOperation>() {
      @Override
      public void apply(final JvmOperation it) {
        EList<JvmAnnotationReference> _annotations = it.getAnnotations();
        JvmAnnotationReference _annotationRef = MetaclassAdapterInferrer.this.jvmAnnRefBuilder.annotationRef(Override.class);
        MetaclassAdapterInferrer.this._jvmTypesBuilder.<JvmAnnotationReference>operator_add(_annotations, _annotationRef);
        String _xifexpression = null;
        boolean _equals = cls.getName().equals("Class");
        if (_equals) {
          String _name = cls.getName();
          _xifexpression = (_name + "_");
        } else {
          _xifexpression = cls.getName();
        }
        final String safeName = _xifexpression;
        StringConcatenationClient _client = new StringConcatenationClient() {
          @Override
          protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
            _builder.append("return ");
            String _fqnFor = MetaclassAdapterInferrer.this._namingHelper.getFqnFor(superType, cls.getEPackage());
            _builder.append(_fqnFor);
            _builder.append(".eINSTANCE.get");
            _builder.append(safeName);
            _builder.append("();");
            _builder.newLineIfNotEmpty();
          }
        };
        MetaclassAdapterInferrer.this._jvmTypesBuilder.setBody(it, _client);
      }
    };
    JvmOperation _method = this._jvmTypesBuilder.toMethod(mm, "eClass", this.typeRefBuilder.typeRef(EClass.class), _function_2);
    this._jvmTypesBuilder.<JvmOperation>operator_add(_members, _method);
    boolean _isEmpty = genCls.getAllGenFeatures().isEmpty();
    boolean _not = (!_isEmpty);
    if (_not) {
      EList<JvmMember> _members_1 = jvmCls.getMembers();
      final Procedure1<JvmOperation> _function_3 = new Procedure1<JvmOperation>() {
        @Override
        public void apply(final JvmOperation it) {
          EList<JvmAnnotationReference> _annotations = it.getAnnotations();
          JvmAnnotationReference _annotationRef = MetaclassAdapterInferrer.this.jvmAnnRefBuilder.annotationRef(Override.class);
          MetaclassAdapterInferrer.this._jvmTypesBuilder.<JvmAnnotationReference>operator_add(_annotations, _annotationRef);
          EList<JvmFormalParameter> _parameters = it.getParameters();
          JvmFormalParameter _parameter = MetaclassAdapterInferrer.this._jvmTypesBuilder.toParameter(mm, "featureID", MetaclassAdapterInferrer.this.typeRefBuilder.typeRef(Integer.TYPE));
          MetaclassAdapterInferrer.this._jvmTypesBuilder.<JvmFormalParameter>operator_add(_parameters, _parameter);
          EList<JvmFormalParameter> _parameters_1 = it.getParameters();
          JvmFormalParameter _parameter_1 = MetaclassAdapterInferrer.this._jvmTypesBuilder.toParameter(mm, "resolve", MetaclassAdapterInferrer.this.typeRefBuilder.typeRef(Boolean.TYPE));
          MetaclassAdapterInferrer.this._jvmTypesBuilder.<JvmFormalParameter>operator_add(_parameters_1, _parameter_1);
          EList<JvmFormalParameter> _parameters_2 = it.getParameters();
          JvmFormalParameter _parameter_2 = MetaclassAdapterInferrer.this._jvmTypesBuilder.toParameter(mm, "coreType", MetaclassAdapterInferrer.this.typeRefBuilder.typeRef(Boolean.TYPE));
          MetaclassAdapterInferrer.this._jvmTypesBuilder.<JvmFormalParameter>operator_add(_parameters_2, _parameter_2);
          StringConcatenationClient _client = new StringConcatenationClient() {
            @Override
            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
              _builder.append("switch (featureID");
              _builder.append(negativeOffsetCorrection);
              _builder.append(") {");
              _builder.newLineIfNotEmpty();
              {
                List<GenFeature> _allGenFeatures = genCls.getAllGenFeatures();
                for(final GenFeature genFeature : _allGenFeatures) {
                  _builder.append("\t");
                  _builder.append("case ");
                  String _qualifiedFeatureID = genCls.getQualifiedFeatureID(genFeature);
                  _builder.append(_qualifiedFeatureID, "\t");
                  _builder.append(":");
                  _builder.newLineIfNotEmpty();
                  {
                    boolean _isPrimitiveType = genFeature.isPrimitiveType();
                    if (_isPrimitiveType) {
                      {
                        boolean _isBooleanType = genFeature.isBooleanType();
                        if (_isBooleanType) {
                          _builder.append("\t");
                          _builder.append("\t");
                          _builder.append("return ");
                          String _getAccessor = genFeature.getGetAccessor();
                          _builder.append(_getAccessor, "\t\t");
                          _builder.append("() ");
                          _builder.append("? Boolean.TRUE : Boolean.FALSE;");
                          _builder.newLineIfNotEmpty();
                        } else {
                          _builder.append("\t");
                          _builder.append("\t");
                          _builder.append("return new ");
                          String _objectType = genFeature.getObjectType(genCls);
                          _builder.append(_objectType, "\t\t");
                          _builder.append("(");
                          String _getAccessor_1 = genFeature.getGetAccessor();
                          _builder.append(_getAccessor_1, "\t\t");
                          _builder.append("());");
                          _builder.newLineIfNotEmpty();
                        }
                      }
                    } else {
                      _builder.append("\t");
                      _builder.append("\t");
                      _builder.append("return ");
                      String _getAccessor_2 = genFeature.getGetAccessor();
                      _builder.append(_getAccessor_2, "\t\t");
                      _builder.append("();");
                      _builder.newLineIfNotEmpty();
                    }
                  }
                }
              }
              _builder.append("}");
              _builder.newLine();
              _builder.newLine();
              _builder.append("return super.eGet(featureID, resolve, coreType);");
              _builder.newLine();
            }
          };
          MetaclassAdapterInferrer.this._jvmTypesBuilder.setBody(it, _client);
        }
      };
      JvmOperation _method_1 = this._jvmTypesBuilder.toMethod(mm, "eGet", this.typeRefBuilder.typeRef(Object.class), _function_3);
      this._jvmTypesBuilder.<JvmOperation>operator_add(_members_1, _method_1);
      final Function1<GenFeature, Boolean> _function_4 = new Function1<GenFeature, Boolean>() {
        @Override
        public Boolean apply(final GenFeature it) {
          return Boolean.valueOf(it.isUnsettable());
        }
      };
      boolean _isEmpty_1 = IterableExtensions.isEmpty(IterableExtensions.<GenFeature>filter(genCls.getAllGenFeatures(), _function_4));
      boolean _not_1 = (!_isEmpty_1);
      if (_not_1) {
        EList<JvmMember> _members_2 = jvmCls.getMembers();
        final Procedure1<JvmOperation> _function_5 = new Procedure1<JvmOperation>() {
          @Override
          public void apply(final JvmOperation it) {
            EList<JvmAnnotationReference> _annotations = it.getAnnotations();
            JvmAnnotationReference _annotationRef = MetaclassAdapterInferrer.this.jvmAnnRefBuilder.annotationRef(Override.class);
            MetaclassAdapterInferrer.this._jvmTypesBuilder.<JvmAnnotationReference>operator_add(_annotations, _annotationRef);
            EList<JvmFormalParameter> _parameters = it.getParameters();
            JvmFormalParameter _parameter = MetaclassAdapterInferrer.this._jvmTypesBuilder.toParameter(mm, "featureID", MetaclassAdapterInferrer.this.typeRefBuilder.typeRef(Integer.TYPE));
            MetaclassAdapterInferrer.this._jvmTypesBuilder.<JvmFormalParameter>operator_add(_parameters, _parameter);
            StringConcatenationClient _client = new StringConcatenationClient() {
              @Override
              protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append("switch (featureID");
                _builder.append(negativeOffsetCorrection);
                _builder.append(") {");
                _builder.newLineIfNotEmpty();
                {
                  final Function1<GenFeature, Boolean> _function = new Function1<GenFeature, Boolean>() {
                    @Override
                    public Boolean apply(final GenFeature it) {
                      return Boolean.valueOf(it.isUnsettable());
                    }
                  };
                  Iterable<GenFeature> _filter = IterableExtensions.<GenFeature>filter(genCls.getAllGenFeatures(), _function);
                  for(final GenFeature genFeature : _filter) {
                    _builder.append("\t");
                    _builder.append("case ");
                    String _qualifiedFeatureID = genCls.getQualifiedFeatureID(genFeature);
                    _builder.append(_qualifiedFeatureID, "\t");
                    _builder.append(":");
                    _builder.newLineIfNotEmpty();
                    {
                      if ((genFeature.isListType() && (!genFeature.isUnsettable()))) {
                        _builder.append("\t");
                        _builder.append("\t");
                        String _getAccessor = genFeature.getGetAccessor();
                        _builder.append(_getAccessor, "\t\t");
                        _builder.append("().clear();");
                        _builder.newLineIfNotEmpty();
                      } else {
                        boolean _isUnsettable = genFeature.isUnsettable();
                        if (_isUnsettable) {
                          _builder.append("\t");
                          _builder.append("\t");
                          _builder.append("unset");
                          String _accessorName = genFeature.getAccessorName();
                          _builder.append(_accessorName, "\t\t");
                          _builder.append("();");
                          _builder.newLineIfNotEmpty();
                        } else {
                          boolean _hasEDefault = genFeature.hasEDefault();
                          boolean _not = (!_hasEDefault);
                          if (_not) {
                            _builder.append("\t");
                            _builder.append("\t");
                            _builder.append("set");
                            String _accessorName_1 = genFeature.getAccessorName();
                            _builder.append(_accessorName_1, "\t\t");
                            _builder.append("((");
                            String _importedType = genFeature.getImportedType(genCls);
                            _builder.append(_importedType, "\t\t");
                            _builder.append(") null);");
                            _builder.newLineIfNotEmpty();
                          } else {
                            _builder.append("\t");
                            _builder.append("\t");
                            _builder.append("set");
                            String _accessorName_2 = genFeature.getAccessorName();
                            _builder.append(_accessorName_2, "\t\t");
                            _builder.append("(");
                            String _eDefault = genFeature.getEDefault();
                            _builder.append(_eDefault, "\t\t");
                            _builder.append(");");
                            _builder.newLineIfNotEmpty();
                          }
                        }
                      }
                    }
                  }
                }
                _builder.append("\t");
                _builder.append("return;");
                _builder.newLine();
                _builder.append("}");
                _builder.newLine();
                _builder.newLine();
                _builder.append("super.eUnset(featureID);");
                _builder.newLine();
              }
            };
            MetaclassAdapterInferrer.this._jvmTypesBuilder.setBody(it, _client);
          }
        };
        JvmOperation _method_2 = this._jvmTypesBuilder.toMethod(mm, "eUnset", this.typeRefBuilder.typeRef(Void.TYPE), _function_5);
        this._jvmTypesBuilder.<JvmOperation>operator_add(_members_2, _method_2);
      }
      EList<JvmMember> _members_3 = jvmCls.getMembers();
      final Procedure1<JvmOperation> _function_6 = new Procedure1<JvmOperation>() {
        @Override
        public void apply(final JvmOperation it) {
          EList<JvmAnnotationReference> _annotations = it.getAnnotations();
          JvmAnnotationReference _annotationRef = MetaclassAdapterInferrer.this.jvmAnnRefBuilder.annotationRef(Override.class);
          MetaclassAdapterInferrer.this._jvmTypesBuilder.<JvmAnnotationReference>operator_add(_annotations, _annotationRef);
          EList<JvmFormalParameter> _parameters = it.getParameters();
          JvmFormalParameter _parameter = MetaclassAdapterInferrer.this._jvmTypesBuilder.toParameter(mm, "featureID", MetaclassAdapterInferrer.this.typeRefBuilder.typeRef(Integer.TYPE));
          MetaclassAdapterInferrer.this._jvmTypesBuilder.<JvmFormalParameter>operator_add(_parameters, _parameter);
          StringConcatenationClient _client = new StringConcatenationClient() {
            @Override
            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
              _builder.append("switch (featureID");
              _builder.append(negativeOffsetCorrection);
              _builder.append(") {");
              _builder.newLineIfNotEmpty();
              {
                List<GenFeature> _allGenFeatures = genCls.getAllGenFeatures();
                for(final GenFeature genFeature : _allGenFeatures) {
                  _builder.append("\t");
                  _builder.append("case ");
                  String _qualifiedFeatureID = genCls.getQualifiedFeatureID(genFeature);
                  _builder.append(_qualifiedFeatureID, "\t");
                  _builder.append(":");
                  _builder.newLineIfNotEmpty();
                  {
                    if ((genFeature.isListType() && (!genFeature.isUnsettable()))) {
                      _builder.append("\t");
                      _builder.append("\t");
                      _builder.append("return ");
                      String _getAccessor = genFeature.getGetAccessor();
                      _builder.append(_getAccessor, "\t\t");
                      _builder.append("() != null ");
                      _builder.append("&& !");
                      String _getAccessor_1 = genFeature.getGetAccessor();
                      _builder.append(_getAccessor_1, "\t\t");
                      _builder.append("().isEmpty();");
                      _builder.newLineIfNotEmpty();
                    } else {
                      boolean _isUnsettable = genFeature.isUnsettable();
                      if (_isUnsettable) {
                        _builder.append("\t");
                        _builder.append("\t");
                        _builder.append("return isSet");
                        String _accessorName = genFeature.getAccessorName();
                        _builder.append(_accessorName, "\t\t");
                        _builder.append("();");
                        _builder.newLineIfNotEmpty();
                      } else {
                        boolean _hasEDefault = genFeature.hasEDefault();
                        boolean _not = (!_hasEDefault);
                        if (_not) {
                          _builder.append("\t");
                          _builder.append("\t");
                          _builder.append("return ");
                          String _getAccessor_2 = genFeature.getGetAccessor();
                          _builder.append(_getAccessor_2, "\t\t");
                          _builder.append("() != null;");
                          _builder.newLineIfNotEmpty();
                        } else {
                          _builder.append("\t");
                          _builder.append("\t");
                          _builder.append("return ");
                          String _getAccessor_3 = genFeature.getGetAccessor();
                          _builder.append(_getAccessor_3, "\t\t");
                          _builder.append("() ");
                          _builder.append("!= ");
                          String _eDefault = genFeature.getEDefault();
                          _builder.append(_eDefault, "\t\t");
                          _builder.append(";");
                          _builder.newLineIfNotEmpty();
                        }
                      }
                    }
                  }
                }
              }
              _builder.append("}");
              _builder.newLine();
              _builder.newLine();
              _builder.append("return super.eIsSet(featureID);");
              _builder.newLine();
            }
          };
          MetaclassAdapterInferrer.this._jvmTypesBuilder.setBody(it, _client);
        }
      };
      JvmOperation _method_3 = this._jvmTypesBuilder.toMethod(mm, "eIsSet", this.typeRefBuilder.typeRef(Boolean.TYPE), _function_6);
      this._jvmTypesBuilder.<JvmOperation>operator_add(_members_3, _method_3);
      final Function1<GenFeature, Boolean> _function_7 = new Function1<GenFeature, Boolean>() {
        @Override
        public Boolean apply(final GenFeature it) {
          return Boolean.valueOf(it.isChangeable());
        }
      };
      boolean _isEmpty_2 = IterableExtensions.isEmpty(IterableExtensions.<GenFeature>filter(genCls.getAllGenFeatures(), _function_7));
      boolean _not_2 = (!_isEmpty_2);
      if (_not_2) {
        EList<JvmMember> _members_4 = jvmCls.getMembers();
        final Procedure1<JvmOperation> _function_8 = new Procedure1<JvmOperation>() {
          @Override
          public void apply(final JvmOperation it) {
            EList<JvmAnnotationReference> _annotations = it.getAnnotations();
            JvmAnnotationReference _annotationRef = MetaclassAdapterInferrer.this.jvmAnnRefBuilder.annotationRef(Override.class);
            MetaclassAdapterInferrer.this._jvmTypesBuilder.<JvmAnnotationReference>operator_add(_annotations, _annotationRef);
            EList<JvmFormalParameter> _parameters = it.getParameters();
            JvmFormalParameter _parameter = MetaclassAdapterInferrer.this._jvmTypesBuilder.toParameter(mm, "featureID", MetaclassAdapterInferrer.this.typeRefBuilder.typeRef(Integer.TYPE));
            MetaclassAdapterInferrer.this._jvmTypesBuilder.<JvmFormalParameter>operator_add(_parameters, _parameter);
            EList<JvmFormalParameter> _parameters_1 = it.getParameters();
            JvmFormalParameter _parameter_1 = MetaclassAdapterInferrer.this._jvmTypesBuilder.toParameter(mm, "newValue", MetaclassAdapterInferrer.this.typeRefBuilder.typeRef(Object.class));
            MetaclassAdapterInferrer.this._jvmTypesBuilder.<JvmFormalParameter>operator_add(_parameters_1, _parameter_1);
            StringConcatenationClient _client = new StringConcatenationClient() {
              @Override
              protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append("switch (featureID");
                _builder.append(negativeOffsetCorrection);
                _builder.append(") {");
                _builder.newLineIfNotEmpty();
                {
                  final Function1<GenFeature, Boolean> _function = new Function1<GenFeature, Boolean>() {
                    @Override
                    public Boolean apply(final GenFeature it) {
                      return Boolean.valueOf(it.isChangeable());
                    }
                  };
                  Iterable<GenFeature> _filter = IterableExtensions.<GenFeature>filter(genCls.getAllGenFeatures(), _function);
                  for(final GenFeature genFeature : _filter) {
                    _builder.append("\t");
                    _builder.append("case ");
                    String _qualifiedFeatureID = genCls.getQualifiedFeatureID(genFeature);
                    _builder.append(_qualifiedFeatureID, "\t");
                    _builder.append(":");
                    _builder.newLineIfNotEmpty();
                    {
                      boolean _isListType = genFeature.isListType();
                      if (_isListType) {
                        _builder.append("\t");
                        _builder.append("\t");
                        String _getAccessor = genFeature.getGetAccessor();
                        _builder.append(_getAccessor, "\t\t");
                        _builder.append("().clear();");
                        _builder.newLineIfNotEmpty();
                        _builder.append("\t");
                        _builder.append("\t");
                        String _getAccessor_1 = genFeature.getGetAccessor();
                        _builder.append(_getAccessor_1, "\t\t");
                        _builder.append("().");
                        _builder.append("addAll((");
                        _builder.append(Collection.class, "\t\t");
                        _builder.append(") newValue);");
                        _builder.newLineIfNotEmpty();
                      } else {
                        boolean _isPrimitiveType = genFeature.isPrimitiveType();
                        if (_isPrimitiveType) {
                          _builder.append("\t");
                          _builder.append("\t");
                          _builder.append("set");
                          String _accessorName = genFeature.getAccessorName();
                          _builder.append(_accessorName, "\t\t");
                          _builder.append("(((");
                          String _objectType = genFeature.getObjectType(genCls);
                          _builder.append(_objectType, "\t\t");
                          _builder.append(") newValue)");
                          _builder.append(".");
                          String _primitiveValueFunction = genFeature.getPrimitiveValueFunction();
                          _builder.append(_primitiveValueFunction, "\t\t");
                          _builder.append("());");
                          _builder.newLineIfNotEmpty();
                        } else {
                          _builder.append("\t");
                          _builder.append("\t");
                          _builder.append("set");
                          String _accessorName_1 = genFeature.getAccessorName();
                          _builder.append(_accessorName_1, "\t\t");
                          _builder.append("(");
                          {
                            if ((((genFeature.getTypeGenDataType() == null) || (!genFeature.getTypeGenDataType().isObjectType())) || (!genFeature.getRawType().equals(genFeature.getType(genCls))))) {
                              _builder.newLineIfNotEmpty();
                              _builder.append("\t");
                              _builder.append("\t");
                              _builder.append("(");
                              String _objectType_1 = genFeature.getObjectType(genCls);
                              _builder.append(_objectType_1, "\t\t");
                              _builder.append(")");
                              _builder.newLineIfNotEmpty();
                              _builder.append("\t");
                              _builder.append("\t");
                            }
                          }
                          _builder.append(" newValue);");
                          _builder.newLineIfNotEmpty();
                        }
                      }
                    }
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("return;");
                    _builder.newLine();
                  }
                }
                _builder.append("}");
                _builder.newLine();
                _builder.newLine();
                _builder.append("super.eSet(featureID, newValue);");
                _builder.newLine();
              }
            };
            MetaclassAdapterInferrer.this._jvmTypesBuilder.setBody(it, _client);
          }
        };
        JvmOperation _method_4 = this._jvmTypesBuilder.toMethod(mm, "eSet", this.typeRefBuilder.typeRef(Void.TYPE), _function_8);
        this._jvmTypesBuilder.<JvmOperation>operator_add(_members_4, _method_4);
      }
      if (((!genCls.getMixinGenFeatures().isEmpty()) || genCls.hasOffsetCorrection())) {
        EList<JvmMember> _members_5 = jvmCls.getMembers();
        final Procedure1<JvmOperation> _function_9 = new Procedure1<JvmOperation>() {
          @Override
          public void apply(final JvmOperation it) {
            EList<JvmAnnotationReference> _annotations = it.getAnnotations();
            JvmAnnotationReference _annotationRef = MetaclassAdapterInferrer.this.jvmAnnRefBuilder.annotationRef(Override.class);
            MetaclassAdapterInferrer.this._jvmTypesBuilder.<JvmAnnotationReference>operator_add(_annotations, _annotationRef);
            EList<JvmFormalParameter> _parameters = it.getParameters();
            JvmFormalParameter _parameter = MetaclassAdapterInferrer.this._jvmTypesBuilder.toParameter(mm, "derivedFeatureID", 
              MetaclassAdapterInferrer.this.typeRefBuilder.typeRef(Integer.TYPE));
            MetaclassAdapterInferrer.this._jvmTypesBuilder.<JvmFormalParameter>operator_add(_parameters, _parameter);
            EList<JvmFormalParameter> _parameters_1 = it.getParameters();
            JvmFormalParameter _parameter_1 = MetaclassAdapterInferrer.this._jvmTypesBuilder.toParameter(mm, "baseClass", 
              MetaclassAdapterInferrer.this.typeRefBuilder.typeRef(Class.class, 
                TypesFactory.eINSTANCE.createJvmWildcardTypeReference()));
            MetaclassAdapterInferrer.this._jvmTypesBuilder.<JvmFormalParameter>operator_add(_parameters_1, _parameter_1);
            StringConcatenationClient _client = new StringConcatenationClient() {
              @Override
              protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                {
                  List<GenClass> _mixinGenClasses = genCls.getMixinGenClasses();
                  for(final GenClass mixinCls : _mixinGenClasses) {
                    _builder.append("if (baseClass == ");
                    String _rawImportedInterfaceName = mixinCls.getRawImportedInterfaceName();
                    _builder.append(_rawImportedInterfaceName);
                    _builder.append(".class) {");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append("switch (derivedFeatureID");
                    _builder.append(negativeOffsetCorrection, "\t");
                    _builder.append(") {");
                    _builder.newLineIfNotEmpty();
                    {
                      EList<GenFeature> _genFeatures = mixinCls.getGenFeatures();
                      for(final GenFeature genFeature : _genFeatures) {
                        _builder.append("\t\t");
                        _builder.append("case ");
                        String _qualifiedFeatureID = genCls.getQualifiedFeatureID(genFeature);
                        _builder.append(_qualifiedFeatureID, "\t\t");
                        _builder.append(":");
                        _builder.newLineIfNotEmpty();
                        _builder.append("\t\t");
                        _builder.append("\t");
                        _builder.append("return ");
                        String _qualifiedFeatureID_1 = mixinCls.getQualifiedFeatureID(genFeature);
                        _builder.append(_qualifiedFeatureID_1, "\t\t\t");
                        _builder.append(";");
                        _builder.newLineIfNotEmpty();
                      }
                    }
                    _builder.append("\t\t");
                    _builder.append("default: return -1;");
                    _builder.newLine();
                    _builder.append("\t");
                    _builder.append("}");
                    _builder.newLine();
                    _builder.append("}");
                    _builder.newLine();
                  }
                }
                _builder.newLine();
                _builder.append("return super.eBaseStructuralFeatureID");
                _builder.append("(derivedFeatureID, baseClass);");
                _builder.newLine();
              }
            };
            MetaclassAdapterInferrer.this._jvmTypesBuilder.setBody(it, _client);
          }
        };
        JvmOperation _method_5 = this._jvmTypesBuilder.toMethod(mm, "eBaseStructuralFeatureID", this.typeRefBuilder.typeRef(Integer.TYPE), _function_9);
        this._jvmTypesBuilder.<JvmOperation>operator_add(_members_5, _method_5);
        EList<JvmMember> _members_6 = jvmCls.getMembers();
        final Procedure1<JvmOperation> _function_10 = new Procedure1<JvmOperation>() {
          @Override
          public void apply(final JvmOperation it) {
            EList<JvmAnnotationReference> _annotations = it.getAnnotations();
            JvmAnnotationReference _annotationRef = MetaclassAdapterInferrer.this.jvmAnnRefBuilder.annotationRef(Override.class);
            MetaclassAdapterInferrer.this._jvmTypesBuilder.<JvmAnnotationReference>operator_add(_annotations, _annotationRef);
            EList<JvmFormalParameter> _parameters = it.getParameters();
            JvmFormalParameter _parameter = MetaclassAdapterInferrer.this._jvmTypesBuilder.toParameter(mm, "baseFeatureID", 
              MetaclassAdapterInferrer.this.typeRefBuilder.typeRef(Integer.TYPE));
            MetaclassAdapterInferrer.this._jvmTypesBuilder.<JvmFormalParameter>operator_add(_parameters, _parameter);
            EList<JvmFormalParameter> _parameters_1 = it.getParameters();
            JvmFormalParameter _parameter_1 = MetaclassAdapterInferrer.this._jvmTypesBuilder.toParameter(mm, "baseClass", 
              MetaclassAdapterInferrer.this.typeRefBuilder.typeRef(Class.class, 
                TypesFactory.eINSTANCE.createJvmWildcardTypeReference()));
            MetaclassAdapterInferrer.this._jvmTypesBuilder.<JvmFormalParameter>operator_add(_parameters_1, _parameter_1);
            StringConcatenationClient _client = new StringConcatenationClient() {
              @Override
              protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                {
                  List<GenClass> _mixinGenClasses = genCls.getMixinGenClasses();
                  for(final GenClass mixinCls : _mixinGenClasses) {
                    _builder.append("if (baseClass == ");
                    String _rawImportedInterfaceName = mixinCls.getRawImportedInterfaceName();
                    _builder.append(_rawImportedInterfaceName);
                    _builder.append(".class) {");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append("switch (baseFeatureID) {");
                    _builder.newLine();
                    {
                      EList<GenFeature> _genFeatures = mixinCls.getGenFeatures();
                      for(final GenFeature genFeature : _genFeatures) {
                        _builder.append("\t\t");
                        _builder.append("case ");
                        String _qualifiedFeatureID = mixinCls.getQualifiedFeatureID(genFeature);
                        _builder.append(_qualifiedFeatureID, "\t\t");
                        _builder.append(":");
                        _builder.newLineIfNotEmpty();
                        _builder.append("\t\t");
                        _builder.append("\t");
                        _builder.append("return ");
                        String _qualifiedFeatureID_1 = genCls.getQualifiedFeatureID(genFeature);
                        _builder.append(_qualifiedFeatureID_1, "\t\t\t");
                        _builder.append(";");
                        _builder.newLineIfNotEmpty();
                      }
                    }
                    _builder.append("\t\t");
                    _builder.append("default: return -1;");
                    _builder.newLine();
                    _builder.append("\t");
                    _builder.append("}");
                    _builder.newLine();
                    _builder.append("}");
                    _builder.newLine();
                  }
                }
                _builder.newLine();
                {
                  boolean _hasOffsetCorrection = genCls.hasOffsetCorrection();
                  if (_hasOffsetCorrection) {
                    _builder.append("if (baseClass == ");
                    String _rawImportedInterfaceName_1 = genCls.getRawImportedInterfaceName();
                    _builder.append(_rawImportedInterfaceName_1);
                    _builder.append(".class) {");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append("switch (baseFeatureID");
                    _builder.append(negativeOffsetCorrection, "\t");
                    _builder.append(") {");
                    _builder.newLineIfNotEmpty();
                    {
                      EList<GenFeature> _genFeatures_1 = genCls.getGenFeatures();
                      for(final GenFeature genFeature_1 : _genFeatures_1) {
                        _builder.append("\t\t");
                        _builder.append("case ");
                        String _qualifiedFeatureID_2 = genCls.getQualifiedFeatureID(genFeature_1);
                        _builder.append(_qualifiedFeatureID_2, "\t\t");
                        _builder.append(":");
                        _builder.newLineIfNotEmpty();
                        _builder.append("\t\t");
                        _builder.append("\t");
                        _builder.append("return ");
                        String _qualifiedFeatureID_3 = genCls.getQualifiedFeatureID(genFeature_1);
                        _builder.append(_qualifiedFeatureID_3, "\t\t\t");
                        _builder.append(positiveOffsetCorrection, "\t\t\t");
                        _builder.append(";");
                        _builder.newLineIfNotEmpty();
                      }
                    }
                    _builder.append("\t\t");
                    _builder.append("default: return -1;");
                    _builder.newLine();
                    _builder.append("\t");
                    _builder.append("}");
                    _builder.newLine();
                    _builder.append("}");
                    _builder.newLine();
                  }
                }
                _builder.newLine();
                _builder.append("return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);");
                _builder.newLine();
              }
            };
            MetaclassAdapterInferrer.this._jvmTypesBuilder.setBody(it, _client);
          }
        };
        JvmOperation _method_6 = this._jvmTypesBuilder.toMethod(mm, "eDerivedStructuralFeatureID", 
          this.typeRefBuilder.typeRef(Integer.TYPE), _function_10);
        this._jvmTypesBuilder.<JvmOperation>operator_add(_members_6, _method_6);
      }
    }
  }
  
  /**
   * Checks whether the given {@link JvmTypeReference} {@code ref} can be
   * used in code generation, ie. it points to a non-null {@link JvmType}
   */
  private boolean isValidReturnType(final JvmTypeReference ref) {
    return (((ref.getType() != null) && (!Objects.equal(ref.getType().getSimpleName(), "void"))) && (!Objects.equal(ref.getType().getSimpleName(), "null")));
  }
}
