/**
 * Copyright (c) 2017 Inria and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Inria - initial API and implementation
 */
package fr.inria.diverse.melange.processors;

import fr.inria.diverse.melange.ast.LanguageExtensions;
import fr.inria.diverse.melange.eclipse.EclipseProjectHelper;
import fr.inria.diverse.melange.metamodel.melange.Language;
import fr.inria.diverse.melange.metamodel.melange.Metamodel;
import fr.inria.diverse.melange.processors.DispatchMelangeProcessor;
import java.util.Arrays;
import javax.inject.Inject;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.xbase.lib.Extension;

/**
 * For each {@link Language} in the current Melange file, if its runtime is
 * generated by Melange, set its #ecoreUri to the Ecore file generated in
 * the external project by the compiler.
 */
@SuppressWarnings("all")
public class EcoreUriInferrer extends DispatchMelangeProcessor {
  @Inject
  @Extension
  private LanguageExtensions _languageExtensions;
  
  @Inject
  @Extension
  private EclipseProjectHelper _eclipseProjectHelper;
  
  protected void _preProcess(final Language l, final boolean preLinkingPhase) {
    final IProject project = this._eclipseProjectHelper.getProject(l.eResource());
    if ((this._languageExtensions.isGeneratedByMelange(l) && (project != null))) {
      boolean _exists = project.getFile(this._languageExtensions.getExternalEcorePath(l)).exists();
      if (_exists) {
        Metamodel _syntax = l.getSyntax();
        _syntax.setEcoreUri(this._languageExtensions.getExternalEcoreUri(l));
      }
    }
  }
  
  public void preProcess(final EObject l, final boolean preLinkingPhase) {
    if (l instanceof Language) {
      _preProcess((Language)l, preLinkingPhase);
      return;
    } else if (l != null) {
      _preProcess(l, preLinkingPhase);
      return;
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(l, preLinkingPhase).toString());
    }
  }
}
