/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.eef.runtime.ui.widgets.imageviewer;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.eef.runtime.EEFRuntimePlugin;
import org.eclipse.emf.eef.runtime.ui.utils.EditingUtils;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;

public class EEFImageViewer
extends Composite
implements ISelectionProvider {
    private static final String[] EXTENSIONS = new String[]{"*.png", "*.bmp", "*.jpeg", "*.jpg", "*.gif", "*.*"};
    private Canvas viewerCanvas;
    private String key;
    private String imagePath;
    private List<ISelectionChangedListener> listeners = new ArrayList<ISelectionChangedListener>();

    public EEFImageViewer(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout());
        this.viewerCanvas = new Canvas((Composite)this, 0);
        this.viewerCanvas.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                if (EEFImageViewer.this.isEnabled()) {
                    FileDialog dialog = new FileDialog(EEFImageViewer.this.getParent().getShell(), 4096);
                    dialog.setFilterExtensions(EXTENSIONS);
                    String fn = dialog.open();
                    if (fn != null) {
                        EEFImageViewer.this.updateImage(fn);
                        SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)EEFImageViewer.this, (ISelection)new StructuredSelection((Object)fn));
                        for (ISelectionChangedListener listener : EEFImageViewer.this.listeners) {
                            listener.selectionChanged(event);
                        }
                    }
                }
            }
        });
        EditingUtils.setEEFtype((Control)this.viewerCanvas, "eef::ImageViewer");
    }

    public void initViewer(String key, String imagePath) {
        this.key = key;
        this.updateImage(imagePath);
    }

    public void setID(Object id) {
        EditingUtils.setID((Control)this.viewerCanvas, id);
    }

    public Object getID() {
        return EditingUtils.getID((Control)this.viewerCanvas);
    }

    private void updateImage(String imagePath) {
        this.imagePath = imagePath;
        EEFRuntimePlugin.getDefault().registerImage(this.key, imagePath);
        Image image = EEFRuntimePlugin.getDefault().getRegisteredImage(this.key);
        if (image != null) {
            Image newImage = null;
            if (this.getLayoutData() instanceof GridData) {
                GridData gridData = (GridData)this.getLayoutData();
                newImage = new Image(image.getDevice(), image.getImageData().scaledTo(gridData.widthHint, gridData.heightHint));
            }
            if (newImage == null) {
                this.viewerCanvas.setBackgroundImage(image);
            } else {
                this.viewerCanvas.setBackgroundImage(newImage);
            }
        }
        this.viewerCanvas.redraw();
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.add(listener);
    }

    public ISelection getSelection() {
        if (this.imagePath != null) {
            return new StructuredSelection((Object)this.imagePath);
        }
        return new StructuredSelection((Object)"");
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.remove(listener);
    }

    public void setSelection(ISelection selection) {
        StructuredSelection sSelection;
        if (selection instanceof StructuredSelection && (sSelection = (StructuredSelection)selection).getFirstElement() instanceof String) {
            String path = (String)sSelection.getFirstElement();
            this.updateImage(path);
        }
    }
}

