/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.userstorage.internal;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.userstorage.IStorageService;
import org.eclipse.userstorage.internal.Session;
import org.eclipse.userstorage.internal.StorageServiceRegistry;
import org.eclipse.userstorage.internal.util.StringUtil;
import org.eclipse.userstorage.spi.AbstractCredentialsProvider;
import org.eclipse.userstorage.spi.Credentials;
import org.eclipse.userstorage.spi.ICredentialsProvider;
import org.eclipse.userstorage.util.NoServiceException;
import org.osgi.framework.BundleContext;

public class Activator
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.userstorage";
    public static final boolean PLATFORM_RUNNING;
    public static final CancelCredentialsProvider CANCEL_CREDENTIALS_PROVIDER;
    private static Activator plugin;
    private static ICredentialsProvider credentialsProvider;

    static {
        CANCEL_CREDENTIALS_PROVIDER = new CancelCredentialsProvider();
        boolean result = false;
        try {
            result = Platform.isRunning();
        }
        catch (Throwable throwable) {}
        PLATFORM_RUNNING = result;
        credentialsProvider = CANCEL_CREDENTIALS_PROVIDER;
    }

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        plugin = this;
        Activator.start();
    }

    public void stop(BundleContext context) throws Exception {
        Activator.stop();
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static void log(IStatus status) {
        if (plugin != null) {
            plugin.getLog().log(status);
        } else if (status.getSeverity() == 4) {
            Throwable exception = status.getException();
            if (exception != null) {
                exception.printStackTrace();
            } else {
                System.err.println(status);
            }
        } else {
            System.out.println(status);
        }
    }

    public static void log(Throwable t, int severity) {
        Activator.log(Activator.getStatus(t, severity));
    }

    public static String log(Throwable t) {
        IStatus status = Activator.getStatus(t);
        Activator.log(status);
        return status.getMessage();
    }

    public static IStatus getStatus(Object obj) {
        if (obj instanceof CoreException) {
            CoreException coreException = (CoreException)obj;
            return coreException.getStatus();
        }
        if (obj instanceof Throwable) {
            Throwable t = (Throwable)obj;
            return Activator.getStatus(t, 4);
        }
        return new Status(1, PLUGIN_ID, obj.toString(), null);
    }

    public static IStatus getStatus(Throwable t, int severity) {
        String msg = t.getLocalizedMessage();
        if (StringUtil.isEmpty(msg)) {
            msg = t.getClass().getName();
        }
        return new Status(severity, PLUGIN_ID, msg, t);
    }

    public static ISecurePreferences getSecurePreferences() {
        if (PLATFORM_RUNNING) {
            return SecurePreferencesFactory.getDefault().node(PLUGIN_ID);
        }
        return null;
    }

    public static ICredentialsProvider getCredentialsProvider() {
        return credentialsProvider;
    }

    public static void start() throws Exception {
        if (PLATFORM_RUNNING) {
            Activator.initCredentialsProvider();
        }
        StorageServiceRegistry.INSTANCE.start();
    }

    public static void stop() throws Exception {
        StorageServiceRegistry.INSTANCE.stop();
        credentialsProvider = null;
    }

    private static void initCredentialsProvider() {
        try {
            IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
            IConfigurationElement prioritizedConfigurationElement = null;
            int highestPriority = Integer.MIN_VALUE;
            IConfigurationElement[] iConfigurationElementArray = extensionRegistry.getConfigurationElementsFor("org.eclipse.userstorage.credentialsProviders");
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement configurationElement = iConfigurationElementArray[n2];
                try {
                    String priorityAttribute = configurationElement.getAttribute("priority");
                    int priority = 500;
                    try {
                        priority = Integer.parseInt(priorityAttribute);
                    }
                    catch (NumberFormatException numberFormatException) {}
                    if (priority > highestPriority) {
                        prioritizedConfigurationElement = configurationElement;
                        highestPriority = priority;
                    }
                }
                catch (Exception ex) {
                    Activator.log(ex);
                }
                ++n2;
            }
            if (prioritizedConfigurationElement != null) {
                credentialsProvider = (ICredentialsProvider)prioritizedConfigurationElement.createExecutableExtension("class");
            }
        }
        catch (Exception ex) {
            Activator.log(ex);
        }
    }

    private static final class CancelCredentialsProvider
    extends AbstractCredentialsProvider {
        private CancelCredentialsProvider() {
        }

        @Override
        public Credentials provideCredentials(IStorageService service, boolean reauthentication) {
            return null;
        }

        @Override
        public Session openSession(IStorageService service) throws NoServiceException {
            throw new NoServiceException();
        }
    }
}

