/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.server.actions;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.glsp.server.actions.Action;
import org.eclipse.glsp.server.actions.ActionHandler;
import org.eclipse.glsp.server.actions.ActionMessage;
import org.eclipse.glsp.server.model.GModelState;
import org.eclipse.glsp.server.protocol.GLSPClient;

public class ClientActionHandler
implements ActionHandler {
    public static final String CLIENT_ACTIONS = "ClientActionHandler";
    @Inject
    protected Provider<GLSPClient> client;
    private final List<Class<? extends Action>> handledActionTypes;

    @Inject
    public ClientActionHandler(@Named(value="ClientActionHandler") Set<Action> clientActions) {
        this.handledActionTypes = clientActions.stream().map(Object::getClass).collect(Collectors.toList());
    }

    @Override
    public List<Class<? extends Action>> getHandledActionTypes() {
        return this.handledActionTypes;
    }

    @Override
    public List<Action> execute(Action action, GModelState modelState) {
        this.send(modelState.getClientId(), action);
        return Collections.emptyList();
    }

    protected void send(String clientId, Action action) {
        ActionMessage message = new ActionMessage(clientId, action);
        ((GLSPClient)this.client.get()).process(message);
    }
}

