/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.graph.gson;

import com.google.gson.ExclusionStrategy;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapterFactory;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.glsp.graph.GraphPackage;
import org.eclipse.glsp.graph.gson.ClassBasedDeserializer;
import org.eclipse.glsp.graph.gson.EMapTypeAdapter;
import org.eclipse.glsp.graph.gson.EObjectExclusionStrategy;
import org.eclipse.glsp.graph.gson.GModelElementTypeAdapter;

public class GraphGsonConfigurator {
    public static final String DEFAULT_TYPE_ATT = "type";
    private final Map<String, EClass> typeMap = new HashMap<String, EClass>();
    private final List<EPackage> ePackages = new ArrayList<EPackage>();

    public GraphGsonConfigurator() {
        this.withEPackages(GraphPackage.eINSTANCE);
    }

    public GraphGsonConfigurator withDefaultTypes() {
        HashMap<String, EClass> defaultTypes = new HashMap<String, EClass>();
        defaultTypes.put("graph", GraphPackage.Literals.GGRAPH);
        defaultTypes.put("node", GraphPackage.Literals.GNODE);
        defaultTypes.put("edge", GraphPackage.Literals.GEDGE);
        defaultTypes.put("comp", GraphPackage.Literals.GCOMPARTMENT);
        defaultTypes.put("label", GraphPackage.Literals.GLABEL);
        return this.withTypes(defaultTypes);
    }

    public GraphGsonConfigurator withTypes(Map<String, EClass> types) {
        this.typeMap.putAll(types);
        return this;
    }

    public GraphGsonConfigurator withEPackages(EPackage ... packages) {
        this.ePackages.addAll(Arrays.asList(packages));
        return this;
    }

    public GsonBuilder configureGsonBuilder(GsonBuilder gsonBuilder) {
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new EMapTypeAdapter.Factory());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new GModelElementTypeAdapter.Factory(DEFAULT_TYPE_ATT, this.typeMap));
        this.configureClassesOfPackages(gsonBuilder);
        gsonBuilder.addSerializationExclusionStrategy((ExclusionStrategy)new EObjectExclusionStrategy());
        return gsonBuilder;
    }

    protected void configureClassesOfPackages(GsonBuilder gsonBuilder) {
        for (EPackage pkg : this.ePackages) {
            for (EClassifier classifier : pkg.getEClassifiers()) {
                if (!(classifier instanceof EClass) || ((EClass)classifier).isAbstract()) continue;
                Class<? extends EObject> implClass = this.getImplementationClass((EClass)classifier, pkg);
                gsonBuilder.registerTypeAdapter((Type)classifier.getInstanceClass(), (Object)new ClassBasedDeserializer(implClass));
            }
        }
    }

    private Class<? extends EObject> getImplementationClass(EClass eClass, EPackage pkg) {
        return pkg.getEFactoryInstance().create(eClass).getClass();
    }
}

