/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.server.internal.toolpalette;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.glsp.server.actions.TriggerElementCreationAction;
import org.eclipse.glsp.server.features.directediting.LabeledAction;
import org.eclipse.glsp.server.features.toolpalette.PaletteItem;
import org.eclipse.glsp.server.features.toolpalette.ToolPaletteItemProvider;
import org.eclipse.glsp.server.operations.CreateEdgeOperation;
import org.eclipse.glsp.server.operations.CreateNodeOperation;
import org.eclipse.glsp.server.operations.CreateOperation;
import org.eclipse.glsp.server.operations.CreateOperationHandler;
import org.eclipse.glsp.server.operations.OperationHandlerRegistry;

public class DefaultToolPaletteItemProvider
implements ToolPaletteItemProvider {
    @Inject
    protected OperationHandlerRegistry operationHandlerRegistry;
    private int counter;

    @Override
    public List<PaletteItem> getItems(Map<String, String> args) {
        List<CreateOperationHandler> handlers = this.operationHandlerRegistry.getAll().stream().filter(CreateOperationHandler.class::isInstance).map(CreateOperationHandler.class::cast).collect(Collectors.toList());
        this.counter = 0;
        List<PaletteItem> nodes = this.createPaletteItems(handlers, CreateNodeOperation.class);
        List<PaletteItem> edges = this.createPaletteItems(handlers, CreateEdgeOperation.class);
        return new ArrayList<PaletteItem>(List.of(PaletteItem.createPaletteGroup("node-group", "Nodes", nodes, "symbol-property", "A"), PaletteItem.createPaletteGroup("edge-group", "Edges", edges, "symbol-property", "B")));
    }

    protected List<PaletteItem> createPaletteItems(List<CreateOperationHandler> handlers, Class<? extends CreateOperation> operationClass) {
        return handlers.stream().filter(handler -> operationClass.isAssignableFrom(handler.getHandledOperationType())).flatMap(handler -> handler.getTriggerActions().stream().map(action -> this.create((TriggerElementCreationAction)action, handler.getLabel()))).sorted(Comparator.comparing(LabeledAction::getLabel)).collect(Collectors.toList());
    }

    protected PaletteItem create(TriggerElementCreationAction action, String label) {
        return new PaletteItem("palette-item" + this.counter++, label, action);
    }
}

