/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.jdt.docker.launcher;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.internal.launching.StandardVMRunner;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.VMRunnerConfiguration;
import org.eclipse.linuxtools.docker.core.IDockerContainerInfo;
import org.eclipse.linuxtools.docker.ui.launch.ContainerLauncher;
import org.eclipse.linuxtools.docker.ui.launch.IContainerLaunchListener;
import org.eclipse.linuxtools.internal.docker.core.DockerConnection;
import org.eclipse.linuxtools.jdt.docker.launcher.ContainerVMInstall;
import org.eclipse.linuxtools.jdt.docker.launcher.ImageQuery;
import org.eclipse.linuxtools.jdt.docker.launcher.Messages;
import org.eclipse.linuxtools.jdt.docker.launcher.UnixFile;
import org.eclipse.osgi.util.NLS;

public class ContainerVMRunner
extends StandardVMRunner {
    private String ipAddress = null;
    private boolean isListening = false;
    private List<String> extraDirs;
    private IDockerContainerInfo containerInfo;

    public ContainerVMRunner(IVMInstall vmInstance) {
        super(vmInstance);
    }

    protected Process exec(String[] cmdLine, File workingDirectory) throws CoreException {
        return this.exec(cmdLine, workingDirectory, null);
    }

    protected Process exec(String[] cmdLine, File workingDirectory, String[] envp) throws CoreException {
        return this.exec(cmdLine, workingDirectory, envp, false);
    }

    protected Process exec(String[] cmdLine, File workingDirectory, String[] envp, boolean mergeOutput) throws CoreException {
        String[] stringArray;
        String connectionUri = ((ContainerVMInstall)this.fVMInstance).getConnection().getUri();
        String command = String.join((CharSequence)" ", cmdLine);
        Object newWD = workingDirectory.getAbsolutePath();
        String[] classPath = this.extractClassPathFromCommand(cmdLine);
        ArrayList<String> additionalDirs = new ArrayList<String>();
        additionalDirs.addAll(Arrays.asList(classPath));
        additionalDirs.addAll(this.getAdditionalDirectories());
        if ("win32".equals(Platform.getOS())) {
            newWD = UnixFile.convertDOSPathToUnixPath(workingDirectory.getAbsolutePath());
        }
        if (!((String)newWD).endsWith("/")) {
            newWD = (String)newWD + "/";
        }
        ArrayList<Object> modAdditionalDirs = new ArrayList<Object>();
        for (String addDir : additionalDirs) {
            if (!addDir.endsWith("/")) {
                modAdditionalDirs.add(addDir + "/");
                continue;
            }
            modAdditionalDirs.add(addDir);
        }
        ContainerLauncher launch = new ContainerLauncher();
        int port = ((ContainerVMInstall)this.fVMInstance).getPort();
        if (port != -1) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = String.valueOf(port) + ":" + String.valueOf(port);
        } else {
            stringArray = new String[]{};
        }
        String[] portMap = stringArray;
        launch.launch("org.eclipse.linuxtools.jdt.docker.launcher", (IContainerLaunchListener)new JavaAppInContainerLaunchListener(), connectionUri, this.fVMInstance.getId(), command, null, (String)newWD, modAdditionalDirs, System.getenv(), null, Arrays.asList(portMap), false, true, true);
        return super.exec(new String[]{"/bin/true"}, null);
    }

    protected String constructProgramString(VMRunnerConfiguration config) throws CoreException {
        String installLocation;
        UnixFile exe;
        String command = null;
        Map map = config.getVMSpecificAttributesMap();
        if (map != null) {
            command = (String)map.get(IJavaLaunchConfigurationConstants.ATTR_JAVA_COMMAND);
        }
        if (command == null) {
            File exe2 = null;
            if (this.fVMInstance instanceof ContainerVMInstall) {
                exe2 = ((ContainerVMInstall)this.fVMInstance).getJavaExecutable();
            }
            if (exe2 == null) {
                this.abort(Messages.ContainerVMRunner_Unable_to_locate_executable_for__0__1, null, 150);
            } else {
                return exe2.getAbsolutePath();
            }
        }
        if (this.fileExists(exe = new UnixFile((installLocation = this.fVMInstance.getInstallLocation().getAbsolutePath() + "/") + "bin/" + command))) {
            return ((File)exe).getAbsolutePath();
        }
        if (this.fileExists(exe = new UnixFile(((File)exe).getAbsolutePath() + ".exe"))) {
            return ((File)exe).getAbsolutePath();
        }
        exe = new UnixFile(installLocation + "jre/bin/" + command);
        if (this.fileExists(exe)) {
            return ((File)exe).getAbsolutePath();
        }
        if (this.fileExists(exe = new UnixFile(((File)exe).getAbsolutePath() + ".exe"))) {
            return ((File)exe).getAbsolutePath();
        }
        this.abort(NLS.bind((String)Messages.ContainerVMRunner_Specified_executable__0__does_not_exist_for__1__4, (Object[])new String[]{command, this.fVMInstance.getName()}), null, 150);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean fileExists(File file) {
        DockerConnection conn = ((ContainerVMInstall)this.fVMInstance).getConnection();
        ImageQuery q = new ImageQuery(conn, this.fVMInstance.getId());
        try {
            boolean bl = q.isFile(file);
            return bl;
        }
        finally {
            q.destroy();
        }
    }

    public String getIPAddress() {
        return this.ipAddress;
    }

    public boolean isListening() {
        return this.isListening;
    }

    private String[] extractClassPathFromCommand(String[] cmd) {
        int i;
        for (i = 0; i < cmd.length && !"-classpath".equals(cmd[i]); ++i) {
        }
        String[] classPath = cmd.length > i + 1 ? cmd[i + 1].split(":") : new String[]{};
        return classPath;
    }

    public void setAdditionalDirectories(List<String> dirs) {
        this.extraDirs = dirs;
    }

    public List<String> getAdditionalDirectories() {
        return this.extraDirs;
    }

    public IDockerContainerInfo getContainerInfo() {
        return this.containerInfo;
    }

    private class JavaAppInContainerLaunchListener
    implements IContainerLaunchListener {
        private JavaAppInContainerLaunchListener() {
        }

        public void newOutput(String output) {
            if (output.contains("dt_socket")) {
                ContainerVMRunner.this.isListening = true;
            }
        }

        public void done() {
        }

        public void containerInfo(IDockerContainerInfo info) {
            ContainerVMRunner.this.ipAddress = info.networkSettings().ipAddress();
            ContainerVMRunner.this.containerInfo = info;
        }
    }
}

