/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.mandas.docker.Nullable;
import org.mandas.docker.client.messages.Ipam;
import org.mandas.docker.client.messages.Network;

final class ImmutableNetwork
implements Network {
    private final String name;
    private final String id;
    private final String scope;
    private final String driver;
    private final Ipam ipam;
    @Nullable
    private final Map<String, Network.Container> containers;
    @Nullable
    private final Map<String, String> options;
    @Nullable
    private final Boolean internal;
    @Nullable
    private final Boolean enableIPv6;
    @Nullable
    private final Map<String, String> labels;
    @Nullable
    private final Boolean attachable;

    private ImmutableNetwork(String name, String id, String scope, String driver, Ipam ipam, @Nullable Map<String, Network.Container> containers, @Nullable Map<String, String> options, @Nullable Boolean internal, @Nullable Boolean enableIPv6, @Nullable Map<String, String> labels, @Nullable Boolean attachable) {
        this.name = name;
        this.id = id;
        this.scope = scope;
        this.driver = driver;
        this.ipam = ipam;
        this.containers = containers;
        this.options = options;
        this.internal = internal;
        this.enableIPv6 = enableIPv6;
        this.labels = labels;
        this.attachable = attachable;
    }

    @Override
    @JsonProperty(value="Name")
    public String name() {
        return this.name;
    }

    @Override
    @JsonProperty(value="Id")
    public String id() {
        return this.id;
    }

    @Override
    @JsonProperty(value="Scope")
    public String scope() {
        return this.scope;
    }

    @Override
    @JsonProperty(value="Driver")
    public String driver() {
        return this.driver;
    }

    @Override
    @JsonProperty(value="IPAM")
    public Ipam ipam() {
        return this.ipam;
    }

    @Override
    @JsonProperty(value="Containers")
    @Nullable
    public Map<String, Network.Container> containers() {
        return this.containers;
    }

    @Override
    @JsonProperty(value="Options")
    @Nullable
    public Map<String, String> options() {
        return this.options;
    }

    @Override
    @JsonProperty(value="Internal")
    @Nullable
    public Boolean internal() {
        return this.internal;
    }

    @Override
    @JsonProperty(value="EnableIPv6")
    @Nullable
    public Boolean enableIPv6() {
        return this.enableIPv6;
    }

    @Override
    @JsonProperty(value="Labels")
    @Nullable
    public Map<String, String> labels() {
        return this.labels;
    }

    @Override
    @JsonProperty(value="Attachable")
    @Nullable
    public Boolean attachable() {
        return this.attachable;
    }

    public final ImmutableNetwork withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableNetwork(newValue, this.id, this.scope, this.driver, this.ipam, this.containers, this.options, this.internal, this.enableIPv6, this.labels, this.attachable);
    }

    public final ImmutableNetwork withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImmutableNetwork(this.name, newValue, this.scope, this.driver, this.ipam, this.containers, this.options, this.internal, this.enableIPv6, this.labels, this.attachable);
    }

    public final ImmutableNetwork withScope(String value) {
        String newValue = Objects.requireNonNull(value, "scope");
        if (this.scope.equals(newValue)) {
            return this;
        }
        return new ImmutableNetwork(this.name, this.id, newValue, this.driver, this.ipam, this.containers, this.options, this.internal, this.enableIPv6, this.labels, this.attachable);
    }

    public final ImmutableNetwork withDriver(String value) {
        String newValue = Objects.requireNonNull(value, "driver");
        if (this.driver.equals(newValue)) {
            return this;
        }
        return new ImmutableNetwork(this.name, this.id, this.scope, newValue, this.ipam, this.containers, this.options, this.internal, this.enableIPv6, this.labels, this.attachable);
    }

    public final ImmutableNetwork withIpam(Ipam value) {
        if (this.ipam == value) {
            return this;
        }
        Ipam newValue = Objects.requireNonNull(value, "ipam");
        return new ImmutableNetwork(this.name, this.id, this.scope, this.driver, newValue, this.containers, this.options, this.internal, this.enableIPv6, this.labels, this.attachable);
    }

    public final ImmutableNetwork withContainers(@Nullable Map<String, ? extends Network.Container> entries) {
        if (this.containers == entries) {
            return this;
        }
        Map<String, Network.Container> newValue = entries == null ? null : ImmutableNetwork.createUnmodifiableMap(true, false, entries);
        return new ImmutableNetwork(this.name, this.id, this.scope, this.driver, this.ipam, newValue, this.options, this.internal, this.enableIPv6, this.labels, this.attachable);
    }

    public final ImmutableNetwork withOptions(@Nullable Map<String, ? extends String> entries) {
        if (this.options == entries) {
            return this;
        }
        Map<String, String> newValue = entries == null ? null : ImmutableNetwork.createUnmodifiableMap(true, false, entries);
        return new ImmutableNetwork(this.name, this.id, this.scope, this.driver, this.ipam, this.containers, newValue, this.internal, this.enableIPv6, this.labels, this.attachable);
    }

    public final ImmutableNetwork withInternal(@Nullable Boolean value) {
        if (Objects.equals(this.internal, value)) {
            return this;
        }
        return new ImmutableNetwork(this.name, this.id, this.scope, this.driver, this.ipam, this.containers, this.options, value, this.enableIPv6, this.labels, this.attachable);
    }

    public final ImmutableNetwork withEnableIPv6(@Nullable Boolean value) {
        if (Objects.equals(this.enableIPv6, value)) {
            return this;
        }
        return new ImmutableNetwork(this.name, this.id, this.scope, this.driver, this.ipam, this.containers, this.options, this.internal, value, this.labels, this.attachable);
    }

    public final ImmutableNetwork withLabels(@Nullable Map<String, ? extends String> entries) {
        if (this.labels == entries) {
            return this;
        }
        Map<String, String> newValue = entries == null ? null : ImmutableNetwork.createUnmodifiableMap(true, false, entries);
        return new ImmutableNetwork(this.name, this.id, this.scope, this.driver, this.ipam, this.containers, this.options, this.internal, this.enableIPv6, newValue, this.attachable);
    }

    public final ImmutableNetwork withAttachable(@Nullable Boolean value) {
        if (Objects.equals(this.attachable, value)) {
            return this;
        }
        return new ImmutableNetwork(this.name, this.id, this.scope, this.driver, this.ipam, this.containers, this.options, this.internal, this.enableIPv6, this.labels, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableNetwork && this.equalTo(0, (ImmutableNetwork)another);
    }

    private boolean equalTo(int synthetic, ImmutableNetwork another) {
        return this.name.equals(another.name) && this.id.equals(another.id) && this.scope.equals(another.scope) && this.driver.equals(another.driver) && this.ipam.equals(another.ipam) && Objects.equals(this.containers, another.containers) && Objects.equals(this.options, another.options) && Objects.equals(this.internal, another.internal) && Objects.equals(this.enableIPv6, another.enableIPv6) && Objects.equals(this.labels, another.labels) && Objects.equals(this.attachable, another.attachable);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.scope.hashCode();
        h += (h << 5) + this.driver.hashCode();
        h += (h << 5) + this.ipam.hashCode();
        h += (h << 5) + Objects.hashCode(this.containers);
        h += (h << 5) + Objects.hashCode(this.options);
        h += (h << 5) + Objects.hashCode(this.internal);
        h += (h << 5) + Objects.hashCode(this.enableIPv6);
        h += (h << 5) + Objects.hashCode(this.labels);
        h += (h << 5) + Objects.hashCode(this.attachable);
        return h;
    }

    public String toString() {
        return "Network{name=" + this.name + ", id=" + this.id + ", scope=" + this.scope + ", driver=" + this.driver + ", ipam=" + String.valueOf(this.ipam) + ", containers=" + String.valueOf(this.containers) + ", options=" + String.valueOf(this.options) + ", internal=" + this.internal + ", enableIPv6=" + this.enableIPv6 + ", labels=" + String.valueOf(this.labels) + ", attachable=" + this.attachable + "}";
    }

    public static ImmutableNetwork copyOf(Network instance) {
        if (instance instanceof ImmutableNetwork) {
            return (ImmutableNetwork)instance;
        }
        return ImmutableNetwork.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + String.valueOf(k) : null);
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size() * 4 / 3 + 1);
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + String.valueOf(k) : null);
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_ID = 2L;
        private static final long INIT_BIT_SCOPE = 4L;
        private static final long INIT_BIT_DRIVER = 8L;
        private static final long INIT_BIT_IPAM = 16L;
        private long initBits = 31L;
        private String name;
        private String id;
        private String scope;
        private String driver;
        private Ipam ipam;
        private Map<String, Network.Container> containers = null;
        private Map<String, String> options = null;
        private Boolean internal;
        private Boolean enableIPv6;
        private Map<String, String> labels = null;
        private Boolean attachable;

        private Builder() {
        }

        public final Builder from(Network instance) {
            Boolean attachableValue;
            Map<String, String> labelsValue;
            Boolean enableIPv6Value;
            Boolean internalValue;
            Map<String, String> optionsValue;
            Objects.requireNonNull(instance, "instance");
            this.name(instance.name());
            this.id(instance.id());
            this.scope(instance.scope());
            this.driver(instance.driver());
            this.ipam(instance.ipam());
            Map<String, Network.Container> containersValue = instance.containers();
            if (containersValue != null) {
                this.putAllContainers(containersValue);
            }
            if ((optionsValue = instance.options()) != null) {
                this.putAllOptions(optionsValue);
            }
            if ((internalValue = instance.internal()) != null) {
                this.internal(internalValue);
            }
            if ((enableIPv6Value = instance.enableIPv6()) != null) {
                this.enableIPv6(enableIPv6Value);
            }
            if ((labelsValue = instance.labels()) != null) {
                this.putAllLabels(labelsValue);
            }
            if ((attachableValue = instance.attachable()) != null) {
                this.attachable(attachableValue);
            }
            return this;
        }

        @JsonProperty(value="Name")
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="Id")
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="Scope")
        public final Builder scope(String scope) {
            this.scope = Objects.requireNonNull(scope, "scope");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="Driver")
        public final Builder driver(String driver) {
            this.driver = Objects.requireNonNull(driver, "driver");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="IPAM")
        public final Builder ipam(Ipam ipam) {
            this.ipam = Objects.requireNonNull(ipam, "ipam");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder addContainer(String key, Network.Container value) {
            if (this.containers == null) {
                this.containers = new LinkedHashMap<String, Network.Container>();
            }
            this.containers.put(Objects.requireNonNull(key, "containers key"), Objects.requireNonNull(value, value == null ? "containers value for key: " + key : null));
            return this;
        }

        public final Builder addContainer(Map.Entry<String, ? extends Network.Container> entry) {
            Network.Container v;
            if (this.containers == null) {
                this.containers = new LinkedHashMap<String, Network.Container>();
            }
            String k = entry.getKey();
            this.containers.put(Objects.requireNonNull(k, "containers key"), Objects.requireNonNull(v, (v = entry.getValue()) == null ? "containers value for key: " + k : null));
            return this;
        }

        @JsonProperty(value="Containers")
        public final Builder containers(@Nullable Map<String, ? extends Network.Container> entries) {
            if (entries == null) {
                this.containers = null;
                return this;
            }
            this.containers = new LinkedHashMap<String, Network.Container>();
            return this.putAllContainers(entries);
        }

        public final Builder putAllContainers(Map<String, ? extends Network.Container> entries) {
            if (this.containers == null) {
                this.containers = new LinkedHashMap<String, Network.Container>();
            }
            for (Map.Entry<String, ? extends Network.Container> e : entries.entrySet()) {
                Network.Container v;
                String k = e.getKey();
                this.containers.put(Objects.requireNonNull(k, "containers key"), Objects.requireNonNull(v, (v = e.getValue()) == null ? "containers value for key: " + k : null));
            }
            return this;
        }

        public final Builder addOption(String key, String value) {
            if (this.options == null) {
                this.options = new LinkedHashMap<String, String>();
            }
            this.options.put(Objects.requireNonNull(key, "options key"), Objects.requireNonNull(value, value == null ? "options value for key: " + key : null));
            return this;
        }

        public final Builder addOption(Map.Entry<String, ? extends String> entry) {
            String v;
            if (this.options == null) {
                this.options = new LinkedHashMap<String, String>();
            }
            String k = entry.getKey();
            this.options.put(Objects.requireNonNull(k, "options key"), Objects.requireNonNull(v, (v = entry.getValue()) == null ? "options value for key: " + k : null));
            return this;
        }

        @JsonProperty(value="Options")
        public final Builder options(@Nullable Map<String, ? extends String> entries) {
            if (entries == null) {
                this.options = null;
                return this;
            }
            this.options = new LinkedHashMap<String, String>();
            return this.putAllOptions(entries);
        }

        public final Builder putAllOptions(Map<String, ? extends String> entries) {
            if (this.options == null) {
                this.options = new LinkedHashMap<String, String>();
            }
            for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
                String v;
                String k = e.getKey();
                this.options.put(Objects.requireNonNull(k, "options key"), Objects.requireNonNull(v, (v = e.getValue()) == null ? "options value for key: " + k : null));
            }
            return this;
        }

        @JsonProperty(value="Internal")
        public final Builder internal(@Nullable Boolean internal) {
            this.internal = internal;
            return this;
        }

        @JsonProperty(value="EnableIPv6")
        public final Builder enableIPv6(@Nullable Boolean enableIPv6) {
            this.enableIPv6 = enableIPv6;
            return this;
        }

        public final Builder addLabel(String key, String value) {
            if (this.labels == null) {
                this.labels = new LinkedHashMap<String, String>();
            }
            this.labels.put(Objects.requireNonNull(key, "labels key"), Objects.requireNonNull(value, value == null ? "labels value for key: " + key : null));
            return this;
        }

        public final Builder addLabel(Map.Entry<String, ? extends String> entry) {
            String v;
            if (this.labels == null) {
                this.labels = new LinkedHashMap<String, String>();
            }
            String k = entry.getKey();
            this.labels.put(Objects.requireNonNull(k, "labels key"), Objects.requireNonNull(v, (v = entry.getValue()) == null ? "labels value for key: " + k : null));
            return this;
        }

        @JsonProperty(value="Labels")
        public final Builder labels(@Nullable Map<String, ? extends String> entries) {
            if (entries == null) {
                this.labels = null;
                return this;
            }
            this.labels = new LinkedHashMap<String, String>();
            return this.putAllLabels(entries);
        }

        public final Builder putAllLabels(Map<String, ? extends String> entries) {
            if (this.labels == null) {
                this.labels = new LinkedHashMap<String, String>();
            }
            for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
                String v;
                String k = e.getKey();
                this.labels.put(Objects.requireNonNull(k, "labels key"), Objects.requireNonNull(v, (v = e.getValue()) == null ? "labels value for key: " + k : null));
            }
            return this;
        }

        @JsonProperty(value="Attachable")
        public final Builder attachable(@Nullable Boolean attachable) {
            this.attachable = attachable;
            return this;
        }

        public ImmutableNetwork build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableNetwork(this.name, this.id, this.scope, this.driver, this.ipam, this.containers == null ? null : ImmutableNetwork.createUnmodifiableMap(false, false, this.containers), this.options == null ? null : ImmutableNetwork.createUnmodifiableMap(false, false, this.options), this.internal, this.enableIPv6, this.labels == null ? null : ImmutableNetwork.createUnmodifiableMap(false, false, this.labels), this.attachable);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("scope");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("driver");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("ipam");
            }
            return "Cannot build Network, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    static final class Container
    implements Network.Container {
        @Nullable
        private final String name;
        private final String endpointId;
        private final String macAddress;
        private final String ipv4Address;
        private final String ipv6Address;

        private Container(@Nullable String name, String endpointId, String macAddress, String ipv4Address, String ipv6Address) {
            this.name = name;
            this.endpointId = endpointId;
            this.macAddress = macAddress;
            this.ipv4Address = ipv4Address;
            this.ipv6Address = ipv6Address;
        }

        @Override
        @JsonProperty(value="Name")
        @Nullable
        public String name() {
            return this.name;
        }

        @Override
        @JsonProperty(value="EndpointID")
        public String endpointId() {
            return this.endpointId;
        }

        @Override
        @JsonProperty(value="MacAddress")
        public String macAddress() {
            return this.macAddress;
        }

        @Override
        @JsonProperty(value="IPv4Address")
        public String ipv4Address() {
            return this.ipv4Address;
        }

        @Override
        @JsonProperty(value="IPv6Address")
        public String ipv6Address() {
            return this.ipv6Address;
        }

        public final Container withName(@Nullable String value) {
            if (Objects.equals(this.name, value)) {
                return this;
            }
            return new Container(value, this.endpointId, this.macAddress, this.ipv4Address, this.ipv6Address);
        }

        public final Container withEndpointId(String value) {
            String newValue = Objects.requireNonNull(value, "endpointId");
            if (this.endpointId.equals(newValue)) {
                return this;
            }
            return new Container(this.name, newValue, this.macAddress, this.ipv4Address, this.ipv6Address);
        }

        public final Container withMacAddress(String value) {
            String newValue = Objects.requireNonNull(value, "macAddress");
            if (this.macAddress.equals(newValue)) {
                return this;
            }
            return new Container(this.name, this.endpointId, newValue, this.ipv4Address, this.ipv6Address);
        }

        public final Container withIpv4Address(String value) {
            String newValue = Objects.requireNonNull(value, "ipv4Address");
            if (this.ipv4Address.equals(newValue)) {
                return this;
            }
            return new Container(this.name, this.endpointId, this.macAddress, newValue, this.ipv6Address);
        }

        public final Container withIpv6Address(String value) {
            String newValue = Objects.requireNonNull(value, "ipv6Address");
            if (this.ipv6Address.equals(newValue)) {
                return this;
            }
            return new Container(this.name, this.endpointId, this.macAddress, this.ipv4Address, newValue);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof Container && this.equalTo(0, (Container)another);
        }

        private boolean equalTo(int synthetic, Container another) {
            return Objects.equals(this.name, another.name) && this.endpointId.equals(another.endpointId) && this.macAddress.equals(another.macAddress) && this.ipv4Address.equals(another.ipv4Address) && this.ipv6Address.equals(another.ipv6Address);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Objects.hashCode(this.name);
            h += (h << 5) + this.endpointId.hashCode();
            h += (h << 5) + this.macAddress.hashCode();
            h += (h << 5) + this.ipv4Address.hashCode();
            h += (h << 5) + this.ipv6Address.hashCode();
            return h;
        }

        public String toString() {
            return "Container{name=" + this.name + ", endpointId=" + this.endpointId + ", macAddress=" + this.macAddress + ", ipv4Address=" + this.ipv4Address + ", ipv6Address=" + this.ipv6Address + "}";
        }

        public static Container copyOf(Network.Container instance) {
            if (instance instanceof Container) {
                return (Container)instance;
            }
            return Container.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        static final class Builder {
            private static final long INIT_BIT_ENDPOINT_ID = 1L;
            private static final long INIT_BIT_MAC_ADDRESS = 2L;
            private static final long INIT_BIT_IPV4_ADDRESS = 4L;
            private static final long INIT_BIT_IPV6_ADDRESS = 8L;
            private long initBits = 15L;
            private String name;
            private String endpointId;
            private String macAddress;
            private String ipv4Address;
            private String ipv6Address;

            private Builder() {
            }

            public final Builder from(Network.Container instance) {
                Objects.requireNonNull(instance, "instance");
                String nameValue = instance.name();
                if (nameValue != null) {
                    this.name(nameValue);
                }
                this.endpointId(instance.endpointId());
                this.macAddress(instance.macAddress());
                this.ipv4Address(instance.ipv4Address());
                this.ipv6Address(instance.ipv6Address());
                return this;
            }

            @JsonProperty(value="Name")
            public final Builder name(@Nullable String name) {
                this.name = name;
                return this;
            }

            @JsonProperty(value="EndpointID")
            public final Builder endpointId(String endpointId) {
                this.endpointId = Objects.requireNonNull(endpointId, "endpointId");
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            @JsonProperty(value="MacAddress")
            public final Builder macAddress(String macAddress) {
                this.macAddress = Objects.requireNonNull(macAddress, "macAddress");
                this.initBits &= 0xFFFFFFFFFFFFFFFDL;
                return this;
            }

            @JsonProperty(value="IPv4Address")
            public final Builder ipv4Address(String ipv4Address) {
                this.ipv4Address = Objects.requireNonNull(ipv4Address, "ipv4Address");
                this.initBits &= 0xFFFFFFFFFFFFFFFBL;
                return this;
            }

            @JsonProperty(value="IPv6Address")
            public final Builder ipv6Address(String ipv6Address) {
                this.ipv6Address = Objects.requireNonNull(ipv6Address, "ipv6Address");
                this.initBits &= 0xFFFFFFFFFFFFFFF7L;
                return this;
            }

            public Container build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new Container(this.name, this.endpointId, this.macAddress, this.ipv4Address, this.ipv6Address);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("endpointId");
                }
                if ((this.initBits & 2L) != 0L) {
                    attributes.add("macAddress");
                }
                if ((this.initBits & 4L) != 0L) {
                    attributes.add("ipv4Address");
                }
                if ((this.initBits & 8L) != 0L) {
                    attributes.add("ipv6Address");
                }
                return "Cannot build Container, some of required attributes are not set " + String.valueOf(attributes);
            }
        }
    }
}

