/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.timinganalysis.ui.launch;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.lsat.common.emf.common.util.URIHelper;
import org.eclipse.lsat.timinganalysis.ui.Activator;
import org.eclipse.lsat.timinganalysis.ui.launch.TimingAnalysisLaunchAttributes;
import org.eclipse.lsat.timinganalysis.ui.launch.TimingAnalysisUtil;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class TimingAnalysisLaunchJob
extends Job {
    private IFile dispatchFile;
    private IFile settingFile;
    private final String mode;
    private final ILaunchConfiguration launchConfiguration;
    private final String showTargetAttribute;

    public TimingAnalysisLaunchJob(IFile[] files, String mode, String showTarget) {
        super("Timing Analysis - " + URIHelper.baseName((IResource)files[0]));
        this.showTargetAttribute = showTarget;
        this.dispatchFile = TimingAnalysisLaunchJob.getFile(files, "dispatching");
        this.settingFile = TimingAnalysisLaunchJob.getFile(files, "setting");
        this.mode = mode;
        this.launchConfiguration = this.selectLaunchConfiguration();
    }

    public boolean shouldSchedule() {
        return this.launchConfiguration != null;
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            this.launchConfiguration.launch(this.mode, monitor);
            return Status.OK_STATUS;
        }
        catch (CoreException e) {
            return new Status(4, "org.eclipse.lsat.timinganalysis.ui", e.getMessage(), (Throwable)e);
        }
    }

    private ILaunchConfiguration selectLaunchConfiguration() {
        Map<String, ILaunchConfiguration> items;
        block5: {
            try {
                items = this.collectItems();
                if (items != null) break block5;
                return null;
            }
            catch (Exception e) {
                Status status = new Status(4, "org.eclipse.lsat.timinganalysis.ui", e.getMessage(), (Throwable)e);
                Activator.getDefault().getLog().log((IStatus)status);
                return null;
            }
        }
        if (items.isEmpty()) {
            return this.createNewConfiguration();
        }
        if (items.size() == 1) {
            return items.values().iterator().next();
        }
        return TimingAnalysisLaunchJob.askUser(items);
    }

    private static ILaunchConfiguration askUser(Map<String, ILaunchConfiguration> items) {
        return TimingAnalysisLaunchJob.askUser(items, "Run Timing Analysis", "Select launch configuration");
    }

    private static IFile askUser(IFile ref, String extension) {
        Map<String, IFile> names = TimingAnalysisLaunchJob.findAllInProject(ref, extension).stream().collect(Collectors.toMap(f -> TimingAnalysisLaunchJob.getName(f), f -> f));
        return TimingAnalysisLaunchJob.askUser(names, "File selector", "Please select " + extension + " file");
    }

    private static <T> T askUser(Map<String, T> items, String title, String message) {
        LabelProvider labelProvider = new LabelProvider();
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (ILabelProvider)labelProvider);
        dialog.setTitle(title);
        URL url = TimingAnalysisLaunchJob.class.getResource("/icons/gantt.png");
        ImageDescriptor imageDcr = ImageDescriptor.createFromURL((URL)url);
        Image image = imageDcr.createImage();
        dialog.setImage(image);
        dialog.setElements(items.keySet().toArray());
        dialog.setMultipleSelection(false);
        dialog.setMessage(message);
        dialog.open();
        if (dialog.getReturnCode() == 0) {
            return items.get(dialog.getFirstResult());
        }
        return null;
    }

    private Map<String, ILaunchConfiguration> collectItems() throws CoreException {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType type = launchManager.getLaunchConfigurationType("org.eclipse.lsat.timinganalysis.ui.launchConfigurationType");
        return Stream.of(launchManager.getLaunchConfigurations(type)).filter(l -> this.eligibleConfig((ILaunchConfiguration)l)).collect(Collectors.toMap(l -> l.getName(), l -> l));
    }

    private boolean eligibleConfig(ILaunchConfiguration lc) {
        try {
            return TimingAnalysisLaunchJob.eqOrNull(TimingAnalysisLaunchJob.getPath(this.dispatchFile), lc.getAttribute(TimingAnalysisLaunchAttributes.MODEL_IFILE, null)) && TimingAnalysisLaunchJob.eqOrNull(TimingAnalysisLaunchJob.getPath(this.settingFile), lc.getAttribute(TimingAnalysisLaunchAttributes.SETTING_IFILE, null)) && lc.getAttribute(this.showTargetAttribute, false);
        }
        catch (CoreException e) {
            e.printStackTrace();
            return false;
        }
    }

    private ILaunchConfiguration createNewConfiguration() throws CoreException {
        if (this.dispatchFile == null) {
            this.dispatchFile = TimingAnalysisLaunchJob.askUser(this.settingFile, "dispatching");
        }
        if (this.settingFile == null) {
            this.settingFile = TimingAnalysisLaunchJob.askUser(this.dispatchFile, "setting");
        }
        if (this.dispatchFile == null || this.settingFile == null) {
            return null;
        }
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType type = launchManager.getLaunchConfigurationType("org.eclipse.lsat.timinganalysis.ui.launchConfigurationType");
        ILaunchConfigurationWorkingCopy workingCopy = type.newInstance(null, this.getLaunchName());
        workingCopy.setAttribute(TimingAnalysisLaunchAttributes.MODEL_IFILE, TimingAnalysisLaunchJob.getPath(this.dispatchFile));
        workingCopy.setAttribute(TimingAnalysisLaunchAttributes.SETTING_IFILE, TimingAnalysisLaunchJob.getPath(this.settingFile));
        workingCopy.setAttribute(TimingAnalysisLaunchAttributes.GANTT_CHART, false);
        workingCopy.setAttribute(this.showTargetAttribute, true);
        workingCopy.setMappedResources(new IResource[]{this.dispatchFile, this.settingFile});
        return workingCopy.doSave();
    }

    private String getLaunchName() {
        return TimingAnalysisUtil.getLaunchName(this.dispatchFile, this.settingFile, this.showTargetAttribute);
    }

    private static boolean eqOrNull(Object a, Object b) {
        if (a == null) {
            return true;
        }
        return a.equals(b);
    }

    private static String getPath(IFile file) {
        return file == null ? null : file.getFullPath().toString();
    }

    private static String getName(IFile file) {
        return file == null ? "Unknown" : URIHelper.baseName((IResource)file);
    }

    private static IFile getFile(IFile[] files, String extension) {
        return Stream.of(files).filter(f -> Objects.equals(f.getFileExtension(), extension)).findFirst().orElse(TimingAnalysisLaunchJob.findOneInProject(files[0], extension));
    }

    private static Collection<IFile> findAllInProject(IFile ref, String extension) {
        ArrayList<IFile> found = new ArrayList<IFile>();
        try {
            IProject project = ref.getProject();
            IResourceVisitor visitor = r -> {
                if (r instanceof IFile && !r.isHidden(512)) {
                    if (Objects.equals(r.getFileExtension(), extension)) {
                        found.add((IFile)r);
                    }
                    return false;
                }
                return true;
            };
            project.accept(visitor);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return found;
    }

    private static IFile findOneInProject(IFile ref, String extension) {
        Collection<IFile> matches = TimingAnalysisLaunchJob.findAllInProject(ref, extension);
        if (matches.size() == 1) {
            return matches.iterator().next();
        }
        return null;
    }
}

