/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test.files;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.lsp4e.internal.files.PathPatternMatcher;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class PathPatternMatcherTest {
    PathPatternMatcherTest() {
    }

    @Test
    void noExpansion() {
        PathPatternMatcherTest.assertExpandPatterns("foo", "foo");
    }

    @Test
    void oneExpansion() {
        PathPatternMatcherTest.assertExpandPatterns("**/foo", "foo", "**/foo");
    }

    @Test
    void twoExpansion() {
        PathPatternMatcherTest.assertExpandPatterns("**/foo/**", "foo", "**/foo", "foo/**", "**/foo/**");
    }

    @Test
    void sixExpansion() {
        PathPatternMatcherTest.assertExpandPatterns("{**/node_modules/**,**/.git/**,**/bower_components/**}", "{node_modules,.git,bower_components}", "{node_modules,.git,bower_components/**}", "{node_modules,.git,**/bower_components}", "{node_modules,.git,**/bower_components/**}", "{node_modules,.git/**,bower_components}", "{node_modules,.git/**,bower_components/**}", "{node_modules,.git/**,**/bower_components}", "{node_modules,.git/**,**/bower_components/**}", "{node_modules,**/.git,bower_components}", "{node_modules,**/.git,bower_components/**}", "{node_modules,**/.git,**/bower_components}", "{node_modules,**/.git,**/bower_components/**}", "{node_modules,**/.git/**,bower_components}", "{node_modules,**/.git/**,bower_components/**}", "{node_modules,**/.git/**,**/bower_components}", "{node_modules,**/.git/**,**/bower_components/**}", "{node_modules/**,.git,bower_components}", "{node_modules/**,.git,bower_components/**}", "{node_modules/**,.git,**/bower_components}", "{node_modules/**,.git,**/bower_components/**}", "{node_modules/**,.git/**,bower_components}", "{node_modules/**,.git/**,bower_components/**}", "{node_modules/**,.git/**,**/bower_components}", "{node_modules/**,.git/**,**/bower_components/**}", "{node_modules/**,**/.git,bower_components}", "{node_modules/**,**/.git,bower_components/**}", "{node_modules/**,**/.git,**/bower_components}", "{node_modules/**,**/.git,**/bower_components/**}", "{node_modules/**,**/.git/**,bower_components}", "{node_modules/**,**/.git/**,bower_components/**}", "{node_modules/**,**/.git/**,**/bower_components}", "{node_modules/**,**/.git/**,**/bower_components/**}", "{**/node_modules,.git,bower_components}", "{**/node_modules,.git,bower_components/**}", "{**/node_modules,.git,**/bower_components}", "{**/node_modules,.git,**/bower_components/**}", "{**/node_modules,.git/**,bower_components}", "{**/node_modules,.git/**,bower_components/**}", "{**/node_modules,.git/**,**/bower_components}", "{**/node_modules,.git/**,**/bower_components/**}", "{**/node_modules,**/.git,bower_components}", "{**/node_modules,**/.git,bower_components/**}", "{**/node_modules,**/.git,**/bower_components}", "{**/node_modules,**/.git,**/bower_components/**}", "{**/node_modules,**/.git/**,bower_components}", "{**/node_modules,**/.git/**,bower_components/**}", "{**/node_modules,**/.git/**,**/bower_components}", "{**/node_modules,**/.git/**,**/bower_components/**}", "{**/node_modules/**,.git,bower_components}", "{**/node_modules/**,.git,bower_components/**}", "{**/node_modules/**,.git,**/bower_components}", "{**/node_modules/**,.git,**/bower_components/**}", "{**/node_modules/**,.git/**,bower_components}", "{**/node_modules/**,.git/**,bower_components/**}", "{**/node_modules/**,.git/**,**/bower_components}", "{**/node_modules/**,.git/**,**/bower_components/**}", "{**/node_modules/**,**/.git,bower_components}", "{**/node_modules/**,**/.git,bower_components/**}", "{**/node_modules/**,**/.git,**/bower_components}", "{**/node_modules/**,**/.git,**/bower_components/**}", "{**/node_modules/**,**/.git/**,bower_components}", "{**/node_modules/**,**/.git/**,bower_components/**}", "{**/node_modules/**,**/.git/**,**/bower_components}", "{**/node_modules/**,**/.git/**,**/bower_components/**}");
    }

    private static void assertExpandPatterns(String pattern, String ... expectedPatterns) {
        List actual = PathPatternMatcher.expandPatterns((String)pattern);
        Collections.sort(actual);
        List<String> expected = Arrays.asList(expectedPatterns);
        Collections.sort(expected);
        Assertions.assertArrayEquals((Object[])actual.toArray(String[]::new), (Object[])expected.toArray(String[]::new), (String)("'" + pattern + "' pattern expansion should match [\"" + String.join((CharSequence)"\",\"", actual) + "\"]"));
    }
}

