/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.adt.debug.core.ocl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.m2m.atl.adt.debug.core.ocl.OclEvaluator;
import org.eclipse.m2m.atl.drivers.emf4atl.ASMEMFModel;
import org.eclipse.m2m.atl.engine.vm.ASM;
import org.eclipse.m2m.atl.engine.vm.AtlLauncher;
import org.eclipse.m2m.atl.engine.vm.Debugger;
import org.eclipse.m2m.atl.engine.vm.SimpleDebugger;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMBoolean;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMInteger;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMModel;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMOclAny;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMString;

public class OclQuery
extends OclEvaluator {
    private String query;
    private ASM compiledQuery;

    public OclQuery(String query) {
        this.query = query;
        this.compiledQuery = null;
    }

    public static ASMOclAny eval(String query) throws Exception {
        return new OclQuery(query).eval();
    }

    public static ASMOclAny eval(String query, Map models) throws Exception {
        return new OclQuery(query).eval(models);
    }

    public EObject[] compile() throws Exception {
        this.compiledQuery = this.compile("query test = \n" + this.query + "\n;");
        return this.pbs;
    }

    public ASMOclAny eval() throws Exception {
        HashMap<String, ASMModel> models = new HashMap<String, ASMModel>();
        models.put("MOF", ASMEMFModel.getMOF());
        return this.eval(models);
    }

    public String evalString(Map models) throws Exception {
        return ((ASMString)this.eval(models)).getSymbol();
    }

    public int evalInteger(Map models) throws Exception {
        return ((ASMInteger)this.eval(models)).getSymbol();
    }

    public boolean evalBoolean(Map models) throws Exception {
        return ((ASMBoolean)this.eval(models)).getSymbol();
    }

    public ASMOclAny eval(Map models) throws Exception {
        return this.eval(models, Collections.EMPTY_MAP);
    }

    public ASMOclAny eval(Map models, Map libraries) throws Exception {
        if (this.compiledQuery == null) {
            this.compile();
        }
        return this.interpretQuery(this.compiledQuery, models, libraries);
    }

    private ASMOclAny interpretQuery(ASM asm, Map models, Map libraries) throws Exception {
        ASMOclAny ret = null;
        AtlLauncher al = AtlLauncher.getDefault();
        Map asmParams = Collections.EMPTY_MAP;
        SimpleDebugger debugger = new SimpleDebugger(false, new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList(), true);
        ret = (ASMOclAny)al.launch(asm, libraries, models, asmParams, Collections.EMPTY_LIST, Collections.EMPTY_MAP, (Debugger)debugger);
        return ret;
    }
}

