/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.pivot.qvtimperative.evaluation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Pattern;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.IteratorExp;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.internal.evaluation.OCLEvaluationVisitor;
import org.eclipse.ocl.pivot.internal.prettyprint.PrettyPrinter;
import org.eclipse.ocl.pivot.util.Visitable;
import org.eclipse.ocl.pivot.values.InvalidValueException;
import org.eclipse.qvtd.pivot.qvtbase.Predicate;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtcorebase.Assignment;
import org.eclipse.qvtd.pivot.qvtcorebase.CoreDomain;
import org.eclipse.qvtd.pivot.qvtcorebase.GuardPattern;
import org.eclipse.qvtd.pivot.qvtcorebase.PropertyAssignment;
import org.eclipse.qvtd.pivot.qvtcorebase.VariableAssignment;
import org.eclipse.qvtd.pivot.qvtimperative.ImperativeModel;
import org.eclipse.qvtd.pivot.qvtimperative.Mapping;
import org.eclipse.qvtd.pivot.qvtimperative.MappingCall;
import org.eclipse.qvtd.pivot.qvtimperative.MappingLoop;
import org.eclipse.qvtd.pivot.qvtimperative.MappingSequence;
import org.eclipse.qvtd.pivot.qvtimperative.MappingStatement;
import org.eclipse.qvtd.pivot.qvtimperative.VariablePredicate;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.IQVTiEvaluationVisitor;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.QVTiEvaluationVisitorDecorator;

public abstract class QVTiAbstractTracingEvaluationVisitor
extends QVTiEvaluationVisitorDecorator {
    protected static Logger logger = Logger.getLogger((String)"QVTiTrace");
    protected static final String DEFAULT_INDENT = "  ";
    static int VERBOSE_LEVEL_LOW = 0;
    static int VERBOSE_LEVEL_MED = 1;
    static int VERBOSE_LEVEL_HIGH = 2;
    protected static int verboseLevel = VERBOSE_LEVEL_LOW;
    private int indentLevel = 0;

    public QVTiAbstractTracingEvaluationVisitor(@NonNull IQVTiEvaluationVisitor decorated) {
        this(decorated, 0);
        if (logger.getAppender("QVTTrace") == null) {
            FileAppender appender = new FileAppender();
            appender.setFile("QVTTrace.log");
            appender.setName("QVTTrace");
            appender.setLayout((Layout)new PatternLayout("%m%n"));
            appender.setAppend(false);
            appender.activateOptions();
            logger.addAppender((Appender)appender);
        }
        logger.setAdditivity(false);
        logger.setLevel(Level.DEBUG);
    }

    protected QVTiAbstractTracingEvaluationVisitor(@NonNull IQVTiEvaluationVisitor decorated, int indentLevel) {
        super(decorated);
        this.indentLevel = indentLevel;
    }

    public int getVerboseLevel() {
        return verboseLevel;
    }

    public void setVerboseLevel(int verboseLevel) {
        QVTiAbstractTracingEvaluationVisitor.verboseLevel = verboseLevel;
    }

    @NonNull
    protected String getIndent() {
        StringBuilder outputBuffer = new StringBuilder(this.indentLevel);
        int i = 0;
        while (i < this.indentLevel) {
            outputBuffer.append(DEFAULT_INDENT);
            ++i;
        }
        String string = outputBuffer.toString();
        return string;
    }

    @NonNull
    public Pattern getRegexPattern(@NonNull String regex) {
        return ((IQVTiEvaluationVisitor)this.delegate).getRegexPattern(regex);
    }

    @NonNull
    protected String safePrint(@Nullable Element element) {
        return element != null ? PrettyPrinter.print((Element)element) : "null";
    }

    @Override
    @Nullable
    public Object visitAssignment(@NonNull Assignment assignment) {
        ++this.indentLevel;
        try {
            Object value = this.safeVisit((Visitable)assignment.getValue());
            value = ((IQVTiEvaluationVisitor)this.delegate).getEnvironmentFactory().getIdResolver().unboxedValueOf(value);
            logger.info((Object)(String.valueOf(this.getIndent()) + "VisitAssignment " + this.prettyPrint(assignment.getESObject()) + " := " + this.prettyPrint(value)));
        }
        catch (InvalidValueException ex) {
            logger.info((Object)(String.valueOf(this.getIndent()) + "VisitAssignment " + this.prettyPrint(assignment.getESObject()) + " := Invalid expression"));
        }
        Object result = ((IQVTiEvaluationVisitor)this.delegate).visitAssignment(assignment);
        --this.indentLevel;
        return result;
    }

    @Override
    @Nullable
    public Object visitCoreDomain(@NonNull CoreDomain coreDomain) {
        logger.info((Object)(String.valueOf(this.getIndent()) + "CoreDomain " + coreDomain.getName()));
        ++this.indentLevel;
        Object result = ((IQVTiEvaluationVisitor)this.delegate).visitCoreDomain(coreDomain);
        --this.indentLevel;
        return result;
    }

    @Override
    @Nullable
    public Object visitGuardPattern(@NonNull GuardPattern guardPattern) {
        if (guardPattern.getArea() instanceof CoreDomain) {
            logger.info((Object)(String.valueOf(this.getIndent()) + "Visiting CoreDomain GuardPattern"));
        }
        if (guardPattern.getArea() instanceof Mapping) {
            logger.info((Object)(String.valueOf(this.getIndent()) + "Visiting Mapping GuardPattern"));
        }
        ++this.indentLevel;
        ArrayList<Variable> nullVars = new ArrayList<Variable>();
        for (Variable v : guardPattern.getVariable()) {
            if (((IQVTiEvaluationVisitor)this.delegate).getEvaluationEnvironment().getValueOf((TypedElement)v) == null) {
                nullVars.add(v);
                OCLExpression initExp = v.getOwnedInit();
                if (initExp == null) continue;
                ++this.indentLevel;
                logger.info((Object)(String.valueOf(this.getIndent()) + "Variable " + v.getName() + " init value:" + this.safePrint((Element)initExp)));
                --this.indentLevel;
                continue;
            }
            logger.info((Object)(String.valueOf(this.getIndent()) + "Variable " + v.getName() + ": " + this.prettyPrint(((IQVTiEvaluationVisitor)this.delegate).getEvaluationEnvironment().getValueOf((TypedElement)v))));
        }
        Object result = ((IQVTiEvaluationVisitor)this.delegate).visitGuardPattern(guardPattern);
        if (result == Boolean.TRUE) {
            for (Variable v : nullVars) {
                logger.info((Object)(String.valueOf(this.getIndent()) + "Variable " + v.getName() + ": " + this.prettyPrint(((IQVTiEvaluationVisitor)this.delegate).getEvaluationEnvironment().getValueOf((TypedElement)v))));
            }
        }
        if (guardPattern.getPredicate().size() == 0) {
            logger.info((Object)(String.valueOf(this.getIndent()) + "GuardPattern has no predicates."));
        } else {
            logger.info((Object)(String.valueOf(this.getIndent()) + "GuardPattern result: " + result));
        }
        --this.indentLevel;
        return result;
    }

    @Override
    @Nullable
    public Object visitImperativeModel(@NonNull ImperativeModel imperativeModel) {
        return ((IQVTiEvaluationVisitor)this.delegate).visitImperativeModel(imperativeModel);
    }

    @Nullable
    public Object visitIteratorExp(@NonNull IteratorExp object) {
        return ((IQVTiEvaluationVisitor)this.delegate).visitIteratorExp(object);
    }

    @Override
    @Nullable
    public Object visitMapping(@NonNull Mapping mapping) {
        logger.info((Object)(String.valueOf(this.getIndent()) + "Mapping " + mapping.getName()));
        ++this.indentLevel;
        Object result = ((IQVTiEvaluationVisitor)this.delegate).visitMapping(mapping);
        --this.indentLevel;
        return result;
    }

    @Override
    @Nullable
    public Object visitMappingCall(@NonNull MappingCall mappingCall) {
        logger.info((Object)(String.valueOf(this.getIndent()) + "Visiting MappingCall, calling: " + mappingCall.getReferredMapping().getName()));
        ++this.indentLevel;
        Object result = ((IQVTiEvaluationVisitor)this.delegate).visitMappingCall(mappingCall);
        --this.indentLevel;
        return result;
    }

    @Override
    @Nullable
    public Object visitMappingLoop(@NonNull MappingLoop mappingLoop) {
        logger.info((Object)(String.valueOf(this.getIndent()) + "Visiting MappingLoop, binding: " + ((Variable)mappingLoop.getOwnedIterators().get(0)).getName()));
        ++this.indentLevel;
        Object result = ((IQVTiEvaluationVisitor)this.delegate).visitMappingLoop(mappingLoop);
        --this.indentLevel;
        return result;
    }

    @Override
    @Nullable
    public Object visitMappingSequence(@NonNull MappingSequence mappingSequence) {
        Object result = ((IQVTiEvaluationVisitor)this.delegate).visitMappingSequence(mappingSequence);
        return result;
    }

    @Override
    @Nullable
    public Object visitMappingStatement(@NonNull MappingStatement vappingStatement) {
        return this.visiting((Visitable)vappingStatement);
    }

    @Override
    @Nullable
    public Object visitPropertyAssignment(@NonNull PropertyAssignment propertyAssignment) {
        try {
            Object value = this.safeVisit((Visitable)propertyAssignment.getValue());
            value = ((IQVTiEvaluationVisitor)this.delegate).getEnvironmentFactory().getIdResolver().unboxedValueOf(value);
            logger.info((Object)(String.valueOf(this.getIndent()) + "VisitPropertyAssignment " + propertyAssignment.getSlotExpression() + "." + propertyAssignment.getTargetProperty().getName() + " = " + this.prettyPrint(value)));
        }
        catch (InvalidValueException ex) {
            logger.info((Object)(String.valueOf(this.getIndent()) + "VisitPropertyAssignment " + propertyAssignment.getSlotExpression() + "." + propertyAssignment.getTargetProperty().getName() + " = InvalidValueException"));
        }
        Object result = ((IQVTiEvaluationVisitor)this.delegate).visitPropertyAssignment(propertyAssignment);
        return result;
    }

    @Override
    @Nullable
    public Object visitTransformation(@NonNull Transformation transformation) {
        logger.info((Object)("---- Transformation " + transformation.getName() + " ----"));
        ++this.indentLevel;
        Object result = ((IQVTiEvaluationVisitor)this.delegate).visitTransformation(transformation);
        --this.indentLevel;
        logger.info((Object)"---- Transformation End ----");
        return result;
    }

    @Override
    @Nullable
    public Object visitPredicate(@NonNull Predicate predicate) {
        OCLExpression exp = predicate.getConditionExpression();
        Object value = this.safeVisit((Visitable)exp);
        logger.info((Object)(String.valueOf(this.getIndent()) + "Predicate " + this.safePrint((Element)exp) + " is " + String.valueOf(value)));
        return ((IQVTiEvaluationVisitor)this.delegate).visitPredicate(predicate);
    }

    @Override
    @Nullable
    public Object visitVariableAssignment(@NonNull VariableAssignment variableAssignment) {
        Variable v = variableAssignment.getTargetVariable();
        logger.info((Object)(String.valueOf(this.getIndent()) + "VisitVariableAssignment " + v + ": " + ((OCLEvaluationVisitor)this.delegate).safeVisit((Visitable)variableAssignment.getValue())));
        ++this.indentLevel;
        Object result = ((IQVTiEvaluationVisitor)this.delegate).visitVariableAssignment(variableAssignment);
        --this.indentLevel;
        return result;
    }

    @Override
    @Nullable
    public Object visitVariablePredicate(@NonNull VariablePredicate variablePredicate) {
        Variable v = variablePredicate.getTargetVariable();
        logger.info((Object)(String.valueOf(this.getIndent()) + "VisitVariablePredicate " + v + ": " + ((OCLEvaluationVisitor)this.delegate).safeVisit((Visitable)variablePredicate.getConditionExpression())));
        ++this.indentLevel;
        Object result = ((IQVTiEvaluationVisitor)this.delegate).visitVariablePredicate(variablePredicate);
        --this.indentLevel;
        return result;
    }

    protected String prettyPrint(Object object) {
        ArrayList<String> lines = new ArrayList<String>();
        if (object instanceof EObject) {
            EObject eo = (EObject)object;
            EClass eClass = eo.eClass();
            lines.add(String.valueOf(eClass.getName()) + " [" + Integer.toHexString(eo.hashCode()) + "] {");
            ++this.indentLevel;
            for (EStructuralFeature feature : eClass.getEAllStructuralFeatures()) {
                Object value = eo.eGet(feature);
                String line = String.valueOf(this.getIndent()) + feature.getName() + " = ";
                if (value instanceof Collection) {
                    int size = ((Collection)value).size();
                    line = size > 0 ? String.valueOf(line) + "[" + ((EObject)((Iterable)value).iterator().next()).eClass().getName() + "] x " + size : String.valueOf(line) + "[ ]";
                } else if (value instanceof EObject) {
                    eClass = ((EObject)value).eClass();
                    line = String.valueOf(line) + eClass.getName() + " [" + Integer.toHexString(value.hashCode()) + "]";
                } else {
                    line = value == null ? String.valueOf(line) + "[ null ]" : String.valueOf(line) + String.valueOf(value);
                }
                lines.add(line);
            }
            lines.add(String.valueOf(this.getIndent()) + "}");
            --this.indentLevel;
            StringBuilder sb = new StringBuilder();
            for (String line : lines) {
                sb.append(line).append('\n');
            }
            sb.delete(sb.length() - 1, sb.length());
            return sb.toString();
        }
        return String.valueOf(object);
    }

    protected String prettyPrintUnident(Object object) {
        ArrayList<String> lines = new ArrayList<String>();
        if (object instanceof EObject) {
            EObject eo = (EObject)object;
            EClass eClass = eo.eClass();
            lines.add(String.valueOf(eClass.getName()) + " [" + Integer.toHexString(eo.hashCode()) + "] {");
            ++this.indentLevel;
            for (EStructuralFeature feature : eClass.getEAllStructuralFeatures()) {
                Object value = eo.eGet(feature);
                String line = DEFAULT_INDENT + feature.getName() + " = ";
                if (value instanceof Collection) {
                    int size = ((Collection)value).size();
                    line = size > 0 ? String.valueOf(line) + "[" + ((EObject)((Iterable)value).iterator().next()).eClass().getName() + "] x " + size : String.valueOf(line) + "[ ]";
                } else if (value instanceof EObject) {
                    eClass = ((EObject)value).eClass();
                    line = String.valueOf(line) + eClass.getName() + " [" + Integer.toHexString(value.hashCode()) + "]";
                } else {
                    line = value == null ? String.valueOf(line) + "[ null ]" : String.valueOf(line) + String.valueOf(value);
                }
                lines.add(line);
            }
            lines.add("  }");
            --this.indentLevel;
            StringBuilder sb = new StringBuilder();
            for (String line : lines) {
                sb.append(line).append('\n');
            }
            sb.delete(sb.length() - 1, sb.length());
            return sb.toString();
        }
        return String.valueOf(object);
    }
}

