/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtr2qvtc.impl;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.Rule;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.impl.AbstractBindings;

public class RuleBindings
extends AbstractBindings {
    @NonNull
    protected final Rule rule;
    private Integer hashCode;

    public RuleBindings(@NonNull Rule rule) {
        this.rule = rule;
    }

    protected void checkKey(@NonNull AbstractBindings.Key<?> key) {
        for (AbstractBindings.Key<?> relationsKey : this.rule.getRuleBindingsKeys().getKeys()) {
            if (relationsKey != key) continue;
            return;
        }
        throw new IllegalArgumentException("Incompatible relations key " + key + " for " + this.rule);
    }

    public boolean containsKey(@NonNull RuleKey<?> key) {
        return this.delegate.containsKey(key);
    }

    public <T> T get(@NonNull RuleKey<T> key) {
        return (T)this.delegate.get(key);
    }

    @NonNull
    public Rule getRule() {
        return this.rule;
    }

    public boolean matches(@NonNull RuleKey<?> rootKey, @NonNull RuleBindings traceBindings) {
        Object boundValue = this.get(rootKey);
        if (boundValue == null && !this.containsKey(rootKey)) {
            return false;
        }
        Object traceValue = traceBindings.get(rootKey);
        if (traceValue == null && !traceBindings.containsKey(rootKey)) {
            return false;
        }
        return !(traceValue == null ? boundValue != null : !traceValue.equals(boundValue));
    }

    public <T> T put(@NonNull RuleKey<T> key, T value) {
        return this.delegate.put(key, value);
    }

    public <T> T remove(@NonNull RuleKey<T> key) {
        return (T)this.delegate.remove(key);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RuleBindings)) {
            return false;
        }
        RuleBindings rb = (RuleBindings)o;
        if (this.rule.getClass() != rb.getRule().getClass()) {
            return false;
        }
        return this.delegate.equals(rb.delegate);
    }

    public int hashCode() {
        if (this.hashCode == null) {
            this.hashCode = this.getClass().hashCode() + this.delegate.hashCode();
        }
        return this.hashCode;
    }

    public static class KeySet
    extends AbstractBindings.KeySet {
        @NonNull
        protected final List<AbstractBindings.Key<?>> rootKeys = new ArrayList();

        @NonNull
        public <T> RuleKey<T> create(@Nullable T keyClass, @NonNull String key) {
            RuleKey theKey = new RuleKey(key);
            this.keys.add(theKey);
            return theKey;
        }

        @NonNull
        public <T> RuleKey<T> createRoot(@Nullable T keyClass, @NonNull String key) {
            RuleKey<T> rootKey = this.create(keyClass, key);
            this.rootKeys.add(rootKey);
            return rootKey;
        }

        @NonNull
        public List<AbstractBindings.Key<?>> getRootKeys() {
            return this.rootKeys;
        }
    }

    public static class RuleKey<T>
    extends AbstractBindings.Key<T> {
        private RuleKey(@NonNull String key) {
            super(key);
        }
    }
}

