/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.pivot.qvtcore.utilities;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.VariableDeclaration;
import org.eclipse.ocl.pivot.VariableExp;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.TreeIterable;
import org.eclipse.qvtd.pivot.qvtcore.Assignment;
import org.eclipse.qvtd.pivot.qvtcore.PropertyAssignment;
import org.eclipse.qvtd.pivot.qvtcore.VariableAssignment;

public class AssignmentComparator
implements Comparator<Assignment> {
    private final @NonNull List<@NonNull Assignment> assignments;
    private @Nullable Map<@NonNull Variable, @NonNull Set<@NonNull Variable>> variable2referencedVariables = null;

    public AssignmentComparator(@NonNull List<@NonNull Assignment> assignments) {
        this.assignments = assignments;
    }

    @Override
    public int compare(@NonNull Assignment o1, @NonNull Assignment o2) {
        if (o1 instanceof PropertyAssignment) {
            if (o2 instanceof PropertyAssignment) {
                String n2;
                Property p1 = ((PropertyAssignment)o1).getTargetProperty();
                Property p2 = ((PropertyAssignment)o2).getTargetProperty();
                String n1 = p1.getName();
                int diff = ClassUtil.safeCompareTo((Comparable)((Object)n1), (Comparable)((Object)(n2 = p2.getName())));
                if (diff != 0) {
                    return diff;
                }
                n1 = p1.toString();
                n2 = p2.toString();
                return ClassUtil.safeCompareTo((Comparable)((Object)n1), (Comparable)((Object)n2));
            }
            return 1;
        }
        if (o1 instanceof VariableAssignment) {
            if (o2 instanceof PropertyAssignment) {
                return -1;
            }
            if (o2 instanceof VariableAssignment) {
                Map<@NonNull Variable, @NonNull Set<@NonNull Variable>> variable2referencedVariables2 = this.variable2referencedVariables;
                if (variable2referencedVariables2 == null) {
                    variable2referencedVariables2 = this.variable2referencedVariables = this.computeReferencedVariableClosure();
                }
                Variable v1 = ((VariableAssignment)o1).getTargetVariable();
                Variable v2 = ((VariableAssignment)o2).getTargetVariable();
                Set<@NonNull Variable> r1 = variable2referencedVariables2.get(v1);
                Set<@NonNull Variable> r2 = variable2referencedVariables2.get(v2);
                assert (r1 != null && r2 != null);
                int diff = r1.size() - r2.size();
                if (diff != 0) {
                    return diff;
                }
                String n1 = v1.getName();
                String n2 = v2.getName();
                return ClassUtil.safeCompareTo((Comparable)((Object)n1), (Comparable)((Object)n2));
            }
        }
        return 0;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private @NonNull Map<@NonNull Variable, @NonNull Set<@NonNull Variable>> computeReferencedVariableClosure() {
        boolean more;
        HashMap<@NonNull Variable, @NonNull Set<@NonNull Variable>> variable2referencedVariables2 = new HashMap<Variable, Set<Variable>>();
        for (Assignment assignment : this.assignments) {
            if (!(assignment instanceof VariableAssignment)) continue;
            VariableAssignment variableAssignment = (VariableAssignment)assignment;
            Variable variable = (Variable)ClassUtil.nonNullState((Object)variableAssignment.getTargetVariable());
            HashSet<@NonNull Variable> referencedVariables = new HashSet<Variable>();
            for (EObject eObject : new TreeIterable((EObject)ClassUtil.nonNullState((Object)variableAssignment.getValue()), true)) {
                if (eObject instanceof VariableExp) {
                    VariableDeclaration referredVariable = ((VariableExp)eObject).getReferredVariable();
                    if (!(referredVariable instanceof Variable)) continue;
                    referencedVariables.add((Variable)referredVariable);
                    continue;
                }
                if (!(eObject instanceof Variable)) continue;
                referencedVariables.add((Variable)eObject);
            }
            variable2referencedVariables2.put(variable, referencedVariables);
        }
        do {
            more = false;
            for (Variable variable : variable2referencedVariables2.keySet()) {
                @NonNull Set referencedVariables = (Set)variable2referencedVariables2.get(variable);
                assert (referencedVariables != null);
                for (Variable referencedVariable : new ArrayList(referencedVariables)) {
                    @NonNull Set referencedReferencedVariables = (Set)variable2referencedVariables2.get(referencedVariable);
                    if (referencedReferencedVariables == null || !referencedVariables.addAll(referencedReferencedVariables)) continue;
                    more = true;
                }
            }
        } while (more);
        return variable2referencedVariables2;
    }
}

