/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.common.emf;

import java.io.IOException;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.m2m.internal.qvt.oml.common.CommonPlugin;
import org.eclipse.m2m.internal.qvt.oml.common.MdaException;
import org.eclipse.m2m.internal.qvt.oml.common.io.CFile;
import org.eclipse.m2m.internal.qvt.oml.emf.util.EmfException;
import org.eclipse.m2m.internal.qvt.oml.emf.util.EmfUtil;
import org.eclipse.m2m.internal.qvt.oml.emf.util.ModelContent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtendedEmfUtil {
    private ExtendedEmfUtil() {
    }

    public static ModelContent loadModel(CFile modelFile) {
        try {
            URI uri = URI.createURI((String)modelFile.getFileStore().toURI().toString());
            return EmfUtil.loadModel((URI)uri);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static void saveModel(Resource extent, CFile file) throws MdaException {
        Map options = EmfUtil.DEFAULT_SAVE_OPTIONS;
        try {
            URI uri = URI.createURI((String)file.getFileStore().toURI().toString());
            EmfUtil.saveModel((Resource)extent, (URI)uri, (Map)options);
        }
        catch (EmfException e) {
            throw new MdaException(e);
        }
        catch (IOException e) {
            throw new MdaException(e);
        }
        try {
            file.refresh();
        }
        catch (Exception e) {
            throw new MdaException(CommonPlugin.getResourceString("EmfUtil.0", new Object[]{file}), e);
        }
    }

    public static void saveModel(EObject eObject, CFile file) throws MdaException {
        ExtendedEmfUtil.saveModel(eObject, file, EmfUtil.DEFAULT_SAVE_OPTIONS);
    }

    public static void saveModel(EObject eObject, CFile file, Map<?, ?> options) throws MdaException {
        try {
            URI uri = URI.createURI((String)file.getFileStore().toURI().toString());
            EmfUtil.saveModel((EObject)eObject, (URI)uri, options);
        }
        catch (EmfException e) {
            throw new MdaException(e);
        }
        catch (IOException e) {
            throw new MdaException(e);
        }
        try {
            file.refresh();
        }
        catch (Exception e) {
            throw new MdaException(CommonPlugin.getResourceString("EmfUtil.0", new Object[]{file}), e);
        }
    }
}

